/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.simplewebservice.wsdl.impl;

import com.sun.portal.providers.simplewebservice.wsdl.BindingOperationOutputDescriptor;
import com.sun.portal.providers.simplewebservice.wsdl.DefinitionDescriptor;
import com.sun.portal.providers.simplewebservice.wsdl.impl.BindingDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.BindingOperationDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.BindingOperationInputDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.BindingOperationOutputDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.DefinitionDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.MessageDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.OperationDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.PartDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.PortDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.PortTypeDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.ServiceDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.TypeDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.TypeElementDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.WSDLException;
import com.sun.portal.providers.simplewebservice.wsdl.impl.WSDLReaderConstants;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WSDLReader
implements WSDLReaderConstants {
    private static final String STRING = "string";
    private static final String INT = "int";
    private static final String FLOAT = "float";
    private static final String DOUBLE = "double";
    private static final String BOOLEAN = "boolean";
    private static final String LONG = "long";
    private static final int ELEMENT_STYLE = 1;
    private static final int COMPLEX_TYPE_STYLE = 2;
    private static WSDLReader wsdlReader = new WSDLReader();

    public static WSDLReader getWSDLReader() {
        return wsdlReader;
    }

    public DefinitionDescriptor getWSDLDefinitionDescriptor(String string) throws WSDLException {
        DefinitionDescriptor definitionDescriptor = null;
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            Document document = this.parseXMLDocument(inputStream);
            inputStream.close();
            definitionDescriptor = this.getDefinitionDescriptor(document);
        }
        catch (IOException iOException) {
            throw new WSDLException("INVALID_URL", iOException.getMessage(), iOException);
        }
        catch (WSDLException wSDLException) {
            throw wSDLException;
        }
        catch (Throwable throwable) {
            throw new WSDLException("OTHER_ERROR", throwable.getMessage(), throwable);
        }
        return definitionDescriptor;
    }

    private DefinitionDescriptor getDefinitionDescriptor(Document document) throws WSDLException {
        DefinitionDescriptorImpl definitionDescriptorImpl = null;
        Element element = document.getDocumentElement();
        String string = element.getNodeName();
        if (!string.equalsIgnoreCase("definitions")) {
            throw new WSDLException("INVALID_WSDL", "Unable to parse- WSDLdefinitions element not found");
        }
        String string2 = this.getAttribute(element, "name");
        String string3 = this.getAttribute(element, "targetNamespace");
        Map map = this.getNamespaces(element);
        Map map2 = this.getTypeDescriptors(element);
        Map map3 = this.getMessageDescriptors(element);
        Map map4 = this.getPortTypeDescriptors(element);
        Map map5 = this.getBindingDescriptors(element);
        Map map6 = this.getServiceDescriptors(element);
        definitionDescriptorImpl = new DefinitionDescriptorImpl(string2, string3, map, map2, map3, map5, map4, map6);
        return definitionDescriptorImpl;
    }

    private Map getTypeDescriptors(Element element) throws WSDLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        NodeList nodeList = element.getElementsByTagName("types");
        if (nodeList != null && nodeList.getLength() != 0) {
            Element element2 = this.getFirstChildElement((Element)nodeList.item(0));
            String string = element2.getTagName();
            String string2 = this.getNSPrefix(string);
            String string3 = this.getAttribute(element2, "targetNamespace");
            if (string2 == null || string2.length() == 0) {
                string2 = "";
            }
            if (!this.removeNS(string).equals("schema")) {
                throw new WSDLException("INVALID_WSDL", "No schema tag found in types section");
            }
            Element element3 = this.getFirstChildElement(element2);
            if (element3 != null) {
                String string4 = element3.getTagName();
                int n = 0;
                if (string4.endsWith("element")) {
                    n = 1;
                } else if (string4.endsWith("complexType")) {
                    n = 2;
                }
                if (n == 1) {
                    Node node = element3;
                    while (node != null) {
                        if (node.getNodeType() == 1) {
                            Object object;
                            Object object2;
                            Object object3;
                            Element element4 = node;
                            String string5 = element4.getTagName();
                            if (!string5.endsWith("element")) {
                                throw new WSDLException("INVALID_WSDL", "ComplexType element not found");
                            }
                            String string6 = this.getAttribute(element4, "name");
                            HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
                            ArrayList<Object> arrayList = new ArrayList<Object>();
                            NodeList nodeList2 = element4.getElementsByTagName(string2 + "element");
                            if (nodeList2 == null || nodeList2.getLength() == 0) {
                                nodeList2 = element4.getElementsByTagName("element");
                            }
                            if (nodeList2 == null || nodeList2.getLength() == 0) {
                                object3 = this.getAttribute(element4, "value");
                                object2 = this.getAttribute(element4, "type");
                                object = new TypeElementDescriptorImpl(string6, (String)object2, (String)object3);
                                hashMap2.put(string6, object);
                                arrayList.add(string6);
                            } else {
                                int n2 = 0;
                                while (n2 < nodeList2.getLength()) {
                                    object2 = (Element)nodeList2.item(n2);
                                    object = this.getAttribute((Element)object2, "name");
                                    String string7 = this.getAttribute((Element)object2, "value");
                                    String string8 = this.getAttribute((Element)object2, "type");
                                    if (!(string8.endsWith(STRING) || string8.endsWith(INT) || string8.endsWith(FLOAT) || string8.endsWith(DOUBLE) || string8.endsWith(BOOLEAN) || string8.endsWith(LONG))) {
                                        throw new WSDLException("INVALID_WSDL", "ComplexType element name: " + (String)object + " contains an unsupported type: " + string8);
                                    }
                                    TypeElementDescriptorImpl typeElementDescriptorImpl = new TypeElementDescriptorImpl((String)object, string8, string7);
                                    hashMap2.put(object, typeElementDescriptorImpl);
                                    arrayList.add(object);
                                    ++n2;
                                }
                            }
                            object3 = new TypeDescriptorImpl(string6, hashMap2, arrayList, string3);
                            hashMap.put(string6, object3);
                        }
                        node = node.getNextSibling();
                    }
                } else if (n == 2) {
                    NodeList nodeList3 = element2.getElementsByTagName(string2 + "complexType");
                    if (nodeList3 == null || nodeList3.getLength() == 0) {
                        nodeList3 = element2.getElementsByTagName("complexType");
                    }
                    int n3 = 0;
                    while (nodeList3 != null && nodeList3.getLength() != 0 && n3 < nodeList3.getLength()) {
                        Object object;
                        Element element5 = (Element)nodeList3.item(n3);
                        String string9 = this.getAttribute(element5, "name");
                        HashMap<String, TypeElementDescriptorImpl> hashMap3 = new HashMap<String, TypeElementDescriptorImpl>();
                        ArrayList<String> arrayList = new ArrayList<String>();
                        NodeList nodeList4 = element5.getElementsByTagName(string2 + "element");
                        if (nodeList4 == null || nodeList4.getLength() == 0) {
                            nodeList4 = element5.getElementsByTagName("element");
                        }
                        if (nodeList4 == null || nodeList4.getLength() == 0) {
                            throw new WSDLException("INVALID_WSDL", "ComplexType complexType name: " + string9 + " does not contain any " + "element");
                        }
                        int n4 = 0;
                        while (n4 < nodeList4.getLength()) {
                            object = (Element)nodeList4.item(n4);
                            String string10 = this.getAttribute((Element)object, "name");
                            String string11 = this.getAttribute((Element)object, "value");
                            String string12 = this.getAttribute((Element)object, "type");
                            if (!(string12.endsWith(STRING) || string12.endsWith(INT) || string12.endsWith(FLOAT) || string12.endsWith(DOUBLE) || string12.endsWith(BOOLEAN) || string12.endsWith(LONG))) {
                                throw new WSDLException("INVALID_WSDL", "ComplexType element name: " + string10 + " contains an unsupported type: " + string12);
                            }
                            TypeElementDescriptorImpl typeElementDescriptorImpl = new TypeElementDescriptorImpl(string10, string12, string11);
                            hashMap3.put(string10, typeElementDescriptorImpl);
                            arrayList.add(string10);
                            ++n4;
                        }
                        object = new TypeDescriptorImpl(string9, hashMap3, arrayList, string3);
                        hashMap.put(string9, object);
                        ++n3;
                    }
                } else {
                    throw new WSDLException("INVALID_WSDL", "ComplexType element or complexType not found under the schema");
                }
            }
        }
        return hashMap;
    }

    private Map getMessageDescriptors(Element element) throws WSDLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        NodeList nodeList = element.getElementsByTagName("message");
        this.checkForInvalidNodes(nodeList, "message", "definitions");
        int n = 0;
        while (n < nodeList.getLength()) {
            Object object;
            HashMap<String, PartDescriptorImpl> hashMap2 = new HashMap<String, PartDescriptorImpl>();
            Element element2 = (Element)nodeList.item(n);
            String string = this.getAttribute(element2, "name");
            NodeList nodeList2 = element2.getElementsByTagName("part");
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            while (nodeList2 != null && n2 < nodeList2.getLength()) {
                object = (Element)nodeList2.item(n2);
                String string2 = this.getAttribute((Element)object, "name");
                String string3 = this.getAttribute((Element)object, "type");
                if (string3 == null) {
                    string3 = this.getAttribute((Element)object, "element");
                }
                arrayList.add(string2);
                PartDescriptorImpl partDescriptorImpl = new PartDescriptorImpl(string2, string3);
                hashMap2.put(string2, partDescriptorImpl);
                ++n2;
            }
            object = new MessageDescriptorImpl(string, hashMap2, arrayList);
            hashMap.put(string, object);
            ++n;
        }
        return hashMap;
    }

    private Map getPortTypeDescriptors(Element element) throws WSDLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        NodeList nodeList = element.getElementsByTagName("portType");
        this.checkForInvalidNodes(nodeList, "portType", "definitions");
        int n = 0;
        while (n < nodeList.getLength()) {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Element element2 = (Element)nodeList.item(n);
            String string = this.getAttribute(element2, "name");
            ArrayList arrayList2 = new ArrayList();
            NodeList nodeList2 = element2.getElementsByTagName("operation");
            this.checkForInvalidNodes(nodeList2, "operation", "portType:" + string);
            int n2 = 0;
            while (n2 < nodeList2.getLength()) {
                Object object2;
                object = (Element)nodeList2.item(n2);
                String string2 = this.getAttribute((Element)object, "name");
                NodeList nodeList3 = object.getElementsByTagName("input");
                this.checkForInvalidNodes(nodeList3, "input", "operation:" + string2);
                Element element3 = (Element)nodeList3.item(0);
                String string3 = this.getAttribute(element3, "message");
                NodeList nodeList4 = object.getElementsByTagName("output");
                String string4 = null;
                if (nodeList4 != null && nodeList4.getLength() > 0) {
                    object2 = (Element)nodeList4.item(0);
                    string4 = this.getAttribute((Element)object2, "message");
                }
                object2 = new OperationDescriptorImpl(string2, string3, string4);
                arrayList.add(object2);
                ++n2;
            }
            object = new PortTypeDescriptorImpl(string, arrayList);
            hashMap.put(string, object);
            ++n;
        }
        return hashMap;
    }

    private Map getBindingDescriptors(Element element) throws WSDLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        NodeList nodeList = element.getElementsByTagName("binding");
        this.checkForInvalidNodes(nodeList, "binding", "definitions");
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            String string = this.getAttribute(element2, "name");
            String string2 = this.getAttribute(element2, "type");
            ArrayList<Object> arrayList = new ArrayList<Object>();
            NodeList nodeList2 = element2.getElementsByTagName("soap:binding");
            if (nodeList2 != null && nodeList2.getLength() != 0) {
                Object object;
                Element element3 = (Element)nodeList2.item(0);
                String string3 = this.getAttribute(element3, "style");
                String string4 = this.getAttribute(element3, "transport");
                NodeList nodeList3 = element2.getElementsByTagName("operation");
                this.checkForInvalidNodes(nodeList3, "operation", "binding:" + string);
                int n2 = 0;
                while (n2 < nodeList3.getLength()) {
                    String string5;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    Object object7;
                    object = (Element)nodeList3.item(n2);
                    String string6 = this.getAttribute((Element)object, "name");
                    NodeList nodeList4 = object.getElementsByTagName("soap:operation");
                    String string7 = null;
                    if (nodeList4 != null && nodeList4.getLength() > 0 && (object7 = (Element)nodeList4.item(0)) != null) {
                        string7 = this.getAttribute((Element)object7, "soapAction");
                    }
                    object7 = object.getElementsByTagName("input");
                    BindingOperationInputDescriptorImpl bindingOperationInputDescriptorImpl = null;
                    if (object7 != null && object7.getLength() > 0) {
                        object6 = (Element)object7.item(0);
                        object5 = object6.getElementsByTagName("soap:body");
                        this.checkForInvalidNodes((NodeList)object5, "soap:body", "input");
                        object4 = (Element)object5.item(0);
                        object3 = this.getAttribute((Element)object4, "use");
                        object2 = this.getAttribute((Element)object4, "namespace");
                        string5 = this.getAttribute((Element)object4, "encodingStyle");
                        bindingOperationInputDescriptorImpl = new BindingOperationInputDescriptorImpl("", (String)object3, (String)object2, string5);
                    }
                    object6 = object.getElementsByTagName("output");
                    object5 = null;
                    if (object6 != null && object6.getLength() > 0) {
                        object4 = (Element)object6.item(0);
                        object3 = object4.getElementsByTagName("soap:body");
                        this.checkForInvalidNodes((NodeList)object3, "soap:body", "output");
                        object2 = (Element)object3.item(0);
                        string5 = this.getAttribute((Element)object2, "use");
                        String string8 = this.getAttribute((Element)object2, "namespace");
                        String string9 = this.getAttribute((Element)object2, "encodingStyle");
                        object5 = new BindingOperationOutputDescriptorImpl("", string5, string8, string9);
                    }
                    object4 = new BindingOperationDescriptorImpl(string6, string7, bindingOperationInputDescriptorImpl, (BindingOperationOutputDescriptor)object5);
                    arrayList.add(object4);
                    ++n2;
                }
                object = new BindingDescriptorImpl(string, string2, arrayList, string3, string4);
                hashMap.put(string, object);
            }
            ++n;
        }
        return hashMap;
    }

    private Map getServiceDescriptors(Element element) throws WSDLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        NodeList nodeList = element.getElementsByTagName("service");
        this.checkForInvalidNodes(nodeList, "service", "definitions");
        int n = 0;
        while (n < nodeList.getLength()) {
            Object object;
            Object object2;
            Object object3;
            Element element2 = (Element)nodeList.item(n);
            String string = this.getAttribute(element2, "name");
            HashMap<String, PortDescriptorImpl> hashMap2 = new HashMap<String, PortDescriptorImpl>();
            String string2 = null;
            NodeList nodeList2 = element2.getElementsByTagName("documentation");
            if (nodeList2 != null && nodeList2.getLength() > 0 && (object3 = (Text)(object2 = (Element)nodeList2.item(0)).getFirstChild()) != null) {
                string2 = object3.getData();
            }
            object2 = null;
            object3 = element.getElementsByTagName("port");
            this.checkForInvalidNodes((NodeList)object3, "port", "service:" + string);
            int n2 = 0;
            while (n2 < object3.getLength()) {
                object = (Element)object3.item(n2);
                String string3 = this.getAttribute((Element)object, "name");
                String string4 = this.getAttribute((Element)object, "binding");
                NodeList nodeList3 = object.getElementsByTagName("soap:address");
                if (nodeList3 != null && nodeList3.getLength() != 0) {
                    object2 = this.getAttribute((Element)nodeList3.item(0), "location");
                    PortDescriptorImpl portDescriptorImpl = new PortDescriptorImpl(string3, string4, (String)object2);
                    hashMap2.put(string3, portDescriptorImpl);
                }
                ++n2;
            }
            object = new ServiceDescriptorImpl(string, string2, hashMap2);
            hashMap.put(string, object);
            ++n;
        }
        return hashMap;
    }

    private Document parseXMLDocument(InputStream inputStream) throws WSDLException {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputStream);
        }
        catch (Throwable throwable) {
            throw new WSDLException("PARSER_ERROR", throwable.getMessage(), throwable);
        }
        return document;
    }

    private Map getNamespaces(Element element) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            String string = attr.getName();
            String string2 = attr.getValue();
            if (string != null && !string.equals("name") && !string.equals("targetNamespace") && string2 != null) {
                hashMap.put(string, string2);
            }
            ++n2;
        }
        return hashMap;
    }

    private String getAttribute(Element element, String string) {
        String string2 = null;
        if (element != null && string != null && (string2 = element.getAttribute(string)) != null && string2.equals("")) {
            string2 = null;
        }
        return string2;
    }

    private void checkForInvalidNodes(NodeList nodeList, String string, String string2) throws WSDLException {
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new WSDLException("INVALID_WSDL", "No " + string + " found in " + string2);
        }
    }

    private Element getFirstChildElement(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    private String getNSPrefix(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(58)) != -1) {
            return string.substring(0, n + 1);
        }
        return null;
    }

    private String removeNS(String string) {
        if (string != null) {
            int n = string.lastIndexOf(58);
            return string.substring(n + 1);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        System.out.println("In Main!");
        try {
            WSDLReader wSDLReader = WSDLReader.getWSDLReader();
            DefinitionDescriptor definitionDescriptor = wSDLReader.getWSDLDefinitionDescriptor(stringArray[0]);
            System.out.println("DefinitionDescriptor is-" + definitionDescriptor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

