/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.userinfo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.desktop.context.ProviderContextThreadLocalizer;
import com.sun.portal.desktop.util.I18n;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.userinfo.tag.ReadTag;
import com.sun.portal.providers.userinfo.tag.TagException;
import com.sun.portal.providers.userinfo.tag.TagWrapperException;
import com.sun.portal.providers.userinfo.tag.UnhandledTagException;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;

public class DateTimeTag
implements ReadTag {
    private static String TIMEZONE_ATTR_KEY = "preferredtimezone";
    private Locale locale = null;
    private ProviderContext context = null;
    private SSOToken token = null;
    private ResourceBundle bundle = null;
    private String channel = null;

    public void init(String string, HttpServletRequest httpServletRequest) throws TagException {
        this.channel = string;
        this.context = ProviderContextThreadLocalizer.get();
        if (this.context == null) {
            throw new TagException("DateTimeTag.init(): provider context was null");
        }
        this.locale = this.context.getLocale();
        try {
            this.bundle = ResourceBundle.getBundle(this.context.getProviderName(string), this.locale);
        }
        catch (ProviderContextException providerContextException) {
            throw new TagException("DateTime.init(): Failed to get resource bundle for " + string + " with locale " + this.locale);
        }
        SSOTokenManager sSOTokenManager = null;
        try {
            sSOTokenManager = SSOTokenManager.getInstance();
            if (sSOTokenManager == null) {
                throw new TagException("DateTime.init(): Failed to getSSOTokenmanager.");
            }
            this.token = sSOTokenManager.createSSOToken(httpServletRequest);
        }
        catch (SSOException sSOException) {
            throw new TagWrapperException("DateTimeTag.init():", (Exception)((Object)sSOException));
        }
    }

    public String get(String string) throws TagException {
        if (string.equals("currentDate")) {
            return this.getCurrentDate();
        }
        if (string.equals("timeLeft")) {
            return this.getTimeLeft();
        }
        if (string.equals("maxIdle")) {
            return this.getMaxIdle();
        }
        throw new UnhandledTagException("unknown key=" + string);
    }

    private String getCurrentDate() throws TagException {
        Date date = new Date();
        String string = this.bundle.getString("timeWasFormat");
        String string2 = null;
        TimeZone timeZone = null;
        string2 = this.context.getStringAttribute(TIMEZONE_ATTR_KEY);
        if (string2 != null && string2.length() > 0) {
            timeZone = TimeZone.getTimeZone(string2);
        } else {
            if (this.context.isDebugWarningEnabled()) {
                this.context.debugWarning((Object)"DateTimeTag.getCurrentDate(): timezone attribute not specified, using default.");
            }
            timeZone = TimeZone.getDefault();
        }
        return I18n.format((String)string, (Date)date, (TimeZone)timeZone, (Locale)this.locale);
    }

    private String getTimeLeft() throws TagException {
        Long l = null;
        String string = null;
        try {
            l = new Long(this.token.getTimeLeft() / 60L);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TagWrapperException("time left is not an integer", numberFormatException);
        }
        catch (SSOException sSOException) {
            throw new TagWrapperException("error getting time left", (Exception)((Object)sSOException));
        }
        string = this.bundle.getString("minsLeftFormat");
        return I18n.format((String)string, (Long)l, (Locale)this.locale);
    }

    private String getMaxIdle() throws TagException {
        Long l = null;
        try {
            l = new Long(this.token.getMaxIdleTime());
        }
        catch (NumberFormatException numberFormatException) {
            throw new TagWrapperException("max idle time is not an integer", numberFormatException);
        }
        catch (SSOException sSOException) {
            throw new TagWrapperException("error getting max idle time", (Exception)((Object)sSOException));
        }
        String string = null;
        string = this.bundle.getString("minsIdleFormat");
        return I18n.format((String)string, (Long)l, (Locale)this.locale);
    }
}

