/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.userinfo;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.desktop.context.ContextException;
import com.sun.portal.desktop.util.I18n;
import com.sun.portal.desktop.util.Integers;
import com.sun.portal.providers.InvalidEditFormDataException;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.userinfo.OriginalPasswordDidntMatchException;
import com.sun.portal.providers.userinfo.PasswordException;
import com.sun.portal.providers.userinfo.PasswordTooShortException;
import com.sun.portal.providers.userinfo.PasswordsDontMatchException;
import com.sun.portal.providers.userinfo.tag.TagException;
import com.sun.portal.providers.userinfo.tag.TagModuleManager;
import com.sun.portal.providers.userinfo.tag.TagWrapperException;
import com.sun.portal.providers.userinfo.tag.UndefinedTagException;
import com.sun.portal.providers.userinfo.tag.WriteTag;
import com.sun.portal.providers.util.ProviderProperties;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UserInfoProvider
extends ProfileProviderAdapter
implements ProviderProperties {
    private TagModuleManager moduleManager = null;
    private ResourceBundle bundle = null;
    private String editContainer = null;
    private String container = null;

    public void init(String string, HttpServletRequest httpServletRequest) throws ProviderException {
        super.init(string, httpServletRequest);
        try {
            this.moduleManager = new TagModuleManager(this.getName(), httpServletRequest);
        }
        catch (TagException tagException) {
            throw new ProviderException("UserInfoProvider.init(): couldn't get tag module manager", (Throwable)((Object)tagException));
        }
        if (this.moduleManager == null) {
            throw new ProviderException("UserInfoProvider.init(): tag module manager failed it init");
        }
    }

    public StringBuffer getContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ProviderException {
        Hashtable hashtable = this.moduleManager.getTable();
        return this.getTemplate("content.template", hashtable);
    }

    public StringBuffer getEdit(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ProviderException {
        this.editContainer = httpServletRequest.getParameter("provider");
        this.container = httpServletRequest.getParameter("containerName");
        Hashtable hashtable = this.moduleManager.getTable();
        SSOTokenManager sSOTokenManager = null;
        SSOToken sSOToken = null;
        AMStoreConnection aMStoreConnection = null;
        AMUser aMUser = null;
        try {
            sSOTokenManager = SSOTokenManager.getInstance();
            if (sSOTokenManager == null) {
                throw new ProviderException("UserinfoProvider.getEdit(): Failed to getSSOTokenmanager.");
            }
            sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            aMStoreConnection = new AMStoreConnection(sSOToken);
            aMUser = aMStoreConnection.getUser(sSOToken.getPrincipal().getName());
        }
        catch (SSOException sSOException) {
            throw new ProviderException("UserinfoProvider.getEdit():", (Throwable)sSOException);
        }
        Set set = null;
        try {
            set = aMUser.getAssignedServices();
        }
        catch (AMException aMException) {
            throw new ProviderException("UserinfoProvider.getEdit(): Failed to get service names.", (Throwable)aMException);
        }
        catch (SSOException sSOException) {
            throw new ProviderException("UserinfoProvider.getEdit():", (Throwable)sSOException);
        }
        if (set.contains(this.getStringProperty("netmailServiceName"))) {
            if (this.getProviderContext().isDebugMessageEnabled()) {
                this.getProviderContext().debugMessage((Object)"UserinfoProvider.getEdit(): NetMail service registered.");
            }
            hashtable.put("netmailSettings", this.getTemplate("netmailSettings.template"));
        } else {
            if (this.getProviderContext().isDebugWarningEnabled()) {
                this.getProviderContext().debugWarning((Object)"UserinfoProvider.getEdit(): NetMail service NOT registered.");
            }
            hashtable.put("netmailSettings", "");
        }
        String string = null;
        try {
            string = sSOToken.getAuthType();
            if (this.getProviderContext().isDebugMessageEnabled()) {
                this.getProviderContext().debugMessage((Object)("UserinfoProvider.getEdit(): authMethod=" + string));
            }
        }
        catch (SSOException sSOException) {
            this.getProviderContext().debugError((Object)"UserinfoProvider.getEdit(): couldn't get auth method");
            string = "<unknown>";
        }
        List list = this.getListProperty("authTypes");
        if (list.contains(string)) {
            if (this.getProviderContext().isDebugMessageEnabled()) {
                this.getProviderContext().debugMessage((Object)"UserinfoProvider.getEdit(): found handler");
            }
            hashtable.put("passwordHandler", this.getTemplate("passwordHandler-" + string + ".template"));
        } else {
            if (this.getProviderContext().isDebugWarningEnabled()) {
                this.getProviderContext().debugWarning((Object)"UserinfoProvider.getEdit(): handler NOT found!");
            }
            hashtable.put("passwordHandler", "");
        }
        String string2 = httpServletRequest.getParameter("error");
        if (string2 != null) {
            hashtable.put("errMessage", string2);
            hashtable.put("inlineError", this.getTemplate("inlineError.template"));
        } else {
            hashtable.put("errMessage", "");
            hashtable.put("inlineError", "");
        }
        return this.getTemplate("edit.template", hashtable);
    }

    public URL processEdit(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ProviderException {
        CharSequence charSequence;
        URL uRL = null;
        boolean bl = true;
        String string = "";
        this.getProviderContext().allContentChanged();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            charSequence = (String)enumeration.nextElement();
            String string2 = httpServletRequest.getParameter((String)charSequence);
            if (string2 == null) {
                string2 = "";
            }
            if (this.getProviderContext().isDebugMessageEnabled()) {
                this.getProviderContext().debugMessage((Object)("UserinfoProvider.processEdit(): tag=" + (String)charSequence));
            }
            WriteTag writeTag = null;
            try {
                writeTag = this.moduleManager.getWriteTag((String)charSequence);
            }
            catch (UndefinedTagException undefinedTagException) {
                if (!this.getProviderContext().isDebugWarningEnabled()) continue;
                this.getProviderContext().debugWarning((Object)("UserinfoProvider.processEdit(): couldn't get module for tag=" + (String)charSequence));
                continue;
            }
            catch (TagException tagException) {
                this.getProviderContext().debugError((Object)"UserinfoProvider.processEdit()", (Throwable)((Object)tagException));
                continue;
            }
            try {
                writeTag.set((String)charSequence, string2);
            }
            catch (PasswordTooShortException passwordTooShortException) {
                if (this.bundle == null) {
                    this.bundle = this.getResourceBundle();
                }
                String string3 = this.bundle.getString("passwordTooShort");
                Locale locale = null;
                locale = this.getProviderContext().getLocale();
                string = I18n.format((String)string3, (Integer)Integers.get((int)passwordTooShortException.getRequiredLength()), (Locale)locale);
                bl = false;
            }
            catch (OriginalPasswordDidntMatchException originalPasswordDidntMatchException) {
                if (this.bundle == null) {
                    this.bundle = this.getResourceBundle();
                }
                string = this.bundle.getString("originalPasswordDidntMatch");
                bl = false;
            }
            catch (PasswordsDontMatchException passwordsDontMatchException) {
                if (this.bundle == null) {
                    this.bundle = this.getResourceBundle();
                }
                string = this.bundle.getString("passwordsDontMatch");
                bl = false;
            }
            catch (PasswordException passwordException) {
                if (!this.getProviderContext().isDebugMessageEnabled()) continue;
                this.getProviderContext().debugMessage((Object)"UserinfoProvider.processEdit()", (Throwable)((Object)passwordException));
            }
            catch (TagException tagException) {
                TagWrapperException tagWrapperException;
                Exception exception;
                this.getProviderContext().debugError((Object)("UserinfoProvider.processEdit(): couldn't set tag " + (String)charSequence + " to " + string2));
                if (tagException instanceof TagWrapperException && (exception = (tagWrapperException = (TagWrapperException)tagException).getWrappedException()) instanceof ContextException) {
                    if (this.bundle == null) {
                        this.bundle = this.getResourceBundle();
                    }
                    string = this.bundle.getString("profileError");
                    throw new InvalidEditFormDataException(string);
                }
                string = "Could not set " + (String)charSequence + " to " + string2 + ".";
                throw new ProviderException(string, (Throwable)((Object)tagException));
            }
        }
        if (!bl) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(this.getProviderContext().getDesktopURL(httpServletRequest)).append("?action=edit&provider=").append(URLEncoder.encode(this.editContainer)).append("&targetprovider=").append(URLEncoder.encode(this.getName())).append("&containerName=").append(URLEncoder.encode(this.container)).append("&error=").append(URLEncoder.encode(string));
            try {
                uRL = new URL(((StringBuffer)charSequence).toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }
}

