/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.crypt.ciph;

import com.sun.portal.netlet.crypt.ciph.Cipher;
import com.sun.portal.netlet.crypt.ciph.NetletCryptoException;
import com.sun.portal.netlet.econnection.SessionKey;
import java.util.StringTokenizer;

public final class CipherGroup {
    private Cipher encryptCipher = null;
    private Cipher decryptCipher = null;
    private SessionKey sKey = null;
    private String algo = null;
    private int keySize = 128;

    public CipherGroup(String algorithm, SessionKey key, int keyLength) {
        if (algorithm == null || key == null) {
            throw new IllegalArgumentException("Invalid Arguments");
        }
        this.sKey = key;
        this.keySize = keyLength;
        if (algorithm.startsWith("RC4")) {
            StringTokenizer stz = new StringTokenizer(algorithm, "/");
            if (stz.countTokens() == 3) {
                stz.nextToken();
                stz.nextToken();
                if (!stz.nextToken().equals("NoPadding")) {
                    // empty if block
                }
                throw new IllegalArgumentException("Selected padding not supported for RC4");
            }
            if (stz.countTokens() == 2) {
                algorithm = algorithm + "/NoPadding";
            } else if (stz.countTokens() <= 1) {
                algorithm = algorithm + "/CBC/NoPadding";
            }
        } else if (algorithm.startsWith("Null")) {
            if (algorithm.indexOf(47) != -1) {
                if (!algorithm.equals("Null/ECB/NoPadding")) {
                    throw new IllegalArgumentException("Null Cipher does not accept suggested modes/Padding");
                }
            } else {
                algorithm = "Null/ECB/NoPadding";
            }
        }
        this.algo = algorithm;
    }

    public CipherGroup(Cipher eCipher, Cipher dCipher) {
        this.encryptCipher = eCipher;
        this.decryptCipher = dCipher;
    }

    public String getAlgorithm() {
        return this.algo;
    }

    public Cipher getEncryptCipher() throws NetletCryptoException {
        if (this.encryptCipher == null && this.algo != null) {
            this.encryptCipher = Cipher.getInstance(this.algo);
            this.encryptCipher.init(1, this.sKey.getSessionKey(this.keySize));
        }
        return this.encryptCipher;
    }

    public Cipher getDecryptCipher() throws NetletCryptoException {
        if (this.decryptCipher == null && this.algo != null) {
            this.decryptCipher = Cipher.getInstance(this.algo);
            this.decryptCipher.init(2, this.sKey.getSessionKey(this.keySize));
        }
        return this.decryptCipher;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public String toString() {
        return "com.sun.portal.netlet.crypt.ciph.CipherGroup";
    }

    public void cleanup() {
    }
}

