/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.crypt.ciph.CipherGroup;
import com.sun.portal.netlet.econnection.ESessionMsg;
import com.sun.portal.netlet.econnection.KeyConstants;
import com.sun.portal.netlet.econnection.ReaderWriter;
import com.sun.portal.netlet.econnection.ReaderWriterClear;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.econnection.SessionCipherMsg;
import com.sun.portal.netlet.econnection.SessionKey;
import com.sun.portal.netlet.eproxy.SConn;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.NetletLogMgr;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class RWGroupForward
extends ReaderWriterLock
implements KeyConstants {
    public boolean done;
    private int npPort;
    private String npHost;
    private Socket fromClient;
    private Socket toNP;
    private ReaderWriterClear src_to_dst;
    private ReaderWriterClear dst_to_src;
    private boolean src_to_dst_clean;
    private boolean dst_to_src_clean;
    private Integer netletLogId;
    private String dynamicAlgo;
    private long startTime;
    private boolean stopLogged;
    private String sessID;

    public RWGroupForward(Socket in, CipherGroup cg, String nphost, int npport, String sessionId) {
        block13: {
            this.done = false;
            this.src_to_dst_clean = false;
            this.dst_to_src_clean = false;
            this.dynamicAlgo = "RC4";
            this.stopLogged = false;
            this.sessID = null;
            this.fromClient = in;
            this.npPort = npport;
            this.npHost = nphost;
            this.dynamicAlgo = cg.getAlgorithm();
            this.sessID = sessionId;
            int slashIndex = this.dynamicAlgo.indexOf(47);
            if (slashIndex != -1) {
                this.dynamicAlgo = this.dynamicAlgo.substring(0, slashIndex);
            }
            this.toNP = SConn.connect(this.npPort, this.npHost);
            if (this.toNP == null) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("RWGroupForward: unable to make server connection!");
                }
                this.cleanup();
                return;
            }
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("RWGroupForward: made the connection request to NetletProxy");
            }
            try {
                DataOutputStream out = new DataOutputStream(this.toNP.getOutputStream());
                ESessionMsg eMsg = new ESessionMsg("RP1.0".getBytes());
                if (eMsg.writeMsg(out) != 0) {
                    this.cleanup();
                    return;
                }
                if (this.encryptSessionId(sessionId.getBytes(), sessionId.getBytes().length, out) != 0) {
                    this.cleanup();
                    return;
                }
                out.flush();
                out = null;
            }
            catch (IOException e) {
                // empty catch block
            }
            if (NetletLogMgr.loggingEnabled) {
                try {
                    this.netletLogId = new Integer(NetletLogMgr.getLogId());
                    NetletLogMgr.write("Netlet", GWLocale.getPFString("en1", new Object[]{this.netletLogId, new String(NetletLogMgr.getUserId(this.sessID)), "START", this.fromClient.getInetAddress().toString(), new Integer(this.fromClient.getPort()), this.toNP.getInetAddress().toString(), new Integer(this.toNP.getPort())}));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.src_to_dst = new ReaderWriterClear(this, this.fromClient, this.toNP);
            this.dst_to_src = new ReaderWriterClear(this, this.toNP, this.fromClient);
            try {
                GWThreadPool.run(this.src_to_dst);
                GWThreadPool.run(this.dst_to_src);
            }
            catch (InterruptedException e) {
                if (!GWDebug.debug.errorEnabled()) break block13;
                GWDebug.debug.error("RWGroupForward: Could not start ReaderWriterClear tasks -> ", e);
            }
        }
        this.startTime = System.currentTimeMillis();
    }

    public synchronized void notifyFinished(ReaderWriter obj) {
        if (!this.stopLogged && NetletLogMgr.loggingEnabled) {
            try {
                this.netletLogId = new Integer(NetletLogMgr.getLogId());
                NetletLogMgr.write("Netlet", GWLocale.getPFString("en1", new Object[]{this.netletLogId, new String(NetletLogMgr.getUserId(this.sessID)), new String("STOP"), this.fromClient.getInetAddress().toString(), new Integer(this.fromClient.getPort()), this.toNP.getInetAddress().toString(), new Integer(this.toNP.getPort())}));
                this.stopLogged = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (obj == this.src_to_dst) {
            if (this.dst_to_src.isAlive()) {
                this.dst_to_src.stop();
            }
        } else if (obj == this.dst_to_src && this.src_to_dst.isAlive()) {
            this.src_to_dst.stop();
        }
        this.cleanup();
        if (obj == this.src_to_dst) {
            this.src_to_dst_clean = true;
        } else if (obj == this.dst_to_src) {
            this.dst_to_src_clean = true;
        }
    }

    public void cleanup() {
        try {
            if (this.fromClient != null) {
                try {
                    block12: {
                        try {
                            this.fromClient.close();
                            if (!PerfContextObject.ENABLE_PERF) break block12;
                            SocketCount.decrementPlainSockets();
                        }
                        catch (Exception e) {
                            Object var3_2 = null;
                            this.fromClient = null;
                        }
                    }
                    Object var3_1 = null;
                    this.fromClient = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.fromClient = null;
                    throw throwable;
                }
            }
            if (this.toNP != null) {
                try {
                    block14: {
                        try {
                            this.toNP.close();
                            if (!PerfContextObject.ENABLE_PERF) break block14;
                            SocketCount.decrementPlainSockets();
                        }
                        catch (Exception e) {
                            Object var5_8 = null;
                            this.toNP = null;
                        }
                    }
                    Object var5_7 = null;
                    this.toNP = null;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    this.toNP = null;
                    throw throwable;
                }
            }
            Object var7_11 = null;
            this.done = true;
            this.npHost = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            this.done = true;
            this.npHost = null;
            throw throwable;
        }
    }

    public boolean isDone() {
        if (this.dst_to_src_clean && this.src_to_dst_clean) {
            this.dst_to_src = null;
            this.src_to_dst = null;
        }
        return this.dst_to_src_clean && this.src_to_dst_clean;
    }

    private int encryptSessionId(byte[] id, int id_len, DataOutputStream out) {
        int rc = 0;
        SessionKey initKey = new SessionKey("SN1.0SN1.0SN1.0S.SN9.0SN3.0SN.05".getBytes());
        CipherGroup initCipherGroup = new CipherGroup("RC4", initKey, 128);
        SessionCipherMsg sMsg = new SessionCipherMsg(id = (new String(id) + "|" + this.dynamicAlgo).getBytes(), id_len += this.dynamicAlgo.length() + 1, initCipherGroup);
        if (sMsg.writeMsg(out) != 0) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("RWGroupForward: unable to process session id");
            }
            rc = -1;
        }
        return rc;
    }

    public long getLastActivityTime() {
        if (this.src_to_dst.getLastActivityTime() > this.dst_to_src.getLastActivityTime()) {
            return this.src_to_dst.getLastActivityTime();
        }
        return this.dst_to_src.getLastActivityTime();
    }

    public synchronized void stopAll() {
        if (!this.done) {
            if (this.dst_to_src != null) {
                this.dst_to_src.stop();
            }
            if (this.src_to_dst != null) {
                this.src_to_dst.stop();
            }
            this.cleanup();
        }
    }

    public int getAppletSrcPort() {
        return 0;
    }

    public long getStartTime() {
        return this.startTime;
    }
}

