/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.BitSet;

public class UrlEncoder {
    static BitSet dontNeedEncoding = new BitSet(256);
    static final int caseDiff = 32;
    private static final String defaultEncoding = "UTF8";

    private UrlEncoder() {
    }

    public static String encode(String s) {
        return UrlEncoder.encode(s, defaultEncoding);
    }

    public static String encode(String s, String enc) {
        try {
            boolean needToChange = false;
            boolean wroteUnencodedChar = false;
            int maxBytesPerChar = 10;
            StringBuffer out = new StringBuffer(s.length());
            ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)buf, enc));
            int i = 0;
            while (i < s.length()) {
                block13: {
                    int c = s.charAt(i);
                    if (dontNeedEncoding.get(c)) {
                        if (c == 32) {
                            c = 43;
                            needToChange = true;
                        }
                        out.append((char)c);
                        wroteUnencodedChar = true;
                    } else {
                        try {
                            char d;
                            if (wroteUnencodedChar) {
                                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)buf, enc));
                                wroteUnencodedChar = false;
                            }
                            writer.write(c);
                            if (c >= 55296 && c <= 56319 && i + 1 < s.length() && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                                writer.write(d);
                                ++i;
                            }
                            writer.flush();
                        }
                        catch (IOException e) {
                            buf.reset();
                            break block13;
                        }
                        byte[] ba = buf.toByteArray();
                        int j = 0;
                        while (j < ba.length) {
                            out.append('%');
                            char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                            if (Character.isLetter(ch)) {
                                ch = (char)(ch - 32);
                            }
                            out.append(ch);
                            ch = Character.forDigit(ba[j] & 0xF, 16);
                            if (Character.isLetter(ch)) {
                                ch = (char)(ch - 32);
                            }
                            out.append(ch);
                            ++j;
                        }
                        buf.reset();
                        needToChange = true;
                    }
                }
                ++i;
            }
            return needToChange ? out.toString() : s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return s;
        }
    }

    static {
        int i = 97;
        while (i <= 122) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            dontNeedEncoding.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            dontNeedEncoding.set(i);
            ++i;
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }
}

