/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.perf.netlet.client;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;

public class DirectClient {
    public static long[] statistics;
    public static byte[] data;
    public static int MAXBUFFERSIZE;

    public DirectClient(String[] args) {
        data = new byte[MAXBUFFERSIZE];
        try {
            FileInputStream fis = new FileInputStream("data/netletData.txt");
            fis.read(data);
        }
        catch (IOException ioe) {
            System.out.println("Error reading input file...." + ioe);
        }
        statistics = new long[1000];
        Object s = null;
        if (args.length != 4) {
            System.out.println("Usage: java com.sun.portal.perf.netlet.client.NetletClient <server-host> <server-port> <kilo-bytes> <conns>");
            System.exit(1);
        }
        int conns = Integer.parseInt(args[3]);
        ReadWrite[] rw = new ReadWrite[10];
        int i = 0;
        while (i < conns) {
            rw[i] = new ReadWrite(i, args[0], args[1], Integer.parseInt(args[2]) / 4);
            ++i;
        }
    }

    public static void main(String[] args) {
        new DirectClient(args);
    }

    static {
        MAXBUFFERSIZE = 8192;
    }

    class ReadWrite
    implements Runnable {
        String sessID;
        String rh;
        String rp;
        String sh;
        String sp;
        String ciphername;
        int id;
        int keylen;
        int kiloBytes;
        public Thread t = null;

        public ReadWrite(int id, String rh, String rp, int kbs) {
            this.id = id;
            this.rh = rh;
            this.rp = rp;
            this.kiloBytes = kbs;
            this.t = new Thread((Runnable)this, "" + id);
            this.t.start();
        }

        public void run() {
            try {
                Socket s = new Socket(InetAddress.getByName(this.rh), Integer.parseInt(this.rp));
                DataOutputStream out = new DataOutputStream(s.getOutputStream());
                long currTime = System.currentTimeMillis();
                boolean count = true;
                Read r = new Read(s.getInputStream(), this.kiloBytes, currTime);
                Write w = new Write(s.getOutputStream(), this.kiloBytes);
                try {
                    w.t.join();
                    r.t.join();
                }
                catch (Exception e) {
                    System.err.println("Error in waiting for the Reader/Writer to finish: " + e);
                }
                r.clean();
                w.clean();
            }
            catch (IOException ioe) {
                System.out.println("Exception in reader writer: " + ioe);
            }
        }
    }

    class Write
    implements Runnable,
    Serializable {
        public Thread t = null;
        int kiloBytes = 0;
        DataOutputStream d_out;

        public Write(OutputStream out, int kbs) {
            this.d_out = new DataOutputStream(out);
            this.kiloBytes = kbs;
            this.t = new Thread(this);
            this.t.start();
        }

        public void run() {
            byte[] b = new byte[MAXBUFFERSIZE];
            int count = this.kiloBytes;
            boolean flag = true;
            while (flag && count > 0) {
                try {
                    this.d_out.write(data, 0, MAXBUFFERSIZE - 4096);
                    this.d_out.flush();
                    --count;
                }
                catch (IOException iioe) {
                    count = 0;
                }
            }
        }

        public void clean() {
            try {
                this.d_out.close();
            }
            catch (IOException ioe) {
                System.err.println("Error in closing the output stream : " + ioe);
            }
        }
    }

    class Read
    implements Runnable,
    Serializable {
        public Thread t = null;
        DataInputStream d_in;
        int kiloBytes = 0;
        long startTime = 0L;

        public Read(InputStream in, int kbs, long startTime) {
            this.d_in = new DataInputStream(in);
            this.kiloBytes = kbs;
            this.startTime = startTime;
            this.t = new Thread(this);
            this.t.start();
        }

        public void run() {
            byte[] b = new byte[MAXBUFFERSIZE];
            boolean flag = true;
            int count = this.kiloBytes;
            while (flag && count > 0) {
                try {
                    this.d_in.readFully(b, 0, MAXBUFFERSIZE - 4096);
                    --count;
                }
                catch (IOException ioe) {
                    flag = false;
                }
            }
            double dataCount = this.kiloBytes - count;
            double timeTaken = System.currentTimeMillis() - this.startTime;
            double bandwidth = (dataCount /= 32.0) / (timeTaken /= 1000.0);
            System.out.println("Received " + dataCount / 8.0 + " MBytes of data in " + timeTaken + " secs\tBandwidth = " + bandwidth + " Mbits/sec.");
        }

        public void clean() {
            try {
                this.d_in.close();
            }
            catch (IOException ioe) {
                System.err.println("Error in closing the input stream : " + ioe);
            }
        }
    }
}

