/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.connectionhandler.HTTPRetriever;
import com.sun.portal.rproxy.connectionhandler.HTTPSRetriever;
import com.sun.portal.rproxy.connectionhandler.Retriever;
import com.sun.portal.rproxy.connectionhandler.SSLHTTPSRetriever;
import com.sun.portal.util.GWDebug;
import java.util.HashMap;
import java.util.Map;

public class RetrievalFactory {
    private static Map _retrievers = new HashMap();

    public static Retriever getRetriever(String protocol) {
        String _protocol = protocol.toLowerCase();
        Retriever result = (Retriever)_retrievers.get(_protocol);
        if (result != null) {
            return result;
        }
        Map map = _retrievers;
        synchronized (map) {
            result = (Retriever)_retrievers.get(_protocol);
            if (result != null) {
                Retriever retriever = result;
                return retriever;
            }
            if (_protocol.equals("http")) {
                result = new HTTPRetriever();
            } else if (_protocol.equals("https")) {
                result = new HTTPSRetriever();
            } else {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("RetrievalFactory: can not find protocol " + _protocol);
                }
                Retriever retriever = null;
                return retriever;
            }
            _retrievers.put(_protocol, result);
        }
        return result;
    }

    public static Retriever getRetriever2(String protocol) {
        String _protocol = protocol.toLowerCase();
        Retriever result = (Retriever)_retrievers.get(_protocol);
        if (result != null) {
            return result;
        }
        Map map = _retrievers;
        synchronized (map) {
            result = (Retriever)_retrievers.get(_protocol);
            if (result != null) {
                Retriever retriever = result;
                return retriever;
            }
            if (_protocol.equals("http")) {
                result = new HTTPRetriever();
            } else if (_protocol.equals("https")) {
                result = new SSLHTTPSRetriever();
            } else {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("RetrievalFactory: can not find protocol " + _protocol);
                }
                Retriever retriever = null;
                return retriever;
            }
            _retrievers.put(_protocol, result);
        }
        return result;
    }
}

