/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.https;

import com.sun.portal.rproxy.https.JSSDebug;
import com.sun.portal.rproxy.https.SRAPPasswordCallback;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.util.PasswordCallback;

public class SRAPNSSInit {
    public static String nickname = "server-cert";

    public static boolean initialize() {
        String jssPassword;
        BufferedReader br;
        InputStreamReader isr;
        FileInputStream fis;
        String certdbDir = System.getProperty("gateway.keybase", "/etc/opt/SUNWps");
        JSSDebug.debug.message("SRAPNSSInit: certdbDir = " + certdbDir);
        String nicknamefile = System.getProperty("gateway.nickname", "/etc/opt/SUNWps/cert/.nickname");
        JSSDebug.debug.message("SRAPNSSInit: nicknamefile = " + nicknamefile);
        if (nicknamefile != null) {
            try {
                fis = new FileInputStream(nicknamefile);
                isr = new InputStreamReader(fis);
                br = new BufferedReader(isr);
                nickname = br.readLine();
            }
            catch (Exception ex) {
                JSSDebug.debug.message("SRAPNSSInit: Unable to read jss nickname from file " + nicknamefile);
            }
        } else {
            JSSDebug.debug.message("SRAPNSSInit: Unable to get nickname file name");
        }
        String pwfile = System.getProperty("gateway.pass", "/etc/opt/SUNWps/cert/.jsspass");
        JSSDebug.debug.message("SRAPNSSInit: pwfile = " + pwfile);
        if (pwfile != null) {
            try {
                fis = new FileInputStream(pwfile);
                isr = new InputStreamReader(fis);
                br = new BufferedReader(isr);
                jssPassword = br.readLine();
            }
            catch (Exception ex) {
                return false;
            }
        } else {
            return false;
        }
        try {
            CryptoManager.InitializationValues vals = new CryptoManager.InitializationValues(certdbDir);
            CryptoManager.initialize((CryptoManager.InitializationValues)vals);
            CryptoManager.getInstance().setPasswordCallback((PasswordCallback)new SRAPPasswordCallback(jssPassword));
        }
        catch (KeyDatabaseException kdbe) {
            JSSDebug.debug.error("SRAPNSSInit: Couldn't open the key database." + (Object)((Object)kdbe));
            return false;
        }
        catch (CertDatabaseException cdbe) {
            JSSDebug.debug.error("SRAPNSSInit: Couldn't open the certificate database." + (Object)((Object)cdbe));
            return false;
        }
        catch (AlreadyInitializedException aie) {
            JSSDebug.debug.message("SRAPNSSInit: CryptoManager already initialized." + (Object)((Object)aie));
        }
        catch (Exception e) {
            JSSDebug.debug.message("SRAPNSSInit: Exception occurred: " + e.getMessage());
            return false;
        }
        return true;
    }
}

