/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile;

import com.iplanet.am.util.Debug;
import com.sun.nfs.XFileExtensionAccessor;
import com.sun.portal.netfile.NetFileException;
import com.sun.portal.netfile.NetFileLogManager;
import com.sun.portal.netfile.NetFileResource;
import com.sun.xfile.XFile;
import com.sun.xfile.XFileInputStream;
import com.sun.xfile.XFileOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Date;
import java.util.Vector;

class NfsFile {
    private static Debug debug;
    public static boolean SHOULD_HAVE_READ_PERMISSION;
    public static boolean SHOULD_NOT_HAVE_READ_PERMISSION;
    public static final String encoding = "UTF8";
    private static final int[] ia_unable_to_login;
    private String s_machine_encoding;
    private XFileInputStream instream = null;
    private XFileOutputStream outstream = null;
    protected int i_number_of_directories_traversed;
    public int authenticationPort = 7946;
    private NetFileLogManager logMgr;

    public native int[] getUserInfo(String var1) throws Exception;

    NfsFile(NetFileLogManager log_Mgr, String s_machine_encoding) {
        this.logMgr = log_Mgr;
        this.s_machine_encoding = s_machine_encoding;
        this.i_number_of_directories_traversed = 0;
        if (debug == null) {
            debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    NfsFile(NetFileLogManager log_Mgr, String s_machine_encoding, int authPort) {
        this(log_Mgr, s_machine_encoding);
        this.authenticationPort = authPort;
    }

    int[] getUserIDs(String user_name, String password) throws NetFileException {
        int[] i_ids = ia_unable_to_login;
        try {
            i_ids = this.getUserInfo(new String(user_name.getBytes(), encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unsupported_character_encoding");
        }
        catch (Exception e) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_do_unix_login");
        }
        if (i_ids[0] == -1) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "error44");
        }
        return i_ids;
    }

    String mkdir(String machine, String share, String user_name, String password, String target_dir, String directory_to_create, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        try {
            if (!this.doAuthenticate("127.0.0.1", this.authenticationPort, user_name, password)) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_do_unix_login");
            }
            int[] i_ids = this.getUserIDs(user_name, password);
            XFile xf_parent_dir = this.getXFile(share, machine, target_dir, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
            if (!xf_parent_dir.canWrite()) {
                throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "no_write_permission_to_parent", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", xf_parent_dir.getPath()});
            }
            XFile xfile = this.getXFile(share, machine, target_dir + "/" + directory_to_create, false, SHOULD_NOT_HAVE_READ_PERMISSION, i_ids);
            if (!xfile.mkdir()) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "could_not_create_directory");
            }
        }
        catch (Exception e) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "could_not_create_directory");
        }
        return nfr_user_locale_i18n_bucket.getString("warning52");
    }

    String[] getNFSDir(String username, String password, String VMSnam, String machname, String dir_nam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        if (!this.doAuthenticate("127.0.0.1", this.authenticationPort, username, password)) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_do_unix_login");
        }
        int[] i_ids = this.getUserIDs(username, password);
        XFile xfile = this.getXFile(VMSnam, machname, dir_nam, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
        String[] sa_files_list = xfile.list();
        String[] sa_listing = null;
        if (sa_files_list == null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_get_listing_error");
        }
        sa_listing = new String[sa_files_list.length * 4];
        int i = 0;
        int j = 0;
        while (i < sa_files_list.length) {
            XFile xf_curr_file = new XFile(xfile, sa_files_list[i]);
            sa_listing[j] = xf_curr_file.isFile() ? "-" : "d";
            sa_listing[++j] = xf_curr_file.getName();
            sa_listing[++j] = new Long(xf_curr_file.length()).toString();
            sa_listing[++j] = new Date(xf_curr_file.lastModified()).toString();
            ++j;
            ++i;
        }
        if (sa_listing == null) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_get_listing_error");
        }
        return sa_listing;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getNFSFile(String username, String password, String VMSname, String machname, String mainfilename, String dir_nam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket, String usersession) throws NetFileException {
        block14: {
            temp_file = null;
            try {
                try {
                    if (!this.doAuthenticate("127.0.0.1", this.authenticationPort, username, password)) {
                        throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_do_unix_login");
                    }
                    i_ids = this.getUserIDs(username, password);
                    xfile = this.getXFile(VMSname, machname, dir_nam + "/" + mainfilename, true, NfsFile.SHOULD_HAVE_READ_PERMISSION, i_ids);
                    xfis_file = new XFileInputStream(xfile);
                    time = new Long(System.currentTimeMillis());
                    s_temp_file = tmpdir + "/" + time.toString() + username.toUpperCase() + mainfilename;
                    temp_file = new File(s_temp_file);
                    temp_file.createNewFile();
                    fops_tmp = new FileOutputStream(temp_file);
                    c = 0;
                    while (true) {
                        if ((c = xfis_file.read()) <= -1) {
                            fops_tmp.close();
                            fops_tmp = null;
                            xfis_file.close();
                            xfis_file = null;
                            xfile = null;
                            time = null;
                            temp_file = null;
                            var18_20 = s_temp_file;
                            var20_21 = null;
                            if (temp_file == null) return var18_20;
                            break;
                        }
                        fops_tmp.write(c);
                    }
                }
                catch (Exception e) {
                    NfsFile.debug.error("Error in putting NFS File", (Throwable)e);
                    var12_14 = "ERROR:" + e.getMessage();
                    var20_22 = null;
                    if (temp_file == null) return var12_14;
                    try {
                        temp_file.delete();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    temp_file = null;
                    return var12_14;
                }
            }
            catch (Throwable var19_27) {
                block13: {
                    var20_23 = null;
                    if (temp_file == null) throw var19_27;
                    ** try [egrp 2[TRYBLOCK] [2 : 306->315)] { 
lbl52:
                    // 1 sources

                    temp_file.delete();
                    break block13;
lbl55:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                }
                temp_file = null;
                throw var19_27;
            }
            ** try [egrp 2[TRYBLOCK] [2 : 306->315)] { 
lbl62:
            // 1 sources

            temp_file.delete();
            break block14;
lbl65:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
        }
        temp_file = null;
        return var18_20;
    }

    /*
     * Unable to fully structure code
     */
    String putNFSFile(String username, String password, String machname, String VMSname, String localfil_arg, String remotefil_arg, String dir_nam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        block15: {
            f_local_file = null;
            try {
                if (!this.doAuthenticate("127.0.0.1", this.authenticationPort, username, password)) {
                    throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_do_unix_login");
                }
                i_ids = this.getUserIDs(username, password);
                xf_parent_dir = this.getXFile(VMSname, machname, dir_nam, true, NfsFile.SHOULD_HAVE_READ_PERMISSION, i_ids);
                if (!xf_parent_dir.canWrite()) {
                    throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "no_write_permission_to_parent", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", xf_parent_dir.getPath()});
                }
                xfile = this.getXFile(VMSname, machname, dir_nam + "/" + remotefil_arg, false, NfsFile.SHOULD_NOT_HAVE_READ_PERMISSION, i_ids);
                f_local_file = new File(localfil_arg);
                if (!f_local_file.exists()) {
                    throw new NetFileException(new String[]{f_local_file.getPath(), " ", NetFileException.KEY_IDENTIFIER_PREFIX + "does_not_exits"});
                }
                fips_local_file = new FileInputStream(f_local_file);
                xfops_destination_file = new XFileOutputStream(xfile);
                c = 0;
                while ((c = fips_local_file.read()) > -1) {
                    xfops_destination_file.write(c);
                }
                fips_local_file.close();
                f_local_file.delete();
                fips_local_file = null;
                xfops_destination_file.close();
                xfops_destination_file = null;
                f_local_file = null;
                xf_parent_dir = null;
                xfile = null;
                var18_19 = null;
                ** if (f_local_file == null) goto lbl-1000
            }
            catch (Throwable var17_25) {
                var18_21 = null;
                if (f_local_file != null) {
                    try {
                        f_local_file.delete();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw var17_25;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    f_local_file.delete();
                }
                catch (Exception e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block15;
                catch (Exception e) {
                    NfsFile.debug.error("Error in putting NFS File", (Throwable)e);
                    var12_14 = "ERROR:" + e.getMessage();
                    var18_20 = null;
                    if (f_local_file != null) {
                        try {
                            f_local_file.delete();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    return var12_14;
                }
            }
        }
        f_local_file = null;
        return nfr_user_locale_i18n_bucket.getString("info6");
    }

    String[] search(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String dir_nam, String domainname, int maxsrchdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        return this.search(usernam, passwrd, machnam, VMSnam, pattern, dir_nam, maxsrchdir);
    }

    String[] search(String usernam, String passwrd, String machnam, String VMSnam, String pattern, String dir_nam, int maxsrchdir) throws NetFileException {
        if (!this.doAuthenticate("127.0.0.1", this.authenticationPort, usernam, passwrd)) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_do_unix_login");
        }
        int[] i_ids = this.getUserIDs(usernam, passwrd);
        XFile xfile = this.getXFile(VMSnam, machnam, dir_nam, true, false, i_ids);
        String s_prefix = "nfs://" + machnam;
        int i_prefix_length = s_prefix.length();
        if (xfile.isFile()) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "cannot_search_a_file");
        }
        Vector<String> v_search_results = new Vector<String>();
        if (xfile.toString().substring(i_prefix_length, xfile.toString().length()).indexOf(pattern) > -1) {
            v_search_results.addElement(xfile.toString().substring(i_prefix_length, xfile.toString().length()));
        }
        this.search(xfile, maxsrchdir, i_prefix_length, v_search_results, pattern, i_ids);
        String[] sa_resulsts = new String[v_search_results.size()];
        int i = 0;
        while (i < v_search_results.size()) {
            sa_resulsts[i] = (String)v_search_results.elementAt(i);
            ++i;
        }
        return sa_resulsts;
    }

    void search(XFile xfile, int maxsrchdir, int i_prefix_length, Vector v_search_results, String pattern, int[] i_ids) throws NetFileException {
        ++this.i_number_of_directories_traversed;
        debug.message(this + ":Directory number being searched=" + this.i_number_of_directories_traversed);
        if (this.i_number_of_directories_traversed > maxsrchdir) {
            return;
        }
        if (xfile.isFile()) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "cannot_search_a_file");
        }
        String[] sa_contents = xfile.list();
        String s_path = xfile.toString();
        if (sa_contents == null) {
            v_search_results.addElement("Permission denied :" + s_path.substring(i_prefix_length, s_path.length()));
        } else {
            int i = 0;
            while (i < sa_contents.length && this.i_number_of_directories_traversed <= maxsrchdir) {
                String s_current_path = s_path + "/" + sa_contents[i];
                XFile x_file = null;
                try {
                    x_file = this.getXFile(s_current_path, true, false, i_ids);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (sa_contents[i].indexOf(pattern) > -1) {
                    v_search_results.addElement(x_file.toString().substring(i_prefix_length, x_file.toString().length()));
                }
                if (x_file.isDirectory()) {
                    if (x_file.canRead()) {
                        this.search(x_file, maxsrchdir, i_prefix_length, v_search_results, pattern, i_ids);
                    } else {
                        v_search_results.addElement("Permission denied :" + x_file.toString().substring(i_prefix_length, x_file.toString().length()));
                    }
                }
                ++i;
            }
        }
    }

    String delNFSFile(String username, String password, String VMSname, String machname, String mainfilename, String dir_nam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket) throws NetFileException {
        try {
            if (!this.doAuthenticate("127.0.0.1", this.authenticationPort, username, password)) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_do_unix_login");
            }
            int[] i_ids = this.getUserIDs(username, password);
            XFile xf_parent_directory = this.getXFile(VMSname, machname, dir_nam, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
            if (!xf_parent_directory.canWrite()) {
                throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "no_write_permission_to_parent", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", " ", xf_parent_directory.getPath()});
            }
            XFile xf_file = this.getXFile(VMSname, machname, dir_nam + "/" + mainfilename, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
            if (!xf_file.canWrite()) {
                throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "no_write_permission", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", " ", xf_file.getPath()});
            }
            xf_file.delete();
        }
        catch (Exception e) {
            debug.error("Error in putting NFS File", (Throwable)e);
            return "ERROR:" + e.getMessage();
        }
        return nfr_user_locale_i18n_bucket.getString("info5");
    }

    private String getFileURL(String VMSnam, String machname, String dir_nam) {
        StringBuffer sb_file_pointer = new StringBuffer("nfs://");
        sb_file_pointer.append(machname);
        sb_file_pointer.append(VMSnam);
        sb_file_pointer.append(dir_nam);
        return sb_file_pointer.toString();
    }

    public XFileOutputStream getNFSOutputStream(String username, String password, String machname, String VMSname, String remotefil_arg, String dir_nam) throws Exception, NetFileException {
        if (!this.doAuthenticate("127.0.0.1", this.authenticationPort, username, password)) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_do_unix_login");
        }
        int[] i_ids = this.getUserIDs(username, password);
        XFile xf_parent_dir = this.getXFile(VMSname, machname, dir_nam, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
        if (!xf_parent_dir.canWrite()) {
            throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "no_write_permission_to_parent", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", xf_parent_dir.getPath()});
        }
        XFile xfile = this.getXFile(VMSname, machname, dir_nam + "/" + remotefil_arg, false, SHOULD_NOT_HAVE_READ_PERMISSION, i_ids);
        this.outstream = new XFileOutputStream(xfile);
        return this.outstream;
    }

    public XFileInputStream getNFSInputStream(String username, String password, String VMSname, String machname, String mainfilename, String dir_nam) throws Exception, NetFileException {
        if (!this.doAuthenticate("127.0.0.1", this.authenticationPort, username, password)) {
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_do_unix_login");
        }
        int[] i_ids = this.getUserIDs(username, password);
        XFile xfile = this.getXFile(VMSname, machname, dir_nam + "/" + mainfilename, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
        this.instream = new XFileInputStream(xfile);
        return this.instream;
    }

    public void closeNfsFile() throws IOException {
        if (this.instream != null) {
            this.instream.close();
        }
        if (this.outstream != null) {
            this.outstream.close();
        }
        this.instream = null;
        this.outstream = null;
    }

    private XFile getXFile(String s_nfs_url, boolean b_file_should_exist, boolean b_is_read_allowed, int[] i_ids) throws NetFileException {
        XFile xfile = new XFile(s_nfs_url);
        XFileExtensionAccessor nfsx = new XFileExtensionAccessor(xfile);
        int i_uid = i_ids[0];
        int i_gid = i_ids[1];
        int[] i_gids = new int[]{i_gid};
        nfsx.loginUGID(i_uid, i_gid, i_gids);
        if (b_file_should_exist && !xfile.exists()) {
            throw new NetFileException(new String[]{xfile.getPath(), " ", NetFileException.KEY_IDENTIFIER_PREFIX + "not_found"});
        }
        if (b_is_read_allowed && !xfile.canRead()) {
            throw new NetFileException(new String[]{xfile.getPath(), " ", NetFileException.KEY_IDENTIFIER_PREFIX + "no_read_permission"});
        }
        return xfile;
    }

    private XFile getXFile(String VMSName, String machname, String file, boolean b_file_should_exist, boolean b_is_read_allowed, int[] i_ids) throws NetFileException {
        if (!VMSName.startsWith("/")) {
            VMSName = "/" + VMSName;
        }
        if (!file.startsWith("/")) {
            file = "/" + file;
        }
        String s_nfs_url = this.getFileURL(VMSName, machname, file);
        return this.getXFile(s_nfs_url, b_file_should_exist, b_is_read_allowed, i_ids);
    }

    void rename(String username, String password, String machine, String share, String directory, String old_file_name, String new_file_name) throws NetFileException {
        try {
            if (!this.doAuthenticate("127.0.0.1", this.authenticationPort, username, password)) {
                throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "unable_to_do_unix_login");
            }
            int[] i_ids = this.getUserIDs(username, password);
            XFile xf_parent_directory = this.getXFile(share, machine, directory, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
            if (!xf_parent_directory.canWrite()) {
                throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "no_write_permission_to_parent", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", " ", xf_parent_directory.getPath()});
            }
            XFile xf_file = this.getXFile(share, machine, directory + "/" + old_file_name, true, SHOULD_HAVE_READ_PERMISSION, i_ids);
            if (!xf_file.canWrite()) {
                throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "no_write_permission", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", " ", xf_file.getPath()});
            }
            XFile xf_renamed_file = new XFile(xf_parent_directory, new_file_name);
            if (xf_renamed_file.exists() && !xf_renamed_file.canWrite()) {
                throw new NetFileException(new String[]{NetFileException.KEY_IDENTIFIER_PREFIX + "no_write_permission", NetFileException.KEY_IDENTIFIER_PREFIX + "textseperator", " ", xf_renamed_file.getPath()});
            }
            xf_file.renameTo(xf_renamed_file);
        }
        catch (Exception e) {
            debug.error("Error in putting NFS File", (Throwable)e);
            throw new NetFileException(NetFileException.KEY_IDENTIFIER_PREFIX + "problem_rename_file");
        }
    }

    /*
     * Loose catch block
     */
    boolean doAuthenticate(String host, int port, String username, String passwd) {
        boolean returnValue;
        block18: {
            Socket sock = null;
            returnValue = false;
            sock = new Socket(host, port);
            BufferedReader buffRdr = new BufferedReader(new InputStreamReader(sock.getInputStream(), "ISO-8859-1"));
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(sock.getOutputStream(), "ISO-8859-1"));
            boolean stop = false;
            do {
                char[] buf = new char[254];
                int i = buffRdr.read(buf, 0, 254);
                String output = new String(buf);
                if (output.startsWith("Enter Unix login:")) {
                    pw.println(username);
                    pw.flush();
                    continue;
                }
                if (output.startsWith("Enter password:")) {
                    pw.println(passwd);
                    pw.flush();
                    continue;
                }
                if (output.startsWith("Authentication passed")) {
                    stop = true;
                    returnValue = true;
                    continue;
                }
                if (output.indexOf("return") <= 0) continue;
                stop = true;
                returnValue = false;
            } while (!stop);
            Object var14_15 = null;
            try {
                if (sock != null) {
                    sock.close();
                    sock = null;
                }
                break block18;
            }
            catch (Exception ee) {
                returnValue = false;
            }
            break block18;
            {
                catch (ConnectException ce) {
                    debug.error("NfsFile, Exception while authenticating, ", (Throwable)ce);
                    returnValue = false;
                    Object var14_16 = null;
                    try {
                        if (sock != null) {
                            sock.close();
                            sock = null;
                        }
                        break block18;
                    }
                    catch (Exception ee) {
                        returnValue = false;
                    }
                    break block18;
                }
                catch (Exception e) {
                    debug.error("NfsFile, Exception while authenticating, ", (Throwable)e);
                    returnValue = false;
                    Object var14_17 = null;
                    try {
                        if (sock != null) {
                            sock.close();
                            sock = null;
                        }
                        break block18;
                    }
                    catch (Exception ee) {
                        returnValue = false;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                try {
                    if (sock != null) {
                        sock.close();
                        sock = null;
                    }
                }
                catch (Exception ee) {
                    returnValue = false;
                }
                throw throwable;
            }
        }
        return returnValue;
    }

    static {
        SHOULD_HAVE_READ_PERMISSION = true;
        SHOULD_NOT_HAVE_READ_PERMISSION = false;
        ia_unable_to_login = new int[]{-1, -1};
        System.loadLibrary("getpwnam");
    }
}

