/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.clip;

import com.sun.portal.rewriter.util.LocaleHelper;
import com.sun.portal.rewriter.util.clip.CLIPParser;
import com.sun.portal.rewriter.util.clip.CLIPSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public class CLIPOption {
    static final CLIPOption[] EMTPY_CLIP_OPTION_ARRAY = new CLIPOption[0];
    private String longName;
    private String shortName;
    private boolean mandatory;
    private int type;
    private String[] defaultValues = null;
    private String helpMessage;

    public CLIPOption(String string, String string2, int n, String string3, String string4) throws IllegalArgumentException {
        this.setLongName(string);
        this.setShortName(string2);
        this.setType(n);
        this.setDefaultValues(n, string3, string2);
        this.setHelpMessage(string4);
    }

    public String getLongName() {
        return this.longName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public int getType() {
        return this.type;
    }

    public String[] getDefaultValues() {
        return this.defaultValues;
    }

    public String getHelpMessage() {
        return this.helpMessage;
    }

    private void setLongName(String string) {
        CLIPParser.verifyName(string, "CLIPOption - Option's long name");
        this.longName = string.trim();
    }

    private void setMandatory(String string) {
        this.mandatory = string == null || string.trim().equalsIgnoreCase("");
    }

    private void setShortName(String string) {
        if (string == null) {
            return;
        }
        if (string.length() > 1) {
            throw new IllegalArgumentException("CLIPOption - Option's short name has to be undefined (NULL) or one character long");
        }
        if (string.equals("-")) {
            throw new IllegalArgumentException("CLIPOption - Option's short name can not be '-'");
        }
        this.shortName = string.trim();
    }

    private void setType(int n) {
        this.type = n;
    }

    private void setDefaultValues(int n, String string, String string2) {
        this.setMandatory(string);
        if (this.isMandatory()) {
            return;
        }
        switch (n) {
            case 0: {
                String string3 = string.trim();
                if (!string3.equals("true") && !string3.equals("false")) {
                    throw new IllegalArgumentException("CLIPOption - Boolean default value has to be 'true' or 'false'");
                }
                this.defaultValues = new String[1];
                this.defaultValues[0] = string3;
                break;
            }
            case 1: {
                this.defaultValues = new String[1];
                this.defaultValues[0] = string;
                break;
            }
            case 2: {
                if (string2 != null) {
                    throw new IllegalArgumentException("CLIPOption - Collection options can not have short names");
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                String string4 = string.indexOf(" ") > -1 ? " " : ",";
                StringTokenizer stringTokenizer = new StringTokenizer(string, string4);
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    arrayList.add(string5);
                }
                this.defaultValues = new String[arrayList.size()];
                arrayList.toArray(this.defaultValues);
                break;
            }
            default: {
                throw new IllegalArgumentException("CLIPOption - Invalid type");
            }
        }
    }

    private void setHelpMessage(String string) {
        if (string == null) {
            throw new IllegalArgumentException("CLIPOption - Option's help can not be NULL");
        }
        this.helpMessage = CLIPSpec.getLocaleHelper().getLocalizedString(string);
    }

    public String toString() {
        return "\nLongName : " + this.getLongName() + "\n" + "ShortName : " + this.getShortName() + "\n" + "Mandatory: " + this.isMandatory() + "\n" + "Type: " + this.getType() + "\n" + "DefaultValues: " + Arrays.asList(this.getDefaultValues()) + "\n" + "HelpMessage: " + this.getHelpMessage() + "\n";
    }

    public static void main(String[] stringArray) {
        LocaleHelper.store("psrwCLI", LocaleHelper.getLocale(null));
        CLIPOption cLIPOption = new CLIPOption("version", null, 2, "a b c d e", "TestMessage");
        System.out.println(cLIPOption.getHelpMessage());
    }
}

