/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines.common;

import com.sun.portal.rewriter.Data;
import com.sun.portal.rewriter.DataRule;
import com.sun.portal.rewriter.RewriterTestInputs;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.xml.Node;
import java.util.List;

public final class Attribute
extends DataRule {
    private Data name;
    private Data tag;
    private Data valuePatterns;
    private List parsedValuePatterns;

    public Attribute(String string, String string2) {
        this(string, string2, null);
    }

    public Attribute(String string, String string2, String string3) {
        super("Attributes", null);
        this.name = new Data(StringHelper.normalize(string), true);
        this.tag = new Data(StringHelper.normalize(string2, "*"), true);
        this.valuePatterns = new Data(StringHelper.normalize(string3));
    }

    public Attribute(Node node) {
        this(node.getAttributeValue("name"), node.getAttributeValue("tag"), node.getAttributeValue("valuePatterns"));
    }

    public String getName() {
        return this.name.value;
    }

    public String getTag() {
        return this.tag.value;
    }

    public String getValuePatterns() {
        return this.valuePatterns.value;
    }

    public List getParsedPatterns() {
        if (this.parsedValuePatterns == null) {
            this.parsedValuePatterns = DataRule.parsePatterns(this.valuePatterns.value);
        }
        return this.parsedValuePatterns;
    }

    public boolean matches(DataRule dataRule) {
        if (dataRule == null && !(dataRule instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)dataRule;
        return DataRule.match(this.name, attribute.name.value) && DataRule.match(this.tag, attribute.tag.value);
    }

    public boolean isValid() {
        return DataRule.doBasicValidation(new String[]{this.name.value});
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("<").append("Attribute").append(" ").append("name").append("=").append("\"").append(this.name).append("\"").append(" ").append("tag").append("=").append("\"").append(this.tag).append("\"").append(" ").append("valuePatterns").append("=").append("\"").append(this.valuePatterns).append("\"").append(" ").append("/>").append("\n");
        return stringBuffer.toString();
    }

    public static Attribute cycleMatche(Attribute attribute, String string, String string2) {
        attribute.name.value = string;
        attribute.tag.value = string2;
        return attribute;
    }

    public static void main(String[] stringArray) {
        Attribute[] attributeArray = RewriterTestInputs.defaultHTMLAttributes;
        int n = 0;
        while (n < attributeArray.length) {
            Debug.println(attributeArray[n].toXML());
            ++n;
        }
    }
}

