/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.clip;

import com.sun.portal.rewriter.util.clip.CLIPException;
import com.sun.portal.rewriter.util.clip.CLIPOption;
import com.sun.portal.rewriter.util.clip.CLIPSpec;
import com.sun.portal.rewriter.util.clip.CLIPSubCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class CLIPParser {
    private String toolHelpMessage;
    private Map subCommandsList = new HashMap();
    private List orderedSubCommandsList = new ArrayList();

    public CLIPParser(CLIPSubCommand[] cLIPSubCommandArray, String string) throws IllegalArgumentException {
        this.toolHelpMessage = CLIPSpec.getLocaleHelper().getLocalizedString(string);
        if (cLIPSubCommandArray == null || cLIPSubCommandArray.length == 0) {
            throw new IllegalArgumentException("CLIPParser - sub command array can not be null or empty");
        }
        int n = 0;
        while (n < cLIPSubCommandArray.length) {
            if (cLIPSubCommandArray[n].getSubCommandName() == null) {
                throw new IllegalArgumentException("CLIPSubCommand can not be null");
            }
            this.addSubCommand(cLIPSubCommandArray[n]);
            ++n;
        }
    }

    public CLIPParser(CLIPOption[] cLIPOptionArray, int n, int n2, String string, String string2) throws IllegalArgumentException {
        CLIPSubCommand cLIPSubCommand = new CLIPSubCommand(null, cLIPOptionArray, n, n2, string2, string);
        this.addSubCommand(cLIPSubCommand);
    }

    private void addSubCommand(CLIPSubCommand cLIPSubCommand) throws IllegalArgumentException {
        if (cLIPSubCommand.getSubCommandName() != null) {
            CLIPParser.verifyName(cLIPSubCommand.getSubCommandName(), "CLIPSubCommand");
        }
        if (this.subCommandsList.containsKey(cLIPSubCommand.getSubCommandName())) {
            throw new IllegalArgumentException("CLIPSubCommand '" + cLIPSubCommand.getSubCommandName() + "', sub command already defined");
        }
        this.subCommandsList.put(cLIPSubCommand.getSubCommandName(), cLIPSubCommand);
        this.orderedSubCommandsList.add(cLIPSubCommand);
    }

    public void verifyArguments(String[] stringArray) {
        try {
            if (CLIPParser.scanForStdExitOptions(stringArray) != null) {
                return;
            }
            this.getSubCommand(stringArray);
            this.getOptions(stringArray);
            this.getOperands(stringArray);
        }
        catch (CLIPException cLIPException) {
            System.err.println(cLIPException);
            System.exit(0);
        }
    }

    public String getSubCommand(String[] stringArray) throws CLIPException {
        boolean bl = !this.subCommandsList.containsKey(null);
        String string = stringArray.length > 0 && bl ? stringArray[0] : null;
        CLIPSubCommand cLIPSubCommand = (CLIPSubCommand)this.subCommandsList.get(string);
        if (cLIPSubCommand == null) {
            throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorInvalidSubCmd", new Object[]{string}), 0);
        }
        return string;
    }

    public Map getOptions(String[] stringArray) throws CLIPException {
        Object object;
        CLIPSubCommand cLIPSubCommand = (CLIPSubCommand)this.subCommandsList.get(this.getSubCommand(stringArray));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = cLIPSubCommand.getDefaultOptionValues().keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object = (List)cLIPSubCommand.getDefaultOptionValues().get(string);
            hashMap.put(string, ((ArrayList)object).clone());
        }
        int n = this.processOptions(stringArray, hashMap);
        iterator = cLIPSubCommand.getValidOptions().keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            CLIPOption cLIPOption = (CLIPOption)cLIPSubCommand.getValidOptions().get(object);
            if (cLIPOption.getDefaultValues() != null || hashMap.containsKey(cLIPOption.getLongName())) continue;
            throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorMissingMandatoryOption", new Object[]{cLIPOption.getLongName()}), n);
        }
        return this.massageOptions(hashMap);
    }

    public String[] getOperands(String[] stringArray) throws CLIPException {
        CLIPSubCommand cLIPSubCommand = (CLIPSubCommand)this.subCommandsList.get(this.getSubCommand(stringArray));
        int n = this.processOptions(stringArray, new HashMap());
        int n2 = stringArray.length - n;
        if (cLIPSubCommand.getMinOperands() > n2 || n2 > cLIPSubCommand.getMaxOperands()) {
            throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorInvalidOperandsCount"), n);
        }
        int n3 = n;
        while (n3 < stringArray.length) {
            if (stringArray[n3].equals("--")) {
                throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorDashDashCantBeOperand"), n3);
            }
            ++n3;
        }
        String[] stringArray2 = new String[n2];
        if (stringArray.length > 0) {
            System.arraycopy(stringArray, n, stringArray2, 0, n2);
        }
        return stringArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int processOptions(String[] stringArray, Map map) throws CLIPException {
        CLIPSubCommand cLIPSubCommand = (CLIPSubCommand)this.subCommandsList.get(this.getSubCommand(stringArray));
        boolean bl = false;
        int n = cLIPSubCommand.getSubCommandName() != null ? 1 : 0;
        while (!bl && n < stringArray.length) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string;
            if (stringArray[n].startsWith("--add-")) {
                string = stringArray[n].substring("--add-".length());
                CLIPOption cLIPOption = (CLIPOption)cLIPSubCommand.getValidOptions().get(string);
                if (string.length() < 2 || cLIPOption == null) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorInvalidOption", new Object[]{string}), n);
                }
                if (cLIPOption.getType() != 2) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorNotACollection", new Object[]{string}), n);
                }
                object4 = this.getOptionValues(cLIPSubCommand, map, string);
                if (n + 1 == stringArray.length) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorMissingCollectionValuesToAdd", new Object[]{string}), n);
                }
                object2 = new StringTokenizer((String)object3, ((String)(object3 = stringArray[++n])).indexOf(" ") > -1 ? " " : ",");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                    object4.add(object);
                }
            } else if (stringArray[n].startsWith("--remove-")) {
                string = stringArray[n].substring("--remove-".length());
                CLIPOption cLIPOption = (CLIPOption)cLIPSubCommand.getValidOptions().get(string);
                if (string.length() < 2 || cLIPOption == null) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorInvalidOption", new Object[]{string}), n);
                }
                if (cLIPOption.getType() != 2) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorNotACollection", new Object[]{string}), n);
                }
                if (n + 1 == stringArray.length) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorMissingCollectionValuesToDelete", new Object[]{string}), n);
                }
                object4 = this.getOptionValues(cLIPSubCommand, map, string);
                object2 = new StringTokenizer((String)object3, ((String)(object3 = stringArray[++n])).indexOf(" ") > -1 ? " " : ",");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                    if (object4.contains(object)) {
                        object4.remove(object);
                        continue;
                    }
                    int n2 = 0;
                    while (n2 < object4.size()) {
                        String string2 = (String)object4.get(n2);
                        if (string2.startsWith((String)object + "=")) {
                            object4.remove(n2);
                        }
                        ++n2;
                    }
                }
            } else if (stringArray[n].equals("--")) {
                ++n;
                bl = true;
            } else if (stringArray[n].startsWith("--no-")) {
                string = stringArray[n].substring("--no-".length());
                CLIPOption cLIPOption = (CLIPOption)cLIPSubCommand.getValidOptions().get(string);
                if (cLIPOption == null) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorInvalidOption", new Object[]{string}), n);
                }
                if (cLIPOption.getType() != 0) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorNotABoolean", new Object[]{string}), n);
                }
                object4 = "false";
                object3 = this.getOptionValues(cLIPSubCommand, map, string);
                object3.clear();
                object3.add(object4);
            } else if (stringArray[n].startsWith("--")) {
                string = stringArray[n].substring("--".length());
                CLIPOption cLIPOption = (CLIPOption)cLIPSubCommand.getValidOptions().get(string);
                if (cLIPOption == null) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorInvalidOption", new Object[]{string}), n);
                }
                if (cLIPOption.getType() == 0) {
                    object4 = "true";
                    object3 = this.getOptionValues(cLIPSubCommand, map, string);
                    object3.clear();
                    object3.add(object4);
                } else if (cLIPOption.getType() == 1) {
                    if (n + 1 == stringArray.length) {
                        throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorMissingRegularOptionValue", new Object[]{string}), n);
                    }
                    object4 = stringArray[++n];
                    object3 = this.getOptionValues(cLIPSubCommand, map, string);
                    object3.clear();
                    object3.add(object4);
                } else {
                    if (cLIPOption.getType() != 2) throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("clipInternalError"), n);
                    if (n + 1 == stringArray.length) {
                        throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorMissingCollectionOptionValue", new Object[]{string}), n);
                    }
                    object4 = stringArray[++n];
                    object3 = this.getOptionValues(cLIPSubCommand, map, string);
                    object3.clear();
                    object2 = new StringTokenizer((String)object4, ((String)object4).indexOf(" ") > -1 ? " " : ",");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken();
                        object3.add(object);
                    }
                }
            } else if (stringArray[n].startsWith("-")) {
                string = stringArray[n].substring("-".length());
                int n3 = 0;
                while (n3 < string.length() - 1) {
                    object4 = "" + string.charAt(n3);
                    object3 = (CLIPOption)cLIPSubCommand.getValidOptions().get(object4);
                    if (object3 == null) {
                        throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorInvalidOption", new Object[]{object4}), n);
                    }
                    if (((CLIPOption)object3).getType() != 0) {
                        throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorNotABooleanOption", new Object[]{object4}), n);
                    }
                    object2 = "true";
                    object = this.getOptionValues(cLIPSubCommand, map, (String)object4);
                    object.clear();
                    object.add(object2);
                    ++n3;
                }
                string = "" + string.charAt(string.length() - 1);
                object4 = (CLIPOption)cLIPSubCommand.getValidOptions().get(string);
                if (object4 == null) {
                    throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorInvalidOption", new Object[]{string}), n);
                }
                if (((CLIPOption)object4).getType() == 0) {
                    object3 = "true";
                    object2 = this.getOptionValues(cLIPSubCommand, map, string);
                    object2.clear();
                    object2.add(object3);
                } else {
                    if (((CLIPOption)object4).getType() != 1) throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("clipInternalError"), n);
                    if (n + 1 == stringArray.length) {
                        throw new CLIPException(CLIPSpec.getLocaleHelper().getLocalizedString("errorMissingRegularOptionValue", new Object[]{string}), n);
                    }
                    object3 = stringArray[++n];
                    object2 = this.getOptionValues(cLIPSubCommand, map, string);
                    object2.clear();
                    object2.add(object3);
                }
            } else {
                bl = true;
            }
            ++n;
        }
        if (!bl) return n;
        --n;
        return n;
    }

    private List getOptionValues(CLIPSubCommand cLIPSubCommand, Map map, String string) {
        CLIPOption cLIPOption = (CLIPOption)cLIPSubCommand.getValidOptions().get(string);
        String string2 = cLIPOption.getLongName();
        ArrayList arrayList = (ArrayList)map.get(string2);
        if (arrayList == null) {
            arrayList = new ArrayList();
            map.put(string2, arrayList);
        }
        return arrayList;
    }

    private Map massageOptions(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = (List)map.get(string);
            String[] stringArray = new String[list.size()];
            list.toArray(stringArray);
            map.put(string, stringArray);
        }
        return map;
    }

    public static String getName(String string) {
        String string2 = string;
        int n = string.indexOf("=");
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static String getValue(String string) {
        String string2 = null;
        int n = string.indexOf("=");
        if (n > -1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public String toString(String[] stringArray) throws CLIPException {
        StringBuffer stringBuffer = new StringBuffer(2048);
        String string = this.getSubCommand(stringArray);
        Map map = this.getOptions(stringArray);
        String[] stringArray2 = this.getOperands(stringArray);
        stringBuffer.append("\n").append("Sub-command: ").append(string).append("\n").append("\n").append("Options: ").append("\n");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String[] stringArray3 = (String[])map.get(string2);
            stringBuffer.append(("  " + string2 + "              ").substring(0, 12) + ": ");
            int n = 0;
            while (n < stringArray3.length) {
                stringBuffer.append(stringArray3[n]).append(" ");
                ++n;
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n").append("Operands: ").append("\n");
        int n = 0;
        while (n < stringArray2.length) {
            stringBuffer.append("  ").append(stringArray2[n]).append("\n");
            ++n;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public boolean needsHelp(String[] stringArray) {
        boolean bl = false;
        try {
            this.verifyArguments(stringArray);
            Map map = this.getOptions(stringArray);
            bl = map.containsKey("help") && ((String[])map.get("help"))[0].equals("true");
        }
        catch (CLIPException cLIPException) {
            bl = true;
        }
        return bl;
    }

    public String getHelp(String[] stringArray) {
        CLIPSubCommand cLIPSubCommand;
        boolean bl = false;
        String string = stringArray.length > 0 ? stringArray[0] : null;
        boolean bl2 = bl = !this.subCommandsList.containsKey(string);
        if (!bl) {
            cLIPSubCommand = (CLIPSubCommand)this.subCommandsList.get(string);
        } else {
            cLIPSubCommand = (CLIPSubCommand)this.subCommandsList.get(null);
            bl = cLIPSubCommand == null || cLIPSubCommand.getSubCommandName() != null;
        }
        StringBuffer stringBuffer = new StringBuffer(2048);
        if (bl) {
            stringBuffer.append(this.toolHelpMessage).append("\n\n");
            stringBuffer.append("SUBCOMMANDS\n");
            int n = this.orderedSubCommandsList.size();
            int n2 = 0;
            while (n2 < n) {
                cLIPSubCommand = (CLIPSubCommand)this.orderedSubCommandsList.get(n2);
                String string2 = cLIPSubCommand.getSubCommandName();
                string2 = string2 == null ? "<NO SUB COMMAND>  " : string2 + "  ";
                stringBuffer.append("  ").append(string2).append(cLIPSubCommand.getSubCommandHelp()).append(".\n");
                this.printOptionsHelp(stringBuffer, "    ", cLIPSubCommand.getOrderedOptions());
                if (cLIPSubCommand.getMaxOperands() > 0) {
                    if (cLIPSubCommand.getMaxOperands() == 1) {
                        stringBuffer.append("    <OPERAND> ");
                    } else {
                        stringBuffer.append("    <OPERANDS> ");
                    }
                    stringBuffer.append(cLIPSubCommand.getOperandsHelp()).append("\n");
                }
                ++n2;
            }
        } else {
            stringBuffer.append(cLIPSubCommand.getSubCommandHelp()).append(".\n\n");
            stringBuffer.append("OPTIONS\n");
            this.printOptionsHelp(stringBuffer, "  ", cLIPSubCommand.getOrderedOptions());
            if (cLIPSubCommand.getMaxOperands() > 0) {
                if (cLIPSubCommand.getMaxOperands() == 1) {
                    stringBuffer.append("\nOPERAND\n");
                } else {
                    stringBuffer.append("\nOPERANDS\n");
                }
                stringBuffer.append("  ").append(cLIPSubCommand.getOperandsHelp()).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    private void printOptionsHelp(StringBuffer stringBuffer, String string, List list) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            CLIPOption cLIPOption = (CLIPOption)list.get(n2);
            stringBuffer.append(string);
            if (cLIPOption.getShortName() == null || cLIPOption.getShortName().length() == 0) {
                stringBuffer.append("   ");
            } else {
                stringBuffer.append('-').append(cLIPOption.getShortName()).append(' ');
            }
            stringBuffer.append("--").append(cLIPOption.getLongName()).append(' ');
            stringBuffer.append(cLIPOption.getHelpMessage()).append(" (");
            if (cLIPOption.getDefaultValues() == null) {
                stringBuffer.append("none");
            } else {
                int n3 = 0;
                while (n3 < cLIPOption.getDefaultValues().length) {
                    if (n3 > 0) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(cLIPOption.getDefaultValues()[n3]);
                    ++n3;
                }
            }
            stringBuffer.append(")\n");
            ++n2;
        }
    }

    static String scanForStdExitOptions(String[] stringArray) {
        String string = "--help";
        String string2 = "--version";
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return string;
            }
            if (stringArray[n].equals(string2)) {
                return string2;
            }
            ++n;
        }
        return null;
    }

    static void verifyName(String string, String string2) {
        if (string == null || string.length() < 2) {
            throw new IllegalArgumentException(string2 + " has to be at least 2 chars long");
        }
        if (string.equals("--")) {
            throw new IllegalArgumentException(string2 + " can not be '--'");
        }
        if (string.startsWith("-") || string.endsWith("-")) {
            throw new IllegalArgumentException(string2 + " can not start or end with '-'");
        }
        if (!string.equals(string.toLowerCase())) {
            throw new IllegalArgumentException(string2 + " has to be in lower case");
        }
    }

    public String toString() {
        return "Tool Help Message: " + this.toolHelpMessage + "\n" + "\nSub Command List: " + this.subCommandsList + "\n";
    }
}

