/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.perfmon;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMProviderException;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.provider.MethodProvider;
import com.sun.wbem.provider.PropertyProvider;
import com.sun.wbem.provider20.Authorizable;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.query.NonJoinExp;
import com.sun.wbem.query.QueryExp;
import com.sun.wbem.query.SelectExp;
import com.sun.wbem.query.SelectList;
import com.sun.wbem.query.WQLParser;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.perfmon.DiskIOInformation;
import com.sun.wbem.solarisprovider.perfmon.PerformanceMonitor;
import com.sun.wbem.utility.log.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class Solaris_DiskIOInformation
implements InstanceProvider,
PropertyProvider,
MethodProvider,
Authorizable {
    public static final String PROVIDERNAME = "Solaris System Performance Monitor";
    public static final String CAPTION = "Solaris Disk IO Information: ";
    private static CIMOMHandle cimomHandle = null;
    private static ProviderUtility provUtil = null;
    private LogUtil logUtil = null;
    private PerformanceMonitor perfMon = null;

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        try {
            String[] stringArray = new String[]{"Create Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {}
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            String[] stringArray = new String[]{"Delete Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {}
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        Vector vector2 = null;
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"enumInstances"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            vector2 = this.perfMon.getAllDiskIOInfoObjs();
            if (vector2 == null) {
                return null;
            }
            int n = 0;
            while (n < vector2.size()) {
                CIMObjectPath cIMObjectPath2 = null;
                cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                cIMObjectPath2.addKey("Name", new CIMValue((Object)((DiskIOInformation)vector2.elementAt(n)).getDeviceName()));
                cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_DiskIOInformation"));
                try {
                    cIMObjectPath2.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (UnknownHostException unknownHostException) {}
                cIMObjectPath2.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                cIMObjectPath2.addKey("DeviceCreationClassName", new CIMValue((Object)"Solaris_DiskDrive"));
                vector.addElement(cIMObjectPath2);
                ++n;
            }
            return vector;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = this.perfMon.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        Vector vector2 = null;
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"enumInstances"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            vector2 = this.perfMon.getAllDiskIOInfoObjs();
            if (vector2 == null) {
                return null;
            }
            int n = 0;
            while (n < vector2.size()) {
                CIMInstance cIMInstance = cIMClass.newInstance();
                DiskIOInformation diskIOInformation = null;
                diskIOInformation = (DiskIOInformation)vector2.elementAt(n);
                if (diskIOInformation != null) {
                    cIMInstance.setProperty("Wlastupdate", new CIMValue((Object)new Double(diskIOInformation.getWlastupdate())));
                    cIMInstance.setProperty("Reads", new CIMValue((Object)new Double(diskIOInformation.getReads())));
                    cIMInstance.setProperty("Writes", new CIMValue((Object)new Double(diskIOInformation.getWrites())));
                    cIMInstance.setProperty("Nread", new CIMValue((Object)new Double(diskIOInformation.getNread())));
                    cIMInstance.setProperty("Nwritten", new CIMValue((Object)new Double(diskIOInformation.getNwritten())));
                    cIMInstance.setProperty("Wlentime", new CIMValue((Object)new Double(diskIOInformation.getWlentime())));
                    cIMInstance.setProperty("Rlentime", new CIMValue((Object)new Double(diskIOInformation.getRlentime())));
                    cIMInstance.setProperty("Wtime", new CIMValue((Object)new Double(diskIOInformation.getWtime())));
                    cIMInstance.setProperty("Rtime", new CIMValue((Object)new Double(diskIOInformation.getRtime())));
                    cIMInstance.setProperty("Name", new CIMValue((Object)diskIOInformation.getDeviceName()));
                }
                if (!bl2) {
                    cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_DiskIOInformation"));
                    try {
                        cIMInstance.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                    }
                    catch (UnknownHostException unknownHostException) {}
                    cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                    cIMInstance.setProperty("DeviceCreationClassName", new CIMValue((Object)"Solaris_DiskDrive"));
                    cIMInstance.setProperty("Description", new CIMValue((Object)diskIOInformation.getDeviceName()));
                    cIMInstance.setProperty("Caption", new CIMValue((Object)diskIOInformation.getDeviceName()));
                }
                vector.addElement(cIMInstance);
                ++n;
            }
        }
        catch (Exception exception) {
            String string = this.perfMon.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return vector;
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) throws CIMException {
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"execQuery"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        WQLParser wQLParser = new WQLParser((InputStream)byteArrayInputStream);
        Vector<CIMElement> vector = new Vector<CIMElement>();
        try {
            SelectExp selectExp = (SelectExp)wQLParser.querySpecification();
            SelectList selectList = selectExp.getSelectList();
            NonJoinExp nonJoinExp = (NonJoinExp)selectExp.getFromClause();
            QueryExp queryExp = selectExp.getWhereClause();
            Vector vector2 = new Vector();
            vector2 = this.enumInstances(cIMObjectPath, false, cIMClass, true);
            int n2 = 0;
            while (n2 < vector2.size()) {
                if (queryExp == null || queryExp.apply((CIMElement)((CIMInstance)vector2.elementAt(n2)))) {
                    vector.addElement(selectList.apply((CIMElement)((CIMInstance)vector2.elementAt(n2))));
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{string};
            String string2 = this.perfMon.writeLog(2, "LM_9630", stringArray, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string2);
        }
        return vector;
    }

    public Integer getBulkDiskIOData(Vector vector) throws CIMException {
        Integer n;
        try {
            String string = this.perfMon.getBulkDiskIOData();
            if (string == null) {
                n = new Integer(-1);
            } else {
                vector.addElement(new CIMValue((Object)string));
                n = new Integer(0);
            }
        }
        catch (Exception exception) {
            String string = this.perfMon.writeLog(2, null, null, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return n;
    }

    protected static CIMOMHandle getCimomHandle() {
        return cimomHandle;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) throws CIMException {
        CIMInstance cIMInstance = cIMClass.newInstance();
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"getInstance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            DiskIOInformation diskIOInformation;
            String string = null;
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration != null && enumeration.hasMoreElements()) {
                diskIOInformation = (CIMProperty)enumeration.nextElement();
                if (!diskIOInformation.getName().equalsIgnoreCase("Name")) continue;
                string = (String)diskIOInformation.getValue().getValue();
            }
            diskIOInformation = this.perfMon.getDiskIOInfoObj(string);
            if (diskIOInformation != null) {
                cIMInstance.setProperty("Wlastupdate", new CIMValue((Object)new Double(diskIOInformation.getWlastupdate())));
                cIMInstance.setProperty("Reads", new CIMValue((Object)new Double(diskIOInformation.getReads())));
                cIMInstance.setProperty("Writes", new CIMValue((Object)new Double(diskIOInformation.getWrites())));
                cIMInstance.setProperty("Nread", new CIMValue((Object)new Double(diskIOInformation.getNread())));
                cIMInstance.setProperty("Nwritten", new CIMValue((Object)new Double(diskIOInformation.getNwritten())));
                cIMInstance.setProperty("Wlentime", new CIMValue((Object)new Double(diskIOInformation.getWlentime())));
                cIMInstance.setProperty("Rlentime", new CIMValue((Object)new Double(diskIOInformation.getRlentime())));
                cIMInstance.setProperty("Wtime", new CIMValue((Object)new Double(diskIOInformation.getWtime())));
                cIMInstance.setProperty("Rtime", new CIMValue((Object)new Double(diskIOInformation.getRtime())));
                cIMInstance.setProperty("Name", new CIMValue((Object)diskIOInformation.getDeviceName()));
            }
            if (bl) {
                return cIMInstance;
            }
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_DiskIOInformation"));
            cIMInstance.setProperty("DeviceCreationClassName", new CIMValue((Object)"Solaris_DiskDrive"));
            try {
                cIMInstance.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (UnknownHostException unknownHostException) {}
            cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMInstance.setProperty("Description", new CIMValue((Object)PROVIDERNAME));
            cIMInstance.setProperty("Caption", new CIMValue((Object)(CAPTION + diskIOInformation.getDeviceName())));
        }
        catch (Exception exception) {
            String string = provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string);
        }
        return cIMInstance;
    }

    public synchronized CIMValue getPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2) throws CIMException {
        CIMValue cIMValue;
        block20: {
            Object object;
            String[] stringArray;
            String string3 = null;
            DiskIOInformation diskIOInformation = null;
            try {
                provUtil.checkAuthenticated();
            }
            catch (CIMException cIMException) {
                String[] stringArray2 = new String[]{"getPropertyValue"};
                this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray2, null, false, 0, 2);
                throw new CIMException("CIM_ERR_ACCESS_DENIED");
            }
            try {
                stringArray = cIMObjectPath.getKeys().elements();
                while (stringArray != null && stringArray.hasMoreElements()) {
                    object = (CIMProperty)stringArray.nextElement();
                    if (!object.getName().equalsIgnoreCase("Name")) continue;
                    string3 = (String)object.getValue().getValue();
                }
                diskIOInformation = this.perfMon.getDiskIOInfoObj(string3);
            }
            catch (Exception exception) {
                String string4 = this.perfMon.writeLog(2, null, null, exception);
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)string4);
            }
            try {
                if (string2.equalsIgnoreCase("Wlastupdate")) {
                    cIMValue = new CIMValue((Object)new Double(diskIOInformation.getWlastupdate()));
                    break block20;
                }
                if (string2.equalsIgnoreCase("Reads")) {
                    cIMValue = new CIMValue((Object)new Double(diskIOInformation.getReads()));
                    break block20;
                }
                if (string2.equalsIgnoreCase("Writes")) {
                    cIMValue = new CIMValue((Object)new Double(diskIOInformation.getWrites()));
                    break block20;
                }
                if (string2.equalsIgnoreCase("Nread")) {
                    cIMValue = new CIMValue((Object)new Double(diskIOInformation.getNread()));
                    break block20;
                }
                if (string2.equalsIgnoreCase("Nwritten")) {
                    cIMValue = new CIMValue((Object)new Double(diskIOInformation.getNwritten()));
                    break block20;
                }
                if (string2.equalsIgnoreCase("Wlentime")) {
                    cIMValue = new CIMValue((Object)new Double(diskIOInformation.getWlentime()));
                    break block20;
                }
                if (string2.equalsIgnoreCase("Rlentime")) {
                    cIMValue = new CIMValue((Object)new Double(diskIOInformation.getRlentime()));
                    break block20;
                }
                if (string2.equalsIgnoreCase("Wtime")) {
                    cIMValue = new CIMValue((Object)new Double(diskIOInformation.getWtime()));
                    break block20;
                }
                if (string2.equalsIgnoreCase("Rtime")) {
                    cIMValue = new CIMValue((Object)new Double(diskIOInformation.getRtime()));
                    break block20;
                }
                if (string2.equalsIgnoreCase("Name")) {
                    cIMValue = new CIMValue((Object)diskIOInformation.getDeviceName());
                    break block20;
                }
                if (string2.equalsIgnoreCase("CreationClassName")) {
                    cIMValue = new CIMValue((Object)"Solaris_DiskIOInformation");
                    break block20;
                }
                if (string2.equalsIgnoreCase("SystemName")) {
                    cIMValue = new CIMValue((Object)InetAddress.getLocalHost().getHostName());
                    break block20;
                }
                if (string2.equalsIgnoreCase("SystemCreationClassName")) {
                    cIMValue = new CIMValue((Object)"Solaris_ComputerSystem");
                    break block20;
                }
                stringArray = new String[]{string2};
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)this.logUtil.getLocalizedMessage("LM_9601", stringArray));
            }
            catch (Exception exception) {
                object = this.perfMon.writeLog(2, null, null, exception);
                throw new CIMProviderException("GENERAL_EXCEPTION", object);
            }
        }
        return cIMValue;
    }

    protected static ProviderUtility getProviderUtil() {
        return provUtil;
    }

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        cimomHandle = cIMOMHandle;
        try {
            provUtil = new ProviderUtility(cimomHandle, PROVIDERNAME);
        }
        catch (CIMException cIMException) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        this.perfMon = new PerformanceMonitor(cIMOMHandle, this.logUtil, provUtil);
    }

    public synchronized CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"invokeMethod"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", stringArray, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        if (string.equalsIgnoreCase("getBulkDiskIOData")) {
            return new CIMValue((Object)this.getBulkDiskIOData(vector2));
        }
        return null;
    }

    public synchronized void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        try {
            String[] stringArray = new String[]{"Set Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {}
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public synchronized void setPropertyValue(CIMObjectPath cIMObjectPath, String string, String string2, CIMValue cIMValue) throws CIMException {
        try {
            String[] stringArray = new String[]{"setPropertyValue"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", stringArray, null, false, 0, 0);
        }
        catch (CIMException cIMException) {}
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }
}

