my $Notice = '
The contents of this file are subject to the Netscape Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/NPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
the License for the specific language governing rights and limitations
under the License.

The Original Code was released August, 1999.  The Initial Developer
of the Original Code is Netscape Communications Corporation.  Portions
created by Netscape are Copyright (C) 1999, 2000 Netscape Communications
Corporation.  All Rights Reserved.
';
my @Contributors = ('John Kristian <kristian@netscape.com>',
		    'Richard Megginson <richm@netscape.com>');
$Notice .= '
Contributor(s): ' . join ('
                ', @Contributors) . '
--------------------------------------------------------------------';

use strict;
use Config;
use Cwd qw(cwd chdir);
use ExtUtils::Install;
use File::Basename qw(dirname basename);
use File::Copy;
use File::Find;
use File::Spec;
use FileHandle;
BEGIN { require (File::Spec->catfile (File::Spec->curdir(), 'util.pm')); }

my $author  = $Contributors[0]; # may be modified, below
my $ARCH    = $Config{archname};
my $BIN     = $Config{installbin};
my $perlpath= $Config{perlpath};
my $ARCHLIB = $Config{installarchlib};
my $PREFIX  = $Config{prefixexp};
my $VERSION = @ARGV ? $ARGV[0] :
		(($PREFIX =~ /(\d[\d\._]*)/) and $1);
	      die "Can't compute version" unless $VERSION;
use vars qw($MSWin32); $MSWin32 = ($ARCH =~ /^MSWin32/i);
my $Pkg = 'nsPerl';
my $distfile = "$Pkg$VERSION-13-$ARCH"
	       . ($MSWin32 ? ".zip" : ".tar.gz");
my ($exe, $bat, $txt) = $MSWin32 ? (".exe", ".bat", ".txt") : ("", "", "");
my $shebang = "#!/bin/sh";
my $updir = File::Spec->updir();
my $stdperl = _subpath ($PREFIX, $perlpath);
# This script can be executed by an installed copy of nsPerl; in that case,
# it must not create install/instruct scripts that create an nsperl program
# that runs itself, recursively.  Instead, `nsperl` must run ordinary perl:
$stdperl =~ s/nsperl$exe$/perl$exe/; 

{ # Compile the `executor` program, into the parent directory:
    unlink glob File::Spec->catfile ($updir, 'executor*');
    my $source = "executor.cpp interpret.cpp";
	my $build_cmd = "";
    # Should we use the same compiler and options that were used to build Perl?
	if ($ARCH eq 'i86pc-solaris') {
		$build_cmd = "CC -DARCH_SOLARIS -O -D_REENTRANT -o ../executor$exe $source";
	} elsif ($ARCH eq 'sun4-solaris') {
		$build_cmd = "CC -DARCH_SOLARIS -O -D_REENTRANT -o ../executor$exe $source";
	} elsif ($ARCH eq 'i686-linux') {
		$build_cmd = "cc -DARCH_LINUX -O2 -o ../executor$exe $source";
		$author = $Contributors[1];
	} elsif ($ARCH =~ /^PA-RISC/) { # HPUX
		$build_cmd = "aCC +DAportable -DARCH_HPUX -O -o ../executor$exe $source";
		$author = $Contributors[1];
	} elsif ($ARCH =~ /^alpha-dec/) { # DEC OSF Tru64
		$build_cmd = "cxx -DARCH_OSF1 -O -o ../executor$exe $source";
		$author = $Contributors[1];
	} elsif ($ARCH =~ /aix/) { # IBM AIX
		$build_cmd = "xlC -DARCH_AIX -O -o ../executor$exe $source";
		$author = $Contributors[1];
	} elsif ($MSWin32) {
		$build_cmd = "CL /DARCH_MSWin32 /Ox /ML /Fe..\\executor$exe $source";
	} else {
		die "ERROR: unknown operating system/architecture $ARCH: please edit this file\n";
	}
    system ($build_cmd) and die $?;
}
# Clean up garbage from compilation, editing or previous installations:
unlink glob '*.o';   # Unix
unlink glob '*.obj'; # MSWin32
unlink glob '*~'; # emacs backup files
unlink glob File::Spec->catfile ($updir, '*~');
unlink glob File::Spec->catfile ($updir, 'instruct*');
unlink glob File::Spec->catfile ($updir, 'Install*');

# Create the `instruct` script, in the parent directory:
if ($MSWin32) {
    # The Win32 command language is incapable of this.
    # Fortunately, Install.pl can do the job instead,
    # since the standard Perl interpreter works, on Win32.
} else {
    my $sitelib  = File::Spec->catdir ('$PREFIX', _subpath ($PREFIX, $Config{installsitelib}));
    my $sitearch = File::Spec->catdir ('$PREFIX', _subpath ($PREFIX, $Config{installsitearch}));
    my $sopath   = File::Spec->catdir ('$PREFIX', _subpath ($PREFIX, $ARCHLIB), 'CORE');
    find (sub {
       $sopath   = File::Spec->catdir ('$PREFIX', _subpath ($PREFIX, $File::Find::dir))
	   if $_ eq $Config{libperl};}, $PREFIX);
    my $sopathvar = 'LD_LIBRARY_PATH'; # may depend on $ARCH, in future ports
    my $sopathvar2 = undef; # for 32 bit HPUX
	if ($ARCH =~ /^PA-RISC/) { # HPUX
		$sopathvar2 = 'SHLIB_PATH';
	} elsif ($ARCH =~ /aix/) { # IBM AIX
		$sopathvar = 'LIBPATH';
	}
    my $instructions = q('source: '"$PKG"/`basename $0`'
ifdef $PERL5LIB { addPath $PERL5LIB : '"$PRIVLIB:).$sitelib.q(:."'
}else{            addPath $PERLLIB  : '"$ARCHLIB:$PRIVLIB:).$sitearch.':'.$sitelib.q(:."'
}                 addPath '").$sopath.q("' : $).$sopathvar;
	if ($sopathvar2) {
		$instructions .= q(
                  addPath '").$sopath.q("' : $).$sopathvar2;
	}
	$instructions .= q(
exec '"$PREFIX/).$stdperl.q("'
# exec failed.  Maybe this will suggest why:
echoError )."$sopathvar is \$$sopathvar";
	if ($sopathvar2) {
		$instructions .= q(
echoError )."$sopathvar2 is \$$sopathvar2";
	}
	$instructions .= q(
ifdef       $PERL5LIB { echoError PERL5LIB is $PERL5LIB
}else{ ifdef $PERLLIB { echoError PERLLIB is $PERLLIB
} }');
	my $instruct = File::Spec->catfile ($updir, "instruct");
	print {new FileHandle ">$instruct"}
	    ($shebang, (join "\n# ", (split /\n/, $Notice)),
	     map { s/--instructions--/$instructions/g; $_ }
	     (new FileHandle "<instruct$bat")->getlines())
	    or die;
	chmod (0755, $instruct);
}

# Create the `Install.pl` script, in the parent directory:
my $Install_pl = 'Install.pl';
copy (($MSWin32 ? "Install-MSWin32.pl" : "Install.pl"),
      File::Spec->catfile ($updir, $Install_pl));

my $reconfigure_pl = 'reconfigure.pl';
{ # Create the `reconfigure.pl` script, in the parent directory:
    my $util_pm = (new FileHandle "<util.pm") or die $!;
    $util_pm = 'my $MSWin32 = "'.$MSWin32."\";\n"
		. join ("", $util_pm->getlines());
    my $change_files_pm = (new FileHandle "<change_files.pm") or die $!;
    $change_files_pm = join ("", $change_files_pm->getlines());
    print {new FileHandle ">".File::Spec->catfile ($updir, $reconfigure_pl)}
    (map { s/--util.pm--/$util_pm/g;
	   s/--change_files.pm--/$change_files_pm/g;
	   s/--Config\{(\w*)\}--/$Config{$1}/g;
	   s/--Pkg--/$Pkg/g;
	   $_ }
     (new FileHandle "<reconfigure.txt")->getlines()) or die;
}

# Create the `test.pl` script, in the parent directory:
copy ("test.pl", File::Spec->catfile ($updir, "test.pl"));

chdir (File::Spec->catdir ($updir, $updir));
my $distdir = cwd;

# Install extensions:
system ($perlpath,
	File::Spec->catfile (File::Spec->curdir(), "Extend.pl"))
    and die $! ? "$perlpath: $!" : "Extend.pl: $?";
{ # install nsPerl itself, as an extension:
    my $installPkg = File::Spec->catdir ($ARCHLIB, $Pkg);
    my $packlist = File::Spec->catfile ($installPkg, ".packlist");
    eval {uninstall $packlist}; # Delete previously installed files, if any.
    install ({'read'  => $packlist,
	      'write' => $packlist,
	      'pkg'   => $installPkg,
	  }, 1, 0, 0);
}
chdir $ARCHLIB;
chmod (0644, "Config.pm",
	     File::Spec->catfile ("CORE", "config.h"));
chmod (0755, File::Spec->catfile ($Pkg, $reconfigure_pl));
chmod (0755, File::Spec->catfile ($Pkg, "test.pl"));
system ($perlpath,
	File::Spec->catfile ($Pkg, $reconfigure_pl),
	qw(myhostname=localhost
	   mydomain=.local.domain.com
	   cf_by=LOCAL.USER
	   cf_email=LOCAL.USER@local.domain.com
	   perladmin=LOCAL.ADMIN@local.domain.com))
    and die "${reconfigure_pl}: $?";

sub is_empty_directory
{
    my ($name) = @_;
    if (-d $name) {
	if (not opendir (DIR, $name)) {
	    warn "$name: " . ($! or $?);
	} else {
	    if (not grep {not ($_ eq $updir or
			       $_ eq File::Spec->curdir())}
		readdir DIR)
	    {
		return 1;
	    }
	    closedir DIR;
	}
    }
    return undef;
}

chdir $PREFIX;
{ # Remove empty subdirectories:
    my @empties;
    find (sub
	  {
	      if (is_empty_directory $_) {
		  push @empties, $File::Find::name;
	      }
	  },
	  File::Spec->curdir());
    foreach my $dir (@empties) {
	while (rmdir $dir) {
	    print ("Deleted $dir\n");
	    last unless ($dir = dirname $dir) and is_empty_directory $dir;
	}
    }
}
{ 
    my $nsperl = 'nsperl';
    my $BINSUFFIX = _subpath ($PREFIX, $BIN)     or File::Spec->catdir ("bin", $ARCH); 
    my $LIBSUFFIX = _subpath ($PREFIX, $ARCHLIB) or File::Spec->catdir ("lib", $ARCH); 
    my $pkgsuffix = File::Spec->catdir  ($LIBSUFFIX, $Pkg);
    my $nsperlpath= File::Spec->catfile ($BINSUFFIX, $nsperl);
    my $instruct  = File::Spec->catfile ($pkgsuffix, 'instruct');

    { # Create the install script:
	my $target = "install$bat";
	my $install = File::Spec->catfile ($pkgsuffix, $Install_pl);
	printf ("Writing %s\n", File::Spec->catfile (cwd, $target));
	print {new FileHandle "> $target"}
	    (join ("\n",
	     $MSWin32 ? ('set PERLLIB=', 'set PERL5LIB=',
			 "$stdperl $install $stdperl $nsperlpath$exe $nsperl$exe")
	              : ($shebang,
			 '# Install the copy of nsPerl that contains this script.',
			 '# To make nsPerl usable via an alias (such as a symbolic',
			 '# link or an automounter name), run this script by its',
			 '# fully-qualified name under that alias (so $0 will be',
			 '# a fully-qualified name).',
			 'if [ $# -le 0 ]; then',
			 '    PREFIX=`dirname "$0"`',
			 '    PREFIX="${PREFIX:-.}"',
			 'else',
			 '    PREFIX="$1"',
			 'fi',
			 'if [ "$PREFIX" != "." ]; then',
			 '  cd "$PREFIX" || exit $?',
			 'fi',
			 'case "$PREFIX" in',
			 '  /* ) ;; # already fully qualified',
			 '   * ) PREFIX=`pwd`;;',
			 'esac',
			 "$instruct \"\$PREFIX\" $nsperlpath$exe $nsperl$exe",
	  		 'unset PERLLIB PERL5LIB',
			 "exec $nsperlpath $install \"\$PREFIX\"")
	     ), "\n") or die;
	chmod (0755, $target);
    }

    # Generate the README file:
    my $base = basename $PREFIX;
    my $install = File::Spec->catfile (File::Spec->curdir(), 'install');
    my $unpack  = $MSWin32 ? "unzip $distfile"
			      : "gzip -dc $distfile | tar -xvof -";
    printf ("Writing %s\n", File::Spec->catfile (cwd, "README$txt"));
    print {new FileHandle "> README$txt"}
	(qq{$Pkg is a binary distribution of dynamic Perl.  To install it:

    cd # to the directory in which you want to install it.
    $unpack
    cd $base
    $install
}.(!$MSWin32 && qq{
But if the $base directory will have a different name (not \`pwd\`)
from the viewpoint of other nsPerl users, you must define an alias for it
that all users can share (usually an automounter name), and use the fully
qualified name of that alias in the install command.  For example:

    /mount/share/$base/install
}).qq{
$nsperlpath is your new Perl interpreter.  For example:
}.($MSWin32 ? qq{
    $nsperlpath -v
} : qq{
    $nsperlpath -e 'print "Hello from \$^X\\n";'

$stdperl is the standard perl program, but it won't run usefully
unless certain environment variables are set correctly (as $nsperlpath
does; see $instruct).
}).qq{
To make it easy to run Perl from a command prompt, copy the file
$nsperlpath$exe into one of the directories named in your
PATH environment variable.  Once that's done, the command `nsperl`
will run Perl.  If you prefer the command `perl`, rename the copy
from nsperl$exe to perl$exe.

bin contains various Perl scripts.  To make it easier to run them
from a command prompt, copy them into one of the directories named
in your PATH evironment variable.

$pkgsuffix contains software that reconfigures Perl
to work on your machine.  Its source code is in the subdirectory src
(which you can discard, without affecting other programs' behavior).

The rest of this package was built from standard Perl source code.
You can get a copy from http://www.perl.com/CPAN/src/5.0/maint/
or http://www.perl.org

To make Perl occupy less disk space, you can remove its documentation;
that is lib/pod/html or lib/pod.  There's a copy of the documentation
at http://www.perl.com/CPAN/doc/ , although it's not the same version
as this copy of Perl.

If you want to automate the installation of nsPerl, the algorithm
supported in all versions is to execute $install, with the current
working directory set to the only directory unpacked from the archive
file.  $install creates a Perl interpreter program named $nsperl$exe,
which can be moved or copied elsewhere without loss of functionality.

- $author

}
		) # print > README
	or die;

    unlink "$nsperl$exe";
    unlink "$nsperlpath$exe";
    unlink "reconfigure$bat";
}

# Create the distribution file (a compressed archive of $PREFIX):
my $distfrom = basename cwd;
chdir $updir;
$distfile = File::Spec->catfile ($distdir, $distfile);
print "Writing $distfile from $distfrom\n";
system $MSWin32
       ? "zip -q -r $distfile $distfrom"
       : "tar -cf - $distfrom | gzip -c > $distfile"
    and die ($! or $?);
