/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.collector.iccol.worker;

import com.sun.vsp.km.ic.collector.ColMessageLookup;
import com.sun.vsp.km.ic.collector.CollectorProps;
import com.sun.vsp.km.ic.collector.iccol.AbstractWorker;
import com.sun.vsp.km.ic.collector.iccol.DataCollectionException;
import com.sun.vsp.km.ic.util.ICPropIfc;
import com.sun.vsp.km.ic.util.ICProperties;
import com.sun.vsp.km.util.KMLogger;
import com.sun.vsp.km.util.XMLUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PiclWorker
extends AbstractWorker {
    protected Document hostDoc;
    protected Document cpuDoc;
    protected Document boardDoc;
    protected Document aliasDoc;
    protected Document variableDoc;
    protected Document diskDoc1;
    protected Document diskDoc2;
    protected Document ioDoc;
    protected Document diskDeviceDoc;
    protected BufferedReader diskReader;
    protected String diskUtility;
    protected int numDisks;
    protected int numDevices;
    protected ICPropIfc props = null;
    protected boolean debug;

    public PiclWorker() {
        this.tableName = "picl";
        this.debug = false;
        this.props = ICProperties.getInstance();
        try {
            this.debug = this.props.getProperty("debug").equals("true");
        }
        catch (NullPointerException nullPointerException) {}
        CollectorProps collectorProps = CollectorProps.getInstance();
        String string = "";
        if (System.getProperty("WORKER_PATH") == null) {
            string = String.valueOf(collectorProps.getProperty("worker_path")) + System.getProperty("file.separator") + "piclworker";
            this.diskUtility = String.valueOf(collectorProps.getProperty("worker_path")) + System.getProperty("file.separator") + "diskworker";
        } else {
            string = String.valueOf(System.getProperty("WORKER_PATH")) + System.getProperty("file.separator") + "piclworker";
            this.diskUtility = String.valueOf(System.getProperty("WORKER_PATH")) + System.getProperty("file.separator") + "diskworker";
        }
        this.utilityName = string;
    }

    public Vector collect() throws DataCollectionException {
        if (this.debug) {
            System.out.println("PiclWorker:collect() called.");
        }
        this.runCmd();
        this.createDoc();
        this.createDiskDocs();
        this.docs = new Vector();
        this.docs.add(this.parsePiclHost());
        this.docs.add(this.cpuDoc);
        this.docs.add(this.boardDoc);
        this.docs.add(this.aliasDoc);
        this.docs.add(this.variableDoc);
        this.docs.add(this.diskDoc1);
        this.docs.add(this.diskDoc2);
        this.docs.add(this.ioDoc);
        this.docs.add(this.diskDeviceDoc);
        return this.docs;
    }

    private void createDiskDocs() {
        Element element;
        Element element2;
        Node node;
        Node node2;
        Node node3;
        Object object;
        String string;
        if (this.debug) {
            System.out.println("PiclWorker:createDiskDocs() called.");
        }
        this.diskDoc1 = XMLUtil.createDocument();
        this.diskDoc2 = XMLUtil.createDocument();
        this.diskDeviceDoc = XMLUtil.createDocument();
        this.numDisks = 0;
        this.numDevices = 0;
        Element element3 = this.diskDoc1.createElement("table");
        element3.setAttribute("name", "diskformat");
        Element element4 = this.diskDoc2.createElement("table");
        element4.setAttribute("name", "hostdisk");
        Element element5 = this.diskDeviceDoc.createElement("table");
        element5.setAttribute("name", "hostdiskdevice");
        String string2 = "";
        Element element6 = null;
        Element element7 = null;
        Element element8 = null;
        try {
            string2 = this.diskReader.readLine();
        }
        catch (Exception exception) {}
        while (string2 != null) {
            Object object2;
            if (string2.startsWith("*")) {
                if (element6 != null) {
                    XMLUtil.appendChildNode((Node)element3, element6);
                }
                if (element7 != null) {
                    XMLUtil.appendChildNode((Node)element4, element7);
                }
                if (element8 != null) {
                    XMLUtil.appendChildNode((Node)element5, element8);
                }
                element6 = this.diskDoc1.createElement("instance");
                element6.setAttribute("id", String.valueOf(this.numDisks));
                element7 = this.diskDoc2.createElement("instance");
                element7.setAttribute("id", String.valueOf(this.numDisks));
                element8 = this.diskDeviceDoc.createElement("instance");
                element8.setAttribute("id", String.valueOf(this.numDisks));
                try {
                    string = string2.substring(string2.indexOf(58) + 2);
                    object = XMLUtil.createElementWithContent((Document)this.diskDoc1, (String)"property", (String)string);
                    object.setAttribute("name", "ctd");
                    object2 = XMLUtil.createElementWithContent((Document)this.diskDoc2, (String)"property", (String)string);
                    object2.setAttribute("name", "diskid");
                    XMLUtil.appendChildNode((Node)element6, (Node)object);
                    XMLUtil.appendChildNode((Node)element7, (Node)object2);
                }
                catch (Exception exception) {}
                ++this.numDisks;
            } else if (string2.startsWith("devfs-path")) {
                string = "";
                try {
                    string = string2.substring(string2.indexOf(58) + 2);
                    object = XMLUtil.createElementWithContent((Document)this.diskDoc1, (String)"property", (String)string);
                    object.setAttribute("name", "devicepathdata");
                    XMLUtil.appendChildNode((Node)element6, (Node)object);
                }
                catch (Exception exception) {}
                object = "//property[@name='devfs-path']";
                object2 = null;
                try {
                    object2 = XPathAPI.selectNodeList((Node)this.doc, (String)object);
                }
                catch (TransformerException transformerException) {}
                if (object2 != null) {
                    int n = 0;
                    while (n < object2.getLength()) {
                        if (XMLUtil.getTextFromNode((Node)object2.item(n)).equals(string)) {
                            node3 = XMLUtil.getChildNodeWithAttributeValue((Node)object2.item(n).getParentNode(), (String)"name", (String)"inquiry-product-id");
                            node2 = XMLUtil.getChildNodeWithAttributeValue((Node)object2.item(n).getParentNode(), (String)"name", (String)"inquiry-revision-id");
                            node = XMLUtil.getChildNodeWithAttributeValue((Node)object2.item(n).getParentNode(), (String)"name", (String)"inquiry-vendor-id");
                            element2 = null;
                            element = null;
                            if (!XMLUtil.getTextFromNode((Node)node3).equals("")) {
                                element2 = XMLUtil.createElementWithContent((Document)this.diskDoc2, (String)"property", (String)XMLUtil.getTextFromNode((Node)node3));
                                element2.setAttribute("name", "product");
                                element = XMLUtil.createElementWithContent((Document)this.diskDeviceDoc, (String)"property", (String)XMLUtil.getTextFromNode((Node)node3));
                                element.setAttribute("name", "product");
                                XMLUtil.appendChildNode((Node)element7, (Node)element2);
                                XMLUtil.appendChildNode((Node)element8, (Node)element);
                            }
                            Element element9 = null;
                            Element element10 = null;
                            if (!XMLUtil.getTextFromNode((Node)node2).equals("")) {
                                element9 = XMLUtil.createElementWithContent((Document)this.diskDoc2, (String)"property", (String)XMLUtil.getTextFromNode((Node)node2));
                                element9.setAttribute("name", "revision");
                                element10 = XMLUtil.createElementWithContent((Document)this.diskDeviceDoc, (String)"property", (String)XMLUtil.getTextFromNode((Node)node2));
                                element10.setAttribute("name", "revision");
                                XMLUtil.appendChildNode((Node)element7, (Node)element9);
                            }
                            Element element11 = null;
                            if (!XMLUtil.getTextFromNode((Node)node).equals("")) {
                                element11 = XMLUtil.createElementWithContent((Document)this.diskDeviceDoc, (String)"property", (String)XMLUtil.getTextFromNode((Node)node));
                                element11.setAttribute("name", "vendor");
                                XMLUtil.appendChildNode((Node)element8, (Node)element11);
                            }
                            break;
                        }
                        ++n;
                    }
                }
            } else if (string2.startsWith("ascii")) {
                try {
                    string = string2.substring(string2.indexOf(58) + 2, string2.indexOf(32, string2.indexOf(58) + 2));
                    object = XMLUtil.createElementWithContent((Document)this.diskDoc1, (String)"property", (String)string);
                    object.setAttribute("name", "typesize");
                    XMLUtil.appendChildNode((Node)element6, (Node)object);
                }
                catch (Exception exception) {}
            }
            try {
                string2 = this.diskReader.readLine();
            }
            catch (Exception exception) {}
        }
        if (element6 != null) {
            XMLUtil.appendChildNode((Node)element3, element6);
        }
        if (element7 != null) {
            XMLUtil.appendChildNode((Node)element4, element7);
        }
        if (element8 != null) {
            XMLUtil.appendChildNode((Node)element5, element8);
        }
        this.numDevices = this.numDisks;
        string = "//instance[@id='sd']";
        object = null;
        try {
            object = XPathAPI.selectNodeList((Node)this.doc, (String)string);
        }
        catch (TransformerException transformerException) {}
        if (object != null) {
            int n = 0;
            while (n < object.getLength()) {
                ++this.numDevices;
                element8 = this.diskDeviceDoc.createElement("instance");
                element8.setAttribute("id", String.valueOf(this.numDevices - 1));
                Node node4 = XMLUtil.getChildNodeWithAttributeValue((Node)object.item(n), (String)"name", (String)"inquiry-product-id");
                node3 = XMLUtil.getChildNodeWithAttributeValue((Node)object.item(n), (String)"name", (String)"inquiry-vendor-id");
                node2 = XMLUtil.getChildNodeWithAttributeValue((Node)object.item(n), (String)"name", (String)"inquiry-revision-id");
                node = XMLUtil.createElementWithContent((Document)this.diskDeviceDoc, (String)"property", (String)XMLUtil.getTextFromNode((Node)node4));
                node.setAttribute("name", "product");
                element2 = XMLUtil.createElementWithContent((Document)this.diskDeviceDoc, (String)"property", (String)XMLUtil.getTextFromNode((Node)node3));
                element2.setAttribute("name", "vendor");
                element = XMLUtil.createElementWithContent((Document)this.diskDeviceDoc, (String)"property", (String)XMLUtil.getTextFromNode((Node)node2));
                element.setAttribute("name", "revision");
                XMLUtil.appendChildNode((Node)element8, (Node)node);
                XMLUtil.appendChildNode((Node)element8, (Node)element2);
                XMLUtil.appendChildNode((Node)element8, (Node)element);
                XMLUtil.appendChildNode((Node)element5, (Node)element8);
                ++n;
            }
        }
        this.diskDoc1.appendChild(element3);
        this.diskDoc2.appendChild(element4);
        this.diskDeviceDoc.appendChild(element5);
    }

    private Document parsePiclHost() {
        Object object;
        Object object2;
        Element element;
        Object object3;
        Object object4;
        Object object5;
        Element element2;
        Object object6;
        Object object7;
        Object object8;
        Element element3;
        Object object9;
        Object object10;
        Object object11;
        Object object12;
        Object object13;
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() called.");
        }
        this.hostDoc = XMLUtil.createDocument();
        this.cpuDoc = XMLUtil.createDocument();
        this.boardDoc = XMLUtil.createDocument();
        this.aliasDoc = XMLUtil.createDocument();
        this.variableDoc = XMLUtil.createDocument();
        this.ioDoc = XMLUtil.createDocument();
        String string = "";
        NodeList nodeList = null;
        NodeList nodeList2 = null;
        Element element4 = this.hostDoc.createElement("table");
        element4.setAttribute("name", "host");
        Element element5 = this.hostDoc.createElement("instance");
        element5.setAttribute("id", System.getProperties().getProperty("HOST_ID"));
        String string2 = "";
        String string3 = "";
        int n = 0;
        while (n < this.numDisks) {
            object13 = "//instance[@id='" + n + "']";
            object12 = null;
            object11 = null;
            try {
                object12 = XPathAPI.selectNodeList((Node)this.diskDoc1, (String)object13);
                object11 = XPathAPI.selectNodeList((Node)this.diskDoc2, (String)object13);
                if (XMLUtil.getChildNodeWithAttributeValue((Node)object11.item(0), (String)"name", (String)"product") != null && XMLUtil.getChildNodeWithAttributeValue((Node)object11.item(0), (String)"name", (String)"revision") != null && XMLUtil.getChildNodeWithAttributeValue((Node)object12.item(0), (String)"name", (String)"devicepathdata") != null && XMLUtil.getChildNodeWithAttributeValue((Node)object12.item(0), (String)"name", (String)"typesize") != null) {
                    string2 = String.valueOf(string2) + String.valueOf(n);
                    string2 = String.valueOf(string2) + ", ";
                }
            }
            catch (Exception exception) {}
            ++n;
        }
        if (!string2.equals("")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        object13 = XMLUtil.createElementWithContent((Document)this.hostDoc, (String)"property", (String)string2);
        object13.setAttribute("name", "diskinstances");
        object12 = XMLUtil.createElementWithContent((Document)this.hostDoc, (String)"property", (String)string2);
        object12.setAttribute("name", "diskformats");
        XMLUtil.appendChildNode((Node)element5, (Node)object13);
        XMLUtil.appendChildNode((Node)element5, (Node)object12);
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() created disk instances and formats instances.");
        }
        object11 = "";
        int n2 = 0;
        while (n2 < this.numDevices) {
            object10 = "//instance[@id='" + n2 + "']";
            object9 = null;
            try {
                object9 = XPathAPI.selectNodeList((Node)this.diskDeviceDoc, (String)object10);
                if (XMLUtil.getChildNodeWithAttributeValue((Node)object9.item(0), (String)"name", (String)"product") != null && XMLUtil.getChildNodeWithAttributeValue((Node)object9.item(0), (String)"name", (String)"vendor") != null) {
                    object11 = String.valueOf(object11) + String.valueOf(n2);
                    object11 = String.valueOf(object11) + ", ";
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        if (!((String)object11).equals("")) {
            object11 = ((String)object11).substring(0, ((String)object11).length() - 2);
        }
        object10 = XMLUtil.createElementWithContent((Document)this.hostDoc, (String)"property", (String)object11);
        object10.setAttribute("name", "hostdiskdevices");
        XMLUtil.appendChildNode((Node)element5, (Node)object10);
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() created disk device instances.");
        }
        string = "/table[@name='picl']/instance[@id='platform']/property[@name='PlatformGroup']";
        try {
            nodeList = XPathAPI.selectNodeList((Node)this.doc, (String)string);
        }
        catch (TransformerException transformerException) {}
        object9 = "";
        if (nodeList.getLength() >= 1) {
            object9 = XMLUtil.getTextFromNode((Node)nodeList.item(0));
        }
        Element element6 = XMLUtil.createElementWithContent((Document)this.hostDoc, (String)"property", (String)object9);
        element6.setAttribute("name", "kernelarch");
        XMLUtil.appendChildNode((Node)element5, (Node)element6);
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() created kernelArch - " + (String)object9);
        }
        string = "//property[@name='processortype']";
        try {
            nodeList = XPathAPI.selectNodeList((Node)this.doc, (String)string);
        }
        catch (TransformerException transformerException) {}
        String string4 = "";
        if (nodeList.getLength() >= 1) {
            string4 = XMLUtil.getTextFromNode((Node)nodeList.item(0));
        }
        Element element7 = XMLUtil.createElementWithContent((Document)this.hostDoc, (String)"property", (String)string4);
        element7.setAttribute("name", "cpuarch");
        XMLUtil.appendChildNode((Node)element5, (Node)element7);
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() created cpuArch - " + string4);
        }
        string = "/table[@name='picl']/instance[@id='openprom']/property[@name='version']";
        try {
            nodeList = XPathAPI.selectNodeList((Node)this.doc, (String)string);
        }
        catch (TransformerException transformerException) {}
        String string5 = "";
        if (nodeList.getLength() >= 1) {
            string5 = XMLUtil.getTextFromNode((Node)nodeList.item(0));
        }
        Element element8 = XMLUtil.createElementWithContent((Document)this.hostDoc, (String)"property", (String)string5);
        element8.setAttribute("name", "obpversion");
        XMLUtil.appendChildNode((Node)element5, (Node)element8);
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() created obpVersion - " + string5);
        }
        string = "/table[@name='picl']/instance[@id='platform']/property[@name='banner-name']";
        try {
            nodeList = XPathAPI.selectNodeList((Node)this.doc, (String)string);
        }
        catch (TransformerException transformerException) {}
        string5 = "";
        if (nodeList.getLength() >= 1) {
            string5 = XMLUtil.getTextFromNode((Node)nodeList.item(0));
        }
        System.setProperty("PLATFORM", string5);
        Element element9 = XMLUtil.createElementWithContent((Document)this.hostDoc, (String)"property", (String)string5);
        element9.setAttribute("name", "systemconfiguration");
        XMLUtil.appendChildNode((Node)element5, (Node)element9);
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() created systemConfiguration - " + string5);
        }
        Element element10 = XMLUtil.createElementWithContent((Document)this.hostDoc, (String)"property", (String)"0");
        element10.setAttribute("name", "hostconfigs");
        XMLUtil.appendChildNode((Node)element5, (Node)element10);
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() created hostConfigs.");
        }
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() starting cpuBoardInstances and board table.");
        }
        string = "/table[@name='picl']/instance[@id='flashprom']/property[@name='version']";
        try {
            nodeList = XPathAPI.selectNodeList((Node)this.doc, (String)string);
        }
        catch (TransformerException transformerException) {}
        Element element11 = this.boardDoc.createElement("table");
        element11.setAttribute("name", "board");
        String string6 = "";
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            string6 = String.valueOf(string6) + String.valueOf(n3);
            if (n3 != nodeList.getLength() - 1) {
                string6 = String.valueOf(string6) + ", ";
            }
            element3 = this.boardDoc.createElement("instance");
            element3.setAttribute("id", String.valueOf(n3));
            object8 = "";
            object7 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(XMLUtil.getTextFromNode((Node)nodeList.item(n3)), ",");
            while (stringTokenizer.hasMoreTokens()) {
                object6 = stringTokenizer.nextToken();
                if (((String)object6).startsWith("OBP")) {
                    object8 = object6;
                    continue;
                }
                if (!((String)object6).startsWith("POST")) continue;
                object7 = object6;
            }
            if (!((String)object8).equals("")) {
                object6 = XMLUtil.createElementWithContent((Document)this.boardDoc, (String)"property", (String)object8);
                object6.setAttribute("name", "obpversion");
                XMLUtil.appendChildNode((Node)element3, (Node)object6);
                if (this.debug) {
                    System.out.println("PiclWorker:parsePiclHost() created obpVersion for board instance - " + (String)object8);
                }
            }
            if (!((String)object7).equals("")) {
                object6 = XMLUtil.createElementWithContent((Document)this.boardDoc, (String)"property", (String)object7);
                object6.setAttribute("name", "postversion");
                XMLUtil.appendChildNode((Node)element3, (Node)object6);
                if (this.debug) {
                    System.out.println("PiclWorker:parsePiclHost() created postVersion for board instance - " + (String)object7);
                }
            }
            XMLUtil.appendChildNode((Node)element11, (Node)element3);
            ++n3;
        }
        this.boardDoc.appendChild(element11);
        element3 = XMLUtil.createElementWithContent((Document)this.hostDoc, (String)"property", (String)string6);
        element3.setAttribute("name", "cpuboardinstances");
        XMLUtil.appendChildNode((Node)element5, (Node)element3);
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() created cpuBoardInstances - " + string6);
        }
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() starting cpuInstances and cpu table.");
        }
        string = "//property[@name='processortype']";
        try {
            nodeList = XPathAPI.selectNodeList((Node)this.doc, (String)string);
        }
        catch (TransformerException transformerException) {}
        object8 = this.cpuDoc.createElement("table");
        object8.setAttribute("name", "cpu");
        object7 = "";
        int n4 = 0;
        while (n4 < nodeList.getLength()) {
            object6 = XMLUtil.getChildNodeWithAttributeValue((Node)nodeList.item(n4).getParentNode(), (String)"name", (String)"id");
            object7 = String.valueOf(object7) + XMLUtil.getTextFromNode((Node)object6);
            if (n4 != nodeList.getLength() - 1) {
                object7 = String.valueOf(object7) + ", ";
            }
            element2 = this.cpuDoc.createElement("instance");
            element2.setAttribute("id", XMLUtil.getTextFromNode((Node)object6));
            if (this.debug) {
                System.out.println("PiclWorker:parsePiclHost() created cpuInstance.");
            }
            object5 = XMLUtil.getChildNodeWithAttributeValue((Node)nodeList.item(n4).getParentNode(), (String)"name", (String)"clock-frequency");
            String string7 = XMLUtil.getTextFromNode((Node)object5);
            try {
                string7 = string7.substring(2, string7.length());
                string7 = String.valueOf(Integer.parseInt(string7, 16) / 1000000);
            }
            catch (Exception exception) {
                string7 = "";
            }
            object4 = XMLUtil.createElementWithContent((Document)this.cpuDoc, (String)"property", (String)string7);
            object4.setAttribute("name", "cpufrequency");
            XMLUtil.appendChildNode((Node)element2, (Node)object4);
            if (this.debug) {
                System.out.println("PiclWorker:parsePiclHost() created cpuFrequency - " + string7);
            }
            XMLUtil.appendChildNode((Node)object8, (Node)element2);
            ++n4;
        }
        this.cpuDoc.appendChild((Node)object8);
        object6 = XMLUtil.createElementWithContent((Document)this.hostDoc, (String)"property", (String)object7);
        object6.setAttribute("name", "cpuinstances");
        XMLUtil.appendChildNode((Node)element5, (Node)object6);
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() created cpuInstances - " + (String)object7);
        }
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() starting aliasInstances and alias table.");
        }
        string = "//instance[@id='aliases']";
        try {
            nodeList = XPathAPI.selectNodeList((Node)this.doc, (String)string);
        }
        catch (TransformerException transformerException) {}
        element2 = this.aliasDoc.createElement("table");
        element2.setAttribute("name", "alias");
        object5 = "";
        if (nodeList.getLength() >= 1) {
            nodeList2 = nodeList.item(0).getChildNodes();
            int n5 = 0;
            while (n5 < nodeList2.getLength()) {
                object4 = String.valueOf(n5);
                if (XMLUtil.getAttributeValue((Node)nodeList2.item(n5), (String)"name").equals("devfs-path")) {
                    object5 = ((String)object5).substring(0, ((String)object5).length() - 2);
                    break;
                }
                object5 = String.valueOf(object5) + XMLUtil.getAttributeValue((Node)nodeList2.item(n5), (String)"name") + (String)object4 + ", ";
                Element element12 = this.aliasDoc.createElement("instance");
                element12.setAttribute("id", String.valueOf(XMLUtil.getAttributeValue((Node)nodeList2.item(n5), (String)"name")) + (String)object4);
                if (this.debug) {
                    System.out.println("PiclWorker:parsePiclHost() created aliasInstance - " + (String)object4);
                }
                object3 = XMLUtil.createElementWithContent((Document)this.aliasDoc, (String)"property", (String)XMLUtil.getAttributeValue((Node)nodeList2.item(n5), (String)"name"));
                object3.setAttribute("name", "alias");
                XMLUtil.appendChildNode((Node)element12, (Node)object3);
                element = XMLUtil.createElementWithContent((Document)this.aliasDoc, (String)"property", (String)XMLUtil.getTextFromNode((Node)nodeList2.item(n5)));
                element.setAttribute("name", "value");
                XMLUtil.appendChildNode((Node)element12, (Node)element);
                XMLUtil.appendChildNode((Node)element2, (Node)element12);
                ++n5;
            }
            this.aliasDoc.appendChild(element2);
        }
        Element element13 = XMLUtil.createElementWithContent((Document)this.hostDoc, (String)"property", (String)object5);
        element13.setAttribute("name", "aliasinstances");
        XMLUtil.appendChildNode((Node)element5, (Node)element13);
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() created aliasInstances - " + (String)object5);
        }
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() starting HostVariable table.");
        }
        string = "//instance[@id='options']";
        try {
            nodeList = XPathAPI.selectNodeList((Node)this.doc, (String)string);
        }
        catch (TransformerException transformerException) {}
        object4 = this.variableDoc.createElement("table");
        object4.setAttribute("name", "variable");
        if (nodeList.getLength() >= 1) {
            nodeList2 = nodeList.item(0).getChildNodes();
            int n6 = 0;
            while (n6 < nodeList2.getLength()) {
                object3 = String.valueOf(n6);
                if (XMLUtil.getAttributeValue((Node)nodeList2.item(n6), (String)"name").equals("devfs-path")) break;
                element = this.variableDoc.createElement("instance");
                element.setAttribute("id", XMLUtil.getAttributeValue((Node)nodeList2.item(n6), (String)"name"));
                if (this.debug) {
                    System.out.println("PiclWorker:parsePiclHost() created aliasInstance.");
                }
                Element element14 = XMLUtil.createElementWithContent((Document)this.variableDoc, (String)"property", (String)XMLUtil.getTextFromNode((Node)nodeList2.item(n6)));
                element14.setAttribute("name", "value");
                XMLUtil.appendChildNode((Node)element, (Node)element14);
                XMLUtil.appendChildNode((Node)object4, (Node)element);
                ++n6;
            }
            this.variableDoc.appendChild((Node)object4);
        }
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() starting ioCards.");
        }
        string = "//instance[@id='pci']";
        try {
            nodeList = XPathAPI.selectNodeList((Node)this.doc, (String)string);
        }
        catch (TransformerException transformerException) {}
        string = "//instance[@id='sbus']";
        NodeList nodeList3 = null;
        try {
            nodeList3 = XPathAPI.selectNodeList((Node)this.doc, (String)string);
        }
        catch (TransformerException transformerException) {}
        object3 = new Vector();
        int n7 = 0;
        while (n7 < nodeList.getLength()) {
            ((Vector)object3).addElement(nodeList.item(n7));
            ++n7;
        }
        int n8 = 0;
        while (n8 < nodeList3.getLength()) {
            ((Vector)object3).addElement(nodeList3.item(n8));
            ++n8;
        }
        string = "//property[@name='iccol-parent-id']";
        try {
            nodeList = XPathAPI.selectNodeList((Node)this.doc, (String)string);
        }
        catch (TransformerException transformerException) {}
        string = "//instance[@id='scsi']";
        NodeList nodeList4 = null;
        try {
            nodeList4 = XPathAPI.selectNodeList((Node)this.doc, (String)string);
        }
        catch (TransformerException transformerException) {}
        Vector<Node> vector = new Vector<Node>();
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() ioCards looking to matching ids.");
        }
        int n9 = 0;
        while (n9 < ((Vector)object3).size()) {
            Node node = XMLUtil.getChildNodeWithAttributeValue((Node)((Node)((Vector)object3).elementAt(n9)), (String)"name", (String)"iccol-id");
            object2 = XMLUtil.getTextFromNode((Node)node);
            int n10 = 0;
            while (n10 < nodeList.getLength()) {
                Node node2 = XMLUtil.getChildNodeWithAttributeValue((Node)nodeList.item(n10).getParentNode(), (String)"name", (String)"iccol-parent-id");
                object = XMLUtil.getTextFromNode((Node)node2);
                if (((String)object2).equals(object)) {
                    vector.addElement(nodeList.item(n10));
                }
                ++n10;
            }
            ++n9;
        }
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() created ioCards adding scsi nodes.");
        }
        int n11 = 0;
        while (n11 < nodeList4.getLength()) {
            vector.addElement(XMLUtil.getChildNodeWithAttributeValue((Node)nodeList4.item(n11), (String)"name", (String)"iccol-parent-id"));
            ++n11;
        }
        object2 = this.ioDoc.createElement("table");
        object2.setAttribute("name", "io");
        String string8 = "";
        int n12 = 0;
        while (n12 < vector.size()) {
            if ((Node)vector.elementAt(n12) != null) {
                string8 = String.valueOf(string8) + String.valueOf(n12);
                if (n12 != vector.size() - 1) {
                    string8 = String.valueOf(string8) + ", ";
                }
                object = this.ioDoc.createElement("instance");
                object.setAttribute("id", String.valueOf(n12));
                if (this.debug) {
                    System.out.println("PiclWorker:parsePiclHost() created ioCardInstance - " + n12);
                }
                Node node = XMLUtil.getChildNodeWithAttributeValue((Node)((Node)vector.elementAt(n12)).getParentNode(), (String)"name", (String)"model");
                String string9 = XMLUtil.getTextFromNode((Node)node);
                Element element15 = XMLUtil.createElementWithContent((Document)this.ioDoc, (String)"property", (String)string9);
                element15.setAttribute("name", "model");
                XMLUtil.appendChildNode((Node)object, (Node)element15);
                if (this.debug) {
                    System.out.println("PiclWorker:parsePiclHost() created model - " + string9);
                }
                Node node3 = XMLUtil.getChildNodeWithAttributeValue((Node)((Node)vector.elementAt(n12)).getParentNode(), (String)"name", (String)"name");
                String string10 = XMLUtil.getTextFromNode((Node)node3);
                Element element16 = XMLUtil.createElementWithContent((Document)this.ioDoc, (String)"property", (String)string10);
                element16.setAttribute("name", "name");
                XMLUtil.appendChildNode((Node)object, (Node)element16);
                if (this.debug) {
                    System.out.println("PiclWorker:parsePiclHost() created name - " + string10);
                }
                Node node4 = XMLUtil.getChildNodeWithAttributeValue((Node)((Node)vector.elementAt(n12)).getParentNode(), (String)"name", (String)"version");
                String string11 = XMLUtil.getTextFromNode((Node)node4);
                Element element17 = XMLUtil.createElementWithContent((Document)this.ioDoc, (String)"property", (String)string11);
                element17.setAttribute("name", "fcodeversion");
                XMLUtil.appendChildNode((Node)object, (Node)element17);
                if (this.debug) {
                    System.out.println("PiclWorker:parsePiclHost() created fcodeVersion - " + string11);
                }
                Node node5 = XMLUtil.getChildNodeWithAttributeValue((Node)((Node)vector.elementAt(n12)).getParentNode(), (String)"name", (String)"firmware-version");
                String string12 = XMLUtil.getTextFromNode((Node)node5);
                Element element18 = XMLUtil.createElementWithContent((Document)this.ioDoc, (String)"property", (String)string12);
                element18.setAttribute("name", "firmwareversion");
                XMLUtil.appendChildNode((Node)object, (Node)element18);
                if (this.debug) {
                    System.out.println("PiclWorker:parsePiclHost() created firmwareVersion - " + string12);
                }
                XMLUtil.appendChildNode((Node)object2, (Node)object);
            }
            ++n12;
        }
        this.ioDoc.appendChild((Node)object2);
        object = XMLUtil.createElementWithContent((Document)this.hostDoc, (String)"property", (String)string8);
        object.setAttribute("name", "iocardinstances");
        XMLUtil.appendChildNode((Node)element5, (Node)object);
        if (this.debug) {
            System.out.println("PiclWorker:parsePiclHost() added ioCard instances - " + string8);
        }
        XMLUtil.appendChildNode((Node)element4, (Node)element5);
        this.hostDoc.appendChild(element4);
        return this.hostDoc;
    }

    protected void runCmd() throws DataCollectionException {
        if (this.debug) {
            System.out.println("PiclWorker:runCmd() called.");
        }
        Process process = null;
        Process process2 = null;
        try {
            process = Runtime.getRuntime().exec(this.utilityName);
            process2 = Runtime.getRuntime().exec(this.diskUtility);
        }
        catch (Exception exception) {
            KMLogger.log((int)KMLogger.SEVERE, (String)("com.sun.vsp.km.ic.collector.iccol.worker.PiclWorker" + this.tableName), (String)"runCmd()", (String)(String.valueOf(ColMessageLookup.getMessage((long)100L)) + " " + this.tableName + " " + ColMessageLookup.getMessage((long)101L)));
            throw new DataCollectionException(String.valueOf(ColMessageLookup.getMessage((long)100L)) + " " + this.tableName + " " + ColMessageLookup.getMessage((long)101L) + " " + ColMessageLookup.getMessage((long)102L) + exception.getMessage());
        }
        this.in = new BufferedReader(new InputStreamReader(process.getInputStream()));
        this.diskReader = new BufferedReader(new InputStreamReader(process2.getInputStream()));
    }
}

