/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.gui;

import com.sun.vsp.km.framework.KMObjectException;
import com.sun.vsp.km.ic.gui.ICGui;
import com.sun.vsp.km.ic.gui.ICPanel;
import com.sun.vsp.km.ic.gui.SwingWorker;
import com.sun.vsp.km.ic.icapp.TaskNotifierIfc;
import com.sun.vsp.km.ic.validator.ValidatorIfc;
import com.sun.vsp.km.ic.validator.kae.KAEUtil;
import com.sun.vsp.km.util.CleanUpUtil;
import com.sun.vsp.km.util.KMException;
import com.sun.vsp.km.util.KMLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class SystemCheckPanel
extends ICPanel {
    JProgressBar progress;
    JTextArea intro;
    JLabel analyze;
    JLabel performAnalysis;
    SwingWorker worker;
    SwingWorker worker2;
    int numChecks;
    int status;
    ValidatorIfc validator;
    CleanUpUtil clean;

    public SystemCheckPanel(int n, TaskNotifierIfc taskNotifierIfc) {
        super(n, taskNotifierIfc);
        this.clean = (CleanUpUtil)taskNotifierIfc.getObject("CleanUpUtil");
        this.next.setEnabled(false);
        this.addContent();
    }

    public void actionPerformed(ActionEvent actionEvent) throws ArrayIndexOutOfBoundsException {
        block11: {
            try {
                if (actionEvent.getSource().equals(this.cancel)) {
                    try {
                        if (this.tn.getStatus("Validator") != 1) {
                            this.tn.stop(this.validator);
                            this.clean.exitWith(0);
                            break block11;
                        }
                        this.clean.exitWith(0);
                    }
                    catch (Exception exception) {}
                    break block11;
                }
                if (actionEvent.getSource().equals(this.back)) {
                    ICGui.switchPanel(1);
                } else if (actionEvent.getSource().equals(this.next)) {
                    ICGui.switchPanel(4);
                } else if (actionEvent.getSource().equals(this.help)) {
                    ICGui.helpVisible(true);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                KMLogger.log((int)KMLogger.WARNING, (String)"SystemCheckPanel.java", (String)"actionPerformed()", (String)"ICGui.SwitchPanel() called with bad index");
            }
        }
    }

    protected void addContent() {
        this.subtitle.setText(ICPanel.messages.getString("CheckTitle"));
        this.intro = new JTextArea(ICPanel.messages.getString("CheckInstructions1"));
        this.intro.setLineWrap(true);
        this.intro.setEditable(false);
        this.intro.setWrapStyleWord(true);
        this.intro.setBackground(this.backgroundColor);
        this.analyze = new JLabel(ICPanel.messages.getString("CheckAnalyze"));
        this.analyze.setFont(new Font(null, 0, 12));
        this.analyze.setForeground(Color.black);
        this.performAnalysis = new JLabel(ICPanel.messages.getString("CheckPerformAnalysis"));
        this.performAnalysis.setFont(new Font(null, 0, 10));
        this.performAnalysis.setForeground(Color.black);
        this.progress = new JProgressBar();
        this.progress.setToolTipText(ICPanel.messages.getString("ProgressTip"));
        this.content.setLayout(this.gridbag);
        this.c.insets = new Insets(12, 12, 0, 6);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 2;
        this.c.fill = 2;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.titleBackground, this.c);
        this.content.add(this.titleBackground);
        this.c.insets = new Insets(12, 18, 0, 11);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 2;
        this.c.fill = 2;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.intro, this.c);
        this.content.add(this.intro);
        this.c.insets = new Insets(12, 30, 0, 11);
        this.c.weightx = 1.0;
        this.c.weighty = 0.5;
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 2;
        this.c.fill = 2;
        this.c.anchor = 16;
        this.gridbag.setConstraints(this.analyze, this.c);
        this.content.add(this.analyze);
        this.c.insets = new Insets(11, 48, 2, 0);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.c.gridwidth = 2;
        this.c.fill = 2;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.performAnalysis, this.c);
        this.content.add(this.performAnalysis);
        this.c.insets = new Insets(0, 48, 0, 48);
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.gridx = 0;
        this.c.gridy = 4;
        this.c.gridwidth = 2;
        this.c.fill = 2;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.progress, this.c);
        this.content.add(this.progress);
    }

    Object doChecks() {
        try {
            this.validator = (ValidatorIfc)this.tn.getObject("Validator");
            try {
                this.tn.execute(this.validator);
                Thread.sleep(7000L);
            }
            catch (Exception exception) {}
            this.numChecks = this.validator.checksTotal();
            try {
                this.status = this.tn.getStatus("Validator");
            }
            catch (Exception exception) {}
            while (this.status == 2) {
                this.numChecks = this.validator.checksTotal();
                this.updateCheckDisplay();
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
                try {
                    this.status = this.tn.getStatus("Validator");
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.status == 4 || this.status == 3) {
            JFrame jFrame = new JFrame();
            JOptionPane.showMessageDialog(jFrame, ICPanel.messages.getString("ExplorerError"), ICPanel.messages.getString("ErrorTitle"), 0);
            try {
                KMLogger.log((int)KMLogger.SEVERE, (String)"SystemCheckPanel.java", (String)"doChecks()", (String)("Data validation failed:  " + this.tn.getException("Validator").getMessage()));
            }
            catch (KMObjectException kMObjectException) {
                KMLogger.log((int)KMLogger.SEVERE, (String)"SystemCheckPanel.java", (String)"doChecks()", (String)"Unknown error while logging check failure.");
                this.clean.exitWith(0);
            }
            this.clean.exitWith(0);
        } else if (this.status == 1) {
            this.onFinish();
        }
        return "Checks Done";
    }

    protected void onFinish() {
        this.back.setEnabled(true);
        this.next.setEnabled(true);
        this.help.setEnabled(true);
        this.performAnalysis.setText(ICPanel.messages.getString("CheckCheckStatus3"));
        this.progress.setValue(100);
    }

    protected void onStart() {
        this.back.setEnabled(false);
        this.help.setEnabled(false);
        this.next.setEnabled(false);
        this.performAnalysis.setText(ICPanel.messages.getString("CheckCheckStatus2"));
        this.progress.setValue(0);
        this.startChecks();
    }

    protected void startChecks() {
        String string = String.valueOf(this.prop.getProperty("worker_path")) + System.getProperty("file.separator") + this.prop.getProperty("checklist");
        int n = Integer.parseInt(this.prop.getProperty("checklist_days_warning"));
        try {
            if (KAEUtil.isChecklistOlderThan(n, string)) {
                JOptionPane.showMessageDialog(null, String.valueOf(ICPanel.messages.getString("OldChecklistText1")) + " " + this.prop.getProperty("checklist_days_warning") + " " + ICPanel.messages.getString("OldChecklistText2"), ICPanel.messages.getString("OldChecklistTitle"), 1);
            }
        }
        catch (KMException kMException) {}
        this.worker = new SwingWorker(){

            public Object construct() {
                return SystemCheckPanel.this.doChecks();
            }
        };
        this.worker.start();
    }

    protected void updateCheckDisplay() {
        Runnable runnable = new Runnable(){

            public void run() {
                SystemCheckPanel.this.progress.setValue((int)((float)SystemCheckPanel.this.validator.getCompletedChecks() / (float)SystemCheckPanel.this.numChecks * 100.0f));
            }
        };
        try {
            SwingUtilities.invokeLater(runnable);
        }
        catch (Exception exception) {}
    }
}

