/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.collector.iccol;

import com.sun.vsp.km.ic.collector.ColMessageLookup;
import com.sun.vsp.km.ic.collector.CollectorProps;
import com.sun.vsp.km.ic.collector.iccol.DataCollectionException;
import com.sun.vsp.km.ic.collector.inputsource.ISTranslator;
import com.sun.vsp.km.ic.query.QueryException;
import com.sun.vsp.km.ic.query.QueryObject;
import com.sun.vsp.km.ic.query.QueryObjectIfc;
import com.sun.vsp.km.ic.util.ICPropIfc;
import com.sun.vsp.km.ic.util.ICProperties;
import com.sun.vsp.km.util.KMException;
import com.sun.vsp.km.util.KMLogger;
import com.sun.vsp.km.util.XMLUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BaseTable {
    protected static final String rootName = "collector";
    protected Document collectorDoc;
    protected Element root;
    protected boolean workersRun;
    protected CollectorProps prop;
    protected ICPropIfc props;
    protected boolean debug;

    public BaseTable() {
        block2: {
            this.collectorDoc = null;
            this.root = null;
            this.props = null;
            this.prop = CollectorProps.getInstance();
            this.props = ICProperties.getInstance();
            this.debug = this.props.getProperty("debug").equals("true");
            this.collectorDoc = XMLUtil.createDocument();
            this.root = this.collectorDoc.createElement(rootName);
            this.collectorDoc.appendChild(this.root);
            this.workersRun = false;
            if (System.getProperty("COL_PATH") == null) break block2;
            this.workersRun = true;
            try {
                this.loadDocument(System.getProperty("COL_PATH"));
            }
            catch (Exception exception) {
                System.out.println("There was a problem reading the collector file.");
            }
        }
    }

    public NodeList acceptQuery(QueryObjectIfc queryObjectIfc) throws QueryException {
        if (this.debug) {
            System.out.println("BaseTable:acceptQuery() called.");
        }
        try {
            if (!this.workersRun) {
                this.runWorkers();
            }
        }
        catch (DataCollectionException dataCollectionException) {
            KMLogger.log(KMLogger.WARNING, "com.sun.vsp.km.ic.collector.iccol.BaseTable", "acceptQuery()", ColMessageLookup.getMessage(103L));
            throw new QueryException(String.valueOf(ColMessageLookup.getMessage(103L)) + " " + ColMessageLookup.getMessage(102L) + "  " + dataCollectionException.getMessage());
        }
        NodeList nodeList = null;
        try {
            nodeList = this.findNodesEqualTo(queryObjectIfc);
        }
        catch (TransformerException transformerException) {
            KMLogger.log(KMLogger.WARNING, "com.sun.vsp.km.ic.collector.iccol.BaseTable", "acceptQuery()", ColMessageLookup.getMessage(104L));
            throw new QueryException(String.valueOf(ColMessageLookup.getMessage(104L)) + " " + ColMessageLookup.getMessage(102L) + "  " + transformerException.getMessage());
        }
        return nodeList;
    }

    public void appendDocument(Vector vector) {
        if (this.debug) {
            System.out.println("BaseTable:appendDocument() called.");
        }
        int n = 0;
        while (n < vector.size()) {
            Document document = (Document)vector.elementAt(n);
            Element element = document.getDocumentElement();
            if (element != null) {
                Node node = this.collectorDoc.importNode(element, true);
                XMLUtil.appendChildNode(this.root, node);
            }
            ++n;
        }
    }

    public void appendDocument(Document document) {
        Element element = document.getDocumentElement();
        Node node = this.collectorDoc.importNode(element, true);
        XMLUtil.appendChildNode(this.root, node);
    }

    protected String createXPathStatement(QueryObjectIfc queryObjectIfc) {
        if (this.debug) {
            System.out.println("BaseTable:createXPathStatement() called.");
        }
        String string = queryObjectIfc.getTableName();
        String string2 = queryObjectIfc.getInstanceName();
        String string3 = queryObjectIfc.getPropertyName();
        String string4 = string.equals("alias") && Character.isLetter(string2.charAt(string2.length() - 1)) ? "/collector/table[@name='" + string + "']" + "/instance[starts-with(@id, '" + string2 + "')]" + "/property[@name='" + string3 + "']" : (string3 != null ? "/collector/table[@name='" + string + "']" + "/instance[@id='" + string2 + "']" + "/property[@name='" + string3 + "']" : "/collector/table[@name='" + string + "']" + "/instance[@id='" + string2 + "']");
        return string4;
    }

    protected NodeList findNodesEqualTo(QueryObjectIfc queryObjectIfc) throws TransformerException {
        Object object;
        if (this.debug) {
            System.out.println("BaseTable:findNodesEqualTo() called.");
        }
        String string = this.createXPathStatement(queryObjectIfc);
        if (System.getProperty("COL_PATH") != null) {
            object = "/collector/table[@name='host']/instance";
            NodeList nodeList = XPathAPI.selectNodeList((Node)this.collectorDoc, (String)object);
            Node node = nodeList.item(0);
            String string2 = XMLUtil.getAttributeValue(node, "id");
            if (string.indexOf(System.getProperty("HOST_ID")) != -1) {
                String string3 = string.substring(0, string.indexOf(System.getProperty("HOST_ID")));
                int n = string.indexOf("'", string.indexOf(System.getProperty("HOST_ID")));
                String string4 = string.substring(string.indexOf("'", n), string.length());
                string = String.valueOf(string3) + string2 + string4;
            }
        }
        if (this.debug) {
            System.out.println("BaseTable:findNodesEqualTo() got XPath statement: " + string);
        }
        object = null;
        object = XPathAPI.selectNodeList((Node)this.collectorDoc, (String)string);
        if (object.getLength() == 0) {
            object = ISTranslator.nodeNotFound((QueryObject)queryObjectIfc);
        }
        return object;
    }

    public void loadDocument(String string) throws KMException {
        this.collectorDoc = XMLUtil.getDocumentFromFile(string);
    }

    protected void runWorkers() throws DataCollectionException {
        if (this.debug) {
            System.out.println("BaseTable:runWorkers() called.");
        }
        this.workersRun = true;
        URL[] uRLArray = new URL[1];
        String string = "";
        string = System.getProperty("WORKER_PATH") == null ? String.valueOf(this.prop.getProperty("worker_path")) + System.getProperty("file.separator") : String.valueOf(System.getProperty("WORKER_PATH")) + System.getProperty("file.separator");
        try {
            uRLArray[0] = new URL("file:" + string + "workers.jar");
        }
        catch (Exception exception) {}
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
        Object[] objectArray = null;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(String.valueOf(string) + "workers.jar");
        }
        catch (Exception exception) {}
        Vector<String> vector = new Vector<String>();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().getName().trim();
            if (!string2.endsWith(".class")) continue;
            string2 = string2.substring(string2.lastIndexOf(47) + 1, string2.lastIndexOf(46));
            vector.addElement(string2);
        }
        int n = 0;
        while (n < vector.size()) {
            block14: {
                try {
                    if (this.debug) {
                        System.out.println("BaseTable:runWorkers() running " + this.prop.getProperty("worker_package") + "." + (String)vector.elementAt(n));
                    }
                    Class<?> clazz = uRLClassLoader.loadClass(String.valueOf(this.prop.getProperty("worker_package")) + "." + (String)vector.elementAt(n));
                    Method method = clazz.getMethod("collect", (Class<?>[])objectArray);
                    Object obj = clazz.newInstance();
                    this.appendDocument((Vector)method.invoke(obj, objectArray));
                    if (this.debug) {
                        System.out.println("BaseTable:runWorkers() finished running " + this.prop.getProperty("worker_package") + "." + (String)vector.elementAt(n));
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw (DataCollectionException)invocationTargetException.getTargetException();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    KMLogger.log(KMLogger.WARNING, "com.sun.vsp.km.ic.collector.iccol.BaseTable", "runWorkers()", String.valueOf(ColMessageLookup.getMessage(105L)) + " " + (String)vector.elementAt(n));
                }
                catch (Exception exception) {
                    if (!this.debug) break block14;
                    System.out.println("BaseTable:runWorkers() worker not found: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
            ++n;
        }
        if (System.getProperty("ICAPP_VAR") != null) {
            this.saveDocument(String.valueOf(System.getProperty("ICAPP_VAR")) + System.getProperty("file.separator") + "data" + System.getProperty("file.separator") + "collector_out.xml");
        }
        XMLUtil.transformXML();
    }

    public void saveDocument(String string) {
        if (this.debug) {
            System.out.println("BaseTable:saveDocument() called.");
        }
        XMLUtil.serialize(this.collectorDoc, string);
        if (this.debug) {
            System.out.println("BaseTable:saveDocument() doc saved to: " + string);
        }
    }
}

