/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.util;

import com.sun.vsp.km.util.JSyslogCode;
import com.sun.vsp.km.util.JSyslogException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class JSyslog
implements JSyslogCode {
    private String ident;
    private int option;
    private int facility;
    private String syshost;
    private InetAddress ip;
    private DatagramPacket dp;
    private DatagramSocket ds;
    private boolean debug = false;

    public JSyslog(String string, int n, int n2) throws JSyslogException {
        this(string, n, n2, "localhost");
    }

    public JSyslog(String string, int n, int n2, String string2) throws JSyslogException {
        this.ident = string;
        this.option = n;
        this.facility = n2;
        this.syshost = string2;
        try {
            this.ip = InetAddress.getByName(string2);
            this.ds = new DatagramSocket();
            if (this.debug) {
                System.out.println(this.ip.toString());
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new JSyslogException("Host not found: " + unknownHostException, 5112L);
        }
        catch (SocketException socketException) {
            throw new JSyslogException("Could not open socket: " + socketException, 53003L);
        }
    }

    public static void main(String[] stringArray) {
        try {
            JSyslog jSyslog = new JSyslog("MyProgram", 2, 8);
            jSyslog.syslog(2, "Hello world.");
        }
        catch (JSyslogException jSyslogException) {
            System.err.println(jSyslogException);
        }
    }

    public void syslog(int n, String string) {
        boolean bl = false;
        String string2 = null;
        int n2 = this.facility & 0x3F8 | n;
        string2 = "<" + new Integer(n2).toString() + ">" + this.ident + ": " + string;
        if (this.debug) {
            System.out.println("tmpstr = " + string2);
            System.out.println("length tmpstr = " + string2.length());
        }
        byte[] byArray = new byte[string2.length()];
        byArray = string2.getBytes();
        this.dp = new DatagramPacket(byArray, string2.length(), this.ip, 514);
        try {
            this.ds.send(this.dp);
        }
        catch (IOException iOException) {
            System.err.println("Failed to send dgram packet. Errno: 5005 " + iOException.getMessage());
        }
    }
}

