/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.operatingsystem;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt64;
import com.sun.wbem.client.CIMOMHandle;
import com.sun.wbem.provider.MethodProvider;
import com.sun.wbem.provider20.InstanceProvider;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.operatingsystem.SwapInfo;
import com.sun.wbem.solarisprovider.packaging.DirFilter;
import java.io.File;
import java.math.BigInteger;
import java.net.InetAddress;
import java.text.DateFormat;
import java.util.Enumeration;
import java.util.Vector;

public class Solaris_OperatingSystem
implements InstanceProvider,
MethodProvider {
    public static int major = 0;
    public static int minor = 0;
    public static int minorMinor;
    public static String revision;
    public static String platformName;
    public String version = new String(String.valueOf(major) + "." + minor + "." + minorMinor);
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;
    private SwapInfo swapData = null;

    static {
        System.loadLibrary("solprov");
        Solaris_OperatingSystem.initStaticOSData();
    }

    native String GetBootUpTime();

    native int GetFreeMemory();

    native int GetFreeSpaceInPagingFiles();

    native int GetFreeVirtualMemory();

    native int GetNumberOfUsers();

    native String GetOSVersion();

    native int GetSwapSpace();

    native int GetTotalVirtualMemory();

    native int GetTotalVisibleMemorySize();

    public Boolean Reboot() {
        int n = 0;
        while (n < 2) {
            if (this.runCommand("sync", true) != 0) {
                return new Boolean(false);
            }
            ++n;
        }
        this.provUtil.writeLog(0, "LM_10010", "LM_10011", null, null, null, null);
        this.runCommand("reboot", true);
        this.provUtil.writeLog(2, "LM_10012", "LM_10013", null, null, null, null);
        return new Boolean(false);
    }

    native boolean SetSystemTime(String var1);

    public Boolean Shutdown() {
        int n = 0;
        while (n < 2) {
            if (this.runCommand("sync", true) != 0) {
                return new Boolean(false);
            }
            ++n;
        }
        this.provUtil.writeLog(0, "LM_10014", "LM_10015", null, null, null, null);
        this.runCommand("halt", true);
        this.provUtil.writeLog(2, "LM_10016", "LM_10017", null, null, null, null);
        return new Boolean(false);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass) throws CIMException {
        try {
            Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
            cIMObjectPath2.addKey("CSCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMObjectPath2.addKey("CreationClassName", new CIMValue((Object)"Solaris_OperatingSystem"));
            cIMObjectPath2.addKey("CSName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            if (platformName != null) {
                cIMObjectPath2.addKey("Name", new CIMValue((Object)platformName));
            } else {
                cIMObjectPath2.addKey("Name", new CIMValue((Object)"unknown"));
            }
            vector.addElement(cIMObjectPath2);
            return vector;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_10006", "LM_10007", null, null, null, null);
            this.provUtil.writeLog(2, exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector enumInstances(CIMObjectPath cIMObjectPath, boolean bl, CIMClass cIMClass, boolean bl2) throws CIMException {
        try {
            Vector<CIMInstance> vector = new Vector<CIMInstance>();
            CIMInstance cIMInstance = cIMClass.newInstance();
            String string = platformName;
            cIMInstance.setProperty("CSCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMInstance.setProperty("CSName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_OperatingSystem"));
            if (platformName != null) {
                cIMInstance.setProperty("Name", new CIMValue((Object)platformName));
                if (string.equalsIgnoreCase("Solaris")) {
                    cIMInstance.setProperty("OSType", new CIMValue((Object)new UnsignedInt16(30)));
                } else if (string.equalsIgnoreCase("SunOS")) {
                    cIMInstance.setProperty("OSType", new CIMValue((Object)new UnsignedInt16(29)));
                } else {
                    cIMInstance.setProperty("OSType", new CIMValue((Object)new UnsignedInt16(1)));
                }
            } else {
                cIMInstance.setProperty("Name", new CIMValue((Object)"unknown"));
                cIMInstance.setProperty("OSType", new CIMValue((Object)new UnsignedInt16(0)));
            }
            cIMInstance.setProperty("OtherTypeDescription", new CIMValue((Object)this.GetOSVersion()));
            cIMInstance.setProperty("LocalDateTime", new CIMValue((Object)new CIMDateTime()));
            cIMInstance.setProperty("CurrentTimeZone", new CIMValue((Object)new Short(this.getTimeZone())));
            cIMInstance.setProperty("Version", new CIMValue((Object)this.version));
            DateFormat dateFormat = DateFormat.getDateInstance();
            String string2 = new String(String.valueOf(this.GetBootUpTime()) + this.getTimeZone());
            cIMInstance.setProperty("LastBootUpTime", new CIMValue((Object)new CIMDateTime(string2)));
            cIMInstance.setProperty("NumberOfUsers", new CIMValue((Object)new UnsignedInt32((long)this.GetNumberOfUsers())));
            cIMInstance.setProperty("NumberOfProcesses", new CIMValue((Object)new UnsignedInt32((long)this.getProcessCount())));
            this.swapData.refresh();
            try {
                cIMInstance.setProperty("TotalSwapSpaceSize", new CIMValue((Object)new UnsignedInt64(new BigInteger(Double.toString(this.swapData.getTotalSwapSpace()).trim()))));
            }
            catch (NumberFormatException numberFormatException) {
                cIMInstance.setProperty("TotalSwapSpaceSize", new CIMValue((Object)new UnsignedInt64(new BigInteger(this.trimString(Double.toString(this.swapData.getTotalSwapSpace()).trim())))));
            }
            try {
                cIMInstance.setProperty("AllocatedSwapSpace", new CIMValue((Object)new UnsignedInt64(new BigInteger(Double.toString(this.swapData.getAllocatedSwapSpace()).trim()))));
            }
            catch (NumberFormatException numberFormatException) {
                cIMInstance.setProperty("AllocatedSwapSpace", new CIMValue((Object)new UnsignedInt64(new BigInteger(this.trimString(Double.toString(this.swapData.getAllocatedSwapSpace()).trim())))));
            }
            try {
                cIMInstance.setProperty("ReservedSwapSpace", new CIMValue((Object)new UnsignedInt64(new BigInteger(Double.toString(this.swapData.getReservedSwapSpace()).trim()))));
            }
            catch (NumberFormatException numberFormatException) {
                cIMInstance.setProperty("ReservedSwapSpace", new CIMValue((Object)new UnsignedInt64(new BigInteger(this.trimString(Double.toString(this.swapData.getReservedSwapSpace()).trim())))));
            }
            try {
                cIMInstance.setProperty("UsedSwapSpace", new CIMValue((Object)new UnsignedInt64(new BigInteger(Double.toString(this.swapData.getUsedSwapSpace()).trim()))));
            }
            catch (NumberFormatException numberFormatException) {
                cIMInstance.setProperty("UsedSwapSpace", new CIMValue((Object)new UnsignedInt64(new BigInteger(this.trimString(Double.toString(this.swapData.getUsedSwapSpace()).trim())))));
            }
            try {
                cIMInstance.setProperty("AvailableSwapSpace", new CIMValue((Object)new UnsignedInt64(new BigInteger(Double.toString(this.swapData.getAvailableSwapSpace()).trim()))));
            }
            catch (NumberFormatException numberFormatException) {
                cIMInstance.setProperty("AvailableSwapSpace", new CIMValue((Object)new UnsignedInt64(new BigInteger(this.trimString(Double.toString(this.swapData.getAvailableSwapSpace()).trim())))));
            }
            cIMInstance.setProperty("NumberOfLicensedUsers", new CIMValue((Object)new UnsignedInt32(0L)));
            cIMInstance.setProperty("MaxNumberOfProcesses", new CIMValue((Object)new UnsignedInt32(0L)));
            cIMInstance.setProperty("FreePhysicalMemory", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString(this.GetFreeMemory())))));
            cIMInstance.setProperty("TotalVirtualMemorySize", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString(this.GetTotalVirtualMemory())))));
            cIMInstance.setProperty("SizeStoredInPagingFiles", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString(this.GetSwapSpace())))));
            cIMInstance.setProperty("FreeSpaceInPagingFiles", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString(this.GetFreeSpaceInPagingFiles())))));
            cIMInstance.setProperty("TotalVisibleMemorySize", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString(this.GetTotalVisibleMemorySize())))));
            cIMInstance.setProperty("FreeVirtualMemory", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString(this.GetFreeVirtualMemory())))));
            vector.addElement(cIMInstance);
            return vector;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_10006", "LM_10007", null, null, null, null);
            this.provUtil.writeLog(2, exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public Vector execQuery(CIMObjectPath cIMObjectPath, String string, int n, CIMClass cIMClass) {
        return null;
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, CIMClass cIMClass, boolean bl) {
        try {
            CIMInstance cIMInstance;
            String string = new String();
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                cIMInstance = (CIMProperty)enumeration.nextElement();
                if (!cIMInstance.getName().equalsIgnoreCase("name")) continue;
                string = (String)cIMInstance.getValue().getValue();
            }
            cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperty("CSCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            cIMInstance.setProperty("CSName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"Solaris_OperatingSystem"));
            if (platformName != null) {
                cIMInstance.setProperty("Name", new CIMValue((Object)platformName));
                if (string.equalsIgnoreCase("Solaris")) {
                    cIMInstance.setProperty("OSType", new CIMValue((Object)new UnsignedInt16(30)));
                } else if (string.equalsIgnoreCase("SunOS")) {
                    cIMInstance.setProperty("OSType", new CIMValue((Object)new UnsignedInt16(29)));
                } else {
                    cIMInstance.setProperty("OSType", new CIMValue((Object)new UnsignedInt16(1)));
                }
            } else {
                cIMInstance.setProperty("Name", new CIMValue((Object)"unknown"));
                cIMInstance.setProperty("OSType", new CIMValue((Object)new UnsignedInt16(0)));
            }
            cIMInstance.setProperty("OtherTypeDescription", new CIMValue((Object)this.GetOSVersion()));
            cIMInstance.setProperty("LocalDateTime", new CIMValue((Object)new CIMDateTime()));
            cIMInstance.setProperty("CurrentTimeZone", new CIMValue((Object)new Short(this.getTimeZone())));
            cIMInstance.setProperty("Version", new CIMValue((Object)this.version));
            DateFormat dateFormat = DateFormat.getDateInstance();
            String string2 = new String(String.valueOf(this.GetBootUpTime()) + this.getTimeZone());
            cIMInstance.setProperty("LastBootUpTime", new CIMValue((Object)new CIMDateTime(string2)));
            cIMInstance.setProperty("NumberOfUsers", new CIMValue((Object)new UnsignedInt32((long)this.GetNumberOfUsers())));
            cIMInstance.setProperty("NumberOfProcesses", new CIMValue((Object)new UnsignedInt32((long)this.getProcessCount())));
            this.swapData.refresh();
            try {
                cIMInstance.setProperty("TotalSwapSpaceSize", new CIMValue((Object)new UnsignedInt64(new BigInteger(Double.toString(this.swapData.getTotalSwapSpace()).trim()))));
            }
            catch (NumberFormatException numberFormatException) {
                cIMInstance.setProperty("TotalSwapSpaceSize", new CIMValue((Object)new UnsignedInt64(new BigInteger(this.trimString(Double.toString(this.swapData.getTotalSwapSpace()).trim())))));
            }
            try {
                cIMInstance.setProperty("AllocatedSwapSpace", new CIMValue((Object)new UnsignedInt64(new BigInteger(Double.toString(this.swapData.getAllocatedSwapSpace()).trim()))));
            }
            catch (NumberFormatException numberFormatException) {
                cIMInstance.setProperty("AllocatedSwapSpace", new CIMValue((Object)new UnsignedInt64(new BigInteger(this.trimString(Double.toString(this.swapData.getAllocatedSwapSpace()).trim())))));
            }
            try {
                cIMInstance.setProperty("ReservedSwapSpace", new CIMValue((Object)new UnsignedInt64(new BigInteger(Double.toString(this.swapData.getReservedSwapSpace()).trim()))));
            }
            catch (NumberFormatException numberFormatException) {
                cIMInstance.setProperty("ReservedSwapSpace", new CIMValue((Object)new UnsignedInt64(new BigInteger(this.trimString(Double.toString(this.swapData.getReservedSwapSpace()).trim())))));
            }
            try {
                cIMInstance.setProperty("UsedSwapSpace", new CIMValue((Object)new UnsignedInt64(new BigInteger(Double.toString(this.swapData.getUsedSwapSpace()).trim()))));
            }
            catch (NumberFormatException numberFormatException) {
                cIMInstance.setProperty("UsedSwapSpace", new CIMValue((Object)new UnsignedInt64(new BigInteger(this.trimString(Double.toString(this.swapData.getUsedSwapSpace()).trim())))));
            }
            try {
                cIMInstance.setProperty("AvailableSwapSpace", new CIMValue((Object)new UnsignedInt64(new BigInteger(Double.toString(this.swapData.getAvailableSwapSpace()).trim()))));
            }
            catch (NumberFormatException numberFormatException) {
                cIMInstance.setProperty("AvailableSwapSpace", new CIMValue((Object)new UnsignedInt64(new BigInteger(this.trimString(Double.toString(this.swapData.getAvailableSwapSpace()).trim())))));
            }
            cIMInstance.setProperty("NumberOfLicensedUsers", new CIMValue((Object)new UnsignedInt32(0L)));
            cIMInstance.setProperty("MaxNumberOfProcesses", new CIMValue((Object)new UnsignedInt32(0L)));
            cIMInstance.setProperty("FreePhysicalMemory", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString(this.GetFreeMemory())))));
            cIMInstance.setProperty("TotalVirtualMemorySize", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString(this.GetTotalVirtualMemory())))));
            cIMInstance.setProperty("SizeStoredInPagingFiles", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString(this.GetSwapSpace())))));
            cIMInstance.setProperty("FreeSpaceInPagingFiles", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString(this.GetFreeSpaceInPagingFiles())))));
            cIMInstance.setProperty("TotalVisibleMemorySize", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString(this.GetTotalVisibleMemorySize())))));
            cIMInstance.setProperty("FreeVirtualMemory", new CIMValue((Object)new UnsignedInt64(new BigInteger(Integer.toString(this.GetFreeVirtualMemory())))));
            return cIMInstance;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_10000", "LM_10001", null, null, null, null);
            return null;
        }
    }

    private int getProcessCount() {
        File file = new File("/proc");
        DirFilter dirFilter = new DirFilter();
        String[] stringArray = file.list(dirFilter);
        return stringArray.length;
    }

    private short getTimeZone() {
        CIMDateTime cIMDateTime = new CIMDateTime();
        String string = cIMDateTime.toString();
        try {
            if (string.length() < 25) {
                return -1;
            }
            return Short.parseShort(string.substring(21, string.length()));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    static native void initStaticOSData();

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.provUtil = new ProviderUtility(cIMOMHandle, "Operating System");
        this.swapData = new SwapInfo();
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        if (string.equalsIgnoreCase("reboot")) {
            return new CIMValue((Object)this.Reboot());
        }
        if (string.equalsIgnoreCase("shutdown")) {
            return new CIMValue((Object)this.Shutdown());
        }
        this.provUtil.writeLog(2, "LM_10008", "LM_10009", string, null, null, null);
        return null;
    }

    private int runCommand(String string, boolean bl) {
        int n = -1;
        try {
            Process process = Runtime.getRuntime().exec(string);
            if (bl) {
                process.waitFor();
                n = process.exitValue();
            }
        }
        catch (Exception exception) {}
        return n;
    }

    private boolean setDateTime(String string) {
        if (string.length() < 25) {
            return false;
        }
        return !this.SetSystemTime(String.valueOf(string.substring(4, 12)) + string.substring(0, 4) + "." + string.substring(12, 14));
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        try {
            String string = cIMInstance.getProperty("LocalDateTime").getValue().getValue().toString();
            if (this.setDateTime(string)) {
                this.provUtil.writeLog(0, "LM_10002", "LM_10003", "LocalDateTime", string, null, null);
            }
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_10004", "LM_10005", null, null, null, null);
            this.provUtil.writeLog(2, exception);
        }
    }

    private String trimString(String string) {
        String string2 = ".";
        String string3 = "0";
        int n = -1;
        try {
            n = string.indexOf(string2);
            if (n != -1) {
                string3 = string.substring(0, n);
            }
        }
        catch (NullPointerException nullPointerException) {}
        return string3;
    }
}

