/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg;

import com.sun.prodreg.ALabel;
import com.sun.prodreg.Article;
import com.sun.prodreg.ClusterArticle;
import com.sun.prodreg.ErrorDialog;
import com.sun.prodreg.FileCount;
import com.sun.prodreg.Icon;
import com.sun.prodreg.Lumberjack;
import com.sun.prodreg.OutlineView;
import com.sun.prodreg.ProdReg;
import com.sun.prodreg.Registry;
import com.sun.prodreg.Separator;
import com.sun.prodreg.SwingTreeNode;
import com.sun.prodreg.VLabel;
import com.sun.prodreg.ViewableNode;
import com.sun.prodreg._;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;

public class LabelBlock {
    static Font smallfont;
    static Font mediumfont;
    static Font largefont;
    static Image damageImage;
    Container treepanel;
    Container infopanel;
    Container installpanel;
    Container toppanel;
    Container rbuttonpanel;
    Container uninstallpanel;
    OutlineView outlinebox;
    JTree treebox;
    Component whateverbox;
    ScrollPane scrollpane;
    JScrollPane jscrollpane;
    Container whateverscrollpane;
    VLabel title;
    VLabel version;
    VLabel source;
    VLabel installationDate;
    VLabel installlocation;
    VLabel currentMegs;
    VLabel installMegs;
    VLabel damageReport;
    Icon damageIcon;
    Component otherAttrs;
    Component installButton;
    Component uninstallButton;
    Component exitButton;
    Component aboutButton;
    static Point savedScroll;
    private static GridBagLayout gbl;
    private static GridBagConstraints gbc;
    private static String[] helpblurb;
    ViewableNode selected = null;
    Thread selectedThread;
    FileCount selectedFileCount;
    static final String wideString = "MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM";
    static final String widerString = "MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM";
    private static Hashtable translator;
    private static String[] translatorItems;

    static {
        helpblurb = null;
        translator = null;
        translatorItems = new String[]{"mnemonic", "id", "articles", "articleids", "parent", "parentid", "pkgs", "title", "description", "tsurl", "tsemail", "tsphone", "vendor", "vendorurl", "vendoremail", "vendorphone", "dist", "disturl", "distemail", "distphone", "source", "installlocation", "diskspace", "installdiskspace", "uninstall", "uninstallprogram", "keyfile", "locationflags"};
    }

    public LabelBlock(Container container, Registry[] registryArray) {
        if (ProdReg.Swing) {
            this.treepanel = new JPanel();
            this.infopanel = new JPanel();
            this.installpanel = new JPanel();
            this.rbuttonpanel = new JPanel();
            this.uninstallpanel = new JPanel();
        } else {
            this.treepanel = new Panel();
            this.infopanel = new Panel();
            this.installpanel = new Panel();
            this.rbuttonpanel = new Panel();
            this.uninstallpanel = new Panel();
        }
        this.toppanel = container;
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        container.add(this.treepanel);
        gridBagLayout.setConstraints(this.treepanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        container.add(this.infopanel);
        gridBagLayout.setConstraints(this.infopanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.weighty = 0.0;
        Separator separator = new Separator();
        container.add(separator);
        gridBagLayout.setConstraints(separator, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        container.add(this.installpanel);
        gridBagLayout.setConstraints(this.installpanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        container.add(this.rbuttonpanel);
        gridBagLayout.setConstraints(this.rbuttonpanel, gridBagConstraints);
        smallfont = new Font("Dialog", 0, 10);
        mediumfont = new Font("Dialog", 0, 12);
        largefont = new Font("Dialog", 0, 14);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        damageImage = toolkit.getImage(this.getClass().getResource("/damage.gif"));
        toolkit.prepareImage(damageImage, -1, -1, null);
        System.err.println(_.__("settingUp2"));
        this.setupLeft(registryArray);
        System.err.println(_.__("settingUp3"));
        this.setupRight();
        this.setupInstall();
    }

    public void clearProduct() {
        this.title.setText(" ");
        this.version.setText(" ");
        this.source.setText(" ");
        this.installationDate.setText(" ");
        this.installlocation.setText(" ");
        this.currentMegs.setText(" ");
        this.installMegs.setText(" ");
        this.damageReport.setText(" ");
        this.damageIcon.setImage(null);
        this.selected = null;
        if (ProdReg.Swing) {
            ((JList)this.otherAttrs).setListData(new Object[0]);
        } else {
            List list = (List)this.otherAttrs;
            if (list.getItemCount() > 0) {
                list.clear();
            }
        }
        this.uninstallpanel.remove(this.uninstallButton);
        this.uninstallpanel.invalidate();
        this.uninstallpanel.repaint();
    }

    private static int compareFolded(String string, String string2) {
        int n = string.length() > string2.length() ? string2.length() : string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = Character.toLowerCase(string.charAt(n2)) - Character.toLowerCase(string2.charAt(n2));
            if (n3 != 0) {
                return n3;
            }
            ++n2;
        }
        return string.length() - string2.length();
    }

    private void copyOverCollapsedBits() {
        int n = 0;
        while (n < ProdReg.allRegistries.length) {
            Registry registry = ProdReg.allRegistries[n];
            registry.equivalent.copyOverCollapsedBits(this.treebox);
            ++n;
        }
    }

    void doAbout() {
        Dialog dialog = new Dialog(ProdReg.frame, _.__("aboutTheRegistry")){

            public boolean handleEvent(Event event) {
                if (event.id == 201 || event.id == 203 || event.id == 502 || event.id == 1001 || event.id == 401) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    return true;
                }
                return super.handleEvent(event);
            }
        };
        dialog.setLayout(new BorderLayout(16, 16));
        dialog.add("North", new Label(" "));
        Label label = new Label(String.valueOf(_.__("prodReg")) + "   " + ProdReg.versionRes, 1);
        label.setFont(new Font("Dialog", 0, 18));
        Label label2 = new Label("(prodreg)", 1);
        label2.setFont(new Font("Dialog", 0, 14));
        Label label3 = new Label(ProdReg.buildDateRes, 1);
        label3.setFont(new Font("Dialog", 0, 9));
        Panel panel = new Panel();
        panel.setEnabled(true);
        panel.setLayout(new GridLayout(6, 1));
        panel.add(label);
        panel.add(label2);
        panel.add(label3);
        int n = ProdReg.copyrightRes.indexOf(65);
        if (n == -1) {
            panel.add(new Label(ProdReg.copyrightRes, 1));
        } else {
            panel.add(new Label(ProdReg.copyrightRes.substring(0, n), 1));
            panel.add(new Label(ProdReg.copyrightRes.substring(n), 1));
        }
        dialog.add("Center", panel);
        dialog.add("East", new Label(" "));
        dialog.add("West", new Label(" "));
        panel = new Panel();
        panel.add(new Button(_.__("close")));
        dialog.add("South", panel);
        dialog.pack();
        ((Component)dialog).setLocation(300, 350);
        dialog.show();
        dialog.toFront();
    }

    public void itemStateChanged(boolean bl, ViewableNode viewableNode) {
        if (bl) {
            viewableNode.setView(this);
            this.setOtherAttrs(viewableNode.getAttrs());
            this.selected = viewableNode;
        } else {
            if (this.selectedThread != null) {
                try {
                    this.selectedThread.stop();
                }
                catch (SecurityException securityException) {}
                this.selectedFileCount.toUpdate = null;
                this.selectedThread = null;
            }
            this.clearProduct();
        }
    }

    private VLabel labfield(String string) {
        ++LabelBlock.gbc.gridy;
        LabelBlock.gbc.gridx = 0;
        LabelBlock.gbc.anchor = 13;
        LabelBlock.gbc.fill = 0;
        Label label = new Label(string);
        label.setFont(smallfont);
        this.infopanel.add(label);
        gbl.setConstraints(label, gbc);
        LabelBlock.gbc.gridx = 1;
        LabelBlock.gbc.anchor = 17;
        LabelBlock.gbc.fill = 1;
        VLabel vLabel = ALabel.newLabel(" ");
        vLabel.setFont(mediumfont);
        this.infopanel.add((Component)((Object)vLabel));
        gbl.setConstraints((Component)((Object)vLabel), gbc);
        return vLabel;
    }

    private void loadHelpBlurb() {
        if (helpblurb == null) {
            helpblurb = new String[]{_.__("helpBlurb1"), _.__(ProdReg.Swing ? "helpBlurb4" : "helpBlurb3"), _.__("helpBlurb6"), _.__("helpBlurb7"), _.__("helpBlurb8"), _.__("helpBlurb9")};
        }
    }

    public void makeProductList(Registry registry) {
        Vector<Article> vector = new Vector<Article>();
        int n = 0;
        while (n < registry.articles.size()) {
            Article article = (Article)registry.articles.elementAt(n);
            if (article.getAttribute("parent") == null) {
                article.assessDamage();
                vector.addElement(article);
            }
            ++n;
        }
        registry.visibleProducts = new Article[vector.size()];
        vector.copyInto(registry.visibleProducts);
        LabelBlock.sortsome(registry.visibleProducts, 0, registry.visibleProducts.length);
    }

    private void refreshCollapseBits(Registry[] registryArray) {
        int n = 0;
        while (n < registryArray.length) {
            Registry registry = registryArray[n];
            Registry registry2 = ProdReg.allRegistries[n];
            registry2.setCollapsed(registry.isCollapsed());
            Vector vector = registry.articles;
            int n2 = 0;
            while (n2 < vector.size()) {
                Article article = (Article)vector.elementAt(n2);
                Article article2 = Article.lookup(article.mnemonic, article.id);
                if (article2 != null) {
                    article2.setCollapsed(article.isCollapsed());
                }
                ++n2;
            }
            ++n;
        }
    }

    private void restoreScroll() {
        if (!ProdReg.Swing) {
            this.scrollpane.setScrollPosition(savedScroll);
        } else {
            JScrollBar jScrollBar = this.jscrollpane.getVerticalScrollBar();
            if (jScrollBar != null) {
                jScrollBar.setValue(LabelBlock.savedScroll.y);
            }
            if ((jScrollBar = this.jscrollpane.getHorizontalScrollBar()) != null) {
                jScrollBar.setValue(LabelBlock.savedScroll.x);
            }
        }
    }

    private void saveScroll() {
        if (!ProdReg.Swing) {
            savedScroll = this.scrollpane.getScrollPosition();
        } else {
            savedScroll = new Point(0, 0);
            JScrollBar jScrollBar = this.jscrollpane.getVerticalScrollBar();
            if (jScrollBar != null) {
                LabelBlock.savedScroll.y = jScrollBar.getValue();
            }
            if ((jScrollBar = this.jscrollpane.getHorizontalScrollBar()) != null) {
                LabelBlock.savedScroll.x = jScrollBar.getValue();
            }
        }
    }

    private void setOtherAttrs(Properties properties) {
        int n;
        Object[] objectArray;
        this.otherAttrs.setVisible(false);
        if (properties == null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            objectArray = (String)enumeration.nextElement();
            String string = String.valueOf(LabelBlock.translate((String)objectArray)) + ": " + properties.getProperty((String)objectArray);
            vector.addElement(string);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        int n2 = objectArray.length;
        boolean bl = true;
        while (bl) {
            bl = false;
            n = 1;
            while (n < n2) {
                if (((String)objectArray[n - 1]).compareTo((String)objectArray[n]) > 0) {
                    Object object = objectArray[n - 1];
                    objectArray[n - 1] = objectArray[n];
                    objectArray[n] = object;
                    bl = true;
                }
                ++n;
            }
        }
        if (ProdReg.Swing) {
            ((JList)this.otherAttrs).setListData(objectArray);
        } else {
            List list = (List)this.otherAttrs;
            if (list.getItemCount() > 0) {
                list.clear();
            }
            list.add(widerString);
            n = 0;
            while (n < n2) {
                list.addItem((String)objectArray[n]);
                ++n;
            }
            list.remove(0);
        }
        this.otherAttrs.setVisible(true);
    }

    private void setupInstall() {
        if (ProdReg.Swing) {
            this.installButton = new JButton(_.__("newInstall"));
            this.uninstallButton = new JButton("\u00a0\u00a0\u00a0\u00a0\u00a0");
            this.exitButton = new JButton(_.__("exit"));
        } else {
            this.installButton = new Button(_.__("newInstall"));
            this.uninstallButton = new Button("\u00a0\u00a0\u00a0\u00a0\u00a0");
            this.exitButton = new Button(_.__("exit"));
        }
        this.installButton.setFont(mediumfont);
        this.uninstallButton.setFont(mediumfont);
        this.exitButton.setFont(mediumfont);
        this.installpanel.add(this.installButton);
        this.rbuttonpanel.setLayout(new BorderLayout());
        this.rbuttonpanel.add("Center", this.uninstallpanel);
        Panel panel = new Panel();
        panel.add(this.exitButton);
        this.rbuttonpanel.add("East", panel);
    }

    private void setupLeft(Registry[] registryArray) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.treepanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        Component component = (Component)((Object)ALabel.newLabel("  "));
        component.setFont(smallfont);
        this.treepanel.add(component);
        gridBagLayout.setConstraints(component, gridBagConstraints);
        Component component2 = (Component)((Object)ALabel.newLabel(_.__("softwareInstalled")));
        component2.setFont(largefont);
        this.treepanel.add(component2);
        gridBagLayout.setConstraints(component2, gridBagConstraints);
        int n = 0;
        while (n < registryArray.length) {
            this.makeProductList(registryArray[n]);
            ++n;
        }
        if (!ProdReg.Swing) {
            this.outlinebox = new OutlineView(registryArray);
            this.outlinebox.labelblock = this;
            this.scrollpane = new ScrollPane(0);
            this.scrollpane.getVAdjustable().setUnitIncrement(16);
            this.scrollpane.add(this.outlinebox);
            this.whateverscrollpane = this.scrollpane;
            this.outlinebox.addItemListener(this);
            this.whateverbox = this.outlinebox;
        } else {
            SwingTreeNode swingTreeNode = new SwingTreeNode(registryArray);
            this.treebox = new JTree(swingTreeNode);
            this.treebox.setRootVisible(false);
            this.treebox.setShowsRootHandles(true);
            this.jscrollpane = new JScrollPane(this.treebox, 22, 30);
            Lumberjack lumberjack = new Lumberjack(this);
            this.treebox.addTreeExpansionListener(lumberjack);
            this.treebox.addTreeSelectionListener(lumberjack);
            this.whateverbox = this.treebox;
            this.whateverscrollpane = this.jscrollpane;
        }
        this.whateverbox.setFont(mediumfont);
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.treepanel.add(this.whateverscrollpane);
        gridBagLayout.setConstraints(this.whateverscrollpane, gridBagConstraints);
    }

    private void setupRight() {
        gbl = new GridBagLayout();
        this.infopanel.setLayout(gbl);
        gbc = new GridBagConstraints();
        LabelBlock.gbc.weightx = 1.0;
        LabelBlock.gbc.weighty = 0.0;
        LabelBlock.gbc.gridx = 0;
        LabelBlock.gbc.gridy = 0;
        LabelBlock.gbc.gridheight = 1;
        LabelBlock.gbc.gridwidth = 1;
        this.aboutButton = ProdReg.Swing ? new JButton(_.__("about")) : new Button(_.__("about"));
        this.aboutButton.setFont(mediumfont);
        this.infopanel.add(this.aboutButton);
        LabelBlock.gbc.gridx = 1;
        LabelBlock.gbc.gridy = 0;
        LabelBlock.gbc.gridwidth = 1;
        LabelBlock.gbc.anchor = 13;
        LabelBlock.gbc.fill = 0;
        LabelBlock.gbc.insets = new Insets(4, 4, 4, 4);
        gbl.setConstraints(this.aboutButton, gbc);
        LabelBlock.gbc.fill = 1;
        LabelBlock.gbc.gridx = 0;
        LabelBlock.gbc.gridy = 1;
        LabelBlock.gbc.gridwidth = 1;
        this.title = this.labfield(_.__("title"));
        ((Component)((Object)this.title)).setFont(largefont);
        this.version = this.labfield(_.__("version"));
        this.installlocation = this.labfield(_.__("location"));
        this.currentMegs = this.labfield(_.__("currentSize"));
        this.installMegs = this.labfield(_.__("installSize"));
        this.installationDate = this.labfield(_.__("installedOn"));
        this.source = this.labfield(_.__("installedFrom"));
        LabelBlock.gbc.gridwidth = 1;
        LabelBlock.gbc.gridy = -1;
        LabelBlock.gbc.gridx = 0;
        this.damageIcon = new Icon();
        this.infopanel.add(this.damageIcon);
        LabelBlock.gbc.anchor = 13;
        LabelBlock.gbc.fill = 0;
        gbl.setConstraints(this.damageIcon, gbc);
        LabelBlock.gbc.anchor = 17;
        LabelBlock.gbc.fill = 1;
        LabelBlock.gbc.gridx = 1;
        this.damageReport = ALabel.newLabel(" ");
        this.damageReport.setFont(mediumfont);
        this.damageReport.setForeground(Color.red);
        this.infopanel.add((Component)((Object)this.damageReport));
        gbl.setConstraints((Component)((Object)this.damageReport), gbc);
        this.loadHelpBlurb();
        Component component = (Component)((Object)ALabel.newLabel(_.__("moreInfo")));
        component.setFont(smallfont);
        LabelBlock.gbc.gridx = 0;
        LabelBlock.gbc.gridwidth = 2;
        this.infopanel.add(component);
        gbl.setConstraints(component, gbc);
        LabelBlock.gbc.gridheight = 0;
        LabelBlock.gbc.weighty = 1.0;
        LabelBlock.gbc.insets = new Insets(4, 4, 4, 4);
        if (ProdReg.Swing) {
            JList<String> jList;
            this.otherAttrs = jList = new JList<String>();
            ScrollPane scrollPane = new ScrollPane(0);
            scrollPane.add(jList);
            jList.setListData(helpblurb);
            this.infopanel.add(scrollPane);
            gbl.setConstraints(scrollPane, gbc);
        } else {
            List list = new List();
            this.otherAttrs = list;
            int n = 0;
            while (n < helpblurb.length) {
                list.addItem(helpblurb[n]);
                ++n;
            }
            this.infopanel.add(list);
            gbl.setConstraints(list, gbc);
        }
        this.otherAttrs.setFont(mediumfont);
    }

    static void sortsome(Article[] articleArray, int n, int n2) {
        if (n2 - n <= 1) {
            return;
        }
        int n3 = n;
        int n4 = n2 - 1;
        int n5 = (n + n2) / 2;
        Article article = articleArray[n5];
        articleArray[n5] = articleArray[n4];
        String string = article.getAttribute("title", "");
        Article article2 = articleArray[n3];
        while (n3 < n4) {
            String string2 = article2.getAttribute("title", "");
            if (LabelBlock.compareFolded(string2, string) < 0) {
                articleArray[n3++] = article2;
                article2 = articleArray[n3];
                continue;
            }
            articleArray[n4--] = article2;
            article2 = articleArray[n4];
        }
        articleArray[n3] = article;
        LabelBlock.sortsome(articleArray, n, n3);
        LabelBlock.sortsome(articleArray, n3 + 1, n2);
    }

    private static String translate(String string) {
        String string2;
        if (translator == null) {
            translator = new Hashtable(47);
            int n = 0;
            while (n < translatorItems.length) {
                translator.put(translatorItems[n], _.__("legend-" + translatorItems[n]));
                ++n;
            }
        }
        if ((string2 = (String)translator.get(string)) == null) {
            return string;
        }
        return string2.toUpperCase();
    }

    void treeviewRefresh() throws IOException {
        Cursor cursor = Cursor.getPredefinedCursor(3);
        this.toppanel.setCursor(cursor);
        Registry[] registryArray = ProdReg.allRegistries;
        this.saveScroll();
        if (ProdReg.Swing) {
            this.copyOverCollapsedBits();
        }
        ProdReg.allRegistries = null;
        Registry.openAllRegistries(false);
        ClusterArticle.readClusterInfo();
        this.refreshCollapseBits(registryArray);
        this.clearProduct();
        this.treepanel.removeAll();
        this.setupLeft(ProdReg.allRegistries);
        this.treepanel.doLayout();
        this.whateverscrollpane.doLayout();
        this.installButton.setEnabled(true);
        this.restoreScroll();
        cursor = Cursor.getPredefinedCursor(0);
        this.toppanel.setCursor(cursor);
    }

    public void uninstall(Component component, boolean bl) {
        if (this.selected == null) {
            return;
        }
        if (this.selected instanceof Registry) {
            ErrorDialog.report(component, _.__("cantUninstallRegEr"));
            return;
        }
        if (this.selected instanceof Article) {
            try {
                Article article = (Article)this.selected;
                article.interactiveUninstall(component, this, bl);
                return;
            }
            catch (Throwable throwable) {
                ErrorDialog.report(component, throwable);
                return;
            }
        }
        throw new Error("unknown thing selected");
    }
}

