#ident	"@(#)i.awk	1.4	02/09/23 SMI"	/* SVr4.0  1.5	*/ 

error=no
while read src dest
do
	[ "$src" = /dev/null ] && continue

	echo "Modifying $dest"

	# Strip PKG_INSTALL_ROOT from dest if installation is to an
	# alternate root.

	if [ -n "$PKG_INSTALL_ROOT" -a "$PKG_INSTALL_ROOT" != "/" ]; then
		client_dest=`echo $dest | \
			/usr/bin/nawk -v rootdir="$PKG_INSTALL_ROOT" '{
				{ print substr($0, length(rootdir)+1)} }'`
		savepath=$PKGSAV/awk${client_dest}
	else
		savepath=$PKGSAV/awk${dest}
	fi

	dirname=`dirname $savepath`
	if [ $? -ne 0 ]
	then
		error=yes
		continue
	fi
	if [ ! -d $dirname ]
	then
		# ignore return code since mkdir has bug
		mkdir -p $dirname
	fi

	cp $src $savepath &&
	/usr/sadm/install/scripts/cmdexec /usr/bin/awk install $savepath $dest

	if [ $? -ne 0 ]
	then
		error=yes
		continue
	fi
done
[ "$error" = yes ] &&
	exit 2
exit 0
