/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opencard.http;

import com.sun.opencard.http.Server;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Main {
    static /* synthetic */ Class class$com$sun$opencard$http$OpenCardHandler;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static void initProps(Properties properties) {
        ((Hashtable)properties).put("mime.html", "text/html");
        ((Hashtable)properties).put("mime.txt", "text/plain");
        ((Hashtable)properties).put("mime.gif", "image/gif");
        ((Hashtable)properties).put("mime.jpg", "image/jpeg");
        ((Hashtable)properties).put("mime.css", "text/x-css-stylesheet");
        ((Hashtable)properties).put("mime.class", "application/octet-stream");
        ((Hashtable)properties).put("mime.jar", "application/octet-stream");
        ((Hashtable)properties).put("mime.jib", "application/octet-stream");
    }

    public static void main(String[] stringArray) throws Exception {
        boolean bl = false;
        Properties properties = new Properties();
        Main.initProps(properties);
        int n = 0;
        try {
            n = 0;
            while (n < stringArray.length) {
                bl = false;
                if (stringArray[n].startsWith("-he")) {
                    throw new Exception();
                }
                if (stringArray[n].startsWith("-ha")) {
                    ((Hashtable)properties).put("handler", stringArray[++n]);
                } else if (stringArray[n].startsWith("-r")) {
                    ((Hashtable)properties).put("root", stringArray[++n]);
                } else if (stringArray[n].startsWith("-ho")) {
                    ((Hashtable)properties).put("host", stringArray[++n]);
                } else if (stringArray[n].startsWith("-de")) {
                    ((Hashtable)properties).put("default", stringArray[++n]);
                } else if (stringArray[n].startsWith("-ip")) {
                    ((Hashtable)properties).put("restrict", String.valueOf(properties.getProperty("restrict", "")) + " " + InetAddress.getByName(stringArray[++n]));
                } else if (stringArray[n].startsWith("-c")) {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(stringArray[++n]);
                        properties.load(fileInputStream);
                        fileInputStream.close();
                    }
                    catch (Exception exception) {
                        System.out.println("Warning: " + exception);
                    }
                } else if (stringArray[n].startsWith("-p")) {
                    ((Hashtable)properties).put("port", stringArray[++n]);
                } else if (stringArray[n].startsWith("-l")) {
                    ((Hashtable)properties).put("log", stringArray[++n]);
                } else if (stringArray[n].startsWith("-s")) {
                    if (Main.startServer(properties)) {
                        System.out.println("Server started on " + properties.getProperty("port", "8080"));
                    }
                    properties = new Properties();
                    Main.initProps(properties);
                    bl = true;
                } else if (!stringArray[n].startsWith("-")) {
                    ((Hashtable)properties).put(stringArray[n], stringArray[++n]);
                } else {
                    System.out.println("Invalid flag : " + stringArray[n]);
                    throw new Exception();
                }
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Missing argument after: " + stringArray[n - 1]);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Usage: Main -conf <file> -port <port> -handler <class name> -root <doc_root> -ip <host> <name value>...");
            return;
        }
        if (!bl && Main.startServer(properties)) {
            System.out.println("Server started on " + properties.getProperty("port", "8080"));
        }
    }

    public static boolean startServer(Properties properties) {
        String string;
        String string2 = properties.getProperty("handler", (class$com$sun$opencard$http$OpenCardHandler != null ? class$com$sun$opencard$http$OpenCardHandler : (class$com$sun$opencard$http$OpenCardHandler = Main.class$("com.sun.opencard.http.OpenCardHandler"))).getName());
        int n = 8080;
        try {
            n = Integer.parseInt(properties.getProperty("port", "8080"));
        }
        catch (NumberFormatException numberFormatException) {}
        Server server = null;
        try {
            server = new Server(new ServerSocket(n), string2, properties);
        }
        catch (BindException bindException) {
            System.out.println("Port " + n + " is already in use");
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Can't find handler class: " + string2);
            return false;
        }
        catch (IOException iOException) {
            System.out.println("Unable to start server on port " + n + " :" + iOException);
            return false;
        }
        if (((Hashtable)properties).containsKey("host")) {
            server.hostName = properties.getProperty("host");
        }
        server.defaultPrefix = properties.getProperty("defaultPrefix", "");
        if (((Hashtable)properties).containsKey("maxRequests")) {
            try {
                server.maxRequests = Integer.decode(properties.getProperty("maxRequests"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (((Hashtable)properties).containsKey("noKeepAlives")) {
            server.maxRequests = 0;
        }
        if (((Hashtable)properties).containsKey("log")) {
            string = properties.getProperty("log");
            server.logLevel = Integer.decode(string);
        }
        if (((Hashtable)properties).containsKey("restrict")) {
            string = properties.getProperty("restrict");
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            Vector<InetAddress> vector = new Vector<InetAddress>(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    vector.addElement(InetAddress.getByName(string3));
                }
                catch (UnknownHostException unknownHostException) {
                    System.out.println(unknownHostException.toString());
                }
            }
            if (vector.size() > 0) {
                vector.copyInto(server.restrict);
            }
        }
        server.start();
        return true;
    }
}

