/*
 * Decompiled with CFR 0.152.
 */
package com.scmmicro.smartos.physical;

import com.scmmicro.smartos.exceptions.BadParameterException;
import com.scmmicro.smartos.exceptions.BadParameterValueException;
import com.scmmicro.smartos.exceptions.CardException;
import com.scmmicro.smartos.exceptions.CommunicationException;
import com.scmmicro.smartos.exceptions.TimeOutException;
import com.scmmicro.smartos.physical.DriveListener;
import com.scmmicro.smartos.util.Buffer;
import com.sun.opencard.common.OCFDebug;

public abstract class Drive {
    boolean verbose = false;
    protected DriveListener m_rDriveListener;
    protected static boolean m_bOpenned;
    protected long m_nTsTimeout;
    protected boolean m_bPower;
    protected long m_nReceptionTimeout;
    protected long m_nTransmitionTimeout;
    protected long m_nRegAccesTimeout;
    protected String DriverName;
    protected String DriverType;
    protected String DriverAddress;
    protected int comSpeed;
    private static final boolean DEFAULT_POWER = false;
    private static final long DEFAULT_TS_TIMEOUT = 100L;
    private static final long DEFAULT_RECEPTION_TIMEOUT = 4000L;
    private static final long DEFAULT_TRANSMITION_TIMEOUT = 4000L;
    private static final long DEFAULT_REG_ACCESS_TIMEOUT = 2000L;

    public Drive() {
        m_bOpenned = false;
        this.m_bPower = false;
        this.m_nTsTimeout = 100L;
        this.m_nReceptionTimeout = 4000L;
        this.m_nTransmitionTimeout = 4000L;
        this.m_nRegAccesTimeout = 2000L;
    }

    public abstract void close() throws CommunicationException, CardException, TimeOutException;

    public abstract int getNumReceived() throws CommunicationException, CardException;

    public long getParameter(byte by) throws CommunicationException, CardException, BadParameterException, TimeOutException {
        switch (by) {
            case 22: {
                throw new BadParameterException("PLP_POWER is write only");
            }
            case 15: {
                long l = this.m_nReceptionTimeout;
                if (!this.verbose) break;
                try {
                    OCFDebug.debugln((String)("getParameter:: PLP_RECEPTIME = " + l));
                }
                catch (Exception exception) {}
                break;
            }
            case 30: {
                long l = this.m_nTsTimeout * 1000L;
                break;
            }
        }
        return -1L;
    }

    public abstract void open() throws CommunicationException, CardException, TimeOutException;

    public abstract void receiveBlock(Buffer var1) throws CommunicationException, CardException, TimeOutException;

    public abstract void sendBlock(Buffer var1) throws CommunicationException, CardException, TimeOutException;

    public void setInitializer(String string, String string2, String string3) throws CommunicationException, CardException {
        this.DriverName = string;
        this.DriverType = string2;
        this.DriverAddress = string3;
    }

    public void setListener(DriveListener driveListener) throws CommunicationException, CardException, TimeOutException {
        this.m_rDriveListener = driveListener;
    }

    public void setParameter(byte by, long l) throws CommunicationException, CardException, BadParameterException, BadParameterValueException, TimeOutException {
        switch (by) {
            case 22: {
                if (l == 0L) {
                    this.m_bPower = false;
                    break;
                }
                this.m_bPower = true;
                break;
            }
            case 15: {
                this.m_nReceptionTimeout = l;
                if (!this.verbose) break;
                try {
                    OCFDebug.debugln((String)("setParameter::  PLP_RECEPTIME = " + l));
                }
                catch (Exception exception) {}
                break;
            }
            case 30: {
                this.m_nTsTimeout = l / 1000L;
                break;
            }
        }
    }
}

