/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.scf;

import com.sun.smartcard.scf.InvalidStateException;
import com.sun.smartcard.scf.Logger;
import com.sun.smartcard.scf.Terminal;
import com.sun.smartcard.scf.TerminalEventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

class TerminalEventDispatcher {
    static final int EVENT_CARDINSERTED = 1;
    static final int EVENT_CARDREMOVED = 2;
    static final int EVENT_TERMINALCLOSED = 4;
    static final int EVENT_COMMUNICATIONERROR = 8;
    static final int EVENT_CARDRESET = 16;
    static final int EVENT_CARDPRESENT = 32;
    static final int EVENT_CARDABSENT = 64;
    static final int EVENT_ALL = 127;
    private static Event[] events = new Event[]{new Event(1, "CardInserted"), new Event(2, "CardRemoved"), new Event(4, "TerminalClosed"), new Event(8, "CommunicationError"), new Event(16, "CardReset"), new Event(32, "CardPresent"), new Event(64, "CardAbsent")};
    private HashMap listeners;
    private Terminal owner;
    private boolean isCardPresent;
    private boolean isActive = false;
    private Logger logger = Logger.createLogger("TerminalEventDispatcher");

    TerminalEventDispatcher() {
        this.listeners = new HashMap();
    }

    synchronized void activate() {
        this.logger.log("activate", "");
        this.isActive = true;
    }

    void addEventListenerAndDispatchInitialStateEvent(TerminalEventListener terminalEventListener, int n) throws InvalidStateException {
        this.logger.log("addEventListener", "");
        TerminalEventRegistration terminalEventRegistration = new TerminalEventRegistration(terminalEventListener, n);
        TerminalEventDispatcher terminalEventDispatcher = this;
        synchronized (terminalEventDispatcher) {
            if (!this.isActive) {
                throw new InvalidStateException();
            }
            terminalEventRegistration.activate();
            terminalEventRegistration.enqueueEvent(this.isCardPresent ? 32 : 64);
            this.listeners.put(terminalEventListener, terminalEventRegistration);
        }
    }

    synchronized void cardInserted() {
        this.isCardPresent = true;
        this.notifyListeners(1);
    }

    synchronized void cardRemoved() {
        this.isCardPresent = false;
        this.notifyListeners(2);
    }

    void close() {
        this.logger.log("close", "");
    }

    private String getEventName(int n) {
        int n2 = 0;
        while (n2 < events.length) {
            if (TerminalEventDispatcher.events[n2].eventType == n) {
                return TerminalEventDispatcher.events[n2].eventName;
            }
            ++n2;
        }
        return null;
    }

    void init(boolean bl) {
        this.logger.log("init", "");
        this.isCardPresent = bl;
    }

    synchronized void notifyListeners(int n) {
        this.logger.log("notifyListeners", "event=" + this.getEventName(n));
        if (!this.isActive) {
            return;
        }
        Iterator iterator = this.listeners.values().iterator();
        while (iterator.hasNext()) {
            ((TerminalEventRegistration)iterator.next()).enqueueEvent(n);
        }
    }

    synchronized void passivate() {
        this.logger.log("passivate", "");
        this.isActive = false;
        Iterator iterator = this.listeners.values().iterator();
        while (iterator.hasNext()) {
            ((TerminalEventRegistration)iterator.next()).close();
        }
        this.listeners.clear();
    }

    void removeEventListener(TerminalEventListener terminalEventListener) throws InvalidStateException {
        TerminalEventRegistration terminalEventRegistration;
        this.logger.log("removeEventListener", "");
        TerminalEventDispatcher terminalEventDispatcher = this;
        synchronized (terminalEventDispatcher) {
            if (!this.isActive) {
                throw new InvalidStateException();
            }
            terminalEventRegistration = (TerminalEventRegistration)this.listeners.remove(terminalEventListener);
        }
        if (terminalEventRegistration != null) {
            terminalEventRegistration.listenerRemoved();
        }
    }

    void setOwner(Terminal terminal) {
        this.owner = terminal;
    }

    private static class Event {
        int eventType;
        String eventName;

        Event(int n, String string) {
            this.eventType = n;
            this.eventName = string;
        }
    }

    private class TerminalEventRegistration {
        private TerminalEventListener listener;
        private int eventMask;
        private LinkedList receivedEvents;
        private boolean isActive;
        private boolean isListenerRemoved;

        TerminalEventRegistration(TerminalEventListener terminalEventListener, int n) {
            this.listener = terminalEventListener;
            this.eventMask = n;
            this.receivedEvents = new LinkedList();
            this.isActive = true;
            this.isListenerRemoved = false;
        }

        static /* synthetic */ void access$0(TerminalEventRegistration terminalEventRegistration) {
            terminalEventRegistration.dispatchEvents();
        }

        void activate() {
            new Thread(new Runnable(this){
                private final /* synthetic */ TerminalEventRegistration this$1;
                {
                    this.this$1 = terminalEventRegistration;
                }

                public void run() {
                    TerminalEventRegistration.access$0(this.this$1);
                }
            }).start();
        }

        void close() {
            TerminalEventDispatcher.this.logger.log("TerminalEventRegistration.close", "");
            TerminalEventRegistration terminalEventRegistration = this;
            synchronized (terminalEventRegistration) {
                this.isActive = false;
                this.notify();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void dispatchEvents() {
            block16: while (true) {
                int n;
                TerminalEventRegistration terminalEventRegistration = this;
                synchronized (terminalEventRegistration) {
                    block22: {
                        while (true) {
                            if (this.receivedEvents.size() != 0) {
                                if (!this.isActive) break;
                                n = (Integer)this.receivedEvents.removeFirst();
                                break block22;
                            }
                            if (!this.isActive) {
                                return;
                            }
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                                continue;
                            }
                            if (this.isListenerRemoved) return;
                        }
                        if ((this.eventMask & 4) == 0) {
                            return;
                        }
                        n = 4;
                    }
                }
                TerminalEventDispatcher.this.logger.log("TerminalEventRegistration.dispatchEvents", "event=" + TerminalEventDispatcher.this.getEventName(n));
                try {
                    switch (n) {
                        default: {
                            continue block16;
                        }
                        case 1: {
                            this.listener.cardInserted(TerminalEventDispatcher.this.owner);
                            continue block16;
                        }
                        case 2: {
                            this.listener.cardRemoved(TerminalEventDispatcher.this.owner);
                            continue block16;
                        }
                        case 16: {
                            this.listener.cardReset(TerminalEventDispatcher.this.owner);
                            continue block16;
                        }
                        case 4: {
                            this.listener.terminalClosed(TerminalEventDispatcher.this.owner);
                            return;
                        }
                        case 8: {
                            this.listener.communicationErrorOccured(TerminalEventDispatcher.this.owner);
                            continue block16;
                        }
                        case 32: {
                            this.listener.cardPresent(TerminalEventDispatcher.this.owner);
                            continue block16;
                        }
                        case 64: 
                    }
                    this.listener.cardAbsent(TerminalEventDispatcher.this.owner);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }

        void enqueueEvent(int n) {
            if ((this.eventMask & n) == 0) {
                return;
            }
            TerminalEventRegistration terminalEventRegistration = this;
            synchronized (terminalEventRegistration) {
                this.receivedEvents.addLast(new Integer(n));
                this.notify();
            }
        }

        synchronized void listenerRemoved() {
            this.isListenerRemoved = true;
            this.close();
        }
    }
}

