/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.serialport;

import com.sun.wbem.solarisprovider.serialport.SerialPortData;
import com.sun.wbem.solarisprovider.serialport.SerialPortException;
import com.sun.wbem.solarisprovider.serialport.Solaris_SerialNative;
import com.sun.wbem.solarisprovider.serialport.TokenString;
import com.sun.wbem.utility.log.LogUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;

public class SerialPortInfo {
    public static final String DEFAULT_PMADM_PATH = "/usr/sbin/pmadm";
    public static final String DEFAULT_SACADM_PATH = "/usr/sbin/sacadm";
    public static final String DEFAULT_TTYADM_PATH = "/usr/sbin/ttyadm";
    public static final String DEFAULT_DEVTERM_DIR = "/dev/term";
    public static final String DEFAULT_ARCHITECTURE = "sparc";
    public static final String DEFAULT_TTYDEFS_FILE = "/etc/ttydefs";
    public static final String PROVIDER_NAME = "SerialPort";
    private static final int PM_NOTEXIST = 0;
    private static final int PM_ENABLED = 1;
    private static final int PM_DISABLED = 2;
    private static final int PM_STARTING = 3;
    private static final int PM_FAILED = 4;
    private String pmadm_path = "/usr/sbin/pmadm";
    private String sacadm_path = "/usr/sbin/sacadm";
    private String ttyadm_path = "/usr/sbin/ttyadm";
    private String devterm_dir = "/dev/term";
    private String alternate_device_dirs = null;
    private String architecture = "sparc";
    private String ttydefs_file = "/etc/ttydefs";
    Hashtable allPortData = new Hashtable();
    Vector dataObjectVector = new Vector();
    LogUtil logUtil = null;

    public SerialPortInfo(LogUtil logUtil) {
        this.logUtil = logUtil;
    }

    private int checkForPortmon(String string) throws SerialPortException {
        String string2 = String.valueOf(this.sacadm_path) + " -l -t ttymon";
        Vector vector = null;
        String[] stringArray = new String[4];
        try {
            stringArray[0] = this.sacadm_path;
            stringArray[1] = "-l";
            stringArray[2] = "-t";
            stringArray[3] = "ttymon";
            vector = this.runCommand(stringArray);
        }
        catch (Exception exception) {
            try {
                String string3 = String.valueOf(stringArray[0]) + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3];
                String[] stringArray2 = new String[]{string3, "ttymon"};
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5064", "LM_5065", stringArray2, "", false, 0, 2);
            }
            catch (Exception exception2) {}
            throw new SerialPortException("EXM_PORTMONERR_SRV");
        }
        if (vector == null || vector.size() == 0) {
            return -1;
        }
        String string4 = (String)vector.elementAt(0);
        if (string4.compareTo("Error") == 0) {
            return -1;
        }
        int n = 1;
        while (n < vector.size()) {
            String string5 = (String)vector.elementAt(n);
            int n2 = string5.indexOf(string);
            if (n2 >= 0) {
                n2 = string5.indexOf("ENABLED");
                if (n2 > 0) {
                    return 1;
                }
                n2 = string5.indexOf("DISABLED");
                if (n2 > 0) {
                    return 2;
                }
                n2 = string5.indexOf("STARTING");
                if (n2 > 0) {
                    return 3;
                }
                n2 = string5.indexOf("FAILED");
                if (n2 > 0) {
                    return 4;
                }
                return -1;
            }
            ++n;
        }
        return -1;
    }

    private void constructData(Vector vector, Vector vector2) {
        String string = null;
        File file = null;
        int n = 0;
        while (n < vector.size()) {
            int n2 = 0;
            String string2 = (String)vector.elementAt(n);
            if (string2 != null && string2.length() > 0) {
                String[] stringArray;
                int n3 = 0;
                while (vector2 != null && n3 < vector2.size()) {
                    String string3 = (String)vector2.elementAt(n3);
                    if (string3 != null && string3.length() > 0) {
                        block15: {
                            try {
                                file = new File(string2);
                            }
                            catch (Exception exception) {
                                try {
                                    stringArray = new String[]{string2};
                                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5004", "LM_5005", stringArray, "", false, 0, 1);
                                }
                                catch (Exception exception2) {}
                                n2 = -1;
                                break;
                            }
                            try {
                                if (file != null && file.exists()) break block15;
                                try {
                                    stringArray = new String[]{string2};
                                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5004", "LM_5005", stringArray, "", false, 0, 1);
                                }
                                catch (Exception exception) {}
                                n2 = -1;
                            }
                            catch (Exception exception) {
                                try {
                                    stringArray = new String[]{string2};
                                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5004", "LM_5005", stringArray, "", false, 0, 1);
                                }
                                catch (Exception exception3) {}
                                n2 = -1;
                            }
                            break;
                        }
                        n2 = this.parseAdmString(string2, string3);
                        if (n2 > 0) break;
                    }
                    ++n3;
                }
                if (n2 != -1 && n2 == 0) {
                    int n4 = string2.lastIndexOf("/");
                    string = n4 >= 0 ? string2.substring(n4 + 1) : string2;
                    stringArray = new SerialPortData(string);
                    stringArray.setDefaults(string);
                    stringArray.setDeleted();
                    stringArray.setDeviceName(string2);
                    this.dataObjectVector.addElement(stringArray);
                    this.allPortData.put(string, stringArray);
                }
            }
            ++n;
        }
    }

    private void fillData(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.allPortData.put(((SerialPortData)vector.elementAt(n)).getPortName(), (SerialPortData)vector.elementAt(n));
            ++n;
        }
    }

    public String getDescription(String string) {
        SerialPortData serialPortData = (SerialPortData)this.allPortData.get(string);
        return serialPortData.getComment();
    }

    public SerialPortData getPortData(int n) throws SerialPortException {
        SerialPortData serialPortData = null;
        serialPortData = (SerialPortData)this.dataObjectVector.elementAt(n);
        if (serialPortData == null) {
            throw new SerialPortException("Null data");
        }
        return serialPortData;
    }

    public SerialPortData getPortData(String string) throws SerialPortException {
        SerialPortData serialPortData = null;
        serialPortData = (SerialPortData)this.allPortData.get(string);
        if (serialPortData == null) {
            throw new SerialPortException("Null data");
        }
        return serialPortData;
    }

    public String getPortMonTag(String string) {
        SerialPortData serialPortData = (SerialPortData)this.allPortData.get(string);
        return serialPortData.getPortMonTag();
    }

    public String getPortName(int n) {
        if (this.dataObjectVector.size() > 0) {
            SerialPortData serialPortData = (SerialPortData)this.dataObjectVector.elementAt(n);
            return serialPortData.getPortName();
        }
        return null;
    }

    public String getServiceTag(String string) {
        SerialPortData serialPortData = (SerialPortData)this.allPortData.get(string);
        return serialPortData.getServiceTag();
    }

    public int getnumPorts() {
        return this.dataObjectVector.size();
    }

    public int initData() throws SerialPortException {
        Vector vector = null;
        Vector vector2 = null;
        if (this.dataObjectVector.size() > 0) {
            this.dataObjectVector.removeAllElements();
        }
        if (!this.allPortData.isEmpty()) {
            this.allPortData.clear();
        }
        if ((vector = this.readDirs()) == null) {
            try {
                String string = this.logUtil.getMessage("LM_LABEL_SERIAL_DEV_DIR");
                String string2 = String.valueOf(string) + ": " + this.devterm_dir + "\n" + this.logUtil.getMessage("LM_LABEL_SERIAL_ALT_DEV_DIR") + ": " + this.alternate_device_dirs;
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5002", "LM_5003", null, string2, false, 0, 0);
            }
            catch (Exception exception) {}
            throw new SerialPortException("EXM_NODEV_SRV");
        }
        vector2 = this.listSerialDevices();
        this.constructData(vector, vector2);
        return this.dataObjectVector.size();
    }

    private Vector listSerialDevices() throws SerialPortException {
        String string;
        String string2 = String.valueOf(this.pmadm_path) + " -L -t ttymon";
        Vector<String> vector = new Vector<String>();
        Process process = null;
        Runtime runtime = null;
        InputStream inputStream = null;
        runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(string2);
        }
        catch (IOException iOException) {
            try {
                String string3 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                String string4 = String.valueOf(string3) + ": " + string2;
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5023", "LM_5024", null, string4, true, 0, 2);
            }
            catch (Exception exception) {}
            throw new SerialPortException("EXM_IO_SRV");
        }
        catch (SecurityException securityException) {
            try {
                String string5 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                String string6 = String.valueOf(string5) + ": " + string2;
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5006", "LM_5007", null, string6, true, 0, 2);
            }
            catch (Exception exception) {}
            throw new SerialPortException("EXM_SEC_SRV");
        }
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            inputStream = process.getInputStream();
            while ((n = inputStream.read()) > 0) {
                stringBuffer.append((char)n);
                ++n2;
            }
        }
        catch (IOException iOException) {}
        if (n2 == 0) {
            InputStream inputStream2 = null;
            StringBuffer stringBuffer2 = new StringBuffer();
            try {
                inputStream2 = process.getErrorStream();
                while ((n = inputStream.read()) > 0) {
                    stringBuffer2.append((char)n);
                    ++n2;
                }
            }
            catch (IOException iOException) {}
            if (n2 == 0) {
                try {
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5008", "LM_5009", null, "", false, 0, 2);
                }
                catch (Exception exception) {}
                return null;
            }
            String string7 = new String(stringBuffer2);
            return null;
        }
        String string8 = new String(stringBuffer);
        n2 = string8.indexOf("\n");
        int n3 = 0;
        int n4 = 0;
        while (n2 != -1) {
            n4 = n2;
            string = string8.substring(n3, n4);
            if (string.length() > 0) {
                vector.addElement(string);
            }
            if ((n3 = n4 + 1) >= string8.length()) break;
            n2 = string8.indexOf("\n", n3);
        }
        if (n3 < string8.length() && (string = string8.substring(n3)).length() > 0) {
            vector.addElement(string);
        }
        return vector;
    }

    private int parseAdmString(String string, String string2) {
        String string3;
        String string4;
        String[] stringArray;
        block12: {
            if (string2.indexOf(String.valueOf(string) + ":") < 0) {
                return 0;
            }
            stringArray = new String[20];
            int n = 0;
            while (n < 20) {
                stringArray[n] = "";
                ++n;
            }
            int n2 = string.lastIndexOf("/");
            string4 = n2 >= 0 ? string.substring(n2 + 1) : string;
            int n3 = 0;
            String string5 = TokenString.getToken(string2, ":");
            while (string5 != null && n3 < 20) {
                int n4;
                stringArray[n3] = string5;
                string5 = TokenString.getToken(null, ":");
                if (string5 != null && (n4 = stringArray[n3].lastIndexOf("\\")) > 0 && n4 == stringArray[n3].length() - 1) {
                    String string6 = stringArray[n3].substring(0, n4);
                    stringArray[n3] = string6 = string6.concat(":");
                    int n5 = n3;
                    stringArray[n5] = String.valueOf(stringArray[n5]) + string5;
                    string5 = TokenString.getToken(null, ":");
                }
                ++n3;
            }
            if (string5 != null && n3 >= 20) {
                try {
                    String[] stringArray2 = new String[]{string2};
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5054", "LM_5014", stringArray2, "", true, 0, 2);
                }
                catch (Exception exception) {}
                return 0;
            }
            if (stringArray[8] != null && stringArray[8].length() != 0) {
                try {
                    if (Solaris_SerialNative.doStat(stringArray[8]) >= 0) break block12;
                    try {
                        String[] stringArray3 = new String[]{stringArray[8]};
                        this.logUtil.writeLog(PROVIDER_NAME, "LM_5013", "LM_5014", stringArray3, "", true, 0, 2);
                    }
                    catch (Exception exception) {}
                    return 0;
                }
                catch (Exception exception) {}
            }
        }
        stringArray[19] = stringArray[19] != null && stringArray[19].length() > 1 ? (string3 = stringArray[19].substring(1)) : "";
        SerialPortData serialPortData = new SerialPortData(string4);
        serialPortData.fillData(stringArray);
        this.dataObjectVector.addElement(serialPortData);
        this.allPortData.put(string4, serialPortData);
        return 1;
    }

    private Vector parseDirString(String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        int n = 0;
        if (string == null || string.length() == 0) {
            return null;
        }
        string2 = TokenString.getToken(string, ":");
        while (string2 != null) {
            vector.addElement(string2);
            ++n;
            string2 = TokenString.getToken(null, ":");
        }
        if (n == 0) {
            return null;
        }
        return vector;
    }

    private Vector readDirs() throws SerialPortException {
        Object object;
        String[] stringArray;
        int n = 0;
        Vector vector = this.parseDirString(this.alternate_device_dirs);
        Vector<Object> vector2 = new Vector<Object>();
        boolean bl = false;
        File file = null;
        try {
            file = new File(this.devterm_dir);
        }
        catch (SecurityException securityException) {
            try {
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5006", "LM_5012", null, "", false, 0, 1);
            }
            catch (Exception exception) {}
            bl = true;
        }
        try {
            if (file.exists() && file.isDirectory() && (stringArray = file.list()) != null && stringArray.length > 0) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    object = String.valueOf(this.devterm_dir) + File.separator + stringArray[n2];
                    vector2.addElement(object);
                    ++n;
                    ++n2;
                }
            }
        }
        catch (SecurityException securityException) {
            try {
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5006", "LM_5012", null, "", false, 0, 1);
            }
            catch (Exception exception) {}
            stringArray = new String[]{this.devterm_dir};
            bl = true;
        }
        if (vector != null && vector.size() > 0) {
            int n3 = 0;
            while (n3 < vector.size()) {
                try {
                    String[] stringArray2;
                    String string = (String)vector.elementAt(n3);
                    object = new File(string);
                    if (((File)object).exists() && ((File)object).isDirectory() && (stringArray2 = ((File)object).list()) != null && stringArray2.length > 0) {
                        int n4 = 0;
                        while (n4 < stringArray2.length) {
                            String string2 = String.valueOf(string) + File.separator + stringArray2[n3];
                            vector2.addElement(string2);
                            ++n;
                            ++n4;
                        }
                    }
                }
                catch (SecurityException securityException) {
                    try {
                        this.logUtil.writeLog(PROVIDER_NAME, "LM_5006", "LM_5012", null, "", false, 0, 1);
                    }
                    catch (Exception exception) {}
                    bl = true;
                }
                ++n3;
            }
        }
        if (n == 0 && bl) {
            throw new SerialPortException("EXM_SEC_SRV");
        }
        if (n == 0) {
            return null;
        }
        return vector2;
    }

    private Vector runCommand(String[] stringArray) throws SerialPortException {
        String string;
        Vector<String> vector = new Vector<String>();
        Process process = null;
        Runtime runtime = null;
        InputStream inputStream = null;
        runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(stringArray);
        }
        catch (IOException iOException) {
            throw new SerialPortException("");
        }
        catch (SecurityException securityException) {
            throw new SerialPortException("EXM_SEC_SRV");
        }
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            inputStream = process.getInputStream();
            while ((n = inputStream.read()) > 0) {
                stringBuffer.append((char)n);
                ++n2;
            }
        }
        catch (IOException iOException) {}
        if (n2 == 0) {
            String string2;
            InputStream inputStream2 = null;
            StringBuffer stringBuffer2 = new StringBuffer();
            try {
                inputStream2 = process.getErrorStream();
                while ((n = inputStream2.read()) > 0) {
                    stringBuffer2.append((char)n);
                    ++n2;
                }
            }
            catch (IOException iOException) {
                throw new SerialPortException("");
            }
            if (n2 == 0) {
                vector.addElement("Success");
                return vector;
            }
            String string3 = new String(stringBuffer2);
            n2 = string3.indexOf("\n");
            int n3 = 0;
            int n4 = 0;
            vector.addElement("Error");
            while (n2 != -1) {
                n4 = n2;
                string2 = string3.substring(n3, n4);
                if (string2.length() > 0) {
                    vector.addElement(string2);
                }
                if ((n3 = n4 + 1) >= string3.length()) break;
                n2 = string3.indexOf("\n", n3);
            }
            if (n3 < string3.length() && (string2 = string3.substring(n3)).length() > 0) {
                vector.addElement(string2);
            }
            return vector;
        }
        String string4 = new String(stringBuffer);
        vector.addElement("Success");
        n2 = string4.indexOf("\n");
        int n5 = 0;
        int n6 = 0;
        while (n2 != -1) {
            n6 = n2;
            string = string4.substring(n5, n6);
            if (string.length() > 0) {
                vector.addElement(string);
            }
            if ((n5 = n6 + 1) >= string4.length()) break;
            n2 = string4.indexOf("\n", n5);
        }
        if (n5 < string4.length() && (string = string4.substring(n5)).length() > 0) {
            vector.addElement(string);
        }
        return vector;
    }

    public synchronized Vector synchronizedDeletePort(String string) throws SerialPortException {
        SerialPortData serialPortData = (SerialPortData)this.allPortData.get(string);
        String string2 = serialPortData.getPortMonTag();
        String string3 = serialPortData.getServiceTag();
        Vector vector = null;
        if (string2 != null && string3 != null) {
            String[] stringArray;
            String string4;
            Object object;
            String string5 = String.valueOf(this.pmadm_path) + " -r -p " + string2 + " -s " + string3;
            try {
                object = new String[]{this.pmadm_path, "-r", "-p", string2, "-s", string3};
                vector = this.runCommand((String[])object);
            }
            catch (Exception exception) {
                try {
                    String string6 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    String[] stringArray2 = new String[]{string};
                    String string7 = String.valueOf(string6) + ": " + string5;
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5015", "LM_5016", stringArray2, string7, false, 0, 2);
                }
                catch (Exception exception2) {}
                throw new SerialPortException("EXM_DEL_SRV", string);
            }
            if (vector != null && vector.size() > 1) {
                try {
                    object = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    String[] stringArray3 = new String[]{string, (String)vector.elementAt(1)};
                    String string8 = String.valueOf(object) + ": " + string5;
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5015", "LM_5017", stringArray3, string8, false, 0, 2);
                }
                catch (Exception exception) {}
                throw new SerialPortException("EXM_DEL_SRV", string);
            }
            serialPortData.setDefaults(string);
            int n = 0;
            while (n < this.dataObjectVector.size()) {
                string4 = null;
                stringArray = (String[])this.dataObjectVector.elementAt(n);
                string4 = stringArray.getPortName();
                if (string4 != null && string4.compareTo(string) == 0) {
                    stringArray.setDefaults(string);
                    stringArray.setDeviceName(serialPortData.getDeviceName());
                    stringArray.setNoService();
                    stringArray.setDeleted();
                    this.dataObjectVector.setElementAt(stringArray, n);
                    this.allPortData.put(string, stringArray);
                    break;
                }
                ++n;
            }
            try {
                string4 = this.logUtil.getMessage("LM_LABEL_SERIAL_PORTMONTAG");
                stringArray = new String[]{string};
                String string9 = String.valueOf(string4) + ": " + string2 + "\n" + this.logUtil.getMessage("LM_LABEL_SERIAL_SERVICETAG") + ": " + string3;
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5019", "LM_5020", stringArray, string9, false, 0, 0);
            }
            catch (Exception exception) {}
            return this.dataObjectVector;
        }
        try {
            String[] stringArray = new String[]{string};
            this.logUtil.writeLog(PROVIDER_NAME, "LM_5015", "LM_5018", stringArray, "", false, 0, 2);
        }
        catch (Exception exception) {}
        throw new SerialPortException("EXM_DELNODATA_SRV", string);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public synchronized void synchronizedSetPortInfo(String var1_1, SerialPortData var2_2, boolean var3_3) throws SerialPortException {
        block66: {
            block65: {
                if (var2_2 == null) {
                    throw new SerialPortException("EXM_NULL_DATA_SRV");
                }
                var4_4 = false;
                var5_5 = "";
                var6_6 = var2_2.getDeviceName();
                try {
                    if (Solaris_SerialNative.isConsole(var6_6) <= 0) break block65;
                    try {
                        var7_7 = new String[]{var6_6};
                        this.logUtil.writeLog("SerialPort", "LM_5028", "LM_5029", var7_7, "", false, 0, 1);
                    }
                    catch (Exception v0) {}
                    throw new SerialPortException("EXM_CONSOLE_SRV", var6_6);
                }
                catch (Exception v1) {}
            }
            if (!var2_2.isEnableSet() && !var3_3) {
                var7_8 = new String[6];
                var8_11 = String.valueOf(this.pmadm_path) + " -d -p " + var2_2.getPortMonTag() + "  -s " + var2_2.getServiceTag();
                var7_8[0] = this.pmadm_path;
                var7_8[1] = "-d";
                var7_8[2] = "-p";
                var7_8[3] = var2_2.getPortMonTag();
                var7_8[4] = "-s";
                var7_8[5] = var2_2.getServiceTag();
                var9_13 = null;
                try {
                    var9_13 = this.runCommand(var7_8);
                }
                catch (Exception v2) {
                    try {
                        var10_15 = new String[]{var2_2.getPortName()};
                        var11_19 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                        this.logUtil.writeLog("SerialPort", "LM_5056", "LM_5057", var10_15, String.valueOf(var11_19) + ": " + var8_11, true, 0, 2);
                    }
                    catch (Exception v3) {}
                    throw new SerialPortException("EXM_CMD_FAIL_SRV", var8_11);
                }
                if (var9_13 != null && var9_13.size() > 0) {
                    var10_16 = (String)var9_13.elementAt(0);
                    if (var10_16.compareTo("Error") == 0) {
                        try {
                            var11_20 = new String[]{var2_2.getPortName()};
                            var12_27 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                            var13_33 = String.valueOf(var12_27) + ": " + var8_11;
                            var14_40 = 1;
                            while (var14_40 < var9_13.size()) {
                                var13_33 = String.valueOf(var13_33) + " " + (String)var9_13.elementAt(var14_40);
                                ++var14_40;
                            }
                            this.logUtil.writeLog("SerialPort", "LM_5056", "LM_5057", var11_20, var13_33, true, 0, 2);
                        }
                        catch (Exception v4) {}
                        throw new SerialPortException("EXM_CMD_FAIL_SRV", var8_11);
                    }
                    try {
                        var11_21 = new String[]{var2_2.getPortName()};
                        var12_28 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                        var13_34 = String.valueOf(var12_28) + ": " + var8_11;
                        this.logUtil.writeLog("SerialPort", "LM_5058", "LM_5059", var11_21, var13_34, false, 0, 0);
                    }
                    catch (Exception v5) {}
                } else {
                    try {
                        var10_17 = new String[]{var2_2.getPortName()};
                        var11_22 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                        this.logUtil.writeLog("SerialPort", "LM_5056", "LM_5057", var10_17, String.valueOf(var11_22) + ": " + var8_11, true, 0, 2);
                    }
                    catch (Exception v6) {}
                    throw new SerialPortException("EXM_CMD_FAIL_SRV", var8_11);
                }
                return;
            }
            try {
                switch (this.checkForPortmon(var2_2.getPortMonTag())) {
                    case -1: {
                        var7_9 /* !! */  = "1";
                        try {
                            var8_12 = new String[]{this.ttyadm_path, "-V"};
                            var9_14 = this.runCommand(var8_12);
                            if (var9_14 != null && var9_14.size() > 0 && (var10_18 = (String)var9_14.elementAt(0)).compareTo("Success") == 0) {
                                var11_23 = 1;
                                while (var11_23 < var9_14.size()) {
                                    var7_9 /* !! */  = (String)var9_14.elementAt(var11_23);
                                    ++var11_23;
                                }
                            }
                        }
                        catch (SerialPortException v7) {}
                        var8_12 = String.valueOf(this.sacadm_path) + " -a -n 2 -p " + var2_2.getPortMonTag() + "\t-t ttymon -c /usr/lib/saf/ttymon -v " + (String)var7_9 /* !! */  + " -y \"Serial Ports\"";
                        try {
                            var9_14 = new String[]{this.sacadm_path, "-a", "-n", "2", "-p", var2_2.getPortMonTag(), "-t", "ttymon", "-c", "/usr/lib/saf/ttymon", "-v", var7_9 /* !! */ , "-y", "\"Serial Ports\""};
                            var10_18 = this.runCommand(var9_14);
                            if (var10_18 == null || var10_18.size() <= 0) break;
                            var11_24 = (String)var10_18.elementAt(0);
                            if (var11_24.compareTo("Error") != 0) ** GOTO lbl112
                            var12_29 = new String[]{var1_1};
                            try {
                                var13_35 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                                var14_41 = String.valueOf(var13_35) + ": " + (String)var8_12;
                                var15_47 = 1;
                                while (var15_47 < var10_18.size()) {
                                    var14_41 = String.valueOf(var14_41) + " " + (String)var10_18.elementAt(var15_47);
                                    ++var15_47;
                                }
                                this.logUtil.writeLog("SerialPort", "LM_5030", "LM_5031", var12_29, var14_41, true, 0, 2);
                            }
                            catch (Exception v8) {}
                            var4_4 = true;
                            var5_5 = var8_12;
                            break;
lbl112:
                            // 1 sources

                            var12_30 = new String[]{var1_1};
                            try {
                                var13_36 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                                var14_42 = String.valueOf(var13_36) + ": " + (String)var8_12;
                                var15_48 = 1;
                                while (var15_48 < var10_18.size()) {
                                    var14_42 = String.valueOf(var14_42) + " " + (String)var10_18.elementAt(var15_48);
                                    ++var15_48;
                                }
                                this.logUtil.writeLog("SerialPort", "LM_5032", "LM_5033", var12_30, var14_42, false, 0, 0);
                            }
                            catch (Exception v9) {
                            }
                        }
                        catch (SerialPortException v10) {
                            var4_4 = true;
                            var5_5 = var8_12;
                        }
                        break;
                    }
                    case 2: {
                        var9_14 = String.valueOf(this.sacadm_path) + " -e -p " + var2_2.getPortMonTag();
                        try {
                            var10_18 = new String[]{this.sacadm_path, "-e", "-p", var2_2.getPortMonTag()};
                            var11_25 = this.runCommand((String[])var10_18);
                            if (var11_25 == null || var11_25.size() <= 0) break;
                            var12_31 = (String)var11_25.elementAt(0);
                            if (var12_31.compareTo("Error") != 0) ** GOTO lbl153
                            var13_37 = new String[]{var1_1};
                            try {
                                var14_43 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                                var15_49 = String.valueOf(var14_43) + ": " + (String)var9_14;
                                var16_53 = 1;
                                while (var16_53 < var11_25.size()) {
                                    var15_49 = String.valueOf(var15_49) + " " + (String)var11_25.elementAt(var16_53);
                                    ++var16_53;
                                }
                                this.logUtil.writeLog("SerialPort", "LM_5034", "LM_5035", var13_37, var15_49, true, 0, 2);
                            }
                            catch (Exception v11) {}
                            var4_4 = true;
                            break;
lbl153:
                            // 1 sources

                            var13_38 = new String[]{var1_1};
                            try {
                                var14_44 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                                var15_50 = String.valueOf(var14_44) + ": " + (String)var9_14;
                                var16_54 = 1;
                                while (var16_54 < var11_25.size()) {
                                    var15_50 = String.valueOf(var15_50) + " " + (String)var11_25.elementAt(var16_54);
                                    ++var16_54;
                                }
                                this.logUtil.writeLog("SerialPort", "LM_5036", "LM_5037", var13_38, var15_50, false, 0, 0);
                            }
                            catch (Exception v12) {
                            }
                        }
                        catch (SerialPortException v13) {
                            var4_4 = true;
                            var5_5 = var9_14;
                        }
                        break;
                    }
                    case 4: {
                        var10_18 = String.valueOf(this.sacadm_path) + " -s -p " + var2_2.getPortMonTag();
                        try {
                            var11_26 = new String[]{this.sacadm_path, "-s", "-p", var2_2.getPortMonTag()};
                            var12_32 = this.runCommand(var11_26);
                            if (var12_32 == null || var12_32.size() <= 0) break;
                            var13_39 = (String)var12_32.elementAt(0);
                            if (var13_39.compareTo("Error") != 0) ** GOTO lbl194
                            var14_45 = new String[]{var1_1};
                            try {
                                var15_51 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                                var16_55 = String.valueOf(var15_51) + ": " + (String)var10_18;
                                var17_57 = 1;
                                while (var17_57 < var12_32.size()) {
                                    var16_55 = String.valueOf(var16_55) + " " + (String)var12_32.elementAt(var17_57);
                                    ++var17_57;
                                }
                                this.logUtil.writeLog("SerialPort", "LM_5038", "LM_5039", var14_45, var16_55, true, 0, 2);
                            }
                            catch (Exception v14) {}
                            var4_4 = true;
                            break;
lbl194:
                            // 1 sources

                            var14_46 = new String[]{var1_1};
                            try {
                                var15_52 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                                var16_56 = String.valueOf(var15_52) + ": " + (String)var10_18;
                                var17_58 = 1;
                                while (var17_58 < var12_32.size()) {
                                    var16_56 = String.valueOf(var16_56) + " " + (String)var12_32.elementAt(var17_58);
                                    ++var17_58;
                                }
                                this.logUtil.writeLog("SerialPort", "LM_5040", "LM_5041", var14_46, var16_56, false, 0, 0);
                            }
                            catch (Exception v15) {
                            }
                        }
                        catch (SerialPortException v16) {
                            var4_4 = true;
                            var5_5 = var10_18;
                        }
                        break;
                    }
                    default: {
                        if (!var4_4) break block66;
                    }
                }
            }
            catch (SerialPortException v17) {
                var7_9 /* !! */  = new String[]{var1_1};
                try {
                    this.logUtil.writeLog("SerialPort", "LM_5042", "LM_5043", var7_9 /* !! */ , "", true, 0, 2);
                }
                catch (Exception v18) {}
            }
            if (!var4_4) break block66;
            throw new SerialPortException("EXM_SACADM_ERR_SRV", (Object)var5_5);
        }
        this.turn_on_port(var2_2, var3_3);
        var7_10 = -1;
        var7_10 = Solaris_SerialNative.eepromSet(var6_6);
        if (var7_10 < 0) {
            var8_12 = new String[]{var2_2.getDeviceName()};
            try {
                this.logUtil.writeLog("SerialPort", "LM_5060", "LM_5061", var8_12, "", true, 0, 2);
            }
            catch (Exception v19) {}
            throw new SerialPortException("EXM_EEPROM_SRV");
        }
        var8_12 = new String[]{var1_1};
        try {
            var9_14 = this.logUtil.getMessage("LM_LABEL_SERIAL_OLD_DATA");
            var10_18 = (SerialPortData)this.allPortData.get(var1_1);
            this.logUtil.writeLog("SerialPort", "LM_5062", "LM_5063", var8_12, String.valueOf(var9_14) + ": " + var10_18.toString(), false, 0, 0);
        }
        catch (Exception v20) {}
    }

    public String toString(int n) {
        SerialPortData serialPortData = (SerialPortData)this.dataObjectVector.elementAt(n);
        return serialPortData.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void turn_on_port(SerialPortData serialPortData, boolean bl) throws SerialPortException {
        void var12_28;
        String[] stringArray;
        Object object;
        String string;
        String string2;
        Vector vector;
        Object[] objectArray;
        String string3;
        Vector<Object> vector2;
        String string4;
        block55: {
            if (serialPortData.isEnableSet() && !bl) {
                Object object2;
                String string5 = String.valueOf(this.pmadm_path) + "  -e -p " + serialPortData.getPortMonTag() + " -s " + serialPortData.getServiceTag();
                Vector vector3 = null;
                try {
                    object2 = new String[]{this.pmadm_path, "-e", "-p", serialPortData.getPortMonTag(), "-s", serialPortData.getServiceTag()};
                    vector3 = this.runCommand((String[])object2);
                }
                catch (Exception exception) {
                    try {
                        String string6 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                        String[] stringArray2 = new String[]{serialPortData.getPortName()};
                        this.logUtil.writeLog(PROVIDER_NAME, "LM_5044", "LM_5045", stringArray2, String.valueOf(string6) + ": " + string5, true, 0, 2);
                        throw new SerialPortException("EXM_CMD_FAIL_SRV", string5);
                    }
                    catch (Exception exception2) {}
                    throw new SerialPortException("EXM_CMD_FAIL_SRV", string5);
                }
                if (vector3 != null && vector3.size() > 0) {
                    object2 = (String)vector3.elementAt(0);
                    if (((String)object2).compareTo("Error") != 0) return;
                    try {
                        String string7 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                        String[] stringArray3 = new String[]{serialPortData.getPortName()};
                        this.logUtil.writeLog(PROVIDER_NAME, "LM_5044", "LM_5045", stringArray3, String.valueOf(string7) + ": " + string5, true, 0, 2);
                        throw new SerialPortException("EXM_CMD_FAIL_SRV", string5);
                    }
                    catch (Exception exception) {}
                    throw new SerialPortException("EXM_CMD_FAIL_SRV", string5);
                }
                try {
                    object2 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    String[] stringArray4 = new String[]{serialPortData.getPortName()};
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5044", "LM_5045", stringArray4, String.valueOf(object2) + ": " + string5, true, 0, 2);
                    throw new SerialPortException("EXM_CMD_FAIL_SRV", string5);
                }
                catch (Exception exception) {}
                throw new SerialPortException("EXM_CMD_FAIL_SRV", string5);
            }
            if (serialPortData.isEnableSet() && bl) {
                serialPortData.tweakPortFlags();
            }
            if (!serialPortData.isEnableSet() && bl) {
                serialPortData.setDisableFlag();
            }
            int n = -1;
            n = Solaris_SerialNative.checkTTYLabel(serialPortData.getTTYLabel(), this.ttydefs_file);
            if (n < 0) {
                try {
                    String[] stringArray5 = new String[]{serialPortData.getPortName(), serialPortData.getTTYLabel(), this.ttydefs_file};
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5050", "LM_5051", stringArray5, "", true, 0, 1);
                    throw new SerialPortException("EXM_NO_TTYLABEL_SRV", (Object)this.ttydefs_file, serialPortData.getTTYLabel());
                }
                catch (Exception exception) {}
                throw new SerialPortException("EXM_NO_TTYLABEL_SRV", (Object)this.ttydefs_file, serialPortData.getTTYLabel());
            }
            string4 = String.valueOf(this.ttyadm_path) + " -d " + serialPortData.getDeviceName() + " -l " + serialPortData.getTTYLabel() + " -s " + serialPortData.getServiceCmdLine();
            vector2 = new Vector<Object>();
            vector2.addElement(this.ttyadm_path);
            vector2.addElement("-d");
            vector2.addElement(serialPortData.getDeviceName());
            vector2.addElement("-l");
            vector2.addElement(serialPortData.getTTYLabel());
            vector2.addElement("-s");
            vector2.addElement(serialPortData.getServiceCmdLine());
            String string8 = serialPortData.getTTYFlags();
            if (string8 != null && string8.length() > 0) {
                if (string8.indexOf("b") >= 0) {
                    string4 = String.valueOf(string4) + " -b ";
                    vector2.addElement("-b");
                }
                if (string8.indexOf("c") >= 0) {
                    string4 = String.valueOf(string4) + " -c ";
                    vector2.addElement("-c");
                }
                if (string8.indexOf("I") >= 0) {
                    string4 = String.valueOf(string4) + " -I ";
                    vector2.addElement("-I");
                }
            }
            if ((string3 = serialPortData.getModules()) != null && string3.length() > 0) {
                string4 = String.valueOf(string4) + " -m " + string3;
                vector2.addElement("-m");
                vector2.addElement(string3);
            }
            if ((string3 = serialPortData.getPrompt()) != null && string3.length() > 0) {
                string4 = String.valueOf(string4) + " -p " + string3;
                vector2.addElement("-p");
                vector2.addElement(string3);
            }
            if ((string3 = serialPortData.getTimeoutVal()) != null && string3.length() > 0) {
                string4 = String.valueOf(string4) + " -t " + string3;
                vector2.addElement("-t");
                vector2.addElement(string3);
            }
            if ((string3 = serialPortData.getSoftwareCarrier()) != null && string3.length() > 0) {
                string4 = String.valueOf(string4) + " -S " + string3;
                vector2.addElement("-S");
                vector2.addElement(string3);
            }
            if ((string3 = serialPortData.getTerminalType()) != null && string3.length() > 0) {
                string4 = String.valueOf(string4) + " -T " + string3;
                vector2.addElement("-T");
                vector2.addElement(string3);
            }
            objectArray = new String[vector2.size()];
            vector2.copyInto(objectArray);
            vector = null;
            string2 = "";
            try {
                vector = this.runCommand((String[])objectArray);
                break block55;
            }
            catch (SerialPortException serialPortException) {
                try {
                    String string9 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    String[] stringArray6 = new String[]{serialPortData.getPortName()};
                    String string10 = String.valueOf(string9) + ": " + string4;
                    int n2 = 1;
                    while (n2 < vector.size()) {
                        string10 = String.valueOf(string10) + " " + (String)vector.elementAt(n2);
                        ++n2;
                    }
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5052", "LM_5053", stringArray6, string10, true, 0, 2);
                    throw new SerialPortException("EXM_SACADM_ERR_SRV", string4);
                }
                catch (Exception exception) {}
            }
            throw new SerialPortException("EXM_SACADM_ERR_SRV", string4);
        }
        if (vector != null && vector.size() > 0) {
            string = (String)vector.elementAt(0);
            if (string.compareTo("Error") == 0) {
                try {
                    String string11 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    String[] stringArray7 = new String[]{serialPortData.getPortName()};
                    String string12 = String.valueOf(string11) + ": " + string4;
                    int n = 1;
                    while (n < vector.size()) {
                        string12 = String.valueOf(string12) + " " + (String)vector.elementAt(n);
                        ++n;
                    }
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5052", "LM_5053", stringArray7, string12, true, 0, 2);
                    throw new SerialPortException("EXM_SACADM_ERR_SRV", string4);
                }
                catch (Exception exception) {}
                throw new SerialPortException("EXM_SACADM_ERR_SRV", string4);
            }
            if (vector.size() > 1) {
                string2 = (String)vector.elementAt(1);
            }
        } else {
            try {
                String string13 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                String[] stringArray8 = new String[]{serialPortData.getPortName()};
                String string14 = String.valueOf(string13) + ": " + string4;
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5052", "LM_5053", stringArray8, string14, true, 0, 2);
                throw new SerialPortException("EXM_SACADM_ERR_SRV", string4);
            }
            catch (Exception exception) {}
            throw new SerialPortException("EXM_SACADM_ERR_SRV", string4);
        }
        string3 = serialPortData.getOldPortMonTag();
        if (string3 != null && string3.length() > 0 && (string = serialPortData.getOldServiceTag()) != null && string.length() > 0) {
            String[] stringArray9 = new String[]{this.pmadm_path, "-r", "-p", string3, "-s", string};
            this.runCommand(stringArray9);
        }
        string = String.valueOf(this.pmadm_path) + " -a " + " -p " + serialPortData.getPortMonTag() + " -s " + serialPortData.getServiceTag() + " -i " + serialPortData.getIdentity();
        vector2 = new Vector();
        vector2.addElement(this.pmadm_path);
        vector2.addElement("-a");
        vector2.addElement("-p");
        vector2.addElement(serialPortData.getPortMonTag());
        vector2.addElement("-s");
        vector2.addElement(serialPortData.getServiceTag());
        vector2.addElement("-i");
        vector2.addElement(serialPortData.getIdentity());
        String string15 = "1";
        try {
            object = new String[]{this.ttyadm_path, "-V"};
            vector = this.runCommand((String[])object);
            if (vector != null && vector.size() > 0 && (stringArray = (String[])vector.elementAt(0)).compareTo("Success") == 0) {
                int n = 1;
                while (n < vector.size()) {
                    String string16 = (String)vector.elementAt(n);
                    ++n;
                }
            }
        }
        catch (SerialPortException serialPortException) {}
        string = String.valueOf(string) + " -v " + (String)var12_28;
        vector2.addElement("-v");
        vector2.addElement(var12_28);
        string3 = serialPortData.getPortFlags();
        if (string3 != null && string3.length() > 0) {
            string = String.valueOf(string) + " -f " + string3;
            vector2.addElement("-f");
            vector2.addElement(string3);
        }
        string = String.valueOf(string) + " -m \"" + string2 + "\"";
        vector2.addElement("-m");
        vector2.addElement(string2);
        string3 = serialPortData.getComment();
        if (string3 != null && string3.length() > 0) {
            string = String.valueOf(string) + " -y " + string3;
            vector2.addElement("-y");
            vector2.addElement(string3);
        }
        objectArray = new String[vector2.size()];
        vector2.copyInto(objectArray);
        try {
            vector = this.runCommand((String[])objectArray);
        }
        catch (SerialPortException serialPortException) {
            try {
                object = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                stringArray = new String[]{serialPortData.getPortName()};
                String string17 = String.valueOf(object) + ": " + string;
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5054", "LM_5055", stringArray, string17, true, 0, 2);
                throw new SerialPortException("EXM_SACADM_ERR_SRV", string);
            }
            catch (Exception exception) {}
            throw new SerialPortException("EXM_SACADM_ERR_SRV", string);
        }
        if (vector != null && vector.size() > 0) {
            object = (String)vector.elementAt(0);
            if (((String)object).compareTo("Error") != 0) return;
            try {
                stringArray = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                String[] stringArray10 = new String[]{serialPortData.getPortName()};
                String string18 = String.valueOf(stringArray) + ": " + string;
                int n = 1;
                while (n < vector.size()) {
                    string18 = String.valueOf(string18) + " " + (String)vector.elementAt(n);
                    ++n;
                }
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5054", "LM_5055", stringArray10, string18, true, 0, 2);
                throw new SerialPortException("EXM_SACADM_ERR_SRV", string);
            }
            catch (Exception exception) {}
            throw new SerialPortException("EXM_SACADM_ERR_SRV", string);
        }
        try {
            object = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
            stringArray = new String[]{serialPortData.getPortName()};
            String string19 = String.valueOf(object) + ": " + string;
            this.logUtil.writeLog(PROVIDER_NAME, "LM_5054", "LM_5055", stringArray, string19, true, 0, 2);
            throw new SerialPortException("EXM_SACADM_ERR_SRV", string);
        }
        catch (Exception exception) {}
        throw new SerialPortException("EXM_SACADM_ERR_SRV", string);
    }
}

