/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.diskmgr.client.Content;
import com.sun.admin.diskmgr.client.CreateFSDialog;
import com.sun.admin.diskmgr.client.NoSolarisPanel;
import com.sun.admin.diskmgr.client.SlicePropDialog;
import com.sun.admin.diskmgr.client.SliceWizard;
import com.sun.admin.diskmgr.client.TreeNodeData;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.DiskData;
import com.sun.admin.diskmgr.common.DiskMgrException;
import com.sun.admin.diskmgr.common.SliceData;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VBusyPanel;
import com.sun.management.viper.console.gui.VFrame;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class DiskContent
extends Content {
    public static final String SLICE_COLUMN = "sliceListSlice";
    public static final String USAGE_COLUMN = "sliceListUsage";
    public static final String SIZE_COLUMN = "sliceListSize";
    public static final String CYLRANGE_COLUMN = "sliceListCylRange";
    public static final String FS_COLUMN = "sliceListFS";
    private ResourceBundle bundle;
    private final Object[][] columnHeaderConfig = new Object[][]{{"sliceListUsage", new Integer(16)}, {"sliceListSize", new Integer(20016)}, {"sliceListCylRange", new Integer(10016)}, {"sliceListFS", new Integer(16)}};
    private static String[][] columnHeaders = null;

    public DiskContent(VDiskMgr vDiskMgr) {
        super(vDiskMgr);
        this.sortPreferenceKey = String.valueOf(this.getClass().getName()) + ".sortPreference";
        this.bundle = vDiskMgr.getResourceBundle();
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)vDiskMgr.getSliceMenuBar());
        this.rootNode.setToolBar((JToolBar)vDiskMgr.getSliceToolBar());
    }

    public void clear() {
        this.theApp.setInfoBar("");
        this.clearSelection();
        this.getDataCache().removeAllElements();
        System.gc();
        this.theApp.getTree().removeAllSlices();
        this.rootNode = new VScopeNode();
        this.rootNode.setColumnHeaders(this.getColumnHeaders());
        this.rootNode.setMenuBar((JMenuBar)this.theApp.getSliceMenuBar());
        this.rootNode.setToolBar((JToolBar)this.theApp.getSliceToolBar());
        this.treeNode.setInternalRoot(this.rootNode);
        this.bRefresh = true;
    }

    public void createFS() {
        VScopeNode vScopeNode = this.getSelectedNode();
        if (vScopeNode == null) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                DiskContent.this.theApp.waitOn();
                SliceData sliceData = (SliceData)DiskContent.this.getSelectedNode().getPayload();
                VFrame vFrame = new VFrame();
                CreateFSDialog createFSDialog = new CreateFSDialog(DiskContent.this.theApp, sliceData);
                createFSDialog.setContainer((Component)vFrame);
                vFrame.showCenter((Component)DiskContent.this.theApp.getProperties().getPropertyObject("vconsole.frame"));
                createFSDialog.setVisible(true);
                DiskContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public void formatSelected() {
        VScopeNode vScopeNode = this.theApp.getTree().getCurrentNode();
        if (vScopeNode == null) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                DiskContent.this.theApp.waitOn();
                VScopeNode vScopeNode = DiskContent.this.theApp.getTree().getCurrentNode();
                TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
                DiskData diskData = treeNodeData.getDiskData();
                VFrame vFrame = new VFrame();
                SliceWizard sliceWizard = new SliceWizard(DiskContent.this.theApp, diskData);
                sliceWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)DiskContent.this.theApp.getProperties().getPropertyObject("vconsole.frame"));
                sliceWizard.start();
                DiskContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public String[][] getColumnHeaders() {
        if (columnHeaders == null) {
            columnHeaders = this.constructColumnHeaders(this.columnHeaderConfig);
        }
        return columnHeaders;
    }

    public static Hashtable getColumnValues(ResourceBundle resourceBundle, SliceData sliceData) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = columnHeaders[0][0];
        String string2 = sliceData.getTagAsString();
        if (string2 == null) {
            string2 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"unknown");
        }
        hashtable.put(string, string2);
        string = columnHeaders[1][0];
        String string3 = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"Megabytes");
        string2 = Content.formatSuffix(sliceData.getSize(), string3);
        hashtable.put(string, string2);
        string = columnHeaders[2][0];
        hashtable.put(string, sliceData.getCylRange());
        string = columnHeaders[3][0];
        if (sliceData.getFS()) {
            hashtable.put(string, ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"Yes"));
        } else {
            hashtable.put(string, ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"No"));
        }
        return hashtable;
    }

    public String getSortAttribute() {
        return null;
    }

    public void openSelected() {
        Vector vector = this.getSelected();
        if (vector.isEmpty()) {
            return;
        }
        VScopeNode vScopeNode = (VScopeNode)vector.elementAt(0);
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this.theApp, "vconsole.scopeselected", (Object)vScopeNode);
        this.theApp.fireConsoleAction(vConsoleEvent);
    }

    public void refresh() {
        Object object;
        this.vDataCache.removeAllElements();
        System.gc();
        this.clear();
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"FetchSlicesTitle");
        this.treeNode.setResultPane((Component)new VBusyPanel(string));
        this.theApp.fireConsoleAction(new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode));
        this.theApp.setStatusBar(string);
        try {
            object = this.theApp.getTree().getCurrentNode();
            TreeNodeData treeNodeData = (TreeNodeData)object.getPayload();
            DiskData diskData = treeNodeData.getDiskData();
            DiskData diskData2 = this.theApp.getDiskMgr().getDisk(null, diskData);
            treeNodeData.setDiskData(diskData2);
            if (!diskData2.hasSolarisPartitions()) {
                NoSolarisPanel noSolarisPanel = new NoSolarisPanel(this.theApp, diskData2);
                ActionListener actionListener = noSolarisPanel.getListener();
                VFrame vFrame = new VFrame();
                WarningDialog warningDialog = new WarningDialog((JFrame)vFrame, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"no_solaris_title"), (JPanel)noSolarisPanel, actionListener, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"continueBtn"));
                this.bRefresh = false;
                return;
            }
            this.theApp.getTree().appendToResultsPane();
        }
        catch (DiskMgrException diskMgrException) {
            this.theApp.reportErrorException((Exception)((Object)diskMgrException));
        }
        object = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"FetchSlicesDone");
        this.treeNode.setResultPane(null);
        this.theApp.fireConsoleAction(new VConsoleEvent((Object)this.theApp, "vconsole.updatescope", (Object)this.treeNode));
        this.theApp.setStatusBar((String)object);
        this.bRefresh = true;
    }

    public void setDefaultColumnHeader() {
        this.properties.setProperty("vconsole.defaultcolumnheader", ResourceStrings.getString((ResourceBundle)this.theApp.getResourceBundle(), (String)SLICE_COLUMN));
    }

    public void updateInfoBar() {
        this.bundle = this.theApp.getResourceBundle();
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SliceListContents");
        Object[] objectArray = new Object[]{new Integer(this.getDataCache().size())};
        String string2 = MessageFormat.format(string, objectArray);
        this.theApp.setInfoBar(string2);
    }

    public void viewProperties() {
        VScopeNode vScopeNode = this.getSelectedNode();
        if (vScopeNode == null) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                DiskContent.this.theApp.waitOn();
                SliceData sliceData = (SliceData)DiskContent.this.getSelectedNode().getPayload();
                VFrame vFrame = new VFrame();
                SlicePropDialog slicePropDialog = new SlicePropDialog(DiskContent.this.theApp, sliceData);
                slicePropDialog.setContainer((Component)vFrame);
                vFrame.showCenter((Component)DiskContent.this.theApp.getProperties().getPropertyObject("vconsole.frame"));
                slicePropDialog.setVisible(true);
                DiskContent.this.theApp.waitOff();
            }
        };
        thread.start();
    }

    public String whatAmI() {
        return "slices";
    }
}

