/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.config;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.console.config.BGImageNode;
import com.sun.management.viperimpl.console.config.VBaseNode;
import com.sun.management.viperimpl.console.config.VConfigurationNode;
import com.sun.xml.tree.NodeEx;
import com.sun.xml.tree.ParseContext;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ToolBoxNode
extends VBaseNode
implements VConfigurationNode {
    protected Locale locale;
    protected Properties properties;
    protected String information;
    protected int SLOT_INFORMATION;

    public ToolBoxNode() {
        this.setTag("ToolBox");
        this.SLOT_NAME = 0;
        this.SLOT_DESCRIPTION = 1;
        this.SLOT_INFORMATION = 2;
        this.SLOT_BGIMAGE = 3;
        this.SLOT_ICON = 4;
        this.SLOT_LARGEICON = 5;
        this.SLOT_SCOPE = 6;
        this.slots = new Node[7];
    }

    public void doneChild(NodeEx nodeEx, ParseContext parseContext) throws SAXException {
        super.doneChild(nodeEx, parseContext);
        String string = nodeEx.getNodeName();
        Node node = nodeEx.getFirstChild();
        String string2 = null;
        if (node != null) {
            string2 = node.getNodeValue();
        }
        try {
            if (string.equals("Name")) {
                this.name = string2;
                this.slots[this.SLOT_NAME] = nodeEx;
            } else if (string.equals("Information")) {
                this.information = string2;
                this.slots[this.SLOT_INFORMATION] = nodeEx;
            } else if (string.equals("Description")) {
                this.description = string2;
                this.slots[this.SLOT_DESCRIPTION] = nodeEx;
            } else if (string.equals("Scope")) {
                this.scope = string2;
                this.slots[this.SLOT_SCOPE] = nodeEx;
            } else if (string.equals("Icon")) {
                this.smallIcon = string2;
                this.slots[this.SLOT_ICON] = nodeEx;
            } else if (string.equals("LargeIcon")) {
                this.largeIcon = string2;
                this.slots[this.SLOT_LARGEICON] = nodeEx;
            } else if (string.equals("BackgroundImage")) {
                this.bgImage = ((BGImageNode)nodeEx).getURL();
                this.bgImageLoc = ((BGImageNode)nodeEx).getLocation();
                this.slots[this.SLOT_BGIMAGE] = nodeEx;
            }
        }
        catch (Exception exception) {
            Debug.trace((String)"Configuration", (int)Debug.WARNING, (String)"Configuration error", (Throwable)exception);
        }
    }

    public String getInformation() {
        return this.information;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Properties getProperties() {
        return null;
    }

    public String getType() {
        return null;
    }

    public URL getURL() {
        return null;
    }

    protected void printNode(int n) {
        super.printNode(n);
        String string = this.indent(n + 1);
        System.out.println(String.valueOf(string) + "Description: " + this.description);
        System.out.println(String.valueOf(string) + "Small Icon: " + this.smallIcon);
        System.out.println(String.valueOf(string) + "Large Icon: " + this.largeIcon);
        System.out.print(String.valueOf(string) + "Known Scopes: ");
        Enumeration enumeration = this.getConfiguration().enumerateScopes();
        while (enumeration != null && enumeration.hasMoreElements()) {
            System.out.print(enumeration.nextElement());
            if (!enumeration.hasMoreElements()) continue;
            System.out.print(", ");
        }
        System.out.println("");
    }

    public void setInformation(String string) {
        this.information = string;
        if (string != null && string.length() > 0) {
            this.setTaggedNode("Information", string, this.SLOT_INFORMATION);
        } else if (this.slots[this.SLOT_INFORMATION] != null) {
            this.removeChild(this.slots[this.SLOT_INFORMATION]);
            this.slots[this.SLOT_INFORMATION] = null;
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setProperties(Properties properties) {
    }

    public void setType(String string) {
    }

    public void setURL(String string) {
    }

    public void startParse(ParseContext parseContext) throws SAXException {
        super.startParse(parseContext);
        NamedNodeMap namedNodeMap = this.getAttributes();
        if (namedNodeMap == null) {
            return;
        }
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            String string = namedNodeMap.item(n).getNodeName();
            String string2 = namedNodeMap.item(n).getNodeValue();
            if (string.equals("Locale")) {
                int n2 = string2.indexOf("_");
                this.locale = new Locale(string2.substring(0, n2), string2.substring(n2 + 1));
            }
            ++n;
        }
    }
}

