/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahout;

import COM.odi.ClassInfo;
import COM.odi.GenericObject;
import COM.odi.IPersistent;
import COM.odi.ObjectStore;
import COM.odi.imp.ObjectReference;
import com.sun.jini.mahout.StorableObjectClassInfo;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;

public class StorableObject
implements Serializable,
IPersistent {
    private MarshalledObject bytes;
    private transient Object obj;
    private static final boolean DEBUG = false;
    private static final long serialVersionUID = -3793675220968988873L;
    private transient ObjectReference ODIref;
    public transient byte ODIObjectState;
    static ClassInfo myOdiClassInfoInstance = ClassInfo.register((ClassInfo)new StorableObjectClassInfo());

    public StorableObject(Object object) throws RemoteException {
        try {
            this.bytes = new MarshalledObject(object);
            this.obj = object;
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (IOException iOException) {
            StorableObject.fatalError("can't encode object", iOException);
        }
    }

    public boolean equals(Object object) {
        try {
            if (object instanceof StorableObject) {
                return this.get().equals(((StorableObject)object).get());
            }
            return this.get().equals(object);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private static void fatalError(String string, Throwable throwable) throws RemoteException {
        System.err.println(string);
        if (throwable != null) {
            throwable.printStackTrace(System.err);
        }
        throw new RemoteException(string, throwable);
    }

    public Object get() throws RemoteException {
        try {
            if (this.ODIObjectState < 0) {
                ObjectStore.fetch((IPersistent)this);
            }
            if (this.obj == null) {
                StorableObject storableObject;
                if (((storableObject = this).ODIObjectState & 2) != 0) {
                    storableObject = storableObject;
                    ObjectStore.dirty((IPersistent)storableObject);
                }
                storableObject.obj = this.bytes.get();
            }
            return this.obj;
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (IOException iOException) {
            StorableObject.fatalError("can't decode object", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            StorableObject.fatalError("can't decode object", classNotFoundException);
        }
        StorableObject.fatalError("how did we get here?", null);
        return null;
    }

    public int hashCode() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this.bytes.hashCode();
    }

    public ObjectReference ODIgetRef() {
        return this.ODIref;
    }

    public void ODIsetRef(ObjectReference objectReference) {
        this.ODIref = objectReference;
    }

    public byte ODIgetState() {
        return this.ODIObjectState;
    }

    public void ODIsetState(byte by) {
        this.ODIObjectState = by;
    }

    public void preDestroyPersistent() {
    }

    public void postInitializeContents() {
    }

    public void preFlushContents() {
    }

    public void preClearContents() {
    }

    protected synchronized Object clone() throws CloneNotSupportedException {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        ((StorableObject)super.clone()).ODIref = null;
        ((StorableObject)super.clone()).ODIObjectState = 0;
        return (StorableObject)super.clone();
    }

    public void initializeContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        this.bytes = (MarshalledObject)genericObject.getClassField(1, classInfo);
    }

    public void flushContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        genericObject.setClassField(1, (Object)this.bytes, classInfo);
    }

    public void clearContents() {
        this.bytes = null;
    }

    public StorableObject(ClassInfo classInfo) {
    }
}

