/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.bridge.ExistsException;
import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.DhcpmgrApplet;
import com.sun.dhcpmgr.client.ErrorTable;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.common.ExportController;
import com.sun.dhcpmgr.common.Exporter;
import com.sun.dhcpmgr.data.ActionError;
import com.sun.dhcpmgr.data.Macro;
import com.sun.dhcpmgr.data.Network;
import com.sun.dhcpmgr.data.Option;
import com.sun.dhcpmgr.ui.FieldLayout;
import com.sun.dhcpmgr.ui.ListPair;
import com.sun.dhcpmgr.ui.NoSpaceField;
import com.sun.dhcpmgr.ui.ProgressManager;
import com.sun.dhcpmgr.ui.Wizard;
import com.sun.dhcpmgr.ui.WizardStep;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ExportWizard
extends Wizard {
    private Network[] networks = new Network[0];
    private String[] macroNames = new String[0];
    private String[] optionNames = new String[0];
    private boolean deleteData = false;
    private String exportPath = "";

    public ExportWizard(Frame frame) {
        super(frame, "");
        this.setTitle(ResourceStrings.getString("export_wiz_title"));
        this.addStep(new NetworkStep());
        this.addStep(new MacroStep());
        this.addStep(new OptionStep());
        this.addStep(new FileStep());
        this.addStep(new ReviewStep());
        this.showFirstStep();
    }

    public void doFinish() {
        final Runnable runnable = new Runnable(){

            public void run() {
                ExportWizard.this.reallyFinish();
            }
        };
        Exporter exporter = new Exporter(){
            ProgressManager progress;
            String[] errObjs = new String[]{ResourceStrings.getString("exp_error_occurred"), ""};

            public void displayError(String string) {
                this.errObjs[1] = string;
                try {
                    SwingUtilities.invokeAndWait(new ErrorDisplay(this.errObjs));
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }

            public void displayErrors(String string, String string2, ActionError[] actionErrorArray) {
                ErrorTable errorTable = new ErrorTable(string2);
                errorTable.setErrors(actionErrorArray);
                JScrollPane jScrollPane = new JScrollPane(errorTable);
                Object[] objectArray = new Object[]{string, jScrollPane};
                try {
                    SwingUtilities.invokeAndWait(new WarningDisplay(objectArray));
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }

            public void initializeProgress(int n) {
                this.progress = new ProgressManager(ExportWizard.this, ResourceStrings.getString("exp_progress_title"), "", 0, n);
            }

            public void updateProgress(int n, String string) throws InterruptedException {
                this.progress.update(n, string);
            }
        };
        final ExportController exportController = new ExportController(exporter, DataManager.get().getServer());
        exportController.setUser(System.getProperty("user.name"));
        exportController.setFile(this.exportPath);
        exportController.setOptions(this.optionNames);
        exportController.setMacros(this.macroNames);
        exportController.setNetworks(this.networks);
        Thread thread = new Thread(){

            public void run() {
                OverwritePrompter overwritePrompter = new OverwritePrompter();
                while (true) {
                    try {
                        if (exportController.exportData(deleteData, overwritePrompter.overwrite)) {
                            SwingUtilities.invokeLater(runnable);
                        }
                        return;
                    }
                    catch (ExistsException existsException) {
                        try {
                            SwingUtilities.invokeAndWait(overwritePrompter);
                            if (overwritePrompter.overwrite) continue;
                            return;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            return;
                        }
                    }
                    break;
                }
            }
        };
        thread.start();
    }

    public void doHelp() {
        DhcpmgrApplet.showHelp("export_wizard");
    }

    protected void reallyFinish() {
        super.doFinish();
    }

    class NetworkStep
    implements WizardStep {
        Box stepBox = Box.createVerticalBox();
        ListPair networkLists;

        public NetworkStep() {
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("exp_wiz_net_explain"), 9, 45));
            this.stepBox.add(Box.createVerticalStrut(10));
            try {
                this.networkLists = new ListPair(ResourceStrings.getString("exp_wiz_dont_export"), DataManager.get().getNetworks(false), ResourceStrings.getString("exp_wiz_export"), ExportWizard.this.networks);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.stepBox.add(this.networkLists);
            this.stepBox.add(Box.createVerticalGlue());
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public String getDescription() {
            return ResourceStrings.getString("exp_wiz_net_desc");
        }

        public void setActive(int n) {
            ExportWizard.this.setForwardEnabled(true);
        }

        public boolean setInactive(int n) {
            ExportWizard.this.networks = (Network[])this.networkLists.getRightContents(new Network[0]);
            return true;
        }
    }

    class MacroStep
    implements WizardStep {
        Box stepBox = Box.createVerticalBox();
        ListPair macroLists;

        public MacroStep() {
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("exp_wiz_macros_explain"), 4, 45));
            this.stepBox.add(Box.createVerticalStrut(10));
            try {
                Macro[] macroArray = DataManager.get().getMacros(false);
                ExportWizard.this.macroNames = new String[macroArray.length];
                int n = 0;
                while (n < macroArray.length) {
                    ((ExportWizard)ExportWizard.this).macroNames[n] = macroArray[n].getKey();
                    ++n;
                }
                this.macroLists = new ListPair(ResourceStrings.getString("exp_wiz_dont_export"), ExportWizard.this.macroNames, ResourceStrings.getString("exp_wiz_export"), null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.stepBox.add(this.macroLists);
            this.stepBox.add(Box.createVerticalGlue());
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public String getDescription() {
            return ResourceStrings.getString("exp_wiz_macro_desc");
        }

        public void setActive(int n) {
            ExportWizard.this.setForwardEnabled(true);
        }

        public boolean setInactive(int n) {
            ExportWizard.this.macroNames = (String[])this.macroLists.getRightContents(new String[0]);
            return true;
        }
    }

    class OptionStep
    implements WizardStep {
        Box stepBox = Box.createVerticalBox();
        ListPair optionLists;

        public OptionStep() {
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("exp_wiz_options_explain"), 4, 45));
            this.stepBox.add(Box.createVerticalStrut(10));
            try {
                Option[] optionArray = DataManager.get().getOptions(false);
                ExportWizard.this.optionNames = new String[optionArray.length];
                int n = 0;
                while (n < optionArray.length) {
                    ((ExportWizard)ExportWizard.this).optionNames[n] = optionArray[n].getKey();
                    ++n;
                }
                this.optionLists = new ListPair(ResourceStrings.getString("exp_wiz_dont_export"), ExportWizard.this.optionNames, ResourceStrings.getString("exp_wiz_export"), null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.stepBox.add(this.optionLists);
            this.stepBox.add(Box.createVerticalGlue());
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public String getDescription() {
            return ResourceStrings.getString("exp_wiz_option_desc");
        }

        public void setActive(int n) {
            ExportWizard.this.setForwardEnabled(true);
        }

        public boolean setInactive(int n) {
            ExportWizard.this.optionNames = (String[])this.optionLists.getRightContents(new String[0]);
            return true;
        }
    }

    class FileStep
    implements WizardStep {
        JPanel stepPanel;
        NoSpaceField pathField;
        JCheckBox deleteBox;

        public FileStep() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.5;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            this.stepPanel = new JPanel(gridBagLayout);
            Component component = Wizard.createTextArea(ResourceStrings.getString("exp_wiz_file_explain"), 4, 45);
            gridBagLayout.setConstraints(component, gridBagConstraints);
            this.stepPanel.add(component);
            JLabel jLabel = new JLabel(ResourceStrings.getString("exp_wiz_file_label"));
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weighty = 0.0;
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.stepPanel.add(jLabel);
            this.pathField = new NoSpaceField(ExportWizard.this.exportPath);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.pathField, gridBagConstraints);
            this.stepPanel.add(this.pathField);
            component = Box.createVerticalStrut(10);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(component, gridBagConstraints);
            this.stepPanel.add(component);
            component = Wizard.createTextArea(ResourceStrings.getString("exp_wiz_delete_explain"), 4, 45);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.5;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(component, gridBagConstraints);
            this.stepPanel.add(component);
            this.deleteBox = new JCheckBox(ResourceStrings.getString("exp_wiz_delete_exported"), false);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.deleteBox, gridBagConstraints);
            this.stepPanel.add(this.deleteBox);
            component = Box.createVerticalGlue();
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(component, gridBagConstraints);
            this.stepPanel.add(component);
            this.pathField.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ FileStep this$1;
                {
                    this.this$1 = fileStep;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    FileStep.access$0(this.this$1).setForwardEnabled(this.this$1.pathField.getText().length() != 0);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }
            });
        }

        static /* synthetic */ ExportWizard access$0(FileStep fileStep) {
            return fileStep.ExportWizard.this;
        }

        public Component getComponent() {
            return this.stepPanel;
        }

        public String getDescription() {
            return ResourceStrings.getString("exp_wiz_file_desc");
        }

        public void setActive(int n) {
            this.pathField.setText(ExportWizard.this.exportPath);
            this.deleteBox.setSelected(ExportWizard.this.deleteData);
        }

        public boolean setInactive(int n) {
            ExportWizard.this.exportPath = this.pathField.getText();
            ExportWizard.this.deleteData = this.deleteBox.isSelected();
            return true;
        }
    }

    class ReviewStep
    implements WizardStep {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JList networkList;
        JList macroList;
        JList optionList;
        JLabel exportLabel;
        JLabel deleteLabel;

        public ReviewStep() {
            this.mainPanel.add((Component)Wizard.createTextArea(ResourceStrings.getString("exp_wiz_review_explain"), 6, 45), "North");
            JPanel jPanel = new JPanel(new FieldLayout());
            jPanel.add((Component)new JLabel(ResourceStrings.getString("exp_wiz_review_nets")), "LabelTop");
            this.networkList = new JList();
            JScrollPane jScrollPane = new JScrollPane(this.networkList);
            jPanel.add((Component)jScrollPane, "Field");
            jPanel.add((Component)new JLabel(ResourceStrings.getString("exp_wiz_review_macros")), "LabelTop");
            this.macroList = new JList();
            jScrollPane = new JScrollPane(this.macroList);
            jPanel.add((Component)jScrollPane, "Field");
            jPanel.add((Component)new JLabel(ResourceStrings.getString("exp_wiz_review_options")), "LabelTop");
            this.optionList = new JList();
            jScrollPane = new JScrollPane(this.optionList);
            jPanel.add((Component)jScrollPane, "Field");
            jPanel.add((Component)new JLabel(ResourceStrings.getString("exp_wiz_file_label")), "Label");
            this.exportLabel = new JLabel();
            this.exportLabel.setForeground(Color.black);
            jPanel.add((Component)this.exportLabel, "Field");
            jPanel.add((Component)new JLabel(ResourceStrings.getString("exp_wiz_delete_label")), "Label");
            this.deleteLabel = new JLabel();
            this.deleteLabel.setForeground(Color.black);
            jPanel.add((Component)this.deleteLabel, "Field");
            this.mainPanel.add((Component)jPanel, "Center");
        }

        public Component getComponent() {
            return this.mainPanel;
        }

        public String getDescription() {
            return ResourceStrings.getString("exp_wiz_review_desc");
        }

        public void setActive(int n) {
            this.networkList.setListData(ExportWizard.this.networks);
            this.macroList.setListData(ExportWizard.this.macroNames);
            this.optionList.setListData(ExportWizard.this.optionNames);
            this.exportLabel.setText(ExportWizard.this.exportPath);
            if (ExportWizard.this.deleteData) {
                this.deleteLabel.setText(ResourceStrings.getString("yes"));
            } else {
                this.deleteLabel.setText(ResourceStrings.getString("no"));
            }
            ExportWizard.this.setFinishEnabled(true);
        }

        public boolean setInactive(int n) {
            return true;
        }
    }

    class ErrorDisplay
    implements Runnable {
        Object[] objs;

        public ErrorDisplay(Object[] objectArray) {
            this.objs = objectArray;
        }

        public void run() {
            JOptionPane.showMessageDialog(ExportWizard.this, this.objs, ResourceStrings.getString("server_error_title"), 0);
        }
    }

    class WarningDisplay
    implements Runnable {
        Object[] objs;

        public WarningDisplay(Object[] objectArray) {
            this.objs = objectArray;
        }

        public void run() {
            JOptionPane.showMessageDialog(ExportWizard.this, this.objs, ResourceStrings.getString("server_warning_title"), 2);
        }
    }

    class OverwritePrompter
    implements Runnable {
        public boolean overwrite = false;

        public void run() {
            int n = JOptionPane.showConfirmDialog(ExportWizard.this, ResourceStrings.getString("exp_overwrite"), ResourceStrings.getString("exp_overwrite_title"), 0, 3);
            this.overwrite = n == 0;
        }
    }
}

