/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.util;

import com.sun.prodreg.core.ComponentDescription;
import com.sun.prodreg.core.ComponentDescriptionLookup;
import com.sun.prodreg.core.ComponentReference;
import com.sun.prodreg.core.ComponentType;
import com.sun.prodreg.util.Localizer;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class Utils
implements Serializable {
    public static Vector alphaCache(Vector vector) {
        Object object;
        Cloneable cloneable;
        Vector<Object> vector2 = new Vector<Object>();
        Vector<Object> vector3 = new Vector<Object>();
        Vector vector4 = new Vector();
        Hashtable<Object, Cloneable> hashtable = new Hashtable<Object, Cloneable>();
        int n = 0;
        while (n < vector.size()) {
            cloneable = (ComponentDescription)vector.elementAt(n);
            object = Utils.getDisplayName((ComponentDescription)cloneable);
            ComponentReference[] componentReferenceArray = ((ComponentDescription)cloneable).getChildren();
            if (componentReferenceArray != null && componentReferenceArray.length > 0) {
                vector3.addElement(object);
            } else {
                vector2.addElement(object);
            }
            hashtable.put(object, cloneable);
            ++n;
        }
        cloneable = Utils.alphabetize(vector3);
        object = Utils.alphabetize(vector2);
        int n2 = 0;
        while (n2 < ((Vector)cloneable).size()) {
            vector4.addElement(hashtable.get((String)((Vector)cloneable).elementAt(n2)));
            ++n2;
        }
        int n3 = 0;
        while (n3 < ((Vector)object).size()) {
            vector4.addElement(hashtable.get((String)((Vector)object).elementAt(n3)));
            ++n3;
        }
        return vector4;
    }

    public static Vector alphabetize(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)vector.elementAt(n2);
            int n3 = vector2.size();
            boolean bl = false;
            int n4 = 0;
            while (n4 < n3) {
                String string2 = (String)vector2.elementAt(n4);
                if (string.compareTo(string2) <= 0) {
                    vector2.insertElementAt(string, n4);
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                vector2.addElement(string);
            }
            ++n2;
        }
        return vector2;
    }

    public static String arrayToString(String[] stringArray) {
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            string = String.valueOf(string) + " " + stringArray[n];
            ++n;
        }
        string = string.trim();
        return string;
    }

    public static Vector getDescriptionStrings(ComponentDescription componentDescription) {
        Object object;
        Vector vector;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Vector vector2;
        String string;
        Object object6;
        String[] stringArray;
        if (componentDescription == null) {
            return new Vector();
        }
        Vector<Object> vector3 = new Vector<Object>();
        String string2 = componentDescription.getUniqueName();
        if (string2 != null) {
            vector3.addElement(Localizer.resolve("<L ProdRegResources.UniqueName>: " + string2));
        }
        if ((stringArray = componentDescription.getDisplayLanguages()) != null) {
            object6 = Localizer.resolve("<L ProdRegResources.SupportedLangs>: ");
            vector3.addElement(object6);
            int n = 0;
            while (n < stringArray.length) {
                vector3.addElement("   " + stringArray[n]);
                ++n;
            }
        }
        if ((object6 = componentDescription.getComponentType()) != null) {
            String string3 = "";
            string3 = ((ComponentType)object6).equals(ComponentType.product) ? Localizer.resolve("<L ProdRegResources.Product>") : (((ComponentType)object6).equals(ComponentType.feature) ? Localizer.resolve("<L ProdRegResources.Feature>") : (((ComponentType)object6).equals(ComponentType.component) ? Localizer.resolve("<L ProdRegResources.Component>") : Localizer.resolve("<L ProdRegResources.Unknown>")));
            vector3.addElement(Localizer.resolve("<L ProdRegResources.CompType>: " + string3));
        }
        if ((string = componentDescription.getUninstaller()) != null) {
            vector3.addElement(Localizer.resolve("<L ProdRegResources.Uninstaller>: " + string));
        }
        if ((vector2 = componentDescription.getRequiredComponents()) != null) {
            vector3.addElement(Localizer.resolve("<L ProdRegResources.Required>"));
            int n = 0;
            while (n < vector2.size()) {
                object5 = (ComponentReference)vector2.elementAt(n);
                object4 = ((ComponentReference)object5).getID();
                object3 = ComponentDescriptionLookup.get((String)object4);
                if (object3 != null) {
                    vector3.addElement("    " + Utils.getDisplayName((ComponentDescription)object3));
                } else {
                    object2 = Localizer.resolve("<L ProdRegResources.MissingReq>");
                    vector3.addElement(String.valueOf(object2) + ": " + (String)object4);
                }
                ++n;
            }
        }
        if ((vector = componentDescription.getDependentComponents()) != null) {
            vector3.addElement(Localizer.resolve("<L ProdRegResources.Dependent>"));
            int n = 0;
            while (n < vector.size()) {
                object4 = (ComponentReference)vector.elementAt(n);
                object3 = ((ComponentReference)object4).getID();
                object2 = ComponentDescriptionLookup.get((String)object3);
                if (object2 != null) {
                    vector3.addElement("    " + Utils.getDisplayName((ComponentDescription)object2));
                } else {
                    object = Localizer.resolve("<L ProdRegResources.MissingDep>");
                    vector3.addElement(String.valueOf(object) + ": " + (String)object3);
                }
                ++n;
            }
        }
        if ((object5 = componentDescription.getCompatibleVersions()) != null) {
            object4 = Localizer.resolve("<L ProdRegResources.CompatVersions>: ");
            if (object5 != null) {
                int n = 0;
                while (n < ((Object)object5).length) {
                    object4 = String.valueOf(object4) + (String)object5[n];
                    if (n != stringArray.length - 1) {
                        object4 = String.valueOf(object4) + ", ";
                    }
                    ++n;
                }
            }
            vector3.addElement(object4);
        }
        if ((object4 = componentDescription.getData()) != null) {
            Vector vector4 = new Vector();
            object2 = ((Hashtable)object4).keys();
            while (object2.hasMoreElements()) {
                vector4.addElement(object2.nextElement());
            }
            object = Utils.alphabetize(vector4);
            int n = 0;
            while (n < ((Vector)object).size()) {
                String string4 = (String)((Vector)object).elementAt(n);
                String string5 = (String)((Hashtable)object4).get(string4);
                vector3.addElement(String.valueOf(string4) + ": " + string5);
                ++n;
            }
        }
        return vector3;
    }

    public static String getDisplayName(ComponentDescription componentDescription) {
        String string = componentDescription.getDisplayName(Utils.getLocaleName());
        if (string == null) {
            string = componentDescription.getDisplayName("en");
        }
        if (string == null) {
            string = componentDescription.getUniqueName();
        }
        string = Utils.trunc(string, 50);
        return string.trim();
    }

    public static String[] getInstalledPkgs(String[] stringArray) {
        Object[] objectArray;
        String string = System.getProperty("prodreg.pkgroot");
        Vector<Object[]> vector = new Vector<Object[]>();
        if (string == null) {
            string = "";
        }
        int n = 0;
        while (n < stringArray.length) {
            objectArray = stringArray[n];
            File file = new File(String.valueOf(string) + "/var/sadm/pkg/" + (String)objectArray + "/pkginfo");
            if (file.exists()) {
                vector.add(objectArray);
            }
            ++n;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String getLocaleName() {
        return Localizer.localeName(Locale.getDefault());
    }

    public static boolean hashtablesEqual(Hashtable hashtable, Hashtable hashtable2) {
        if (hashtable == hashtable2) {
            return true;
        }
        if (hashtable == null || hashtable2 == null) {
            return false;
        }
        if (hashtable.size() != hashtable2.size()) {
            return false;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object v;
            Object k = enumeration.nextElement();
            Object v2 = hashtable.get(k);
            if (v2.equals(v = hashtable2.get(k))) continue;
            return false;
        }
        return true;
    }

    public static String[] listPackages(ComponentDescription componentDescription) {
        Object[] objectArray;
        Object object;
        String string = componentDescription.getData("pkgs");
        Vector<Object> vector = new Vector<Object>();
        if (string != null) {
            object = new StringTokenizer(string);
            while (((StringTokenizer)object).hasMoreTokens()) {
                objectArray = ((StringTokenizer)object).nextToken();
                boolean bl = vector.removeElement(objectArray);
                vector.add(objectArray);
            }
        }
        if ((object = componentDescription.getChildren()) != null) {
            int n = 0;
            while (n < ((Object)object).length) {
                String[] stringArray;
                ComponentDescription componentDescription2 = ComponentDescriptionLookup.get(((ComponentReference)object[n]).getID());
                if (componentDescription2 != null && (stringArray = Utils.listPackages(componentDescription2)) != null) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        boolean bl = vector.removeElement(stringArray[n2]);
                        vector.add(stringArray[n2]);
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (vector.isEmpty()) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static boolean objectsEqual(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (!object.getClass().equals(object2.getClass())) {
            return false;
        }
        if (!object.getClass().isArray()) {
            return object.equals(object2);
        }
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = (Object[])object2;
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (!Utils.objectsEqual(objectArray[n], objectArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String trunc(String string, int n) {
        String string2 = string;
        if (string2 != null && string2.length() > n) {
            string2 = String.valueOf(string2.substring(0, n)) + "...";
        }
        return string2;
    }

    public static boolean vectorsEqual(Vector vector, Vector vector2) {
        if (vector == vector2) {
            return true;
        }
        if (vector == null || vector2 == null) {
            return false;
        }
        if (vector.size() != vector2.size()) {
            return false;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (vector2.contains(e)) continue;
            return false;
        }
        return true;
    }
}

