/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.osserver;

import com.sun.wbem.solarisprovider.osserver.DBTableException;
import com.sun.wbem.solarisprovider.osserver.TimezoneObject;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.Vector;

public class TimezoneTable {
    private String table = new String("timezone");
    private String timezoneCol = "timezone";
    private String hostnameCol = "domain";
    private String commentCol = "comment";
    private int timezoneColNum = 0;
    private int hostnameColNum = 0;
    private int commentColNum = 0;
    private String scope;

    public TimezoneTable(String string) throws DirectoryTableException {
        this.scope = string;
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)string);
        TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
        tableDefinitions.loadTableDefinitions("timezone");
        this.timezoneColNum = tableDefinitions.getColumnNumber(this.timezoneCol);
        this.hostnameColNum = tableDefinitions.getColumnNumber(this.hostnameCol);
        this.commentColNum = tableDefinitions.getColumnNumber(this.commentCol);
    }

    public void addTimezoneEntry(TimezoneObject timezoneObject) throws DBTableException, DirectoryTableException {
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        String string = timezoneObject.getHostName();
        String string2 = timezoneObject.getTimezone();
        if (string == null || string.trim().length() == 0 || string2 == null || string2.trim().length() == 0) {
            throw new DBTableException("EXM_ADD_INV", this.table);
        }
        try {
            directoryTable = this.openTimezoneTable();
            directoryRow = this.checkTimezoneEntry(directoryTable, timezoneObject);
            if (directoryRow != null) {
                TimezoneObject timezoneObject2 = this.makeTimezoneObject(directoryRow);
                directoryTable.close();
                if (timezoneObject2.equals(timezoneObject)) {
                    return;
                }
                throw new DBTableException("EXM_ADD_EXIST", this.table);
            }
            directoryRow = this.makeRow(directoryTable, timezoneObject);
            directoryTable.addRow(directoryRow);
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
    }

    private DirectoryRow checkTimezoneEntry(DirectoryTable directoryTable, TimezoneObject timezoneObject) throws DirectoryTableException {
        DirectoryRow directoryRow = null;
        String string = timezoneObject.getHostName();
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        directoryRow = directoryTable.getRowInstance();
        directoryRow.putColumn(this.hostnameColNum, string);
        directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
        return directoryRow;
    }

    public void deleteTimezoneEntry(TimezoneObject timezoneObject) throws DBTableException, DirectoryTableException {
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        String string = timezoneObject.getHostName();
        String string2 = timezoneObject.getTimezone();
        if (string == null || string.trim().length() == 0) {
            throw new DBTableException("EXM_DEL_INV", this.table);
        }
        try {
            directoryTable = this.openTimezoneTable();
            directoryRow = this.checkTimezoneEntry(directoryTable, timezoneObject);
            if (directoryRow == null) {
                directoryTable.close();
                return;
            }
            directoryTable.deleteRow(directoryRow);
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
    }

    public void deleteTimezoneEntry(String string) throws DBTableException, DirectoryTableException {
        TimezoneObject timezoneObject = new TimezoneObject(null, string, null);
        this.deleteTimezoneEntry(timezoneObject);
    }

    private String getInput(String string) {
        System.out.print(string);
        try {
            byte[] byArray = new byte[100];
            char c = (char)System.in.read(byArray);
            if ((char)byArray[c - '\u0001'] == '\n') {
                byArray[c - '\u0001'] = 0;
            }
            String string2 = new String(byArray);
            return string2.trim();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            return new String("");
        }
    }

    public TimezoneObject getTimezoneEntry(TimezoneObject timezoneObject) throws DirectoryTableException {
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        TimezoneObject timezoneObject2 = null;
        try {
            directoryTable = this.openTimezoneTable();
            directoryRow = this.checkTimezoneEntry(directoryTable, timezoneObject);
            if (directoryRow != null) {
                timezoneObject2 = this.makeTimezoneObject(directoryRow);
            }
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
        return timezoneObject2;
    }

    public TimezoneObject getTimezoneEntry(String string) throws DirectoryTableException {
        TimezoneObject timezoneObject = new TimezoneObject(null, string, null);
        return this.getTimezoneEntry(timezoneObject);
    }

    public Vector list() throws DirectoryTableException {
        Vector<TimezoneObject> vector = new Vector<TimezoneObject>();
        DirectoryTable directoryTable = null;
        DirectoryRow directoryRow = null;
        try {
            directoryTable = this.openTimezoneTable();
            directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                vector.addElement(this.makeTimezoneObject(directoryRow));
                directoryRow = directoryTable.getNextRow();
            }
        }
        catch (DirectoryTableException directoryTableException) {
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw directoryTableException;
        }
        directoryTable.close();
        return vector;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        var1_1 = null;
        var2_2 = false;
        try {
            var1_1 = new TimezoneTable("File://poseidon");
            if (true) ** GOTO lbl44
        }
        catch (Exception var3_3) {
            System.out.println("Exception: " + var3_3);
            return;
        }
        do {
            System.out.println("1 - Add timezone entry");
            System.out.println("2 - Delete timezone entry");
            System.out.println("3 - Get timezone entry");
            System.out.println("4 - List timezone table");
            System.out.println("9 - Exit");
            System.out.print("Enter option: ");
            try {
                var3_4 = new byte[100];
                var4_6 = (char)System.in.read(var3_4);
                System.out.println("");
                if (var4_6 != '\u0002') {
                    var2_2 = true;
                    continue;
                }
                var5_7 = (char)var3_4[0];
                switch (var5_7) {
                    case '1': {
                        var1_1.testAdd();
                        break;
                    }
                    case '2': {
                        var1_1.testDelete();
                        break;
                    }
                    case '3': {
                        var1_1.testGet();
                        break;
                    }
                    case '4': {
                        var1_1.testList();
                        break;
                    }
                    default: {
                        var2_2 = true;
                        break;
                    }
                }
            }
            catch (Exception var3_5) {
                System.out.println("Exception: " + var3_5);
            }
            System.out.println("");
lbl44:
            // 3 sources

        } while (!var2_2);
    }

    private DirectoryRow makeRow(DirectoryTable directoryTable, TimezoneObject timezoneObject) throws DirectoryTableException {
        DirectoryRow directoryRow = directoryTable.getRowInstance();
        String string = timezoneObject.getTimezone();
        if (string != null && string.trim().length() != 0) {
            directoryRow.putColumn(this.timezoneColNum, string);
        }
        if ((string = timezoneObject.getHostName()) != null && string.trim().length() != 0) {
            directoryRow.putColumn(this.hostnameColNum, string);
        }
        if ((string = timezoneObject.getComment()) != null && string.trim().length() != 0) {
            directoryRow.putColumn(this.commentColNum, string);
        }
        return directoryRow;
    }

    private TimezoneObject makeTimezoneObject(DirectoryRow directoryRow) throws DirectoryTableException {
        String string = directoryRow.getColumn(this.timezoneColNum);
        String string2 = directoryRow.getColumn(this.hostnameColNum);
        String string3 = directoryRow.getColumn(this.commentColNum);
        TimezoneObject timezoneObject = new TimezoneObject(string, string2, string3);
        return timezoneObject;
    }

    public void modifyTimezoneEntry(TimezoneObject timezoneObject, TimezoneObject timezoneObject2) throws DBTableException, DirectoryTableException {
        this.deleteTimezoneEntry(timezoneObject);
        this.addTimezoneEntry(timezoneObject2);
    }

    public void modifyTimezoneEntry(String string, TimezoneObject timezoneObject) throws DBTableException, DirectoryTableException {
        this.deleteTimezoneEntry(string);
        this.addTimezoneEntry(timezoneObject);
    }

    private DirectoryTable openTimezoneTable() throws DirectoryTableException {
        DirectoryTable directoryTable = null;
        try {
            directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            directoryTable.open(this.table);
            return directoryTable;
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            directoryTable.create(this.table);
            return directoryTable;
        }
        catch (DirectoryTableException directoryTableException) {
            throw directoryTableException;
        }
    }

    private void testAdd() throws Exception {
        System.out.println("****Start testAdd****");
        String string = this.getInput("Timezone: ");
        String string2 = this.getInput("Host/Domain Name: ");
        String string3 = this.getInput("Comment: ");
        TimezoneObject timezoneObject = new TimezoneObject(string, string2, string3);
        this.addTimezoneEntry(timezoneObject);
        System.out.println("****End of test****");
    }

    private void testDelete() throws Exception {
        System.out.println("****Start testDelete****");
        System.out.println("(Only Host/Domain Name required)");
        String string = this.getInput("Timezone: ");
        String string2 = this.getInput("Host/Domain Name: ");
        String string3 = this.getInput("Comment: ");
        TimezoneObject timezoneObject = new TimezoneObject(string, string2, string3);
        this.deleteTimezoneEntry(timezoneObject);
        System.out.println("****End of test****");
    }

    private void testGet() throws Exception {
        System.out.println("****Start testGet****");
        String string = this.getInput("Host/Domain Name: ");
        TimezoneObject timezoneObject = this.getTimezoneEntry(string);
        System.out.println("    Got:\t" + timezoneObject);
        System.out.println("****End of test****");
    }

    private void testList() throws Exception {
        System.out.println("****Start testList****");
        TimezoneObject timezoneObject = null;
        Vector vector = this.list();
        System.out.println("Timezone Table (" + vector.size() + " entries) :::");
        int n = 0;
        while (vector != null && n < vector.size()) {
            timezoneObject = (TimezoneObject)vector.elementAt(n);
            System.out.println(timezoneObject);
            ++n;
        }
        System.out.println("****End of test****");
    }
}

