/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.auths;

import com.sun.wbem.solarisprovider.common.ProviderDirectoryFilter;
import com.sun.wbem.solarisprovider.usermgr.auths.AuthAttrObj;
import com.sun.wbem.solarisprovider.usermgr.auths.AuthAttrTable;
import com.sun.wbem.solarisprovider.usermgr.common.KeyValue;
import com.sun.wbem.utility.directorytable.DirectoryFilter;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.Vector;

public class SolarisAuthAttrTable
implements AuthAttrTable {
    private static final String table = new String("auth_attr");
    private static final String emptyString = new String("");
    private static final String nameCol = "name";
    private static final String res1Col = "res1";
    private static final String res2Col = "res2";
    private static final String shortDescCol = "short_descr";
    private static final String longDescCol = "long_descr";
    private static final String attrCol = "attr";
    private String scope;
    static /* synthetic */ Class array$Ljava$lang$String;

    public SolarisAuthAttrTable(String string) {
        this.scope = string;
        Class[] classArray = new Class[]{};
        Class[] classArray2 = new Class[]{array$Ljava$lang$String != null ? array$Ljava$lang$String : (array$Ljava$lang$String = SolarisAuthAttrTable.class$("[Ljava.lang.String;"))};
        AuthAttrObj authAttrObj = new AuthAttrObj();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void createAuthAttrTable() throws DirectoryTableException {
        DirectoryTable directoryTable = null;
        boolean bl = true;
        try {
            directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            directoryTable.open(table);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            bl = false;
        }
        catch (DirectoryTableException directoryTableException) {
            System.out.println("Error creating auth table: " + directoryTableException.getMessage());
            directoryTable.close();
            throw directoryTableException;
        }
        TableDefinitions tableDefinitions = null;
        try {
            try {
                if (!bl) {
                    tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions(table);
                    directoryTable.create(table);
                }
            }
            catch (DirectoryTableException directoryTableException) {
                System.out.println("Error creating table: " + directoryTableException.getMessage());
                throw directoryTableException;
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
    }

    public AuthAttrObj[] listAuthAttributes() throws DirectoryTableException {
        return this.listAuthAttributes(null);
    }

    public AuthAttrObj[] listAuthAttributes(ProviderDirectoryFilter providerDirectoryFilter) throws DirectoryTableException {
        Vector<AuthAttrObj> vector = new Vector<AuthAttrObj>();
        DirectoryTable directoryTable = this.openAuthAttrTable();
        DirectoryFilter directoryFilter = null;
        if (providerDirectoryFilter != null) {
            try {
                directoryFilter = providerDirectoryFilter.getDirectoryFilter(directoryTable);
            }
            catch (Exception exception) {
                System.out.println("AuthAttr: error getting filter: " + exception.getMessage());
                throw new DirectoryTableInvalidParameterException("EXM_INVALID");
            }
        }
        try {
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = null;
            directoryRow = directoryFilter != null ? directoryTable.getAll((SearchTemplate)directoryFilter) : directoryTable.getAll();
            if (directoryRow != null) {
                int n = 1;
                while (n <= directoryRow.getNumberOfRows()) {
                    AuthAttrObj authAttrObj = new AuthAttrObj();
                    authAttrObj.setAuthName(directoryRow.getColumn(tableDefinitions.getColumnNumber(nameCol), n));
                    authAttrObj.setShortDesc(directoryRow.getColumn(tableDefinitions.getColumnNumber(shortDescCol), n));
                    authAttrObj.setLongDesc(directoryRow.getColumn(tableDefinitions.getColumnNumber(longDescCol), n));
                    String string = directoryRow.getColumn(tableDefinitions.getColumnNumber(attrCol), n);
                    KeyValue.getAttributes(string, authAttrObj.attrSet);
                    vector.addElement(authAttrObj);
                    ++n;
                }
            } else {
                throw new DirectoryTableException("EXM_TABLE_EMPTY", (Object)table);
            }
            Object var7_13 = null;
        }
        catch (Throwable throwable) {
            Object var7_14 = null;
            directoryTable.close();
            throw throwable;
        }
        directoryTable.close();
        Object[] objectArray = new AuthAttrObj[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private DirectoryTable openAuthAttrTable() throws DirectoryTableException {
        DirectoryTableFactory directoryTableFactory = new DirectoryTableFactory();
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
        try {
            directoryTable.open(table);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            throw new DirectoryTableException("EXM_TABLE_EMPTY", (Object)table);
        }
        return directoryTable;
    }

    public AuthAttrObj readAuthAttrObj(String string) throws DirectoryTableException {
        DirectoryTable directoryTable;
        AuthAttrObj authAttrObj;
        block3: {
            authAttrObj = null;
            directoryTable = this.openAuthAttrTable();
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), string);
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow != null) {
                    authAttrObj = new AuthAttrObj(string);
                    authAttrObj.setShortDesc(directoryRow.getColumn(tableDefinitions.getColumnNumber(shortDescCol)));
                    authAttrObj.setLongDesc(directoryRow.getColumn(tableDefinitions.getColumnNumber(longDescCol)));
                    String string2 = directoryRow.getColumn(tableDefinitions.getColumnNumber(attrCol));
                    KeyValue.getAttributes(string2, authAttrObj.attrSet);
                    break block3;
                }
                System.out.println("Attrs for " + string + " do not exist");
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var5_7 = null;
        directoryTable.close();
        return authAttrObj;
    }

    public AuthAttrObj[] readAuthAttrObjList(String string) throws DirectoryTableException {
        Vector<AuthAttrObj> vector = new Vector<AuthAttrObj>();
        DirectoryTable directoryTable = this.openAuthAttrTable();
        try {
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = directoryTable.getAll();
            if (directoryRow == null) {
                throw new DirectoryTableException("EXM_TABLE_EMPTY", (Object)table);
            }
            int n = 1;
            while (n <= directoryRow.getNumberOfRows()) {
                String string2 = directoryRow.getColumn(tableDefinitions.getColumnNumber(nameCol), n);
                if (string2.startsWith(string)) {
                    AuthAttrObj authAttrObj = new AuthAttrObj(string2);
                    authAttrObj.setShortDesc(directoryRow.getColumn(tableDefinitions.getColumnNumber(shortDescCol), n));
                    authAttrObj.setLongDesc(directoryRow.getColumn(tableDefinitions.getColumnNumber(longDescCol), n));
                    String string3 = directoryRow.getColumn(tableDefinitions.getColumnNumber(attrCol));
                    KeyValue.getAttributes(string3, authAttrObj.attrSet);
                    vector.addElement(authAttrObj);
                }
                ++n;
            }
        }
        finally {
            Object var7_10 = null;
            directoryTable.close();
        }
        Object[] objectArray = new AuthAttrObj[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void removeAuthAttrObj(AuthAttrObj authAttrObj) throws DirectoryTableException {
        String string = authAttrObj.getAuthName();
        this.removeAuthAttrObj(string);
    }

    public void removeAuthAttrObj(String string) throws DirectoryTableException {
        DirectoryTable directoryTable;
        block3: {
            directoryTable = this.openAuthAttrTable();
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), string);
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    System.out.println("Auth " + string + " does not exist");
                    break block3;
                }
                directoryTable.deleteRow(directoryRow);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var4_5 = null;
        directoryTable.close();
    }

    public void writeAuthAttrObj(AuthAttrObj authAttrObj) throws DirectoryTableException {
        DirectoryTable directoryTable;
        block3: {
            directoryTable = this.openAuthAttrTable();
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), authAttrObj.getAuthName());
                DirectoryRow directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                String string = directoryRow2 != null ? directoryRow2.getColumn(tableDefinitions.getColumnNumber(attrCol)) : null;
                String string2 = KeyValue.putAttributes(string, authAttrObj.attrSet, false);
                directoryRow.putColumn(tableDefinitions.getColumnNumber(shortDescCol), authAttrObj.getShortDesc());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(longDescCol), authAttrObj.getLongDesc());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(attrCol), string2);
                if (directoryRow2 == null) {
                    directoryTable.addRow(directoryRow);
                    break block3;
                }
                directoryTable.modifyRow(directoryRow2, directoryRow);
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var4_8 = null;
        directoryTable.close();
    }
}

