/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.JMenuPlus;
import com.sun.admin.diskmgr.client.Content;
import com.sun.admin.diskmgr.client.ContentEvent;
import com.sun.admin.diskmgr.client.ContentListener;
import com.sun.admin.diskmgr.client.DiskActionsListener;
import com.sun.admin.diskmgr.client.DiskContent;
import com.sun.admin.diskmgr.client.NavigationSelectionListener;
import com.sun.admin.diskmgr.client.TreeNodeData;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.SliceData;
import com.sun.management.viper.console.VScopeNode;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class SliceMenuBar
extends JMenuBar {
    private VDiskMgr theApp;
    private ResourceBundle bundle;
    private JMenuPlus actionMenu;
    private JMenuItem miCreateFdisk;
    private JMenuItem miPopupCreateFdisk;
    private JMenuItem miChangeFdisk;
    private JMenuItem miPopupChangeFdisk;
    private JMenuItem miFormat;
    private JMenuItem miPopupFormat;
    private JMenuItem miCreateFS;
    private JMenuItem miPopupCreateFS;
    private JMenuItem miPopupProperties;
    private JMenuPlus popupMenu;
    private JMenuPlus helpMenu;
    private JMenuItem miAbout;
    private ContentListener contentListener;
    private Content content = null;
    private boolean bX86 = false;

    public SliceMenuBar(VDiskMgr vDiskMgr) {
        this.theApp = vDiskMgr;
        this.bundle = vDiskMgr.getResourceBundle();
        this.bX86 = vDiskMgr.isX86();
    }

    private void buildMenu() {
        DiskActionsListener diskActionsListener;
        this.removeAll();
        DiskActionsListener diskActionsListener2 = diskActionsListener = new DiskActionsListener(this.theApp);
        ActionString actionString = new ActionString(this.bundle, "ActionMenu");
        this.actionMenu = new JMenuPlus(actionString.getString());
        this.actionMenu.setMnemonic(actionString.getMnemonic());
        this.actionMenu.setActionCommand("VMenuID.ACTION");
        if (this.bX86) {
            actionString = new ActionString(this.bundle, "ActionCreateFdisk");
            this.miCreateFdisk = new JMenuItem(actionString.getString());
            this.actionMenu.add(this.miCreateFdisk);
            this.miCreateFdisk.setMnemonic(actionString.getMnemonic());
            this.miCreateFdisk.setActionCommand("CreateFdisk");
            this.miCreateFdisk.addActionListener(diskActionsListener);
            this.miCreateFdisk.setEnabled(false);
            actionString = new ActionString(this.bundle, "ActionChangeFdisk");
            this.miChangeFdisk = new JMenuItem(actionString.getString());
            this.actionMenu.add(this.miChangeFdisk);
            this.miChangeFdisk.setMnemonic(actionString.getMnemonic());
            this.miChangeFdisk.setActionCommand("ChangeFdisk");
            this.miChangeFdisk.addActionListener(diskActionsListener);
            this.miChangeFdisk.setEnabled(false);
        }
        actionString = new ActionString(this.bundle, "ActionFormat");
        this.miFormat = new JMenuItem(actionString.getString());
        this.actionMenu.add(this.miFormat);
        this.miFormat.setMnemonic(actionString.getMnemonic());
        this.miFormat.setActionCommand("Format");
        this.miFormat.addActionListener(diskActionsListener);
        this.miFormat.setEnabled(false);
        actionString = new ActionString(this.bundle, "ActionCreateFS");
        this.miCreateFS = new JMenuItem(actionString.getString());
        this.actionMenu.add(this.miCreateFS);
        this.miCreateFS.setMnemonic(actionString.getMnemonic());
        this.miCreateFS.setActionCommand("CreateFS");
        this.miCreateFS.addActionListener(diskActionsListener);
        this.miCreateFS.setEnabled(false);
        this.add((JMenu)this.actionMenu);
        actionString = new ActionString(this.bundle, "HelpMenu");
        this.helpMenu = new JMenuPlus(actionString.getString());
        this.helpMenu.setMnemonic(actionString.getMnemonic());
        this.helpMenu.setActionCommand("VMenuID.HELP");
        actionString = new ActionString(this.bundle, "HelpAbout");
        this.miAbout = new JMenuItem(actionString.getString());
        this.helpMenu.add(this.miAbout);
        this.miAbout.setMnemonic(actionString.getMnemonic());
        this.miAbout.setActionCommand("About");
        this.miAbout.addActionListener(diskActionsListener);
        this.miAbout.setEnabled(true);
        this.add((JMenu)this.helpMenu);
        actionString = new ActionString(this.bundle, "ActionMenu");
        this.popupMenu = new JMenuPlus(actionString.getString());
        this.popupMenu.setMnemonic(actionString.getMnemonic());
        if (this.bX86) {
            actionString = new ActionString(this.bundle, "ActionCreateFdisk");
            this.miPopupCreateFdisk = new JMenuItem(actionString.getString());
            this.popupMenu.add(this.miPopupCreateFdisk);
            this.miPopupCreateFdisk.setMnemonic(actionString.getMnemonic());
            this.miPopupCreateFdisk.setActionCommand("CreateFdisk");
            this.miPopupCreateFdisk.addActionListener(diskActionsListener);
            this.miPopupCreateFdisk.setEnabled(false);
            actionString = new ActionString(this.bundle, "ActionChangeFdisk");
            this.miPopupChangeFdisk = new JMenuItem(actionString.getString());
            this.popupMenu.add(this.miPopupChangeFdisk);
            this.miPopupChangeFdisk.setMnemonic(actionString.getMnemonic());
            this.miPopupChangeFdisk.setActionCommand("ChangeFdisk");
            this.miPopupChangeFdisk.addActionListener(diskActionsListener);
            this.miPopupChangeFdisk.setEnabled(false);
            this.popupMenu.add(new JSeparator());
        }
        actionString = new ActionString(this.bundle, "ActionFormat");
        this.miPopupFormat = new JMenuItem(actionString.getString());
        this.popupMenu.add(this.miPopupFormat);
        this.miPopupFormat.setMnemonic(actionString.getMnemonic());
        this.miPopupFormat.setActionCommand("Format");
        this.miPopupFormat.addActionListener(diskActionsListener);
        this.miPopupFormat.setEnabled(false);
        actionString = new ActionString(this.bundle, "ActionCreateFS");
        this.miPopupCreateFS = new JMenuItem(actionString.getString());
        this.popupMenu.add(this.miPopupCreateFS);
        this.miPopupCreateFS.setMnemonic(actionString.getMnemonic());
        this.miPopupCreateFS.setActionCommand("CreateFS");
        this.miPopupCreateFS.addActionListener(diskActionsListener);
        this.miPopupCreateFS.setEnabled(false);
        this.popupMenu.add(new JSeparator());
        actionString = new ActionString(this.bundle, "ActionProperties");
        this.miPopupProperties = new JMenuItem(actionString.getString());
        this.popupMenu.add(this.miPopupProperties);
        this.miPopupProperties.setMnemonic(actionString.getMnemonic());
        this.miPopupProperties.setActionCommand("Properties");
        this.miPopupProperties.addActionListener(diskActionsListener);
        this.miPopupProperties.setEnabled(false);
        this.setMinimumSize(this.getPreferredSize());
        this.contentListener = new ContentListener(){

            public void itemPressed(ContentEvent contentEvent) {
                Content content = contentEvent.getSource();
                SliceMenuBar.this.notifySelectionChange(content.getNumSelections());
            }
        };
        this.theApp.addNavigationSelectionListener(new NavigationSelectionListener(){

            public void valueChanged(VScopeNode vScopeNode) {
                if (SliceMenuBar.this.content != null) {
                    SliceMenuBar.this.content.removeContentListener(SliceMenuBar.this.contentListener);
                }
                TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
                SliceMenuBar.this.content = treeNodeData.getContent();
                SliceMenuBar.this.content.addContentListener(SliceMenuBar.this.contentListener);
                SliceMenuBar.this.configureForContent();
                SliceMenuBar.this.notifySelectionChange(SliceMenuBar.this.content.getNumSelections());
            }
        });
    }

    private void configureForContent() {
        boolean bl = this.theApp.getDiskMgr().hasWriteAuthorization();
        if (this.theApp.isX86()) {
            this.miCreateFdisk.setEnabled(bl);
            this.miPopupCreateFdisk.setEnabled(bl);
            this.miChangeFdisk.setEnabled(bl);
            this.miPopupChangeFdisk.setEnabled(bl);
        }
        this.miFormat.setEnabled(bl);
        this.miPopupFormat.setEnabled(bl);
        this.miCreateFS.setEnabled(bl);
        this.miPopupCreateFS.setEnabled(bl);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu.getPopupMenu();
    }

    private void notifySelectionChange(int n) {
        Content content;
        boolean bl = this.theApp.getDiskMgr().hasWriteAuthorization();
        VScopeNode vScopeNode = this.theApp.getTree().getCurrentContent().getSelectedNode();
        if (vScopeNode != null && (content = this.theApp.getTree().getCurrentContent()) instanceof DiskContent) {
            SliceData sliceData = (SliceData)vScopeNode.getPayload();
            boolean bl2 = bl && sliceData.getDiskData().hasSolarisPartitions();
            this.miFormat.setEnabled(bl2);
            this.miPopupFormat.setEnabled(bl2);
            int n2 = sliceData.getEndCylinder() - sliceData.getStartCylinder();
            boolean bl3 = n2 > 0 && sliceData.getTag() != 5;
            boolean bl4 = bl && bl3 && !sliceData.getFS();
            this.miCreateFS.setEnabled(bl4);
            this.miPopupCreateFS.setEnabled(bl4);
            this.miPopupProperties.setEnabled(n == 1);
            if (this.bX86) {
                this.miCreateFdisk.setEnabled(bl);
                this.miPopupCreateFdisk.setEnabled(bl);
                boolean bl5 = bl && sliceData.getDiskData().getVPartitions().size() > 1;
                this.miChangeFdisk.setEnabled(bl5);
                this.miPopupChangeFdisk.setEnabled(bl5);
            }
        }
    }

    public void setX86(boolean bl) {
        this.bX86 = bl;
        this.buildMenu();
    }
}

