/*
 * Copyright (c) 1999 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_SYS_EXACCT_IMPL_H
#define	_SYS_EXACCT_IMPL_H

#pragma ident	"@(#)exacct_impl.h	1.1	00/02/14 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

#include <sys/types.h>

typedef struct task_usage {
	uint64_t tu_utime;	/* user time (in ticks) */
	uint64_t tu_stime;	/* system time (in ticks) */

	uint64_t tu_minflt;	/* minor faults */
	uint64_t tu_majflt;	/* major faults */
	uint64_t tu_sndmsg;	/* messages sent */
	uint64_t tu_rcvmsg;	/* messages received */
	uint64_t tu_ioch;	/* characters read and written */
	uint64_t tu_iblk;	/* input blocks */
	uint64_t tu_oblk;	/* output blocks */
	uint64_t tu_vcsw;	/* voluntary context switches */
	uint64_t tu_icsw;	/* involuntary context switches */
	uint64_t tu_nsig;	/* signals received */
	uint64_t tu_nswp;	/* swaps */
	uint64_t tu_nscl;	/* system calls */
	uint64_t tu_utimesec;	/* user time (seconds) */
	uint64_t tu_utimensec;	/* user time (nanoseconds) */
	uint64_t tu_stimesec;	/* system time (seconds) */
	uint64_t tu_stimensec;	/* system time (nanoseconds) */
	uint64_t tu_startsec;	/* start time (seconds) */
	uint64_t tu_startnsec;	/* start time (nanoseconds) */
	uint64_t tu_finishsec;	/* finish time (seconds) */
	uint64_t tu_finishnsec;	/* finish time (nanoseconds) */
} task_usage_t;

typedef struct proc_usage {
	uint64_t pu_minflt;	/* minor faults */
	uint64_t pu_majflt;	/* major faults */
	uint64_t pu_sndmsg;	/* messages sent */
	uint64_t pu_rcvmsg;	/* messages received */
	uint64_t pu_ioch;	/* characters read and written */
	uint64_t pu_iblk;	/* input blocks */
	uint64_t pu_oblk;	/* output blocks */
	uint64_t pu_vcsw;	/* voluntary context switches */
	uint64_t pu_icsw;	/* involuntary context switches */
	uint64_t pu_nsig;	/* signals received */
	uint64_t pu_nswp;	/* swaps */
	uint64_t pu_nscl;	/* system calls */
	uint64_t pu_utimesec;	/* user time (seconds) */
	uint64_t pu_utimensec;	/* user time (nanoseconds) */
	uint64_t pu_stimesec;	/* system time (seconds) */
	uint64_t pu_stimensec;	/* system time (nanoseconds) */
	uint64_t pu_startsec;	/* start time (seconds) */
	uint64_t pu_startnsec;	/* start time (nanoseconds) */
	uint64_t pu_finishsec;	/* finish time (seconds) */
	uint64_t pu_finishnsec;	/* finish time (nanoseconds) */

	pid_t pu_pid;		/* process ID */
	uid_t pu_ruid;		/* user ID */
	gid_t pu_rgid;		/* group ID */
	projid_t pu_projid;	/* project ID */
	taskid_t pu_taskid;	/* task ID */
	uint32_t pu_acflag;	/* accounting flags */
	char *pu_command;	/* command string */
	uint32_t pu_major;	/* major number of controlling tty */
	uint32_t pu_minor;	/* minor number of controlling tty */
} proc_usage_t;

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_EXACCT_IMPL_H */
