
import java.rmi.*;
import com.sun.wbem.client.CIMClient;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import java.util.Enumeration;

/** 
 * This example enumerates classes and instances. It does deep and shallow
 * enumerations on a class that is passed from the command line
 */

public class ClientEnum {
    public static void main(String args[]) throws CIMException {
	CIMClient cc = null;
	CIMObjectPath cop = null;
	if (args.length != 2) {
	    System.out.println("Usage: ClientEnum host className"); 
	    System.exit(1);
	    }
	try {
	    CIMNameSpace cns = new CIMNameSpace(args[0]);

	    cc = new CIMClient(cns);

	    // Get the class name from the command line
	    cop = new CIMObjectPath(args[1]);
	    // Do a deep enumeration of the class
	    Enumeration e = cc.enumClass(cop, true);
	    // Will print out all the subclasses of the class.
	    for (; e.hasMoreElements(); System.out.println(e.nextElement()));
	    System.out.println("+++++");
	    // Do a shallow enumeration of the class
	    e = cc.enumClass(cop, false);
	    // Will print out the first level subclasses.
	    for (; e.hasMoreElements(); System.out.println(e.nextElement()));
	    System.out.println("+++++");
	    // Do a deep enumeration of the instances of the class
	    e = cc.enumInstances(cop, true);
	    // Will print out all the instances of the class and its subclasses.
	    for (; e.hasMoreElements(); System.out.println(e.nextElement()));
	    System.out.println("+++++");
	    // Do a shallow enumeration of the instances of the class
	    e = cc.enumInstances(cop, false);
	    // Will print out all the instances of the class.
	    for (; e.hasMoreElements(); System.out.println(e.nextElement()));
	    System.out.println("+++++");
	}
	catch (Exception e) {
	    System.out.println("Exception: "+e);
	}

	// close session.
	if (cc != null) {
	    cc.close();
	}
    }
}
