/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.scf;

import com.sun.smartcard.scf.CardManager;
import com.sun.smartcard.scf.CardPresenceMonitor;
import com.sun.smartcard.scf.CardRemovedException;
import com.sun.smartcard.scf.CommException;
import com.sun.smartcard.scf.InternalCard;
import com.sun.smartcard.scf.InternalException;
import com.sun.smartcard.scf.InvalidStateException;
import com.sun.smartcard.scf.Logger;
import com.sun.smartcard.scf.NoSuchTerminalException;
import com.sun.smartcard.scf.SCFException;
import com.sun.smartcard.scf.TerminalEventDispatcher;
import com.sun.smartcard.scf.TerminalInfo;
import com.sun.smartcard.scf.spi.CardProvider;
import com.sun.smartcard.scf.spi.TerminalProvider;

class InternalTerminal
implements Runnable {
    private boolean isActive = false;
    private TerminalInfo terminalInfo = null;
    private InternalCard internalCard;
    private CardProvider cardProvider;
    private TerminalProvider terminalProvider;
    private CardManager cardManager;
    private CardPresenceMonitor cardPresenceMonitor;
    private TerminalEventDispatcher eventDispatcher;
    private final Logger logger = Logger.createLogger("InternalTerminal");

    InternalTerminal() {
        this.cardManager = new CardManager();
        this.cardPresenceMonitor = new CardPresenceMonitor();
        this.eventDispatcher = new TerminalEventDispatcher();
        this.terminalInfo = new TerminalInfo();
    }

    void init(String string, TerminalProvider terminalProvider) throws InvalidStateException, CommException, InternalException, NoSuchTerminalException {
        this.logger.log("init", string);
        this.terminalProvider = terminalProvider;
        this.cardProvider = terminalProvider.getCard();
        boolean bl = false;
        if (this.cardProvider != null) {
            this.internalCard = this.createInternalCard(this.cardProvider);
            if (this.internalCard == null) {
                this.cardProvider = null;
            } else {
                bl = true;
            }
        }
        this.cardManager.init(this.internalCard);
        this.cardPresenceMonitor.init(bl);
        this.eventDispatcher.init(bl);
        this.terminalInfo.init(string, terminalProvider);
    }

    void activate() {
        this.logger.log("activate", "");
        this.isActive = true;
        new Thread(this).start();
    }

    void close() {
        this.logger.log("close", "");
        if (this.isActive) {
            this.isActive = false;
            if (this.internalCard != null) {
                this.internalCard.close();
                this.internalCard = null;
            }
            this.cardManager.close();
            this.cardPresenceMonitor.close();
            this.eventDispatcher.close();
            this.terminalProvider = null;
        }
    }

    CardPresenceMonitor getCardPresenceMonitor() {
        return this.cardPresenceMonitor;
    }

    CardManager getCardManager() {
        return this.cardManager;
    }

    TerminalEventDispatcher getTerminalEventDispatcher() {
        return this.eventDispatcher;
    }

    TerminalInfo getTerminalInfo() {
        return this.terminalInfo;
    }

    public void run() {
        this.logger.log("run", "Thread started");
        try {
            while (this.isActive) {
                if (this.internalCard == null) {
                    do {
                        this.cardProvider = this.terminalProvider.waitForCard();
                        if (!this.isActive) {
                            return;
                        }
                        this.internalCard = this.createInternalCard(this.cardProvider);
                    } while (this.internalCard == null);
                    this.cardManager.cardInserted(this.internalCard);
                    this.eventDispatcher.cardInserted();
                    this.cardPresenceMonitor.cardPresenceChanged(true);
                    continue;
                }
                this.cardProvider.waitForCardRemoved();
                this.cardProvider = null;
                if (!this.isActive) {
                    return;
                }
                this.cardManager.cardRemoved();
                this.internalCard.close();
                this.internalCard = null;
                this.eventDispatcher.cardRemoved();
                this.cardPresenceMonitor.cardPresenceChanged(false);
            }
        }
        catch (CommException commException) {
            this.eventDispatcher.notifyListeners(8);
        }
        catch (SCFException sCFException) {
            // empty catch block
        }
    }

    private InternalCard createInternalCard(CardProvider cardProvider) throws InvalidStateException, CommException, InternalException, NoSuchTerminalException {
        this.logger.log("getInternalCard", "");
        InternalCard internalCard = new InternalCard();
        internalCard.init(cardProvider, this.eventDispatcher);
        try {
            internalCard.activate();
        }
        catch (CardRemovedException cardRemovedException) {
            return null;
        }
        return internalCard;
    }
}

