/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.scfimpl;

import com.sun.smartcard.Smartcard;
import com.sun.smartcard.SmartcardException;
import com.sun.smartcard.scf.CommException;
import com.sun.smartcard.scf.InternalException;
import com.sun.smartcard.scf.InvalidStateException;
import com.sun.smartcard.scf.spi.SessionProvider;
import com.sun.smartcard.scf.spi.TerminalProvider;
import com.sun.smartcard.scfimpl.OCFExceptionHandler;
import com.sun.smartcard.scfimpl.OCFTerminalProvider;
import java.util.Enumeration;
import java.util.LinkedList;

class OCFSessionProvider
implements SessionProvider {
    private Smartcard ocfSmartcard = null;

    OCFSessionProvider() {
    }

    void init() throws CommException, InternalException {
        try {
            this.ocfSmartcard = new Smartcard("scf");
        }
        catch (SmartcardException smartcardException) {
            try {
                OCFExceptionHandler.convertCommonOCFException(smartcardException);
            }
            catch (InvalidStateException invalidStateException) {
                // empty catch block
            }
        }
    }

    public void close() {
        this.ocfSmartcard.cleanup();
    }

    public String[] getTerminalNames() throws InvalidStateException, CommException, InternalException {
        LinkedList<String> linkedList = new LinkedList<String>();
        Enumeration enumeration = null;
        try {
            enumeration = this.ocfSmartcard.readersConfigured();
        }
        catch (SmartcardException smartcardException) {
            OCFExceptionHandler.convertCommonOCFException(smartcardException);
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            linkedList.addLast(string);
        }
        return linkedList.toArray(new String[0]);
    }

    public TerminalProvider getTerminalProvider(String string) {
        OCFTerminalProvider oCFTerminalProvider = new OCFTerminalProvider();
        oCFTerminalProvider.init(string, this.ocfSmartcard);
        return oCFTerminalProvider;
    }
}

