/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.scfimpl;

import com.sun.smartcard.AIDSpec;
import com.sun.smartcard.Card;
import com.sun.smartcard.CardSpec;
import com.sun.smartcard.ReaderSpec;
import com.sun.smartcard.Smartcard;
import com.sun.smartcard.SmartcardException;
import com.sun.smartcard.SmartcardInvalidCardHandleException;
import com.sun.smartcard.SmartcardNoCardException;
import com.sun.smartcard.SmartcardNoSuchPropertyException;
import com.sun.smartcard.SmartcardReaderNotSupportedException;
import com.sun.smartcard.SmartcardUnauthorizedAccessException;
import com.sun.smartcard.TimeoutSpec;
import com.sun.smartcard.scf.CommException;
import com.sun.smartcard.scf.InternalException;
import com.sun.smartcard.scf.InvalidStateException;
import com.sun.smartcard.scf.NoSuchTerminalException;
import com.sun.smartcard.scf.spi.CardProvider;
import com.sun.smartcard.scf.spi.TerminalProvider;
import com.sun.smartcard.scfimpl.OCFCardProvider;
import com.sun.smartcard.scfimpl.OCFExceptionHandler;

class OCFTerminalProvider
implements TerminalProvider {
    private Smartcard ocfSmartcard;
    private String terminalName;

    OCFTerminalProvider() {
    }

    void init(String string, Smartcard smartcard) {
        this.terminalName = string;
        this.ocfSmartcard = smartcard;
    }

    public CardProvider waitForCard() throws InvalidStateException, CommException, InternalException, NoSuchTerminalException {
        return this.getCardProvider(0);
    }

    public CardProvider getCard() throws InvalidStateException, CommException, InternalException, NoSuchTerminalException {
        return this.getCardProvider(1);
    }

    private CardProvider getCardProvider(int n) throws InvalidStateException, CommException, InternalException, NoSuchTerminalException {
        try {
            Card card = this.ocfSmartcard.waitForCardInserted(new CardSpec(), new ReaderSpec(this.terminalName), new AIDSpec(), new TimeoutSpec(n, 0));
            OCFCardProvider oCFCardProvider = new OCFCardProvider();
            oCFCardProvider.init(card);
            return oCFCardProvider;
        }
        catch (SmartcardNoCardException smartcardNoCardException) {
        }
        catch (SmartcardInvalidCardHandleException smartcardInvalidCardHandleException) {
        }
        catch (SmartcardUnauthorizedAccessException smartcardUnauthorizedAccessException) {
            throw new NoSuchTerminalException(smartcardUnauthorizedAccessException + " " + "terminalName");
        }
        catch (SmartcardReaderNotSupportedException smartcardReaderNotSupportedException) {
            throw new NoSuchTerminalException(this.terminalName);
        }
        catch (SmartcardException smartcardException) {
            OCFExceptionHandler.convertCommonOCFException(smartcardException);
        }
        return null;
    }

    public String getTerminalProperty(String string) throws CommException, InvalidStateException, InternalException {
        try {
            return this.ocfSmartcard.getTerminalInfo(this.terminalName, string);
        }
        catch (SmartcardNoSuchPropertyException smartcardNoSuchPropertyException) {
        }
        catch (SmartcardException smartcardException) {
            OCFExceptionHandler.convertCommonOCFException(smartcardException);
        }
        return null;
    }
}

