/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public class RequestDumperValve
extends ValveBase {
    private static final String info = "org.apache.catalina.valves.RequestDumperValve/1.0";
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.valves");

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        int i;
        if (!(request instanceof HttpRequest) || !(response instanceof HttpResponse)) {
            context.invokeNext(request, response);
            return;
        }
        HttpRequest hrequest = (HttpRequest)request;
        HttpResponse hresponse = (HttpResponse)response;
        HttpServletRequest hreq = (HttpServletRequest)hrequest.getRequest();
        HttpServletResponse hres = (HttpServletResponse)hresponse.getResponse();
        this.log("REQUEST URI       =" + hreq.getRequestURI());
        this.log("          authType=" + hreq.getAuthType());
        this.log(" characterEncoding=" + hreq.getCharacterEncoding());
        this.log("     contentLength=" + hreq.getContentLength());
        this.log("       contentType=" + hreq.getContentType());
        this.log("       contextPath=" + hreq.getContextPath());
        Cookie[] cookies = hreq.getCookies();
        if (cookies != null) {
            int i2 = 0;
            while (i2 < cookies.length) {
                this.log("            cookie=" + cookies[i2].getName() + "=" + cookies[i2].getValue());
                ++i2;
            }
        }
        Enumeration hnames = hreq.getHeaderNames();
        while (hnames.hasMoreElements()) {
            String hname = (String)hnames.nextElement();
            Enumeration hvalues = hreq.getHeaders(hname);
            while (hvalues.hasMoreElements()) {
                String hvalue = (String)hvalues.nextElement();
                this.log("            header=" + hname + "=" + hvalue);
            }
        }
        this.log("            locale=" + hreq.getLocale());
        this.log("            method=" + hreq.getMethod());
        Enumeration pnames = hreq.getParameterNames();
        while (pnames.hasMoreElements()) {
            String pname = (String)pnames.nextElement();
            String[] pvalues = hreq.getParameterValues(pname);
            StringBuffer result = new StringBuffer(pname);
            result.append('=');
            i = 0;
            while (i < pvalues.length) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(pvalues[i]);
                ++i;
            }
            this.log("         parameter=" + result.toString());
        }
        this.log("          pathInfo=" + hreq.getPathInfo());
        this.log("          protocol=" + hreq.getProtocol());
        this.log("       queryString=" + hreq.getQueryString());
        this.log("        remoteAddr=" + hreq.getRemoteAddr());
        this.log("        remoteHost=" + hreq.getRemoteHost());
        this.log("        remoteUser=" + hreq.getRemoteUser());
        this.log("requestedSessionId=" + hreq.getRequestedSessionId());
        this.log("            scheme=" + hreq.getScheme());
        this.log("        serverName=" + hreq.getServerName());
        this.log("        serverPort=" + hreq.getServerPort());
        this.log("       servletPath=" + hreq.getServletPath());
        this.log("          isSecure=" + hreq.isSecure());
        this.log("---------------------------------------------------------------");
        context.invokeNext(request, response);
        this.log("---------------------------------------------------------------");
        this.log("          authType=" + hreq.getAuthType());
        this.log("     contentLength=" + hresponse.getContentLength());
        this.log("       contentType=" + hresponse.getContentType());
        Cookie[] rcookies = hresponse.getCookies();
        int i3 = 0;
        while (i3 < rcookies.length) {
            this.log("            cookie=" + rcookies[i3].getName() + "=" + rcookies[i3].getValue() + "; domain=" + rcookies[i3].getDomain() + "; path=" + rcookies[i3].getPath());
            ++i3;
        }
        String[] rhnames = hresponse.getHeaderNames();
        i = 0;
        while (i < rhnames.length) {
            String[] rhvalues = hresponse.getHeaderValues(rhnames[i]);
            int j = 0;
            while (j < rhvalues.length) {
                this.log("            header=" + rhnames[i] + "=" + rhvalues[j]);
                ++j;
            }
            ++i;
        }
        this.log("           message=" + hresponse.getMessage());
        this.log("        remoteUser=" + hreq.getRemoteUser());
        this.log("            status=" + hresponse.getStatus());
        this.log("===============================================================");
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(String.valueOf(this.toString()) + ": " + message);
        } else {
            System.out.println(String.valueOf(this.toString()) + ": " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log(String.valueOf(this.toString()) + ": " + message, throwable);
        } else {
            System.out.println(String.valueOf(this.toString()) + ": " + message);
            throwable.printStackTrace(System.out);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RequestDumperValve[");
        if (this.container != null) {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }
}

