/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.io.Serializable;
import java.util.Vector;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.MOFFormatter;

public class CIMValue
implements Serializable {
    static final long serialVersionUID = 200L;
    private CIMDataType dataType = null;
    private Vector valueVector = null;
    private Object value = null;
    private boolean isArrayVal = false;
    public static final CIMValue TRUE = new CIMValue(Boolean.valueOf("true"));
    public static final CIMValue FALSE = new CIMValue(Boolean.valueOf("false"));

    private void initialize(Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            if (vector == null) {
                throw new NullPointerException();
            }
            this.isArrayVal = true;
            int n = CIMDataType.findType(vector);
            if (n != 30) {
                this.initialize(vector, new CIMDataType(CIMDataType.findType(vector)));
            } else {
                this.valueVector = (Vector)vector.clone();
            }
        } else {
            int n = CIMDataType.findType(object);
            if (n != 30) {
                if (object instanceof CIMObjectPath) {
                    this.initialize(object, new CIMDataType(((CIMObjectPath)object).getObjectName()));
                } else {
                    this.initialize(object, new CIMDataType(n));
                }
            }
        }
    }

    private void initialize(Object object, CIMDataType cIMDataType) {
        int n;
        if (cIMDataType.isArrayType()) {
            throw new IllegalArgumentException();
        }
        if (object == null) {
            this.dataType = cIMDataType;
            return;
        }
        int n2 = CIMDataType.findType(object);
        if (n2 != (n = cIMDataType.getType())) {
            throw new IllegalArgumentException();
        }
        this.value = object;
        this.dataType = cIMDataType;
    }

    private void initialize(Vector vector, CIMDataType cIMDataType) {
        if (!cIMDataType.isArrayType()) {
            throw new IllegalArgumentException();
        }
        if (vector == null) {
            this.dataType = cIMDataType;
            return;
        }
        int n = cIMDataType.getType();
        this.valueVector = new Vector();
        int n2 = 0;
        while (n2 < vector.size()) {
            Object e = vector.elementAt(n2);
            if (e != null) {
                int n3 = CIMDataType.findType(e);
                if ((n3 = CIMDataType.findArrayType(n3)) != n) {
                    throw new IllegalArgumentException();
                }
            }
            this.valueVector.addElement(e);
            ++n2;
        }
        this.dataType = cIMDataType;
    }

    public CIMValue(Object object, CIMDataType cIMDataType) {
        this.initialize(object, cIMDataType);
    }

    public CIMValue(Vector vector, CIMDataType cIMDataType) {
        this.isArrayVal = true;
        this.initialize(vector, cIMDataType);
    }

    public CIMValue(Object object) {
        this.initialize(object);
    }

    public boolean isArrayValue() {
        return this.isArrayVal;
    }

    public boolean isNullValue() {
        return this.dataType == null;
    }

    public String toMOF() {
        MOFFormatter mOFFormatter = new MOFFormatter();
        return mOFFormatter.toString(this);
    }

    public String toString() {
        return this.toMOF();
    }

    public boolean contains(Object object) {
        if (this.isArrayValue()) {
            return this.valueVector.contains(object);
        }
        if (this.value == null && object == null) {
            return true;
        }
        return object.equals(this.value);
    }

    public boolean isEmpty() {
        return this.value == null && this.valueVector == null && this.dataType != null;
    }

    public int size() {
        if (this.isArrayValue()) {
            return this.valueVector.size();
        }
        return -1;
    }

    public Object getValue() {
        if (this.isEmpty()) {
            return null;
        }
        if (!this.isArrayValue()) {
            return this.value;
        }
        return this.valueVector.clone();
    }

    public CIMDataType getType() {
        return this.dataType;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof CIMValue)) {
            return false;
        }
        CIMValue cIMValue = (CIMValue)object;
        if (this.dataType == null ? cIMValue.dataType != null : !this.dataType.equals(cIMValue.dataType)) {
            return false;
        }
        if (this.value != null) {
            return this.value.equals(cIMValue.value);
        }
        if (this.valueVector != null) {
            if (cIMValue.valueVector == null) {
                return false;
            }
            if (this.valueVector.size() != cIMValue.valueVector.size()) {
                return false;
            }
            int n = 0;
            while (n < this.valueVector.size()) {
                Object e = this.valueVector.elementAt(n);
                if (!e.equals(cIMValue.valueVector.elementAt(n))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return cIMValue.valueVector == null;
    }
}

