/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.security;

import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Arrays;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import javax.wbem.security.ClientSecurityContext;
import javax.wbem.security.SecurityUtil;

public class BasicClientSecurity
implements ClientSecurityContext {
    private static final String mechanism = "basic";
    private CIMNameSpace nameSpace;
    private Principal principal;
    private String userName;
    private byte[] userPswd;
    private String nsHost;
    private String nsPath;
    private boolean bEstablished = false;
    private String initialKey = "InitialKey";
    private byte[] sessionId = null;
    private byte[] encryptKey = null;
    private static final int MAX_DATA_SIZE = 15;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public BasicClientSecurity() throws NoSuchAlgorithmException {
        this.nameSpace = null;
        this.principal = null;
        this.userName = null;
        this.userPswd = new byte[0];
        this.nsHost = null;
        this.nsPath = "";
    }

    public BasicClientSecurity(CIMNameSpace cIMNameSpace, Principal principal, Object object) throws NoSuchAlgorithmException, CIMException {
        this.setNameSpace(cIMNameSpace);
        this.setPrincipal(principal);
        this.setCredential(object);
    }

    public String getMechanism() {
        return mechanism;
    }

    public String getServerName() {
        return this.nsHost;
    }

    public CIMNameSpace getNameSpace() {
        return this.nameSpace;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public boolean isEstablished() {
        return this.bEstablished;
    }

    public void setNameSpace(CIMNameSpace cIMNameSpace) throws CIMException {
        if (cIMNameSpace == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        this.nameSpace = cIMNameSpace;
        this.nsHost = cIMNameSpace.getHost();
        this.nsPath = cIMNameSpace.getNameSpace();
    }

    public void setPrincipal(Principal principal) throws CIMException {
        if (principal == null || !(principal instanceof UserPrincipal)) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        this.principal = principal;
        this.userName = principal.getName();
        if (this.userName == null || this.userName.trim().length() == 0) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
    }

    public void setCredential(Object object) throws CIMException {
        String string = null;
        if (object != null) {
            if (object instanceof PasswordCredential) {
                string = new String(((PasswordCredential)object).getUserPassword());
            } else if (object instanceof String) {
                string = new String((String)object);
            }
        }
        if (string == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        int n = string.length();
        this.userPswd = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.userPswd[n2] = (byte)c;
            ++n2;
        }
    }

    public void dispose() {
        this.bEstablished = false;
        this.nameSpace = null;
        this.principal = null;
        this.userName = null;
        Arrays.fill(this.userPswd, (byte)0);
        this.userPswd = new byte[0];
        this.nsHost = null;
        this.nsPath = "";
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        String string = null;
        if (this.userPswd.length > 0) {
            char[] cArray = new char[this.userPswd.length];
            int n = 0;
            while (n < this.userPswd.length) {
                cArray[n] = (char)(0 | this.userPswd[n] & 0xFF);
                ++n;
            }
            string = new String(cArray);
        }
        return string;
    }

    public String getSecurityToken(String[] stringArray) throws CIMException {
        String string = null;
        return string;
    }

    public String trans51Format(String string) throws CIMException {
        if (string.length() > 15 || this.encryptKey == null) {
            throw new CIMException("CIM_ERR_FAILED", "Bad data length or null encrypt key");
        }
        byte[] byArray = string.getBytes();
        int n = this.encryptKey.length;
        byte[] byArray2 = new byte[n];
        System.arraycopy(this.encryptKey, 0, byArray2, 0, n);
        byte[] byArray3 = new byte[n];
        SecurityUtil.secrand.nextBytes(byArray3);
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = n2;
            byArray2[n3] = (byte)(byArray2[n3] ^ byArray[n2]);
            ++n2;
        }
        int n4 = n2++;
        byArray2[n4] = (byte)(byArray2[n4] ^ 0);
        while (n2 < byArray2.length) {
            int n5 = n2;
            byArray2[n5] = (byte)(byArray2[n5] ^ byArray3[n2]);
            ++n2;
        }
        String string2 = this.toHex(byArray2);
        return string2;
    }

    private String toHex(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hex[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(hex[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private byte[] fromHex(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byArray[n3] = 0;
            boolean bl = false;
            char c = string.charAt(n2);
            int n4 = 0;
            while (n4 < hex.length) {
                if (c == hex[n4]) {
                    byArray[n3] = (byte)(n4 << 4 & 0xF0);
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                return null;
            }
            bl = false;
            c = string.charAt(++n2);
            n4 = 0;
            while (n4 < hex.length) {
                if (c == hex[n4]) {
                    byArray[n3] = (byte)(byArray[n3] | (byte)(n4 & 0xF));
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                return null;
            }
            ++n3;
            ++n2;
        }
        return byArray;
    }
}

