/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.patchmgr.client.DownloadDirectoryCard;
import com.sun.admin.patchmgr.client.DownloadReviewCard;
import com.sun.admin.patchmgr.client.DownloadSelectCard;
import com.sun.admin.patchmgr.client.DownloadSpecificListCard;
import com.sun.admin.patchmgr.client.DownloadTextCard;
import com.sun.admin.patchmgr.client.VPatchMgr;
import com.sun.admin.patchmgr.common.DownloadPatchesResults;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.console.gui.wizard.VWizard;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class DownloadPatchWizard
extends VWizard {
    private VPatchMgr theApp;
    private ResourceBundle bundle;
    private DownloadPatchWizard wizard;
    private GenInfoPanel infoPanel;
    private DownloadPatchesResults downLoadResults;
    private static final String SPACE = " ";
    private boolean specific = true;
    private boolean textFile = false;
    private Vector patchList = new Vector();
    private String textFilename = "";
    private String downloadDir = "";
    public static final String SELECT_MODE_CARD = "selectmodecard";
    public static final String SPECIFIC_PATCH_CARD = "specificpatchcard";
    public static final String TEXT_PATCH_CARD = "textpatchcard";
    public static final String DOWNLOAD_DIR_CARD = "downloaddircard";
    public static final String DOWNLOAD_REVIEW_CARD = "downloadreviewcard";
    private DownloadSelectCard selectCard;
    private DownloadSpecificListCard listCard;
    private DownloadTextCard textCard;
    private DownloadDirectoryCard dirCard;
    private DownloadReviewCard reviewCard;

    public DownloadPatchWizard(VPatchMgr vPatchMgr, String string) {
        this.theApp = vPatchMgr;
        this.wizard = this;
        this.infoPanel = new GenInfoPanel((VOptionPane)this);
        this.setTitle(string);
        this.bundle = vPatchMgr.getResourceBundle();
        this.selectCard = new DownloadSelectCard(vPatchMgr, this.wizard);
        this.listCard = new DownloadSpecificListCard(vPatchMgr, this.wizard);
        this.textCard = new DownloadTextCard(vPatchMgr, this.wizard);
        this.dirCard = new DownloadDirectoryCard(vPatchMgr, this);
        this.reviewCard = new DownloadReviewCard(vPatchMgr, this);
        this.addCard(SELECT_MODE_CARD, this.selectCard);
        this.addCard(SPECIFIC_PATCH_CARD, this.listCard);
        this.addCard(TEXT_PATCH_CARD, this.textCard);
        this.addCard(DOWNLOAD_DIR_CARD, this.dirCard);
        this.addCard(DOWNLOAD_REVIEW_CARD, this.reviewCard);
        this.loadHelp();
        this.setFirst(SELECT_MODE_CARD);
        this.setShowsSteps(false);
        this.getManager().setNext(DOWNLOAD_REVIEW_CARD, "");
        this.setHelpHTML(this.selectCard.getOverviewHelp());
    }

    private void loadHelp() {
        this.selectCard.loadHelp();
        this.listCard.loadHelp();
        this.textCard.loadHelp();
        this.dirCard.loadHelp();
        this.reviewCard.loadHelp();
    }

    public void init() {
        super.init();
    }

    public void cancelWizard() {
        super.cancelWizard();
    }

    public void doFinish() {
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"DownloadPatchTitle");
        int n = Math.max(string.length(), 10);
        final ProgressPanel progressPanel = new ProgressPanel(this.theApp.getFrame(), 1, n, true);
        progressPanel.setValue(0);
        progressPanel.setIndeterminate(true);
        progressPanel.setTitle(string);
        Thread thread = new Thread(){

            public void run() {
                String string = DownloadPatchWizard.this.wizard.downloadDir;
                String string2 = ResourceStrings.getString((ResourceBundle)DownloadPatchWizard.this.bundle, (String)"DownloadingPatchesStatus");
                progressPanel.setText(string2);
                DownloadPatchWizard.this.cancelWizard();
                progressPanel.setVisible(true);
                Object[] objectArray = new Object[4];
                String string3 = DownloadPatchWizard.this.theApp.getServerName();
                String string4 = "/usr/sadm/bin/smpatch download";
                String string5 = " -H " + string3;
                StringBuffer stringBuffer = new StringBuffer(50);
                int n = 0;
                while (n < DownloadPatchWizard.this.patchList.size()) {
                    stringBuffer.append(" -i " + (String)DownloadPatchWizard.this.patchList.elementAt(n));
                    if (n != DownloadPatchWizard.this.patchList.size() - 1) {
                        stringBuffer.append(" \\\n");
                    }
                    ++n;
                }
                objectArray[0] = string;
                objectArray[1] = string4 + string5 + " -- " + " \\";
                objectArray[2] = " -d " + string + " \\";
                objectArray[3] = stringBuffer;
                VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)DownloadPatchWizard.this.theApp, "vconsole.appendcommandlog", (Object)MessageFormat.format(ResourceStrings.getString((ResourceBundle)DownloadPatchWizard.this.bundle, (String)"CLIDownloadPatch"), objectArray));
                DownloadPatchWizard.this.theApp.fireConsoleAction(vConsoleEvent);
                try {
                    DownloadPatchWizard.this.downLoadResults = DownloadPatchWizard.this.theApp.getpatchM().downloadPatches(DownloadPatchWizard.this.patchList, string);
                }
                catch (Exception exception) {
                    progressPanel.dispose();
                    DownloadPatchWizard.this.theApp.reportErrorException(exception);
                    return;
                }
                string2 = ResourceStrings.getString((ResourceBundle)DownloadPatchWizard.this.bundle, (String)"DownloadedPatches");
                progressPanel.setIndeterminate(false);
                progressPanel.setText(string2);
                StringBuffer stringBuffer2 = new StringBuffer(50);
                StringBuffer stringBuffer3 = new StringBuffer(50);
                Vector vector = DownloadPatchWizard.this.downLoadResults.getPatchesNotDownloaded();
                int n2 = vector != null ? vector.size() : 0;
                int n3 = 0;
                while (n3 < n2) {
                    stringBuffer2.append((String)vector.elementAt(n3));
                    stringBuffer2.append(DownloadPatchWizard.SPACE);
                    ++n3;
                }
                Vector vector2 = DownloadPatchWizard.this.downLoadResults.getPatchListClosure();
                n2 = vector2 != null ? vector2.size() : 0;
                int n4 = 0;
                while (n4 < n2) {
                    stringBuffer3.append((String)vector2.elementAt(n4));
                    stringBuffer3.append(DownloadPatchWizard.SPACE);
                    ++n4;
                }
                Object[] objectArray2 = new Object[]{stringBuffer3.toString(), stringBuffer2.toString(), string};
                String string6 = "";
                String string7 = "";
                String string8 = "";
                String string9 = "";
                string6 = MessageFormat.format(ResourceStrings.getString((ResourceBundle)DownloadPatchWizard.this.bundle, (String)"err_download_msg"), objectArray2);
                string7 = MessageFormat.format(ResourceStrings.getString((ResourceBundle)DownloadPatchWizard.this.bundle, (String)"wrn_download_report"), objectArray2);
                string8 = MessageFormat.format(ResourceStrings.getString((ResourceBundle)DownloadPatchWizard.this.bundle, (String)"ok_download_msg"), objectArray2);
                string9 = MessageFormat.format(ResourceStrings.getString((ResourceBundle)DownloadPatchWizard.this.bundle, (String)"obs_download_msg"), objectArray2);
                if (stringBuffer2.length() > 0) {
                    ErrorDialog errorDialog = new ErrorDialog(DownloadPatchWizard.this.theApp.getFrame(), string6);
                } else if (DownloadPatchWizard.this.wizard.patchList.size() != vector2.size()) {
                    ErrorDialog errorDialog = new ErrorDialog(DownloadPatchWizard.this.theApp.getFrame(), string7);
                } else if (DownloadPatchesResults.areVecContentsSame(DownloadPatchWizard.this.patchList, vector2)) {
                    ErrorDialog errorDialog = new ErrorDialog(DownloadPatchWizard.this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)DownloadPatchWizard.this.bundle, (String)"generic_info_title"), string8, true);
                } else {
                    ErrorDialog errorDialog = new ErrorDialog(DownloadPatchWizard.this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)DownloadPatchWizard.this.bundle, (String)"generic_info_title"), string9, true);
                }
                progressPanel.dispose();
            }
        };
        thread.start();
    }

    public Vector getPatchIDList() {
        return this.patchList;
    }

    public void setPatchIDList(Vector vector) {
        this.patchList.removeAllElements();
        this.patchList = vector;
    }

    public String getDownloadDir() {
        return this.downloadDir;
    }

    public void setDownloadDir(String string) {
        this.downloadDir = string;
    }

    public boolean getSpecificFlag() {
        return this.specific;
    }

    public void setSpecificFlag(boolean bl) {
        this.specific = bl;
    }

    public boolean getTextFlag() {
        return this.textFile;
    }

    public void setTextFlag(boolean bl) {
        this.textFile = bl;
    }

    public String getTextFilename() {
        return this.textFilename;
    }

    public void setTextFilename(String string) {
        this.textFilename = string;
    }

    public GenInfoPanel getInfoPanel() {
        return this.infoPanel;
    }

    public static boolean isValidPatchID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        int n = stringTokenizer.countTokens();
        if (n != 2) {
            return false;
        }
        try {
            String string2 = stringTokenizer.nextToken();
            if (string2.charAt(0) == 'R') {
                string2 = string2.substring(1);
            }
            if (string2.length() != 6) {
                return false;
            }
            Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            if (string2.length() != 2) {
                return false;
            }
            Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }
}

