/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import com.sun.wbem.client.SolarisPswdCredential;
import com.sun.wbem.client.SolarisUserRolePrincipal;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Arrays;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.security.SunDigestClientSecurity;

public class SolarisDigestClientSecurity
extends SunDigestClientSecurity {
    private static final String mechanism = "solarisdigest";
    private String roleName;
    private byte[] rolePswd;

    public SolarisDigestClientSecurity() throws NoSuchAlgorithmException {
        this.roleName = null;
        this.rolePswd = new byte[0];
    }

    public SolarisDigestClientSecurity(CIMNameSpace cIMNameSpace, Principal principal, Object object) throws NoSuchAlgorithmException, CIMException {
        this.setNameSpace(cIMNameSpace);
        this.setPrincipal(principal);
        this.setCredential(object);
    }

    public String getMechanism() {
        return mechanism;
    }

    public void setPrincipal(Principal principal) throws CIMException {
        super.setPrincipal(principal);
        this.roleName = null;
        if (principal instanceof SolarisUserRolePrincipal) {
            this.roleName = ((SolarisUserRolePrincipal)((Object)principal)).getRoleName();
        }
    }

    public void setCredential(Object object) throws CIMException {
        String string;
        super.setCredential(object);
        if (object instanceof SolarisPswdCredential && (string = ((SolarisPswdCredential)((Object)object)).getRolePassword()) != null) {
            int n = string.length();
            this.rolePswd = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                this.rolePswd[n2] = (byte)c;
                ++n2;
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.roleName = null;
        Arrays.fill(this.rolePswd, (byte)0);
        this.rolePswd = new byte[0];
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getRolePassword() {
        String string = "";
        if (this.rolePswd.length > 0) {
            char[] cArray = new char[this.rolePswd.length];
            int n = 0;
            while (n < this.rolePswd.length) {
                cArray[n] = (char)(0 | this.rolePswd[n] & 0xFF);
                ++n;
            }
            string = new String(cArray);
        }
        return string;
    }
}

