/*
 * Decompiled with CFR 0.152.
 */
package tyrex.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import tyrex.jdbc.AbstractTyrexConnectionImpl;
import tyrex.tm.EnlistedResource;
import tyrex.tm.ResourceManager;

public class EnlistedConnection
extends AbstractTyrexConnectionImpl
implements Connection,
EnlistedResource {
    private Connection _underlying;
    private XAResource _xaRes;
    private boolean _enlisted;

    public EnlistedConnection(Connection connection, XAResource xAResource) throws SQLException {
        this._underlying = connection;
        this._xaRes = xAResource;
        this.enlist();
    }

    public void commit() throws SQLException {
        throw new SQLException("Commit not supported in enlisted connections.");
    }

    public void delisted() {
        this._enlisted = false;
    }

    private void enlist() throws SQLException {
        if (!this._enlisted) {
            try {
                this._underlying.rollback();
                ResourceManager.enlistResource(this._xaRes, this);
                this._enlisted = true;
            }
            catch (RollbackException rollbackException) {
                throw new SQLException(rollbackException.getMessage());
            }
            catch (SystemException systemException) {
                throw new SQLException(systemException.toString());
            }
        }
    }

    public void enlisted(Transaction transaction) {
    }

    public boolean getAutoCommit() throws SQLException {
        return false;
    }

    protected void internalClose() throws SQLException {
        if (!this.isClosed()) {
            this._underlying.close();
            this._underlying = null;
            this._xaRes = null;
        }
    }

    protected Connection internalGetUnderlyingConnection() throws SQLException {
        this.enlist();
        return this._underlying;
    }

    public synchronized boolean isClosed() {
        return this._underlying == null;
    }

    public boolean isEnlisted() {
        return this._enlisted;
    }

    public void rollback() throws SQLException {
        throw new SQLException("Rollback not supported in enlisted connections.");
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        throw new SQLException("SetAutoCommit not supported in enlisted connections.");
    }

    public String toString() {
        if (this._underlying == null) {
            return "Connection closed";
        }
        return this._underlying.toString();
    }
}

