/*
 * Decompiled with CFR 0.152.
 */
package tyrex.security.ldap;

import java.net.MalformedURLException;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;
import tyrex.security.container.helper.RolesRealm;

public class LDAPRealm
extends RolesRealm {
    public static final String DefaultRealmName = "<default>";
    private LDAPUrl _url;
    private String _dnMaskStart;
    private String _dnMaskEnd;
    private String _rolesRDN;

    LDAPRealm(String string, String string2, String string3, String string4) throws MalformedURLException, LDAPException {
        super(string, null);
        this._url = new LDAPUrl(string2);
        DN dN = new DN(string3);
        Vector vector = dN.getRDNs();
        if (vector.size() < 2) {
            throw new IllegalArgumentException("DN mask " + string3 + " not of the form x=*,y=z");
        }
        RDN rDN = (RDN)vector.elementAt(0);
        if (!rDN.getValues()[0].equals("*")) {
            throw new IllegalArgumentException("DN mask " + string3 + " not of the form x=*,y=z");
        }
        this._dnMaskStart = String.valueOf(rDN.getTypes()[0]) + "=";
        this._dnMaskEnd = "," + dN.getParent();
        this._rolesRDN = string4;
        LDAPConnection lDAPConnection = new LDAPConnection();
        try {
            lDAPConnection.connect(this._url.getHost(), this._url.getPort());
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string4, 1, "(objectclass=role)", new String[]{"role", "member"}, false);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("role");
                if (lDAPAttribute == null) continue;
                String[] stringArray = lDAPAttribute.getStringValueArray();
                int n = 0;
                while (n < stringArray.length) {
                    String string5 = stringArray[n];
                    lDAPAttribute = lDAPEntry.getAttribute("member");
                    if (lDAPAttribute != null) {
                        this.addRole(string5, lDAPAttribute.getStringValueArray());
                    }
                    ++n;
                }
            }
        }
        catch (LDAPException lDAPException) {
            try {
                if (lDAPConnection.isConnected()) {
                    lDAPConnection.disconnect();
                }
            }
            catch (Exception exception) {}
            if (lDAPException.getLDAPResultCode() == 32) {
                return;
            }
            throw lDAPException;
        }
    }

    public String getDN(String string) {
        return String.valueOf(this._dnMaskStart) + string + this._dnMaskEnd;
    }

    public String getLDAPHost() {
        return this._url.getHost();
    }

    public int getLDAPPort() {
        return this._url.getPort();
    }

    public String getLDAPUrl() {
        return this._url.toString();
    }

    public boolean isDefaultRealm() {
        return this.getRealmName().equals(DefaultRealmName);
    }

    /*
     * Unable to fully structure code
     */
    public void store(String var1_1, String var2_2) throws LDAPException {
        var3_3 = new LDAPConnection();
        try {
            var3_3.connect(this._url.getHost(), this._url.getPort());
            var3_3.authenticate(var1_1, var2_2);
            var6_4 = this.listRoles();
            var9_5 = 0;
            while (var9_5 < var6_4.length) {
                var8_7 = "role=" + var6_4[var9_5] + "," + this._rolesRDN;
                var7_6 = this.listMembers(var6_4[var9_5]);
                if (var7_6.length == 0) {
                    try {
                        var3_3.delete(var8_7);
                    }
                    catch (LDAPException var10_9) {
                        if (var10_9.getLDAPResultCode() == 32) ** GOTO lbl29
                        throw var10_9;
                    }
                } else {
                    try {
                        var10_8 = var3_3.read(var8_7);
                        var3_3.modify(var8_7, new LDAPModification(2, new LDAPAttribute("member", var7_6)));
                    }
                    catch (LDAPException var11_10) {
                        if (var11_10.getLDAPResultCode() == 32) {
                            var10_8 = new LDAPEntry(var8_7);
                            var10_8.getAttributeSet().add(new LDAPAttribute("role", var6_4[var9_5]));
                            var10_8.getAttributeSet().add(new LDAPAttribute("member", var7_6));
                            var3_3.add(var10_8);
                        }
                        throw var11_10;
                    }
                }
lbl29:
                // 4 sources

                ++var9_5;
            }
        }
        catch (Throwable var4_13) {
            var5_12 = null;
            try {
                if (var3_3.isConnected()) {
                    var3_3.disconnect();
                }
            }
            catch (Exception v0) {}
            throw var4_13;
        }
        var5_11 = null;
        try {
            if (var3_3.isConnected()) {
                var3_3.disconnect();
            }
        }
        catch (Exception v1) {}
    }
}

