/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom;

import com.sun.wbem.cimom.CIMOMImpl;
import com.sun.wbem.cimom.adapter.provider.ProviderAdapterIF;
import com.sun.wbem.cimom.adapter.provider.ProviderProtocolAdapterIF;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMException;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.Debug;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.CIMAssociatorProvider;
import javax.wbem.provider.CIMIndicationProvider;
import javax.wbem.provider.CIMInstanceProvider;
import javax.wbem.provider.CIMMethodProvider;
import javax.wbem.provider.CIMProvider;
import javax.wbem.provider.EventProvider;
import javax.wbem.provider.PropertyProvider;

public class InternalProviderAdapter
implements ProviderProtocolAdapterIF {
    private static final String DESCRIPTION = "Internal class provider adapter";
    private static final String VENDOR = "Sun Microsystems Inc.";
    private static final int VERSION = 1;
    private boolean valid = false;
    private ProviderCIMOMHandle mCimom;
    private static Map internalProviders = Collections.synchronizedMap(new HashMap());
    CIMOMImpl cimom;
    InternalServiceProvider[] serviceProviderArray;

    InternalProviderAdapter() {
    }

    public void initialize(ProviderCIMOMHandle providerCIMOMHandle) {
        this.mCimom = providerCIMOMHandle;
        int n = 0;
        while (n < this.serviceProviderArray.length) {
            InternalServiceProvider internalServiceProvider = this.serviceProviderArray[n];
            String[] stringArray = internalServiceProvider.getProviderNames();
            int n2 = stringArray.length - 1;
            while (n2 >= 0) {
                String string = stringArray[n2];
                try {
                    CIMProvider cIMProvider = internalServiceProvider.getProvider(string);
                    cIMProvider.initialize((CIMOMHandle)providerCIMOMHandle);
                    internalProviders.put(string, cIMProvider);
                }
                catch (Exception exception) {
                    Debug.trace1((String)("Unable to add provider: " + string), (Throwable)exception);
                }
                --n2;
            }
            ++n;
        }
        internalProviders.put("cimom", this.cimom);
    }

    public void start() {
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void stop() {
        this.valid = false;
    }

    public int getVersion() {
        return 1;
    }

    public String getVendor() {
        return VENDOR;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public static void putProvider(String string, CIMProvider cIMProvider) {
        internalProviders.put(string, cIMProvider);
    }

    public Object loadProvider(String string, String string2, String[] stringArray, CIMClass cIMClass) throws ClassNotFoundException, CIMClassException {
        Object object = null;
        object = (CIMProvider)internalProviders.get(string2);
        if (object == null) {
            object = this.cimom;
        }
        if (object instanceof ProviderAdapterIF) {
            return object;
        }
        return new WrappedProviderAdapter((CIMProvider)object);
    }

    public void unloadProvider(Object object) throws CIMClassException {
    }

    public ProviderAdapterIF getProviderAdapter(Object object) throws CIMClassException {
        if (object instanceof ProviderAdapterIF) {
            return (ProviderAdapterIF)object;
        }
        throw new CIMClassException("CIM_ERR_INVALID_CLASS", (Object)"Unrecognized object!");
    }

    public void terminate() {
    }

    public class WrappedProviderAdapter
    implements ProviderAdapterIF {
        private CIMProvider mWrapped = null;

        WrappedProviderAdapter(CIMProvider cIMProvider) {
            this.mWrapped = cIMProvider;
        }

        public boolean isInstanceProvider() {
            return this.mWrapped instanceof CIMInstanceProvider;
        }

        public boolean isPropertyProvider() {
            return this.mWrapped instanceof PropertyProvider;
        }

        public boolean isMethodProvider() {
            return this.mWrapped instanceof CIMMethodProvider;
        }

        public boolean isCIMIndicationProvider() {
            return this.mWrapped instanceof CIMIndicationProvider;
        }

        public boolean isEventProvider() {
            return this.mWrapped instanceof EventProvider;
        }

        public boolean isAuthorizable() {
            return this.mWrapped instanceof Authorizable;
        }

        public boolean isAssociatorProvider() {
            return this.mWrapped instanceof CIMAssociatorProvider;
        }

        public CIMProvider getProvider() {
            return this.mWrapped;
        }
    }

    public static interface InternalServiceProvider {
        public String[] getProviderNames();

        public CIMProvider getProvider(String var1) throws CIMException;
    }
}

