/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.printer;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.printer.PrtBuff;
import com.sun.wbem.solarisprovider.printer.Solaris_PrtNative;
import com.sun.wbem.utility.log.LogUtil;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;

public class Solaris_OwningPrintQueue
implements InstanceProvider,
Authorizable {
    private CIMOMHandle cimomhandle = null;
    private String prtList = null;
    private String pos = null;
    private String Q_name = null;
    private String prt_buff = null;
    LogUtil logUtil = null;
    private ProviderUtility prov_util = null;
    private String PROVIDER_NAME = "Solaris_OwningPrintQueue";
    PrtBuff prtbuff = new PrtBuff();
    public static final String PRINTER_MODIFY_RIGHT = "solaris.admin.printer.modify";
    public static final String PRINTER_DELETE_RIGHT = "solaris.admin.printer.delete";
    public static final String PRINTER_READ_RIGHT = "solaris.admin.printer.read";

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cIMOMHandle);
        this.prov_util = new ProviderUtility(cIMOMHandle, this.PROVIDER_NAME);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        this.prov_util.checkRights(PRINTER_MODIFY_RIGHT, cIMObjectPath);
        try {
            String[] stringArray = new String[]{"createInstance for OwningPrintQueue"};
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9406", "LM_9407", stringArray, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)"Create Printer Queue Failed.");
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)exception);
        }
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        this.prov_util.checkRights(PRINTER_DELETE_RIGHT, cIMObjectPath);
        try {
            String[] stringArray = new String[]{"deleteInstance for OwningPrintQueue"};
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9410", "LM_9411", stringArray, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)"Delete Queue Failed");
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)exception);
        }
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        this.prov_util.checkRights(PRINTER_MODIFY_RIGHT, cIMObjectPath);
        try {
            String[] stringArray = new String[]{"set Instance for Owning PrintQueue"};
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9420", "LM_9420", stringArray, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_NOT_SUPPORTED", (Object)"Set Instance Failed");
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        CIMObjectPath cIMObjectPath2 = null;
        CIMObjectPath cIMObjectPath3 = null;
        String[] stringArray2 = new String[]{"getInstance for OwningPrintQueue"};
        try {
            CIMProperty cIMProperty;
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                cIMProperty = (CIMProperty)enumeration.nextElement();
                if (cIMProperty.getName().equalsIgnoreCase("Antecedent")) {
                    cIMObjectPath2 = (CIMObjectPath)cIMProperty.getValue().getValue();
                }
                if (!cIMProperty.getName().equalsIgnoreCase("Dependent")) continue;
                cIMObjectPath3 = (CIMObjectPath)cIMProperty.getValue().getValue();
            }
            this.prt_buff = cIMObjectPath3.toString();
            this.pos = Solaris_OwningPrintQueue.parseJob_OBJ(this.prt_buff, "QueuePosition=");
            cIMProperty = cIMClass.newInstance();
            cIMProperty.setProperty("Antecedent", new CIMValue((Object)cIMObjectPath2));
            cIMProperty.setProperty("Dependent", new CIMValue((Object)cIMObjectPath3));
            cIMProperty.setProperty("QueuePosition", new CIMValue((Object)new UnsignedInt32((long)Integer.parseInt(this.pos))));
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9425", "LM_9425", stringArray2, "Success", false, 0, 0);
            if (bl) {
                cIMProperty = cIMProperty.localElements();
            }
            return cIMProperty.filterProperties(stringArray, bl2, bl3);
        }
        catch (Exception exception) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9427", "LM_9428", stringArray2, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"getInstance Failed");
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        String[] stringArray2 = new String[]{"Enumeriating Print queue owners"};
        try {
            CIMInstance cIMInstance;
            this.prtbuff.createPrtFile();
            this.prtbuff.createJobFile();
            int n = this.prtbuff.getNumPrinters();
            int n2 = 0;
            while (n2 < n) {
                cIMInstance = cIMClass.newInstance();
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                CIMObjectPath cIMObjectPath3 = new CIMObjectPath("Solaris_PrintJob");
                CIMObjectPath cIMObjectPath4 = new CIMObjectPath("Solaris_PrintQueue");
                CIMObjectPath cIMObjectPath5 = new CIMObjectPath(cIMObjectPath4.getObjectName(), cIMObjectPath4.getNameSpace());
                CIMObjectPath cIMObjectPath6 = new CIMObjectPath(cIMObjectPath3.getObjectName(), cIMObjectPath3.getNameSpace());
                this.prtList = this.prtbuff.getJob("ID", n2);
                int n3 = this.prtList.indexOf(45, 0);
                this.Q_name = this.prtList.substring(0, n3);
                this.pos = Solaris_PrtNative.getPos(this.Q_name, this.prtList);
                if (!this.pos.equalsIgnoreCase("no jobs")) {
                    cIMObjectPath6.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                    try {
                        cIMObjectPath6.addKey("JobID", new CIMValue((Object)this.prtList));
                    }
                    catch (Exception exception) {
                        throw new CIMException("CIM_ERR_FAILED", (Object)exception);
                    }
                    try {
                        cIMObjectPath6.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    cIMObjectPath6.addKey("CreationClassName", new CIMValue((Object)"Solaris_PrintJob"));
                    cIMObjectPath5.addKey("QueueName", new CIMValue((Object)this.Q_name));
                    cIMInstance.setProperty("Antecedent", new CIMValue((Object)cIMObjectPath5));
                    cIMInstance.setProperty("Dependent", new CIMValue((Object)cIMObjectPath6));
                    if (bl) {
                        cIMInstance = cIMInstance.localElements();
                    }
                    vector.addElement(cIMInstance.filterProperties(stringArray, bl2, bl3));
                }
                ++n2;
            }
            cIMInstance = new CIMInstance[vector.size()];
            vector.toArray((T[])cIMInstance);
            return cIMInstance;
        }
        catch (Exception exception) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9427", "LM_9428", stringArray2, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        String[] stringArray = new String[]{"Enumerating Print Queue Owners"};
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        try {
            CIMObjectPath cIMObjectPath2;
            this.prtbuff.createPrtFile();
            this.prtbuff.createJobFile();
            int n = this.prtbuff.getNumJobs();
            int n2 = 0;
            while (n2 < n) {
                cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                CIMObjectPath cIMObjectPath3 = new CIMObjectPath("Solaris_PrintJob");
                CIMObjectPath cIMObjectPath4 = new CIMObjectPath("Solaris_PrintQueue");
                CIMObjectPath cIMObjectPath5 = new CIMObjectPath(cIMObjectPath3.getObjectName(), cIMObjectPath3.getNameSpace());
                CIMObjectPath cIMObjectPath6 = new CIMObjectPath(cIMObjectPath4.getObjectName(), cIMObjectPath4.getNameSpace());
                CIMInstance cIMInstance = cIMClass.newInstance();
                this.prtList = this.prtbuff.getJob("ID", n2);
                int n3 = this.prtList.indexOf(45, 0);
                this.Q_name = this.prtList.substring(0, n3);
                this.pos = Solaris_PrtNative.getPos(this.Q_name, this.prtList);
                if (!this.pos.equalsIgnoreCase("no jobs")) {
                    cIMObjectPath5.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                    cIMObjectPath5.addKey("QueuePosition", new CIMValue((Object)new UnsignedInt32((long)Integer.parseInt(this.pos))));
                    try {
                        cIMObjectPath5.addKey("JobID", new CIMValue((Object)this.prtList));
                    }
                    catch (Exception exception) {
                        throw new CIMException("CIM_ERR_FAILED", (Object)exception);
                    }
                    try {
                        cIMObjectPath5.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    cIMObjectPath5.addKey("CreationClassName", new CIMValue((Object)"Solaris_PrintJob"));
                    cIMObjectPath6.addKey("QueueName", new CIMValue((Object)this.Q_name));
                    cIMObjectPath2.addKey("Antecedent", new CIMValue((Object)cIMObjectPath6));
                    cIMObjectPath2.addKey("Dependent", new CIMValue((Object)cIMObjectPath5));
                    cIMObjectPath2.addKey("QueuePosition", new CIMValue((Object)new UnsignedInt32((long)Integer.parseInt(this.pos))));
                    vector.addElement(cIMObjectPath2);
                }
                ++n2;
            }
            cIMObjectPath2 = new CIMObjectPath[vector.size()];
            vector.toArray((T[])cIMObjectPath2);
            return cIMObjectPath2;
        }
        catch (Exception exception) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9427", "LM_9428", stringArray, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) {
        return null;
    }

    public static String parseJob_OBJ(String string, String string2) {
        int n = string.indexOf(string2, 0);
        int n2 = string2.length();
        String string3 = "";
        string3 = string.substring(n + n2, n + n2 + 6);
        n = string3.indexOf(":");
        string3 = string3.substring(0, n);
        return string3;
    }
}

