/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.scheduledjob;

import com.sun.wbem.solarisprovider.scheduledjob.ScheduledJobProvider;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotFoundException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import javax.wbem.cim.CIMException;

public class CronConfiguration {
    public static String PROPERTY_CRONLOG = "CRONLOG";
    public static String PROPERTY_PATH = "PATH";
    public static String PROPERTY_SUPATH = "SUPATH";
    public static String DEFAULT_LOGGING_ON = "NO";
    public static String DEFAULT_USER_PATH = "/usr/bin";
    public static String DEFAULT_ROOT_PATH = "/usr/sbin:/usr/bin";
    private static String CRON_PROPERTIES_FILE = "/etc/default/cron";
    private static int CRON_PROPERTIES_FILE_USER = 2;
    private static int CRON_PROPERTIES_FILE_GROUP = 2;
    private static int CRON_PROPERTIES_FILE_ACCESS = 273;
    DirectoryTable cronProperties = null;
    TableDefinitions cronPropTableDefs = null;
    boolean dataLoaded = false;
    String loggingOn = DEFAULT_LOGGING_ON;
    boolean loggingOnChanged = false;
    String userPath = DEFAULT_USER_PATH;
    boolean userPathChanged = false;
    String rootPath = DEFAULT_ROOT_PATH;
    boolean rootPathChanged = false;
    ScheduledJobProvider provHandle = null;

    public CronConfiguration(ScheduledJobProvider scheduledJobProvider) {
        this.provHandle = scheduledJobProvider;
    }

    public void loadCronConfiguration() throws CIMException {
        try {
            this.cronProperties = DirectoryTableFactory.getDirectoryTableInstance((String)"File", (String)"", (String)"");
            this.cronPropTableDefs = this.cronProperties.getTableDefinitionsInstance();
            this.cronPropTableDefs.loadTableDefinitions("pkginfo");
            this.cronPropTableDefs.setMappedTableName(CRON_PROPERTIES_FILE);
            this.cronPropTableDefs.setUser(CRON_PROPERTIES_FILE_USER);
            this.cronPropTableDefs.setGroup(CRON_PROPERTIES_FILE_GROUP);
            this.cronPropTableDefs.setAccess(CRON_PROPERTIES_FILE_ACCESS);
        }
        catch (DirectoryTableException directoryTableException) {
            this.cronProperties = null;
            this.provHandle.logErrorAndThrow("LM_7902", "LM_7903");
        }
        try {
            this.cronProperties.open(this.cronPropTableDefs);
            DirectoryRow directoryRow = this.cronProperties.getAll();
            DirectoryRow directoryRow2 = this.cronProperties.getRowInstance();
            int n = 0;
            int n2 = this.cronPropTableDefs.getColumnNumber("value");
            int n3 = this.cronPropTableDefs.getColumnNumber("key");
            directoryRow2.putColumn(n3, PROPERTY_CRONLOG);
            try {
                n = directoryRow.getFirstRow((SearchTemplate)directoryRow2, this.cronPropTableDefs);
                this.loggingOn = directoryRow.getColumn(n2, n);
            }
            catch (DirectoryTableException directoryTableException) {
                this.loggingOn = DEFAULT_LOGGING_ON;
            }
            directoryRow2.putColumn(n3, PROPERTY_PATH);
            try {
                n = directoryRow.getFirstRow((SearchTemplate)directoryRow2, this.cronPropTableDefs);
                this.userPath = directoryRow.getColumn(n2, n);
            }
            catch (DirectoryTableException directoryTableException) {
                this.userPath = DEFAULT_USER_PATH;
            }
            directoryRow2.putColumn(n3, PROPERTY_SUPATH);
            try {
                n = directoryRow.getFirstRow((SearchTemplate)directoryRow2, this.cronPropTableDefs);
                this.rootPath = directoryRow.getColumn(n2, n);
            }
            catch (DirectoryTableException directoryTableException) {
                this.rootPath = DEFAULT_ROOT_PATH;
            }
            this.cronProperties.close();
        }
        catch (DirectoryTableException directoryTableException) {
            this.loggingOn = DEFAULT_LOGGING_ON;
            this.userPath = DEFAULT_USER_PATH;
            this.rootPath = DEFAULT_ROOT_PATH;
            this.provHandle.logWarning("LM_7666", "LM_7668");
        }
        this.dataLoaded = true;
    }

    public void saveCronConfiguration() throws CIMException {
        block16: {
            if (!this.dataLoaded) {
                this.provHandle.logErrorAndThrow("LM_7669", "LM_7670");
            }
            if (!(this.loggingOnChanged || this.userPathChanged || this.rootPathChanged)) {
                return;
            }
            try {
                this.cronProperties.open(this.cronPropTableDefs);
            }
            catch (DirectoryTableException directoryTableException) {
                try {
                    this.cronProperties.create(this.cronPropTableDefs);
                    this.provHandle.logWarning("LM_7904", "LM_7905");
                }
                catch (DirectoryTableException directoryTableException2) {
                    this.provHandle.logErrorAndThrow("LM_7669", "LM_7671");
                }
            }
            try {
                DirectoryRow directoryRow = this.cronProperties.getRowInstance();
                DirectoryRow directoryRow2 = this.cronProperties.getRowInstance();
                int n = this.cronPropTableDefs.getColumnNumber("value");
                int n2 = this.cronPropTableDefs.getColumnNumber("key");
                if (this.loggingOnChanged) {
                    directoryRow2.putColumn(n2, PROPERTY_CRONLOG);
                    try {
                        this.cronProperties.deleteRow(directoryRow2);
                    }
                    catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                        this.provHandle.logWarning("LM_7906", "LM_7907", PROPERTY_CRONLOG);
                    }
                    directoryRow.putColumn(n2, PROPERTY_CRONLOG);
                    directoryRow.putColumn(n, this.loggingOn);
                    this.cronProperties.addRow(directoryRow);
                }
                if (this.rootPathChanged) {
                    directoryRow2.putColumn(n2, PROPERTY_SUPATH);
                    try {
                        this.cronProperties.deleteRow(directoryRow2);
                    }
                    catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                        this.provHandle.logWarning("LM_7906", "LM_7907", PROPERTY_SUPATH);
                    }
                    directoryRow.putColumn(n2, PROPERTY_SUPATH);
                    directoryRow.putColumn(n, this.rootPath);
                    this.cronProperties.addRow(directoryRow);
                }
                if (!this.userPathChanged) break block16;
                directoryRow2.putColumn(n2, PROPERTY_PATH);
                try {
                    this.cronProperties.deleteRow(directoryRow2);
                }
                catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                    this.provHandle.logWarning("LM_7906", "LM_7907", PROPERTY_PATH);
                }
                directoryRow.putColumn(n2, PROPERTY_PATH);
                directoryRow.putColumn(n, this.userPath);
                this.cronProperties.addRow(directoryRow);
            }
            catch (DirectoryTableException directoryTableException) {
                this.cronProperties.close();
                this.provHandle.logErrorAndThrow("LM_7669", "LM_7674");
            }
        }
        this.cronProperties.close();
        this.loggingOnChanged = false;
        this.userPathChanged = false;
        this.rootPathChanged = false;
    }

    public boolean getLoggingOn() throws CIMException {
        return this.loggingOn.compareTo("NO") != 0;
    }

    public void setLoggingOn(boolean bl) throws CIMException {
        if (!this.dataLoaded) {
            this.provHandle.logErrorAndThrow("LM_7677", "LM_7678", PROPERTY_CRONLOG);
        }
        this.loggingOn = bl ? "YES" : "NO";
        this.loggingOnChanged = true;
    }

    public String getUserPath() throws CIMException {
        return this.userPath;
    }

    public void setUserPath(String string) throws CIMException {
        if (!this.dataLoaded) {
            this.provHandle.logErrorAndThrow("LM_7677", "LM_7678", PROPERTY_PATH);
        }
        this.userPath = string;
        this.userPathChanged = true;
    }

    public String getRootPath() throws CIMException {
        return this.rootPath;
    }

    public void setRootPath(String string) throws CIMException {
        if (!this.dataLoaded) {
            this.provHandle.logErrorAndThrow("LM_7677", "LM_7678", PROPERTY_SUPATH);
        }
        this.rootPath = string;
        this.rootPathChanged = true;
    }
}

