/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.users;

import com.sun.wbem.solarisprovider.common.ProviderDirectoryFilter;
import com.sun.wbem.solarisprovider.usermgr.common.AdminCommonTools;
import com.sun.wbem.solarisprovider.usermgr.common.FilterItem;
import com.sun.wbem.solarisprovider.usermgr.common.ListProperties;
import com.sun.wbem.solarisprovider.usermgr.common.SolServerDirTableException;
import com.sun.wbem.solarisprovider.usermgr.common.SolServerException;
import com.sun.wbem.solarisprovider.usermgr.common.UserMgrIDAlreadyInUseException;
import com.sun.wbem.solarisprovider.usermgr.common.UserMgrNameAlreadyInUseException;
import com.sun.wbem.solarisprovider.usermgr.groups.SolGroupAttr;
import com.sun.wbem.solarisprovider.usermgr.groups.SolarisGroupTable;
import com.sun.wbem.solarisprovider.usermgr.users.FlatUserObj;
import com.sun.wbem.solarisprovider.usermgr.users.LightUserObj;
import com.sun.wbem.solarisprovider.usermgr.users.SolHomedirAttr;
import com.sun.wbem.solarisprovider.usermgr.users.SolServicesAttr;
import com.sun.wbem.solarisprovider.usermgr.users.UserObj;
import com.sun.wbem.utility.directorytable.DirectoryFilter;
import com.sun.wbem.utility.directorytable.DirectoryMask;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableConnectionException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.Vector;

public class SolarisPasswdTable {
    private String emptyString = new String("");
    private String fileType = new String("File");
    private String tableName = "passwd";
    private String nameCol = "name";
    private String passwdCol = "passwd";
    private String uidCol = "uid";
    private String gidCol = "gid";
    private String gcosCol = "gcos";
    private String homeCol = "home";
    private String shellCol = "shell";
    private int nameColNum = 0;
    private int passwdColNum = 0;
    private int uidColNum = 0;
    private int gidColNum = 0;
    private int gcosColNum = 0;
    private int homeColNum = 0;
    private int shellColNum = 0;
    private String xPassword = "x";
    private String scope;
    private static final String DEFAULT_PRIMARY_GROUP_NAME = "staff";

    public SolarisPasswdTable(String string) {
        this.scope = string;
    }

    private DirectoryTable openPasswdTable() throws Exception {
        try {
            DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            directoryTable.open(this.tableName);
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            this.nameColNum = tableDefinitions.getColumnNumber(this.nameCol);
            this.passwdColNum = tableDefinitions.getColumnNumber(this.passwdCol);
            this.uidColNum = tableDefinitions.getColumnNumber(this.uidCol);
            this.gidColNum = tableDefinitions.getColumnNumber(this.gidCol);
            this.gcosColNum = tableDefinitions.getColumnNumber(this.gcosCol);
            this.homeColNum = tableDefinitions.getColumnNumber(this.homeCol);
            this.shellColNum = tableDefinitions.getColumnNumber(this.shellCol);
            return directoryTable;
        }
        catch (DirectoryTableException directoryTableException) {
            throw directoryTableException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    private void closePasswdTable(DirectoryTable directoryTable) {
        directoryTable.close();
        this.nameColNum = 0;
        this.passwdColNum = 0;
        this.uidColNum = 0;
        this.gidColNum = 0;
        this.gcosColNum = 0;
        this.homeColNum = 0;
        this.shellColNum = 0;
    }

    public Vector getAllLightRows(ProviderDirectoryFilter providerDirectoryFilter) throws Exception {
        Vector<LightUserObj> vector = null;
        int n = 0;
        DirectoryTable directoryTable = null;
        directoryTable = this.openPasswdTable();
        DirectoryFilter directoryFilter = null;
        if (providerDirectoryFilter != null) {
            try {
                directoryFilter = providerDirectoryFilter.getDirectoryFilter(directoryTable);
            }
            catch (Exception exception) {
                throw new DirectoryTableInvalidParameterException("EXM_INVALID");
            }
        }
        try {
            block14: {
                try {
                    DirectoryRow directoryRow = null;
                    DirectoryMask directoryMask = directoryTable.getDirectoryMaskInstance();
                    directoryMask.setColumn(this.nameColNum);
                    directoryMask.setColumn(this.uidColNum);
                    directoryMask.setColumn(this.gcosColNum);
                    directoryRow = directoryFilter != null ? directoryTable.getAll((SearchTemplate)directoryFilter, directoryMask) : directoryTable.getAll(directoryMask);
                    if (directoryRow != null) {
                        n = directoryRow.getNumberOfRows();
                        vector = new Vector(n);
                        vector.setSize(n);
                        int n2 = 1;
                        while (n2 <= n) {
                            LightUserObj lightUserObj = new LightUserObj();
                            lightUserObj.setUserName(directoryRow.getColumn(this.nameColNum, n2));
                            lightUserObj.setUserUID(directoryRow.getColumn(this.uidColNum, n2));
                            lightUserObj.setUserDescr(directoryRow.getColumn(this.gcosColNum, n2));
                            vector.setElementAt(lightUserObj, n2 - 1);
                            ++n2;
                        }
                        break block14;
                    }
                    vector = new Vector<LightUserObj>();
                }
                catch (DirectoryTableException directoryTableException) {
                    throw directoryTableException;
                }
                catch (Exception exception) {
                    throw exception;
                }
            }
            Object var11_14 = null;
            if (directoryTable != null) {
                this.closePasswdTable(directoryTable);
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (directoryTable != null) {
                this.closePasswdTable(directoryTable);
            }
            throw throwable;
        }
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getAllLightRows() throws Exception {
        Vector<LightUserObj> vector = null;
        int n = 0;
        DirectoryTable directoryTable = null;
        directoryTable = this.openPasswdTable();
        try {
            try {
                DirectoryMask directoryMask = directoryTable.getDirectoryMaskInstance();
                directoryMask.setColumn(this.nameColNum);
                directoryMask.setColumn(this.uidColNum);
                directoryMask.setColumn(this.gcosColNum);
                DirectoryRow directoryRow = directoryTable.getAll();
                if (directoryRow == null) {
                    Vector<LightUserObj> vector2 = vector = new Vector<LightUserObj>();
                    Object var9_11 = null;
                    if (directoryTable == null) return vector2;
                    this.closePasswdTable(directoryTable);
                    return vector2;
                }
                n = directoryRow.getNumberOfRows();
                vector = new Vector(n);
                vector.setSize(n);
                int n2 = 1;
                while (n2 <= n) {
                    LightUserObj lightUserObj = new LightUserObj();
                    lightUserObj.setUserName(directoryRow.getColumn(this.nameColNum, n2));
                    lightUserObj.setUserUID(directoryRow.getColumn(this.uidColNum, n2));
                    lightUserObj.setUserDescr(directoryRow.getColumn(this.gcosColNum, n2));
                    vector.setElementAt(lightUserObj, n2 - 1);
                    ++n2;
                }
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (directoryTable == null) throw throwable;
            this.closePasswdTable(directoryTable);
            throw throwable;
        }
        Object var9_12 = null;
        if (directoryTable == null) return vector;
        this.closePasswdTable(directoryTable);
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getAllFlatRows() throws Exception {
        Vector<FlatUserObj> vector = null;
        int n = 0;
        DirectoryTable directoryTable = null;
        directoryTable = this.openPasswdTable();
        try {
            DirectoryRow directoryRow = directoryTable.getAll();
            if (directoryRow == null) {
                Vector<FlatUserObj> vector2 = vector = new Vector<FlatUserObj>();
                Object var8_9 = null;
                if (directoryTable == null) return vector2;
                this.closePasswdTable(directoryTable);
                return vector2;
            }
            n = directoryRow.getNumberOfRows();
            vector = new Vector(n);
            vector.setSize(n);
            int n2 = 1;
            while (n2 <= n) {
                FlatUserObj flatUserObj = new FlatUserObj();
                flatUserObj.setUserName(directoryRow.getColumn(this.nameColNum, n2));
                flatUserObj.setUserUID(directoryRow.getColumn(this.uidColNum, n2));
                flatUserObj.setUserDescr(directoryRow.getColumn(this.gcosColNum, n2));
                vector.setElementAt(flatUserObj, n2 - 1);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (directoryTable == null) throw throwable;
            this.closePasswdTable(directoryTable);
            throw throwable;
        }
        Object var8_10 = null;
        if (directoryTable == null) return vector;
        this.closePasswdTable(directoryTable);
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getAllPasswdRows(ListProperties listProperties) throws SolServerDirTableException, Exception {
        Vector<UserObj> vector = null;
        int n = 0;
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openPasswdTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (Exception exception) {
            throw exception;
        }
        try {
            try {
                Object object;
                Vector vector2 = listProperties.getFilters();
                DirectoryFilter directoryFilter = new DirectoryFilter(vector2.size());
                String string = "";
                int n2 = 0;
                while (true) {
                    if (n2 >= vector2.size()) {
                        object = directoryTable.getAll((SearchTemplate)directoryFilter);
                        if (object != null) break;
                        Vector<UserObj> vector3 = vector = new Vector<UserObj>();
                        Object var16_21 = null;
                        if (directoryTable == null) return vector3;
                        this.closePasswdTable(directoryTable);
                        return vector3;
                    }
                    FilterItem filterItem = (FilterItem)vector2.elementAt(n2);
                    string = filterItem.getValue();
                    String string2 = filterItem.getAttribute();
                    int n3 = 0;
                    if (string2.equals("filter_user_name")) {
                        n3 = this.nameColNum;
                    } else if (string2.equals("filter_user_desc")) {
                        n3 = this.gcosColNum;
                    } else if (string2.equals("filter_user_id")) {
                        n3 = this.uidColNum;
                    } else if (string2.equals("filter_group_id")) {
                        n3 = this.gidColNum;
                    } else if (string2.equals("filter_user_group")) {
                        object = new SolarisGroupTable(this.scope);
                        string = ((SolarisGroupTable)object).translateNametoGID(filterItem.getValue());
                        n3 = this.gidColNum;
                    }
                    directoryFilter.add(n3, filterItem.getBooleanOperator(), filterItem.getOperator(), string);
                    ++n2;
                }
                n = object.getNumberOfRows();
                vector = new Vector(n);
                vector.setSize(n);
                int n4 = 1;
                while (n4 <= n) {
                    UserObj userObj = new UserObj(object.getColumn(this.nameColNum, n4));
                    userObj.setUserName(object.getColumn(this.nameColNum, n4));
                    userObj.setUserID(object.getColumn(this.uidColNum, n4));
                    userObj.setUserDescription(object.getColumn(this.gcosColNum, n4));
                    userObj.setUserType("Solaris");
                    vector.setElementAt(userObj, n4 - 1);
                    ++n4;
                }
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2090");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2094");
            }
            catch (Exception exception) {
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var16_23 = null;
            if (directoryTable == null) throw throwable;
            this.closePasswdTable(directoryTable);
            throw throwable;
        }
        Object var16_22 = null;
        if (directoryTable == null) return vector;
        this.closePasswdTable(directoryTable);
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getNextAvailableUID() throws Exception {
        long l = 100L;
        DirectoryTable directoryTable = null;
        directoryTable = this.openPasswdTable();
        try {
            try {
                DirectoryMask directoryMask = directoryTable.getDirectoryMaskInstance();
                directoryMask.setColumn(this.uidColNum);
                DirectoryRow directoryRow = directoryTable.getAll(directoryMask);
                if (directoryRow == null) {
                    String string = String.valueOf(l);
                    Object var13_10 = null;
                    if (directoryTable == null) return string;
                    this.closePasswdTable(directoryTable);
                    return string;
                }
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                directoryRow.sortByColumn(this.uidColNum, tableDefinitions);
                long l2 = 0L;
                boolean bl = false;
                int n = 1;
                while (n <= directoryRow.getNumberOfRows() && !bl) {
                    String string = directoryRow.getColumn(this.uidColNum, n);
                    if (string != null && string.trim().length() > 0 && (l2 = Long.parseLong(string)) != 60001L && l2 != 60002L && l2 != 65534L) {
                        if (l == l2) {
                            ++l;
                        } else if (l < l2) {
                            bl = true;
                        }
                    }
                    ++n;
                }
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            if (directoryTable == null) throw throwable;
            this.closePasswdTable(directoryTable);
            throw throwable;
        }
        Object var13_11 = null;
        if (directoryTable == null) return String.valueOf(l);
        this.closePasswdTable(directoryTable);
        return String.valueOf(l);
    }

    public void deletePasswdRow(FlatUserObj flatUserObj) throws Exception {
        DirectoryTable directoryTable = null;
        directoryTable = this.openPasswdTable();
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.nameColNum, flatUserObj.getUserName());
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    throw new Exception("User does not exist");
                }
                directoryTable.deleteRow(directoryRow);
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                throw exception;
            }
            Object var6_6 = null;
            if (directoryTable != null) {
                this.closePasswdTable(directoryTable);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (directoryTable != null) {
                this.closePasswdTable(directoryTable);
            }
            throw throwable;
        }
    }

    public void addPasswdRow(FlatUserObj flatUserObj) throws Exception {
        DirectoryTable directoryTable = null;
        directoryTable = this.openPasswdTable();
        try {
            try {
                Object object;
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                if (flatUserObj.getUserUID() == null || flatUserObj.getUserName() == null || flatUserObj.getHomeDirPathName() == null) {
                    throw new Exception();
                }
                directoryRow.putColumn(this.uidColNum, flatUserObj.getUserUID());
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow != null) {
                    throw new UserMgrIDAlreadyInUseException(null);
                }
                directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.nameColNum, flatUserObj.getUserName());
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow != null) {
                    throw new UserMgrNameAlreadyInUseException(null);
                }
                directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.nameColNum, flatUserObj.getUserName());
                if (flatUserObj.getUserDescr() != null) {
                    directoryRow.putColumn(this.gcosColNum, flatUserObj.getUserDescr());
                }
                directoryRow.putColumn(this.uidColNum, flatUserObj.getUserUID());
                if (flatUserObj.getPrimaryGroup() != null) {
                    object = new SolarisGroupTable(this.scope);
                    directoryRow.putColumn(this.gidColNum, ((SolarisGroupTable)object).translateNametoGID(flatUserObj.getPrimaryGroup()));
                }
                object = flatUserObj.getHomeDirPathName();
                if (flatUserObj.getAutoMountHomeDir()) {
                    object = this.getAutomountPath("auto_home");
                    object = ((String)object).concat(flatUserObj.getUserName());
                }
                directoryRow.putColumn(this.homeColNum, (String)object);
                if (flatUserObj.getInitialShell() != null) {
                    directoryRow.putColumn(this.shellColNum, flatUserObj.getInitialShell());
                }
                directoryRow.putColumn(this.passwdColNum, this.xPassword);
                directoryTable.addRow(directoryRow);
            }
            catch (DirectoryTableException directoryTableException) {
                directoryTableException.printStackTrace();
                throw directoryTableException;
            }
            catch (Exception exception) {
                throw exception;
            }
            Object var6_8 = null;
            if (directoryTable != null) {
                this.closePasswdTable(directoryTable);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (directoryTable != null) {
                this.closePasswdTable(directoryTable);
            }
            throw throwable;
        }
    }

    public LightUserObj getPasswdRow(LightUserObj lightUserObj) throws Exception {
        DirectoryTable directoryTable = null;
        directoryTable = this.openPasswdTable();
        String string = lightUserObj.getUserName();
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.nameColNum, string);
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    // empty if block
                }
                lightUserObj.setUserUID(directoryRow.getColumn(this.uidColNum));
                lightUserObj.setUserDescr(directoryRow.getColumn(this.gcosColNum));
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                throw exception;
            }
            Object var7_7 = null;
            if (directoryTable != null) {
                this.closePasswdTable(directoryTable);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (directoryTable != null) {
                this.closePasswdTable(directoryTable);
            }
            throw throwable;
        }
        return lightUserObj;
    }

    public UserObj getPasswdRow(UserObj userObj) throws SolServerException, Exception {
        SolServicesAttr solServicesAttr;
        SolHomedirAttr solHomedirAttr;
        AdminCommonTools.CMN_Trace3("In getPasswdRow()");
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openPasswdTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (Exception exception) {
            throw exception;
        }
        SolGroupAttr solGroupAttr = userObj.getSolGroupAttr();
        if (solGroupAttr == null) {
            solGroupAttr = new SolGroupAttr();
            userObj.setSolGroupAttr(solGroupAttr);
        }
        if ((solHomedirAttr = userObj.getSolHomedirAttr()) == null) {
            solHomedirAttr = new SolHomedirAttr();
            userObj.setSolHomedirAttr(solHomedirAttr);
        }
        if ((solServicesAttr = userObj.getSolServicesAttr()) == null) {
            solServicesAttr = new SolServicesAttr();
            userObj.setSolServicesAttr(solServicesAttr);
        }
        String string = userObj.getUserName();
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.nameColNum, string);
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    throw new SolServerException("EXM_SUS2", string);
                }
                userObj.setUserID(directoryRow.getColumn(this.uidColNum));
                userObj.setUserType("Solaris");
                userObj.setUserDescription(directoryRow.getColumn(this.gcosColNum));
                SolarisGroupTable solarisGroupTable = new SolarisGroupTable(this.scope);
                String string2 = directoryRow.getColumn(this.gidColNum);
                if (string2.length() > 0) {
                    solGroupAttr.setPrimaryGroup(solarisGroupTable.translateGIDtoName(string2));
                } else {
                    solGroupAttr.setPrimaryGroup(DEFAULT_PRIMARY_GROUP_NAME);
                }
                solHomedirAttr.setPathname(directoryRow.getColumn(this.homeColNum));
                solServicesAttr.setInitialShell(directoryRow.getColumn(this.shellColNum));
                solServicesAttr.setMailServer("");
            }
            catch (SolServerException solServerException) {
                throw solServerException;
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2090");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2094");
            }
            catch (Exception exception) {
                throw exception;
            }
            Object var13_15 = null;
            if (directoryTable != null) {
                this.closePasswdTable(directoryTable);
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (directoryTable != null) {
                this.closePasswdTable(directoryTable);
            }
            throw throwable;
        }
        return userObj;
    }

    public FlatUserObj getPasswdRow(FlatUserObj flatUserObj) throws Exception {
        DirectoryTable directoryTable = null;
        directoryTable = this.openPasswdTable();
        String string = flatUserObj.getUserName();
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.nameColNum, string);
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    // empty if block
                }
                flatUserObj.setUserUID(directoryRow.getColumn(this.uidColNum));
                flatUserObj.setUserDescr(directoryRow.getColumn(this.gcosColNum));
                SolarisGroupTable solarisGroupTable = new SolarisGroupTable(this.scope);
                String string2 = directoryRow.getColumn(this.gidColNum);
                if (string2.length() > 0) {
                    flatUserObj.setPrimaryGroup(solarisGroupTable.translateGIDtoName(string2));
                } else {
                    flatUserObj.setPrimaryGroup(DEFAULT_PRIMARY_GROUP_NAME);
                }
                flatUserObj.setHomeDirPathName(directoryRow.getColumn(this.homeColNum));
                flatUserObj.setInitialShell(directoryRow.getColumn(this.shellColNum));
                flatUserObj.setMailServer("");
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                throw exception;
            }
            Object var8_10 = null;
            if (directoryTable != null) {
                this.closePasswdTable(directoryTable);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (directoryTable != null) {
                this.closePasswdTable(directoryTable);
            }
            throw throwable;
        }
        return flatUserObj;
    }

    public void modifyPasswdRow(UserObj userObj, String string) throws SolServerException, Exception {
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openPasswdTable();
        }
        catch (SolServerDirTableException solServerDirTableException) {
            throw solServerDirTableException;
        }
        catch (Exception exception) {
            throw exception;
        }
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.uidColNum, userObj.getUserID());
                directoryRow.putColumn(this.nameColNum, string);
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    throw new SolServerException("EXM_SUS2", userObj.getUserName());
                }
                DirectoryRow directoryRow2 = directoryRow.extractRows(1, 1);
                if (!string.equals(userObj.getUserName())) {
                    directoryRow2.putColumn(this.nameColNum, userObj.getUserName());
                    directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow2);
                    if (directoryRow2 != null) {
                        throw new UserMgrNameAlreadyInUseException("EXM_SUS19", userObj.getUserName());
                    }
                    directoryRow2 = directoryTable.getRowInstance();
                }
                SolGroupAttr solGroupAttr = userObj.getSolGroupAttr();
                SolHomedirAttr solHomedirAttr = userObj.getSolHomedirAttr();
                SolServicesAttr solServicesAttr = userObj.getSolServicesAttr();
                directoryRow2.putColumn(this.nameColNum, userObj.getUserName());
                directoryRow2.putColumn(this.uidColNum, userObj.getUserID());
                SolarisGroupTable solarisGroupTable = new SolarisGroupTable(this.scope);
                directoryRow2.putColumn(this.gidColNum, solarisGroupTable.translateNametoGID(solGroupAttr.getPrimaryGroup()));
                directoryRow2.putColumn(this.gcosColNum, userObj.getUserDescription());
                directoryRow2.putColumn(this.shellColNum, solServicesAttr.getInitialShell());
                directoryRow2.putColumn(this.passwdColNum, directoryRow.getColumn(this.passwdColNum));
                String string2 = solHomedirAttr.getPathname();
                if (solHomedirAttr.getAutomount()) {
                    string2 = new String("/home/");
                    string2 = string2.concat(userObj.getUserName());
                } else {
                    string2 = solHomedirAttr.getPathname();
                }
                directoryRow2.putColumn(this.homeColNum, string2);
                directoryTable.modifyRow(directoryRow, directoryRow2);
            }
            catch (SolServerException solServerException) {
                throw solServerException;
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw new SolServerDirTableException("LM_2090");
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw new SolServerDirTableException("LM_2094");
            }
            catch (Exception exception) {
                throw exception;
            }
            Object var12_18 = null;
            if (directoryTable != null) {
                this.closePasswdTable(directoryTable);
            }
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            if (directoryTable != null) {
                this.closePasswdTable(directoryTable);
            }
            throw throwable;
        }
    }

    public void modifyPasswdRow(FlatUserObj flatUserObj) throws Exception {
        DirectoryTable directoryTable = null;
        directoryTable = this.openPasswdTable();
        try {
            try {
                Object object;
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                if (flatUserObj.getUserUID() == null) {
                    throw new Exception();
                }
                if (flatUserObj.getUserName() == null) {
                    throw new Exception();
                }
                directoryRow.putColumn(this.uidColNum, flatUserObj.getUserUID());
                directoryRow.putColumn(this.nameColNum, flatUserObj.getUserName());
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    throw new Exception();
                }
                DirectoryRow directoryRow2 = directoryRow.extractRows(1, directoryRow.getNumberOfRows());
                String string = flatUserObj.getNewName();
                String string2 = flatUserObj.getUserName();
                if (!string2.equals(string)) {
                    object = directoryTable.getRowInstance();
                    object.putColumn(this.nameColNum, string);
                    if (directoryTable.getFirstRow((SearchTemplate)object) != null) {
                        throw new UserMgrNameAlreadyInUseException(null);
                    }
                }
                directoryRow2.putColumn(this.nameColNum, string);
                if (flatUserObj.getUserDescr() != null) {
                    directoryRow2.putColumn(this.gcosColNum, flatUserObj.getUserDescr());
                }
                directoryRow2.putColumn(this.uidColNum, flatUserObj.getUserUID());
                if (flatUserObj.getPrimaryGroup() != null) {
                    object = new SolarisGroupTable(this.scope);
                    directoryRow2.putColumn(this.gidColNum, ((SolarisGroupTable)object).translateNametoGID(flatUserObj.getPrimaryGroup()));
                }
                object = flatUserObj.getHomeDirPathName();
                if (flatUserObj.getAutoMountHomeDir()) {
                    object = this.getAutomountPath("auto_home");
                    object = ((String)object).concat(string);
                }
                if (object != null) {
                    directoryRow2.putColumn(this.homeColNum, (String)object);
                }
                if (flatUserObj.getInitialShell() != null) {
                    directoryRow2.putColumn(this.shellColNum, flatUserObj.getInitialShell());
                }
                directoryRow2.putColumn(this.passwdColNum, directoryRow.getColumn(this.passwdColNum));
                directoryTable.modifyRow(directoryRow, directoryRow2);
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                throw exception;
            }
            Object var9_11 = null;
            if (directoryTable != null) {
                this.closePasswdTable(directoryTable);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (directoryTable != null) {
                this.closePasswdTable(directoryTable);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getAutomountPath(String string) {
        String string2;
        DirectoryTable directoryTable;
        block8: {
            String string3;
            block7: {
                String string4;
                block6: {
                    String string5 = "/home/";
                    directoryTable = null;
                    try {
                        try {
                            directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
                            TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
                            tableDefinitions.loadTableDefinitions("auto_master");
                            directoryTable.open(tableDefinitions);
                            DirectoryFilter directoryFilter = new DirectoryFilter(1);
                            directoryFilter.add(tableDefinitions.getColumnNumber("value"), 1, 3, string);
                            DirectoryRow directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryFilter);
                            if (directoryRow == null) {
                                string4 = string5;
                                Object var10_11 = null;
                                if (directoryTable == null) return string4;
                                break block6;
                            }
                            String string6 = directoryRow.getColumn(tableDefinitions.getColumnNumber("key"));
                            if (string6 == null || string6.trim().length() == 0) {
                                string3 = string5;
                                break block7;
                            }
                            string2 = string6 + "/";
                            break block8;
                        }
                        catch (Exception exception) {
                            String string7 = string5;
                            Object var10_14 = null;
                            if (directoryTable == null) return string7;
                            directoryTable.close();
                            return string7;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_15 = null;
                        if (directoryTable == null) throw throwable;
                        directoryTable.close();
                        throw throwable;
                    }
                }
                directoryTable.close();
                return string4;
            }
            Object var10_12 = null;
            if (directoryTable == null) return string3;
            directoryTable.close();
            return string3;
        }
        Object var10_13 = null;
        if (directoryTable == null) return string2;
        directoryTable.close();
        return string2;
    }
}

